#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_def_dev18 {
private:
   std::vector<Rotation_Matrix> o_HR;   //
   std::vector<Rotation_Matrix> o_HU;   //
   std::vector<double> o_Hd;            //
   std::vector<Coordinates> o_Hx;       //
public:
   MEM_def_dev18(int o):
      o_HR(o),
      o_HU(o),
      o_Hd(o),
      o_Hx(o)
   {
   }
   Rotation_Matrix& HR(int i){
      return o_HR.at( i);  }
   Rotation_Matrix& HU(int i){
      return o_HU.at( i);  }
   double& Hd(int i){
      return o_Hd.at( i);  }
   Coordinates& Hx(int i){
      return o_Hx.at( i);  }
};

double Backbone_Defs::DEF_DEV18(
      const DAT_PHYSICS_CONSTS& physics_consts,
      const DAT_RESIDUE_MAPPINGS& residue_mappings,
      Output_Streams& out,
      const Structure& str,
      const Search_Subspace& sub,
      int iZ2,int iD1){

   int jR1=Z2[iZ2].CYC;                 //start residue of segment
   int oR1=Z2[iZ2].nR1;                 //number of residues in segment
//
//
// generation components
//
   int oH=( 3*oR1);
   MEM_def_dev18 vv(oH);
   {
      int iH= 2;
      for(int aR1= 0;aR1<oR1;aR1++){
         double phi= (physics_consts.RAD)*Z2[iZ2].D1[iD1].R1[aR1].phi;
         double C= std::cos( phi);
         double S= std::sin( phi);
         vv.HR(iH  )(0,0)= (1.00);
         vv.HR(iH  )(1,0)= (0.00);
         vv.HR(iH  )(2,0)= (0.00);
         vv.HR(iH  )(0,1)= (0.00);
         vv.HR(iH  )(1,1)= C;
         vv.HR(iH  )(2,1)= S;
         vv.HR(iH  )(0,2)= (0.00);
         vv.HR(iH  )(1,2)=-S;
         vv.HR(iH++)(2,2)= C;
         if( aR1<(oR1-1) ){
            double psi= (physics_consts.RAD)*Z2[iZ2].D1[iD1].R1[aR1].psi;
            C= std::cos( psi);
            S= std::sin( psi);
            vv.HR(iH  )(0,0)= (1.00);
            vv.HR(iH  )(1,0)= (0.00);
            vv.HR(iH  )(2,0)= (0.00);
            vv.HR(iH  )(0,1)= (0.00);
            vv.HR(iH  )(1,1)= C;
            vv.HR(iH  )(2,1)= S;
            vv.HR(iH  )(0,2)= (0.00);
            vv.HR(iH  )(1,2)=-S;
            vv.HR(iH++)(2,2)= C;
            double omg= (physics_consts.RAD)*Z2[iZ2].D1[iD1].R1[aR1].omg;
            C= std::cos( omg);
            S= std::sin( omg);
            vv.HR(iH  )(0,0)= (1.00);
            vv.HR(iH  )(1,0)= (0.00);
            vv.HR(iH  )(2,0)= (0.00);
            vv.HR(iH  )(0,1)= (0.00);
            vv.HR(iH  )(1,1)= C;
            vv.HR(iH  )(2,1)= S;
            vv.HR(iH  )(0,2)= (0.00);
            vv.HR(iH  )(1,2)=-S;
            vv.HR(iH++)(2,2)= C;
         }
      }
      iH= 2;
      for(int aR1= 0;aR1<oR1;aR1++){
         int aL0=sub.R1[jR1+aR1].L0;
         if( aR1> 0 ){
            vv.HU(iH++)=residue_mappings.L0[aL0].Upsi;
            vv.HU(iH++)=residue_mappings.L0[aL0].Uomg;
         }
         vv.HU(iH++)=residue_mappings.L0[aL0].Uphi;
      }
      iH= 1;
      for(int aR1= 0;aR1<oR1;aR1++){
         int aL0=sub.R1[jR1+aR1].L0;
         if( aR1> 0 ){
            vv.Hd(iH++)=residue_mappings.L0[aL0].dpsi;
         }
         vv.Hd(iH++)=residue_mappings.L0[aL0].domg;
         vv.Hd(iH++)=residue_mappings.L0[aL0].dphi;
      }
   }
//
//
// backbone coords
//
   Rotation_Matrix P,B;
   {
      vv.Hx( 2).zero();
      vv.Hx( 1)=vv.Hx( 2);
      vv.Hx( 1)(0)-=vv.Hd( 2);
      vv.Hx( 0)=vv.Hx( 1);
      vv.Hx( 0)(0)-=vv.Hd( 1)*vv.HU( 2)(0,0);
      vv.Hx( 0)(1)+=vv.Hd( 1)*vv.HU( 2)(1,0);
      P.identity();
      for(int iH= 3;iH<oH;iH++){
         B=P*vv.HR(iH);
         P=B*vv.HU(iH);
         vv.Hx(iH  )=vv.Hx(iH-1);
         for(int i=0;i<3;i++){
            vv.Hx(iH  )(i)+=vv.Hd(iH)*P(i,0);
         }
      }
   }
//
//
// translation +rotation
//
   for(int iH= 0;iH<oH;iH++){
      Coordinates x=vv.Hx(iH);
      vv.Hx(iH).generate( Z2[iZ2].y00, Z2[iZ2].P, x);
   }
//
//
// diagnostic output
//
   {
//    std::string N3atm[3];
//    N3atm[0]=" N  ";
//    N3atm[1]=" CA ";
//    N3atm[2]=" C  ";
//    out.FILE3<< std::fixed<< std::setprecision( 3);
//    int iH= 0;
//    for(int aR1= 0;aR1<oR1;aR1++){
//       int iR0=sub.R1[jR1+aR1].R0;
//       for(int iN3=0;iN3<3;iN3++){
//          out.FILE3<<" iR0="<< std::setw( 4)<<iR0
//                   <<" atm="<<N3atm[iN3]
//                   <<" x=";
//          for(int i=0;i<3;i++){
//             out.FILE3<< std::setw( 8)<<( (physics_consts.ANG)*vv.Hx(iH)(i));
//          }
//          out.FILE3<<'\n';
//          iH++;
//       }
//    }

//    for(int jN3=0;jN3<3;jN3++){
//       for(int iN3=2;iN3>=0;iN3--){
//          double zR=( vv.Hx( jN3 +(oR1-1)*3) -vv.Hx(iN3)).r();
//          out.FILE3<<" aa1="<<N3atm[iN3]
//                   <<" aa2="<<N3atm[jN3]
//                   << std::setw( 8)<<(physics_consts.ANG*zR)<<'\n';
//       }
//    }
   }
//
//
// distance from target of end residue C
//
   double Rend= physics_consts.ANG
               *( vv.Hx( 2 +(oR1-1)*3) -Z2[iZ2].y18).r();
//
//
// if segment is N-terminal, correct trans +rot such that core remains fixed
//
   Rotation_Matrix ROT1,ROT2,ROT;
   Coordinates TRANS1,TRANS2,TRANS;
   if( sub.mBOD==1 ){
      int iZ0=Z2[iZ2].Z0;
      if( iZ0>=0 ){
         ROT2= Z2[iZ2].P*P;
         TRANS2= vv.Hx( 2 +(oR1-1)*3);
         ROT1= Z2[iZ2].Q;
         TRANS1= Z2[iZ2].y18;

         ROT= ROT1*transpose(ROT2);
         TRANS.generate( TRANS1, (-1.00)*ROT, TRANS2);

         double alp= str.Z0[iZ0].rot(0);
         double bet= str.Z0[iZ0].rot(1);
         double gam= str.Z0[iZ0].rot(2);
         ROT2= Rotation_Matrix(alp,bet,gam);
         TRANS2=str.Z0[iZ0].trans;

         ROT1= ROT*ROT2;
         TRANS1.generate( TRANS, ROT, TRANS2);
         double Cbet= ROT1(2,2);
         double Sbet= std::sqrt( (1.00) -Cbet*Cbet);
         bet= std::atan2(Sbet,Cbet);
         double Calp,Salp, Cgam,Sgam;
         if( Sbet<(1.00e-12) ){
            gam= (0.00);
            if( Cbet>(0.00) ){
               Calp= ROT1(0,0);
               Salp= ROT1(0,1);
               alp= std::atan2(Salp,Calp);
            }else{
               Calp=-ROT1(0,0);
               Salp=-ROT1(0,1);
               alp= std::atan2(Salp,Calp);
            }
         }else{
            Calp= (ROT1(2,0)/Sbet);
            Salp= (ROT1(2,1)/Sbet);
            alp= std::atan2(Salp,Calp);
            Cgam=-(ROT1(0,2)/Sbet);
            Sgam= (ROT1(1,2)/Sbet);
            gam= std::atan2(Sgam,Cgam);
         }
         Z2[iZ2].D1[iD1].tr.rot(0)= alp;
         Z2[iZ2].D1[iD1].tr.rot(1)= bet;
         Z2[iZ2].D1[iD1].tr.rot(2)= gam;
         Z2[iZ2].D1[iD1].tr.trans=TRANS1;
      }
   }
   return Rend;
}
