#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../glo/Backbone_Defs.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_def_clust {
private:
   std::vector<int> o_D1I3a;            //start index of confs within threshold
   std::vector<int> o_D1cI3;            //number of confs within threshold
   std::vector<int> o_D1I3b;            //start index of higher neighbor confs
   std::vector<int> o_D1dI3;            //number of lower neighbor confs
   std::vector<int> o_D1map;            //mapping of density maxima to indexes
public:
   std::vector<int> o_I3D1;             //index of neighbor conf
   MEM_def_clust(int o):
      o_D1I3a(o),
      o_D1cI3(o),
      o_D1I3b(o),
      o_D1dI3(o),
      o_D1map(o)
   {
   }
   int& D1I3a(int i){
      return o_D1I3a.at( i);  }
   int& D1cI3(int i){
      return o_D1cI3.at( i);  }
   int& D1I3b(int i){
      return o_D1I3b.at( i);  }
   int& D1dI3(int i){
      return o_D1dI3.at( i);  }
   int& I3D1(int i){
      return o_I3D1.at( i);  }
   int& D1map(int i){
      return o_D1map.at( i);  }
};

void Backbone_Defs::DEF_CLUST(
      const DAT_PHYSICS_CONSTS& physics_consts,
      const DAT_DEFORM_PARAMS& deform_params,
      Output_Streams& out,
      int iZ2){

// int jR1=Z2[iZ2].CYC;         //start residue of segment
   int oR1=Z2[iZ2].nR1;         //number of residues in segment
   int oD1=Z2[iZ2].nD1;         //number of bb deformations
   MEM_def_clust vv(oD1);

   int nD1cut=( nZ2> 1 )? int( oD1*std::sqrt( (1.00)/((nZ2*(nZ2-1))/2))): oD1;
//
//
// cluster
//
   double F=( Z2[iZ2].CORE )? (0.125)/(1.44): (0.500)/(1.44);
   int nD1;
   for(int iTER=0;iTER<8;iTER++){
      F*=(1.44);
      vv.o_I3D1.clear();

      for(int iD1= 0;iD1<oD1;iD1++){
         vv.D1cI3(iD1)=0;
         vv.D1dI3(iD1)=0;
      }

      int mI3=0;
      for(int iD1= 0;iD1<oD1;iD1++){
         vv.D1I3a(iD1)=mI3;
         int n=vv.D1cI3(iD1);
         for(int i=0;i<n;i++){
            vv.o_I3D1.push_back(-1);
            mI3++;
         }
         vv.D1I3b(iD1)=mI3;
         double RRa= F*Z2[iZ2].D1[iD1].d;
         for(int jD1=(iD1+1);jD1<oD1;jD1++){
            double RRb= F*Z2[iZ2].D1[jD1].d;
            if( RRa<RRb )RRb= RRa;
            bool NEIGHBOR=true;
            double RR= (0.00);
            for(int aR1= 1;aR1<oR1;aR1++){
               RR+=deform_params.C4C4d(Z2[iZ2].D1[jD1].R1[aR1].C4,
                                       Z2[iZ2].D1[iD1].R1[aR1].C4);
               if( RR>RRb ){
                  NEIGHBOR=false;
                  break;
               }
            }
            if( NEIGHBOR ){
               vv.o_I3D1.push_back(jD1);
               mI3++;
               vv.D1cI3(iD1)++;
               vv.D1cI3(jD1)++;
            }
         }
      }

      for(int iD1= 0;iD1<(oD1-1);iD1++){
         int iI3min=vv.D1I3b(iD1);
         int iI3max=(vv.D1I3a(iD1)-1+vv.D1cI3(iD1));
         for(int iI3=iI3min;iI3<=iI3max;iI3++){
            int jD1=vv.I3D1(iI3);
            vv.I3D1(vv.D1I3a(jD1)+vv.D1dI3(jD1))=iD1;
            vv.D1dI3(jD1)++;
         }
      }

      nD1=0;
      for(int iD1= 0;iD1<oD1;iD1++){
         int aI3=vv.D1cI3(iD1);
         bool DENSITYMAX=true;
         int iI3min=vv.D1I3a(iD1);
         int iI3max=(iI3min-1+vv.D1cI3(iD1));
         for(int iI3=iI3min;(iI3<=iI3max)&&DENSITYMAX;iI3++){
            int jD1=vv.I3D1(iI3);
            int bI3=vv.D1cI3(jD1);
            if( (bI3<aI3)||((bI3==aI3)&&(jD1>iD1)) )continue;
            DENSITYMAX=false;
            break;
         }
         if( DENSITYMAX ){
            vv.D1map(nD1++)=iD1;
         }
      }

      if( nD1<=nD1cut )break;
   }
//
//
// reduce collection of bb deformations
//
   Z2[iZ2].nD1=nD1;
   for(int jD1= 0;jD1<nD1;jD1++){
      int iD1=vv.D1map(jD1);
      Z2[iZ2].D1[jD1].p= -physics_consts.ekT*std::log( Z2[iZ2].D1[iD1].p);
      if( iD1!=jD1 ){
         Z2[iZ2].D1[jD1].d= Z2[iZ2].D1[iD1].d;
         Z2[iZ2].D1[jD1].star=Z2[iZ2].D1[iD1].star;
         Z2[iZ2].D1[jD1].bord=Z2[iZ2].D1[iD1].bord;
         Z2[iZ2].D1[jD1].r= Z2[iZ2].D1[iD1].r;
         Z2[iZ2].D1[jD1].fg= Z2[iZ2].D1[iD1].fg;
         for(int iR1= 0;iR1<oR1;iR1++){
            Z2[iZ2].D1[jD1].R1[iR1]=Z2[iZ2].D1[iD1].R1[iR1];
         }
         if( Z2[iZ2].Z0>=0 ){
            Z2[iZ2].D1[jD1].tr= Z2[iZ2].D1[iD1].tr;
         }
      }
   }
   for(int iD1=(oD1-1);iD1>(nD1-1);iD1--){
      Z2[iZ2].D1.pop_back();
   }
//
//
// diagnostic output
//
   if( out.VERBOSE&&false ){
      out.FILE3<< std::fixed;
      out.FILE3<<"  iD1""  ""     p      ""  d   ""  "" s"" b""  endr  ""  "
                 "  cnf0"<<'\n';
      for(int iD1= 0;iD1<nD1;iD1++){
         double e= Z2[iZ2].D1[iD1].p;
         double p= std::exp( -e/physics_consts.ekT);
         double d= std::sqrt( Z2[iZ2].D1[iD1].d/((2.)*(oR1-1)));
         out.FILE3<< std::setw( 5)<<iD1<<"  "
                  << std::setprecision(10)<< std::setw(12)<<p
                  << std::setprecision( 0)<< std::setw( 6)<<d<<"  "
                  << std::setw( 2)<<Z2[iZ2].D1[iD1].star
                  << std::setw( 2)<<Z2[iZ2].D1[iD1].bord
                  << std::setprecision( 2)<< std::setw( 8)<<Z2[iZ2].D1[iD1].r
                  <<"  ";
         for(int iR1= 0;iR1<oR1;iR1++){
            out.FILE3<<Z2[iZ2].D1[iD1].R1[iR1].cnfa;
         }
         out.FILE3<<'\n';
      }
   }
   return;
}
