#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../def/Def_Automatic.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../glo/Backbone_Defs.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_def {
private:
   std::vector<int> o_R1mC4;            //start conf of peptide plane
   std::vector<int> o_R1nC4;            //end conf of peptide plane
   std::vector<double> o_R1C4z;         //sum over partial paths
   std::vector<std::string> o_R1cnf;    //region of (phi,psi) grid
   std::vector<double> o_Dtrans;        //translation displacement (angstrom)
   std::vector<double> o_Drot;          //rotation displacement (radian)
   std::vector<int> o_HD;               //point in space of dispacements
   std::vector<double> o_Hg;            //derivative of fpath wrt displacement
   int o_R1;                            //
   std::vector<int> o_X3R1C4;           //confs of peptide planes
   std::vector<double> o_X3p;           //probability
   std::vector<double> o_X3d;           //distance from undeformed conf
   std::vector<int> o_R1jC4;            //undeformed conf
   std::vector<int> o_R1iC4;            //path through combined confs
   std::vector<double> o_R1q;           //product over partial path
   std::vector<double> o_R1d;           //distance from undeformed conf
public:
   MEM_def(int o):
      o_R1mC4(o),
      o_R1nC4(o),
      o_R1C4z(o*60),
      o_R1cnf(o),
      o_Dtrans(65),
      o_Drot(65),
      o_HD(6,0),
      o_Hg(6),
      o_R1(o),
      o_X3R1C4(2048*o),
      o_X3p(2048),
      o_X3d(2048),
      o_R1jC4(o),
      o_R1iC4(o),
      o_R1q(o),
      o_R1d(o)
   {
   }
   int& R1mC4(int i){
      return o_R1mC4.at( i);  }
   int& R1nC4(int i){
      return o_R1nC4.at( i);  }
   double& R1C4z(int i,int j){
      return o_R1C4z.at( i*60 +j);  }
   std::string& R1cnf(int i){
      return o_R1cnf.at( i);  }
   double& Dtrans(int i){
      return o_Dtrans.at( i+32);  }
   double& Drot(int i){
      return o_Drot.at( i+32);  }
   int& HD(int i){
      return o_HD.at( i);  }
   double& Hg(int i){
      return o_Hg.at( i);  }
   int& X3R1C4(int i,int j){
      return o_X3R1C4.at( i*o_R1 +j);  }
   double& X3p(int i){
      return o_X3p.at( i);  }
   double& X3d(int i){
      return o_X3d.at( i);  }
   int& R1jC4(int i){
      return o_R1jC4.at( i);  }
   int& R1iC4(int i){
      return o_R1iC4.at( i);  }
   double& R1q(int i){
      return o_R1q.at( i);  }
   double& R1d(int i){
      return o_R1d.at( i);  }
};

void Backbone_Defs::DEF(const DAT_PHYSICS_CONSTS& physics_consts,
                        const DAT_ENERGY_PARAMS& energy_params,
                        const DAT_RESIDUE_MAPPINGS& residue_mappings,
                        const DAT_DEFORM_PARAMS& deform_params,
                        const DAT_REGION_MAPS& region_maps,
                        const Thread_Options& opt,
                        Output_Streams& out,
                        const Structure& str,
                        const Search_Subspace& sub,
                        const Mechanical_System& mol,
                        const Subset_Contracted_System::tM3& con,
                        Conf_Dependent_System& dep,
                        Energy_Surface4& ene,
                        Local_Minimization4& loc,
                        int iZ2,int iJ3){

   int jR1=Z2[iZ2].CYC;                     //start residue of segment
   int oR1=Z2[iZ2].nR1;                     //number of residues in segment
   MEM_def vv(oR1);
   Def_Automatic aut( (Z2[iZ2].nR1-5)/2);
//
//
// threshold for probability of deformation
//
   {
      double zN= (1.00);
      for(int aR1= 1;aR1<oR1;aR1++){
         int iL0=sub.R1[jR1+aR1].L0;
         int iG4=residue_mappings.L0[iL0].G4;
         vv.R1mC4(aR1)=deform_params.G4[iG4].mC4;
         vv.R1nC4(aR1)=deform_params.G4[iG4].nC4;
         zN*=( vv.R1nC4(aR1)-vv.R1mC4(aR1)+1);
      }
      for(int iC4=vv.R1mC4(oR1-1);iC4<=vv.R1nC4(oR1-1);iC4++){
         vv.R1C4z((oR1-1),iC4)= deform_params.C4C4p(iC4, 0);
      }
      for(int aR1=(oR1-2);aR1>0;aR1--){
         for(int iC4=vv.R1mC4(aR1  );iC4<=vv.R1nC4(aR1  );iC4++){
            vv.R1C4z((aR1  ),iC4)= (0.00);
            for(int jC4=vv.R1mC4(aR1+1);jC4<=vv.R1nC4(aR1+1);jC4++){
               vv.R1C4z((aR1  ),iC4)+=
                   deform_params.C4C4p(iC4,jC4)*vv.R1C4z((aR1+1),jC4);
            }
         }
      }
      double zZ= (0.00);
      for(int jC4=vv.R1mC4( 1);jC4<=vv.R1nC4( 1);jC4++){
         zZ+=deform_params.C4C4p( 0,jC4)*vv.R1C4z((  1  ),jC4);
      }
      aut.z= (zZ/zN)*(.0625)*std::exp( -((oR1-1)/2)*std::log( (2.00)));
   }
//
//
// characterization of initial conf
//
   Z2[iZ2].nD1=0;
   if( (!PATCH)&&(Z2[iZ2].J3[iJ3].shf1==0)&&(Z2[iZ2].J3[iJ3].shf2==0) ){
      Z2[iZ2].D1.push_back( tZ2::tZ2D1(oR1));

      double zZ= deform_params.C4C4p( 0,Z2[iZ2].R1[ 1].C4);
      for(int iR1= 2;iR1<oR1;iR1++){
         zZ*=deform_params.C4C4p(Z2[iZ2].R1[iR1-1].C4,Z2[iZ2].R1[iR1  ].C4);
      }
      zZ*=deform_params.C4C4p(Z2[iZ2].R1[oR1-1].C4, 0);
      if( ((.0625)*zZ)<aut.z )aut.z= ((.0625)*zZ);

      int nSTAR=0;
      int nBORD=0;
      for(int iR1= 0;iR1<oR1;iR1++){
         vv.R1cnf(iR1)="  ";
         std::string aa=sub.R1[jR1+iR1].aa;
         if( (aa=="ACE ")||(aa=="NME ")||(aa=="NH2 ") )continue;
         if( (aa[0]=='e')||(aa[0]=='z')||
             (aa[3]=='e')||(aa[3]=='z') )continue;
         double phi= Z2[iZ2].R1[iR1].phi;
         double psi= Z2[iZ2].R1[iR1].psi;
         if( phi>(0.00) ){
            phi=-phi;
            psi=-psi;
            vv.R1cnf(iR1)[1]='*';
            if( aa!="GLY " )nSTAR++;
         }
         int iH4=1 +int( phi +(180.00))/10;
         int jH4=1 +int( psi +(180.00))/10;
         int iI0=( aa=="GLY " )? region_maps.H4H4gly(iH4,jH4):
                                 region_maps.H4H4ala(iH4,jH4);
         vv.R1cnf(iR1)[0]=region_maps.I0alp(iI0);
         if( vv.R1cnf(iR1)[0]=='X' )nBORD++;
      }

      double Fg= (0.00);
      for(int iR1= 0;iR1<oR1;iR1++){
         std::string aa=sub.R1[jR1+iR1].aa;
         std::string cnf=vv.R1cnf(iR1  );
         if      ( (aa=="SER ")&&(cnf=="A*") ){
            Fg+=(2.00)*energy_params.fac_pp;
         }else if( (aa=="CYS ")&&(cnf=="A*") ){
            Fg+=(3.60)*energy_params.fac_pp;
         }
      }

      for(int iR1= 0;iR1<oR1;iR1++){
         Z2[iZ2].D1[ 0].R1[iR1]=Z2[iZ2].R1[iR1];
         Z2[iZ2].D1[ 0].R1[iR1].cnfa= vv.R1cnf(iR1);
      }
      DEF_SEGPT(physics_consts,residue_mappings,
                out,sub,mol,con,dep,ene,loc,
                iZ2,iJ3,Z2[iZ2].nD1);
      double Rend= DEF_DEV18(physics_consts,residue_mappings,
                             out,str,sub,
                             iZ2,Z2[iZ2].nD1);

      Z2[iZ2].D1[ 0].p= zZ;
      Z2[iZ2].D1[ 0].d= (0.00);
      Z2[iZ2].D1[ 0].star=nSTAR;
      Z2[iZ2].D1[ 0].bord=nBORD;
      Z2[iZ2].D1[ 0].r= Rend;
      Z2[iZ2].D1[ 0].fg= Fg;
      Z2[iZ2].nD1++;
   }else{
      aut.z*=(1.00e-6);
   }
//
//
// segment deformations
//
   if( ((!PATCH)&&(opt.MODE=="bb "))||
       (( PATCH)&&(Z2[iZ2].Z0==-2)) ){
      vv.Dtrans( 0)= ( 0.00);
      vv.Drot( 0)= ( 0.00);
      for(int i= 1;i<33;i++){
         vv.Dtrans( i)=( vv.Dtrans( i-1) +( 0.125));
         vv.Dtrans(-i)=-vv.Dtrans( i);
         vv.Drot( i)=( vv.Drot( i-1) +( 1.00)*physics_consts.RAD);
         vv.Drot(-i)=-vv.Drot( i);
      }
      DEF_SETX1(aut,physics_consts,deform_params,opt,str,sub,iZ2,iJ3);
      DEF_DISCE(aut,residue_mappings,deform_params,sub,iZ2);

      double L= (oR1-1);                //parameter of path
      double Q00= ( 3.)/(L*L);          //
      double Q10= (-2.)/(L*L*L);        //
      double Q01= (-1.)/L;              //
      double Q11= ( 1.)/(L*L);          //
      double B= (2.00);                 //length of path per unit of parameter
      Coordinates v;                    // x(L)= u*(L  ) +v*(L**2) +w*(L**3)
      Coordinates w;                    //
      double wfac= (9.00)*(L*L);        //weight on cubic coeff of path
      double fpath;                     //target function of path

      for(aut.PASS=0;;aut.PASS++){
         if( aut.PASS==0 ){
         }else if( fpath<(.05) ){
            B= (2.40);
            vv.HD( 0)=0;
            vv.HD( 1)=0;
            vv.HD( 2)=32;
            vv.HD( 3)=-16;
            vv.HD( 4)=32;
            vv.HD( 5)=0;
         }else{
            vv.Hg( 3)= ((2.)*v(0)*Q00)
                       +((2.)*w(0)*Q10)*wfac;
            vv.Hg( 4)= ((2.)*v(1)*Q00)
                       +((2.)*w(1)*Q10)*wfac;
            vv.Hg( 5)= ((2.)*v(2)*Q00)
                       +((2.)*w(2)*Q10)*wfac;
            vv.Hg( 0)=-((2.)*v(1)*Q01*aut.T1(2,0)*B)
                       -((2.)*w(1)*Q11*aut.T1(2,0)*B)*wfac
                       +((2.)*v(2)*Q01*aut.T1(1,0)*B)
                       +((2.)*w(2)*Q11*aut.T1(1,0)*B)*wfac;
            vv.Hg( 1)= ((2.)*v(0)*Q01*aut.T1(2,0)*B)
                       +((2.)*w(0)*Q11*aut.T1(2,0)*B)*wfac
                       -((2.)*v(2)*Q01*aut.T1(0,0)*B)
                       -((2.)*w(2)*Q11*aut.T1(0,0)*B)*wfac;
            vv.Hg( 2)=-((2.)*v(0)*Q01*aut.T1(1,0)*B)
                       -((2.)*w(0)*Q11*aut.T1(1,0)*B)*wfac
                       +((2.)*v(1)*Q01*aut.T1(0,0)*B)
                       +((2.)*w(1)*Q11*aut.T1(0,0)*B)*wfac;
            double zg= (0.00);
            for(int iH=0;iH<6;iH++){
               if( std::abs( vv.Hg(iH))>zg )zg= std::abs( vv.Hg(iH));
            }
            for(int iH=0;iH<6;iH++){
               vv.HD(iH)=int( std::floor( (.50) -(4.)*vv.Hg(iH)/zg));
            }
         }
         double alp= vv.Drot(vv.HD( 0));
         double Calp= std::cos( alp);
         double Salp= std::sin( alp);
         double bet= vv.Drot(vv.HD( 1));
         double Cbet= std::cos( bet);
         double Sbet= std::sin( bet);
         double gam= vv.Drot(vv.HD( 2));
         double Cgam= std::cos( gam);
         double Sgam= std::sin( gam);
         Rotation_Matrix zP;
         zP(0,0)= Cbet*Cgam;
         zP(1,0)= Cbet*Sgam;
         zP(2,0)=-Sbet;
         zP(0,1)= Salp*Sbet*Cgam -Calp*Sgam;
         zP(1,1)= Salp*Sbet*Sgam +Calp*Cgam;
         zP(2,1)= Salp*Cbet;
         zP(0,2)= Calp*Sbet*Cgam +Salp*Sgam;
         zP(1,2)= Calp*Sbet*Sgam -Salp*Cgam;
         zP(2,2)= Calp*Cbet;
         aut.T1= zP*aut.T1;
         aut.x1(0)+=vv.Dtrans(vv.HD( 3));
         aut.x1(1)+=vv.Dtrans(vv.HD( 4));
         aut.x1(2)+=vv.Dtrans(vv.HD( 5));
//
//
// loop over discrete values of the conf of the N-terminal
//  block of the segment
//
         for(aut.iV1= 0;aut.iV1<aut.nV1;aut.iV1++){
            DEF_SETX2(aut,physics_consts,deform_params,iZ2);
//
//
// loop over discrete values of the conf of the C-terminal
//  block of the segment
//
            for(aut.iV2= 0;aut.iV2<aut.nV2;aut.iV2++){
               DEF_SETX3(aut,physics_consts,deform_params,iZ2);
               DEF_DISCT(aut,physics_consts,deform_params,iZ2);
               if( aut.nDIS==0 )continue;
//
//
// loop over discreet values of theta4
//
               for(aut.iDIS= 0;aut.iDIS<aut.nDIS;aut.iDIS++){
                  DEF_SETT4(aut,physics_consts,deform_params,iZ2);
                  DEF_SETTH(aut,physics_consts,deform_params,iZ2);
//
//
// loop over 2 solutions for theta2
//
                  for(aut.iSOL=0;aut.iSOL<2;aut.iSOL++){
                     DEF_SETX4(aut,physics_consts,deform_params,iZ2);
                     DEF_DISCP(aut,physics_consts,deform_params,iZ2);
                     if( aut.mDIS==0 )continue;
//
//
// loop over the discrete values of psi4
//
                     for(aut.jDIS= 0;aut.jDIS<aut.mDIS;aut.jDIS++){
                        DEF_SETX5(aut,physics_consts,iZ2);
                        DEF_SETSG(aut,physics_consts,deform_params,iZ2);
                        if( aut.nSEG==0 )continue;
                        DEF_SETPS(aut,
                                  physics_consts,energy_params,residue_mappings,
                                  deform_params,region_maps,
                                  out,str,sub,mol,con,dep,ene,loc,
                                  iZ2,iJ3);
                     }
                  }
               }
            }
         }
         if( Z2[iZ2].nD1>0 )break;
//
// form of path as a function of scalar parameter L
//  x(L)= u*(L  ) +v*(L**2) +w*(L**3)
//
         Coordinates x= aut.x1;
         x(0)-=(B*L);
         Coordinates dx;
         dx(0)= aut.T1(0,0);
         dx(1)= aut.T1(1,0);
         dx(2)= aut.T1(2,0);
         dx*=B;
         dx(0)-=B;
         v=( Q00*x +Q01*dx);
         w=( Q10*x +Q11*dx);
//
//
// target function of curvature of path
//
         fpath=( v.rr() +w.rr()*wfac);
//
//
// characterization of geometry of failed closure
//
         Coordinates zU= aut.x1;
         zU.normalize();
         double Cthe=( zU(0)*aut.T1(0,0)
                      +zU(1)*aut.T1(1,0)
                      +zU(2)*aut.T1(2,0));
         if( (zU(0)>(.75))&&(Cthe>(.75)) ){
            B= (2.80);
         }
//
//
// diagnostic ouput
//
         int iZ0=sub.R1[jR1].Z0;
         int iR0min=sub.R1[jR1].R0;
         int iR0max=sub.R1[jR1-1+oR1].R0;
         if( out.VERBOSE&& out.SHELL ){
            out.FILE3<< std::fixed;
            out.FILE3<<"No closure found for target segment ["
                     <<"iZ0="<< std::setw( 2)<<iZ0<<':'
                     <<"iR0="<< std::setw( 4)<<iR0min<<'-'
                     << std::setw( 4)<<iR0max<<"].\n";
            out.FILE3<<" PASS="<< std::setw( 2)<<aut.PASS
                     <<" x1 distance="
                     << std::setprecision( 2)
                     << std::setw( 8)<<aut.x1.r()
                     <<" dot product x1 direction with T1="
                     << std::setprecision( 3)
                     << std::setw( 6)<<Cthe
                     <<".\n";
            out.FILE3<<" x1="<< std::setprecision( 2);
            for(int i=0;i<3;i++){
               out.FILE3<< std::setw( 7)<<aut.x1(i);
            }
            out.FILE3<<" T1="<< std::setprecision( 3);
            for(int i=0;i<3;i++){
               out.FILE3<< std::setw( 6)<<aut.T1(i,0);
            }
            out.FILE3<<".\n";
            out.FILE3<<" Path x(L)= u*(L  ) +v*(L**2) +w*(L**3).\n";
            out.FILE3<<" v="<< std::setprecision( 3);
            for(int i=0;i<3;i++){
               out.FILE3<< std::setw( 8)<<v(i);
            }
            out.FILE3<<" w=";
            for(int i=0;i<3;i++){
               out.FILE3<< std::setw( 8)<<w(i);
            }
            out.FILE3<<".\n";
            out.FILE3<<" Target function of path="
                     << std::setw( 8)<<fpath<<".\n";
            out.FILE3<<" Displacement step:"
                     <<" dalp="<< std::setw( 3)<<vv.HD( 0)
                     <<" dbet="<< std::setw( 3)<<vv.HD( 1)
                     <<" dgam="<< std::setw( 3)<<vv.HD( 2)
                     <<" dx="<< std::setw( 3)<<vv.HD( 3)
                     <<" dy="<< std::setw( 3)<<vv.HD( 4)
                     <<" dz="<< std::setw( 3)<<vv.HD( 5)<<".\n";
         }
         if( aut.PASS>=80 ){
            out.FILE3<<"No closure found for target segment ["
                     <<"iZ0="<< std::setw( 2)<<iZ0<<':'
                     <<"iR0="<< std::setw( 4)<<iR0min<<'-'
                     << std::setw( 4)<<iR0max<<"].\n";
            ENDSTATE=1;
            return;
         }
      }
   }
//
//
// unconstrained deformations for terminal segments
//
   if( Z2[iZ2].Z0>-2 ){
      int oX3=2048;                     //maximum number of combined confs
      int pR1=(oR1-1);

      double RRc= ( 2*pR1)*( pR1 +2)*( pR1 +2);

      for(int iX3= 0;iX3<oX3;iX3++){
         for(int aR1= 0;aR1<pR1;aR1++){
            vv.X3R1C4(iX3  ,aR1)=-1;
         }
         vv.X3p(iX3)= (0.00);
         vv.X3d(iX3)= (0.00);
      }

      double zN= (1.00);
      for(int aR1= 0;aR1<pR1;aR1++){
         vv.R1jC4(aR1)=Z2[iZ2].R1[ 1+aR1].C4;
         int iL0=sub.R1[jR1+1+aR1].L0;
         int iG4=residue_mappings.L0[iL0].G4;
         vv.R1mC4(aR1)=deform_params.G4[iG4].mC4;
         vv.R1nC4(aR1)=deform_params.G4[iG4].nC4;
         zN*=(vv.R1nC4(aR1)-vv.R1mC4(aR1)+1);
      }

      for(int iC4=vv.R1mC4(pR1-1);iC4<=vv.R1nC4(pR1-1);iC4++){
         vv.R1C4z((pR1-1),iC4)= deform_params.C4C4p(iC4, 0);
      }
      for(int aR1=(pR1-2);aR1>=0;aR1--){
         for(int iC4=vv.R1mC4(aR1  );iC4<=vv.R1nC4(aR1  );iC4++){
            vv.R1C4z((aR1  ),iC4)= (0.00);
            for(int jC4=vv.R1mC4(aR1+1);jC4<=vv.R1nC4(aR1+1);jC4++){
               vv.R1C4z((aR1  ),iC4)+=
                   deform_params.C4C4p(iC4,jC4)*vv.R1C4z((aR1+1),jC4);
            }
         }
      }
      double zZ= (0.00);
      for(int jC4=vv.R1mC4( 0);jC4<=vv.R1nC4( 0);jC4++){
         zZ+=deform_params.C4C4p( 0,jC4)*vv.R1C4z((  0  ),jC4);
      }
      zZ*= std::exp( -( 8 +2*pR1)*std::log( (2.00)));

      for(int iR1= 0;iR1<pR1;iR1++){
         vv.R1iC4(iR1)=(vv.R1mC4(iR1)-1);
      }
      int iR1= 0;
      for(;;){
         vv.R1iC4(iR1)++;
         if( vv.R1iC4(iR1)>vv.R1nC4(iR1) ){
            if( iR1== 0 ){
               break;
            }else{
               vv.R1iC4(iR1)=(vv.R1mC4(iR1)-1);
               iR1--;
               continue;
            }

         }else{
            if( iR1== 0 ){
               vv.R1q(iR1  )= deform_params.C4C4p( 0,vv.R1iC4(iR1  ));
               vv.R1d(iR1  )= deform_params.C4C4d(vv.R1iC4(iR1  ),
                                                   vv.R1jC4(iR1  ));
            }else{
               vv.R1q(iR1  )= vv.R1q(iR1-1)
                          *deform_params.C4C4p(vv.R1iC4(iR1-1),
                                               vv.R1iC4(iR1  ));
               vv.R1d(iR1  )= vv.R1d(iR1-1)
                          +deform_params.C4C4d(vv.R1iC4(iR1  ),
                                               vv.R1jC4(iR1  ));
            }
            if( vv.R1q(iR1  )*vv.R1C4z((iR1  ),vv.R1iC4(iR1  ))<zZ )continue;
            if( iR1==(pR1-1) ){
               double RRa= RRc
                  *std::exp( (.40)*std::log( (1.00e-8) +(vv.R1d(pR1-1)/RRc)));

               bool DEGENERATE=false;
               for(int iX3= 0;(iX3<oX3)&&!DEGENERATE;iX3++){
                  if( vv.X3p(iX3)<=(0.00) )break;
                  double RRb=( vv.X3d(iX3)<RRa )? vv.X3d(iX3): RRa;
                  double RR= (0.00);
                  for(int aR1= 0;aR1<pR1;aR1++){
                     RR+=deform_params.C4C4d(vv.R1iC4(aR1),
                                             vv.X3R1C4(iX3  ,aR1));
                  }
                  if( RR<RRb )DEGENERATE=true;
               }
               if( DEGENERATE )continue;

               for(int aR1= 0;aR1<pR1;aR1++){
                  vv.X3R1C4(oX3-1,aR1)=vv.R1iC4(aR1);
               }
               vv.X3p(oX3-1)= vv.R1q(pR1-1)
                              *vv.R1C4z((pR1-1),vv.R1iC4( pR1-1));
               vv.X3d(oX3-1)= RRa;
               for(int iX3=(oX3-1);iX3>0;iX3--){
                  if( vv.X3p(iX3)<=vv.X3p(iX3-1) )break;
                  for(int aR1= 0;aR1<pR1;aR1++){
                     int j=vv.X3R1C4(iX3-1,aR1);
                     vv.X3R1C4(iX3-1,aR1)=vv.X3R1C4(iX3  ,aR1);
                     vv.X3R1C4(iX3  ,aR1)=j;
                  }
                  double z= vv.X3p(iX3-1);
                  vv.X3p(iX3-1)= vv.X3p(iX3);
                  vv.X3p(iX3)= z;
                  z= vv.X3d(iX3-1);
                  vv.X3d(iX3-1)= vv.X3d(iX3);
                  vv.X3d(iX3)= z;
               }
               if( vv.X3p(oX3-1)>zZ )zZ= vv.X3p(oX3-1);

            }else{
               iR1++;
            }

         }
      }

      while( Z2[iZ2].nD1>(aut.oD1/2) ){
         Z2[iZ2].D1.pop_back();
         Z2[iZ2].nD1--;
      }
      int nX3=oX3;
      while( (nX3>0)&&(vv.X3p(nX3-1)<=(0.00)) ){
         nX3--;
      }
      if( nX3>int( std::pow(2.00,(2+pR1))) )nX3=int( std::pow(2.00,(2+pR1)));
      if( nX3>(aut.oD1-Z2[iZ2].nD1) )nX3=(aut.oD1-Z2[iZ2].nD1);

      if( Z2[iZ2].Z0>=0 ){
         for(int iD1= 0;iD1<Z2[iZ2].nD1;iD1++){
            Z2[iZ2].D1[iD1].tr.trans=dep.Z0[Z2[iZ2].Z0].trans;
            Z2[iZ2].D1[iD1].tr.rot=dep.Z0[Z2[iZ2].Z0].rot;
         }
      }

      for(int iX3= 0;iX3<nX3;iX3++){
         Z2[iZ2].D1.push_back( tZ2::tZ2D1(oR1));
         Z2[iZ2].D1[Z2[iZ2].nD1].R1[ 0].C4=Z2[iZ2].R1[ 0].C4;
         Z2[iZ2].D1[Z2[iZ2].nD1].R1[  0  ].phi=Z2[iZ2].R1[  0  ].phi;
         Z2[iZ2].D1[Z2[iZ2].nD1].R1[oR1-1].psi=Z2[iZ2].R1[oR1-1].psi;
         Z2[iZ2].D1[Z2[iZ2].nD1].R1[oR1-1].omg=Z2[iZ2].R1[oR1-1].omg;
         for(int aR1= 0;aR1<pR1;aR1++){
            int iC4=vv.X3R1C4(iX3  ,aR1);
            Z2[iZ2].D1[Z2[iZ2].nD1].R1[  aR1].psi= deform_params.C4[iC4].psi;
            Z2[iZ2].D1[Z2[iZ2].nD1].R1[  aR1].omg= deform_params.C4[iC4].omg;
            Z2[iZ2].D1[Z2[iZ2].nD1].R1[1+aR1].phi= deform_params.C4[iC4].phi;
            std::string aa=sub.R1[jR1+1+aR1].aa;
//          if( (aa[0]=='e')||(aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||(aa[3]=='z') )aa=aa.substr(0,3)+' ';
            if      ( aa=="PRO " ){
               Z2[iZ2].D1[Z2[iZ2].nD1].R1[1+aR1].phi= (-74.39 );
            }else if( aa=="HPR " ){
               Z2[iZ2].D1[Z2[iZ2].nD1].R1[1+aR1].phi= (-74.39 );
            }
            Z2[iZ2].D1[Z2[iZ2].nD1].R1[1+aR1].C4=iC4;
         }

         bool REJECT=false;
         int nSTAR=0;
         int nBORD=0;
         for(int aR1= 0;aR1<oR1;aR1++){
            vv.R1cnf(aR1)="  ";
            std::string aa=sub.R1[jR1+aR1].aa;
            int iL0=sub.R1[jR1+aR1].L0;
            if( (aa=="ACE ")||(aa=="NME ")||(aa=="NH2 ") )continue;
            if( (aa[0]=='e')||(aa[0]=='z')||
                (aa[3]=='e')||(aa[3]=='z') )continue;
            double phi= Z2[iZ2].D1[Z2[iZ2].nD1].R1[  aR1].phi;
            double psi= Z2[iZ2].D1[Z2[iZ2].nD1].R1[  aR1].psi;
            int iH4=1 +int( phi +(180.00))/10;
            int jH4=1 +int( psi +(180.00))/10;
            int thr=residue_mappings.L0[iL0].thr;
            if( region_maps.H4H4scr(iH4,jH4)>thr )REJECT=true;
            if( phi>(0.00) ){
               phi=-phi;
               psi=-psi;
               vv.R1cnf(aR1)[1]='*';
               if( aa!="GLY " )nSTAR++;
               if( nSTAR>2 )REJECT=true;
            }
            iH4=1 +int( phi +(180.00))/10;
            jH4=1 +int( psi +(180.00))/10;
            int iI0=( aa=="GLY " )? region_maps.H4H4gly(iH4,jH4):
                                    region_maps.H4H4ala(iH4,jH4);
            vv.R1cnf(aR1)[0]=region_maps.I0alp(iI0);
            if( vv.R1cnf(aR1)[0]=='X' )nBORD++;
            if( nBORD>4 )REJECT=true;
         }
         if( REJECT ){
            Z2[iZ2].D1.pop_back();
            continue;
         }

         if( Z2[iZ2].Z0>=0 ){
            Z2[iZ2].D1[Z2[iZ2].nD1].tr.trans=dep.Z0[Z2[iZ2].Z0].trans;
            Z2[iZ2].D1[Z2[iZ2].nD1].tr.rot=dep.Z0[Z2[iZ2].Z0].rot;
         }

         double Fg= (0.00);
         for(int iR1= 0;iR1<oR1;iR1++){
            std::string aa=sub.R1[jR1+iR1].aa;
            std::string cnf=vv.R1cnf(iR1  );
            if      ( (aa=="SER ")&&(cnf=="A*") ){
               Fg+=(2.00)*energy_params.fac_pp;
            }else if( (aa=="CYS ")&&(cnf=="A*") ){
               Fg+=(3.60)*energy_params.fac_pp;
            }
         }

         double Rend= DEF_DEV18(physics_consts,residue_mappings,
                                out,str,sub,
                                iZ2,Z2[iZ2].nD1);

         for(int iR1= 0;iR1<oR1;iR1++){
            Z2[iZ2].D1[Z2[iZ2].nD1].R1[iR1].cnfa= vv.R1cnf(iR1);
         }
         Z2[iZ2].D1[Z2[iZ2].nD1].p= vv.X3p(iX3);
         Z2[iZ2].D1[Z2[iZ2].nD1].d= vv.X3d(iX3);
         Z2[iZ2].D1[Z2[iZ2].nD1].star=nSTAR;
         Z2[iZ2].D1[Z2[iZ2].nD1].bord=nBORD;
         Z2[iZ2].D1[Z2[iZ2].nD1].r= Rend;
         Z2[iZ2].D1[Z2[iZ2].nD1].fg= Fg;
         Z2[iZ2].nD1++;
      }
   }
   DEF_CLUST(physics_consts,deform_params,out,iZ2);
   ENDSTATE=0;
   return;
}
