#ifndef DEF_DEF_AUTOMATIC
#define DEF_DEF_AUTOMATIC

#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include <vector>

class Def_Automatic {
private:
   int oR1;                     //number of residues in terminal blocks

public:
   int oD1;                     //maximum number of segment deformations
   double z;                    //threshold probability of deformation
   Rotation_Matrix T1;          //target rotation matrix
   Coordinates x1;              //target coordinates (angstrom)
   int nV1;                     //number
   int iV1;                     //index
   int nV2;                     //number
   int iV2;                     //index
   int PASS;                    //iteration through displacement space
   Rotation_Matrix T2;          //target rotation matrix
   Coordinates x2;              //target coordinates (angstrom)
   Rotation_Matrix T3;          //R(the1)*U*R(the2)*U*R(the3)*U*R(the4)
   Coordinates x3;              //target coordinates (angstrom)
   int nDIS;                    //number
   int iDIS;                    //index
   double DISthe4[18];          //discrete values of theta4 (degree)
   Rotation_Matrix T4;          //R(the1)*U*R(the2)*U*R(the3)
   double the1[2];              //theta1 (degree)
   double the2[2];              //theta2 (degree)
   double the3[2];              //theta3 (degree)
   double C_;                   //URcisU= UR(150)U(psi)R( 0)U(omg)R(-75)U
   double S_;                   //  =R(106)U_(114)R(-36)
   double Cthe2;                //cos(theta2)
   double Sthe2;                //sin(theta2)
   int iSOL;                    //index of solution {0,1}
   Rotation_Matrix B;           //R(the2)*U*R(the3)*U
   Coordinates x4;              //target coordinates (angstrom)
   int mDIS;                    //number
   int jDIS;                    //index
   double DISps4[36];           //discrete values of psi4 (degree)
   double Zbet;                 //params of final eq f(psi3)=0
   double bet;                  //(degree)
   double Zgam;                 //params of final eq f(psi3)=0
   double gam;                  //(degree)
   Coordinates x5;              //target coordinates (angstrom)
   double mu1;                  //params of final eq f(psi3)=0
   double mu2;                  //
   int nSEG;                    //number
   double SEG1[8];              //start of psi3 segment (degree)
   double SEG2[8];              //end of psi3 segment (degree)
   double SGN1;                 //branch of soln of psi1(psi3)
   double SGN2;                 //branch of soln of psi2(psi3)
   int nROO;                    //number
   double ROOps3[32];           //roots of f(psi3) (degree)

   /*discrete confs of peptide planes for N-terminal block*/
   std::vector<double> o_V1R1psi;       //(degree)
   std::vector<double> o_V1R1phi;       //(degree)
   /*discrete confs of peptide planes for C-terminal block*/
   std::vector<double> o_V2R1psi;       //(degree)
   std::vector<double> o_V2R1phi;       //(degree)

   double& V1R1psi(int i,int j){
      return o_V1R1psi[ i*oR1 +j];
   }
   double& V1R1phi(int i,int j){
      return o_V1R1phi[ i*oR1 +j];
   }
   double& V2R1psi(int i,int j){
      return o_V2R1psi[ i*oR1 +j];
   }
   double& V2R1phi(int i,int j){
      return o_V2R1phi[ i*oR1 +j];
   }

   Def_Automatic(int o):
      oR1(o),
      oD1(2048)
   {
   }
};

#endif
