#ifndef DEF_DAT_RESIDUE_MAPPINGS
#define DEF_DAT_RESIDUE_MAPPINGS

#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Fourier1D_Coeffs.hh"
#include "../phi/Fourier2D_Coeffs.hh"
#include "../phi/Fourier3D_Coeffs.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Rotation_Matrix.hh"
#include <string>
#include <vector>

class DAT_RESIDUE_MAPPINGS {
public:
   class tL0 { /*residues in dataset*/
   public:
      std::string aa;           //4 char residue name
      char c1;                  //1 char class name
      char a1;                  //1 char residue name
      /*start indexes into sets*/
      int Q0a;                  //
      int U0a;                  //
      int F0a;                  //
      int B0a;                  //
      int G0a;                  //
      int H0a;                  //
      int J0a;                  //
      int Y0a;                  //
      int K0a;                  //
      /*numbers of set elements*/
      int cQ0;                  //
      int cU0;                  //
      int cF0;                  //
      int cB0;                  //
      int cG0;                  //
      int cH0;                  //
      int cJ0;                  //
      int cY0;                  //
      int cK0;                  //
      /*start indexes into sets*/
      int P0a;                  //
      int T0a;                  //
      /*numbers of set elements*/
      int cP0;                  //
      int cT0;                  //
      int cO0;                  //
      /*start indexes into sets*/
      int P2a;                  //
      /*numbers of set elements*/
      int cP2;                  //
      /*side chain ellipsoid*/
      double del;               //center displacement from CB along CA-->CB
      double ea;                //radius parallel to CA--CB (angstrom)
      double eb;                //radius perpendicular to CA--CB (angstrom)
      /*side chain rotamers*/
      int nQ6;                  //number of deformable side chain torsions
      int C2a;                  //start index into set of rotamers
      int cC2;                  //number of rotamers
      /*backbone deformation*/
      int G4;                   //group of (psi,phi) peptide plane confs
      int thr;                  //threshold for screen of (psi,phi) defs
      double dpsi;              //bond length (C --N ) (bohr)
      Rotation_Matrix Upsi;     //
      double domg;              //bond length (N --CA) (bohr)
      Rotation_Matrix Uomg;     //
      double dphi;              //bond length (CA--C ) (bohr)
      Rotation_Matrix Uphi;     //
      /*screen energy*/
      /*position (X---Ca--N---C) and volume of side chain centroid*/
      double dst;               //bond length (bohr)
      double lam;               //bond angle (radian)
      double chi;               //torsion angle (radian)
      Gaussian_Volume gau;      //volume density sqrt(kcal/bohr**3)
      int pol;                  //polarity {0=nonpolar,1=polar,2=charged}
      /*defect energy params*/
      double scsa;              //side chain surface area (A**2)
      double schp;              //side chain hydrophobicity
      tL0(){}
   };
   class tF0 { /*atoms in residues [backward order]*/
   public:
      std::string atm;          //4 char atom name
      int typ;                  //atom type
      int hb;                   //H-bond bit pattern {1=don,2=acc,3=other}
      int lnk;                  //index of backward atom of 1-2 atom pair
      /*atomic multipoles in local coordinate system*/
      int lte;                  //maximum L of multipoles
      Multipoles q;             //
      int lhb;                  //maximum L of multipoles
      Multipoles p;             //H-bond octopole
      /*atom name specification of local coordinate system*/
      std::string ztip;         //z-axis tip
      std::string zbse;         //z-axis base
      std::string xtip;         //xz-plane tip
      std::string xbse;         //xz-plane base
      /*site gaussians*/
      Gaussian_Volume gau;      //volume density sqrt(hart/bohr**3)
      int mu;                   //number of intersecting atoms
      int fac[3];               //intersecting atoms
      std::string wjnt;         //water site donor or acceptor
      Coordinates u;            //u0*[-1.0+tanh( u1*excluded_volume -u2)]
      Gaussian_Volume ef[4];    //elec field density sqrt(hart/bohr**3)
      int zet;                  //charge
      Gaussian_Volume vf;       //volume density sqrt(1/bohr**3)
      int kap;                  //low dielectric site
      tF0(){}
   };
   class tB0 { /*atoms in residue base groups [forward order]*/
   public:
      int F0;                   //map to F0
      Coordinates x;            //coords (bohr)
      tB0(){}
   };
   class tG0 { /*atoms in residue forward groups [forward order]*/
   public:
      int F0;                   //map to F0
      Coordinates b;            //untransformed coords (bohr)
      tG0(){}
   };
   class tH0 { /*atoms in residue backward groups of branch torsions [branch
                 backward order]*/
   public:
      std::string F0;           //map to F0
      tH0(){}
   };
   class tQ0 { /*torsions in residues [forward order]*/
   public:
      std::string tor;          //3 char torsion name
      /*torsion tree*/
      int br;                   //branch
      int jnt;                  //index offset to connected torsion
      int cbr;                  //branch of connected torsion
      bool omg;                 //order of generation bb-sc switch
      int ext;                  //connection to external residue
      /*forward group*/
      int bse;                  //base atom
      int cG0;                  //number of atoms
      int G0a;                  //start index into set of atoms
      int chg;                  //net charge
      /*mappings*/
      int X0;                   //
      int X0a;                  //start index into set of bb torsions
      int U0;                   //
      /*chi=(torsion angle), lam=(pi-bond angle)*/
      Rotation_Matrix tu;       //t(chi about x-axis)u(lam about z-axis)
      Fourier1D_Coeffs tau;     //fourier coeffs (hart)
      /*K2=patterns of subsets of degrees of freedom*/
      tQ0(){}
   };
   class tX0 { /*torsions in residues [backward order]*/
   public:
      /*backward group*/
      int bse;                  //base atom
      int cF0;                  //number of atoms
      int F0a;                  //start index into set of atoms
      tX0(){}
   };
   class tU0 { /*side chain torsions in residues [branch backward order]*/
   public:
      int X0;                   //map to X0
      /*branch backward group*/
      std::string bse;          //5 char base atom
      int cH0;                  //number of atoms
      int H0a;                  //start index into set of atoms
      tU0(){}
   };
   class tP0 { /*physical atoms in residues [iupac order]*/
   public:
      std::string atm;          //4 char atom name
      int typ;                  //atom type
      bool sc;                  //sc atom
      tP0(){}
   };
   class tT0 { /*torsions in residues [iupac order]*/
   public:
      std::string tor;          //3 char torsion name
      tT0(){}
   };
   class tJ0 { /*pairs of adjacent torsion angles in residues*/
   public:
      Fourier2D_Coeffs tau;     //fourier coeffs (hart)
      tJ0(){}
   };
   class tY0 { /*triples of adjacent torsion angles in residues*/
   public:
      Fourier3D_Coeffs tau;     //fourier coeffs (hart)
      tY0(){}
   };
   class tK0 { /*cross links for ring closure in residues*/
   public:
      double a;                 //harmonic force constant (hart/bohr**2)
      double r;                 //target distance (bohr)
      tK0(){}
   };
   class tP2 { /*physical atoms in blocked residues [iupac order]*/
   public:
      /*residue offsets*/
      int grp0;                 //
      int grp1;                 //
      int grp2;                 //
      int grp3;                 //
      /*4 char atom names*/
      std::string atm0;         //
      std::string atm1;         //
      std::string atm2;         //
      std::string atm3;         //
      double dst;               //bond length (angstrom)
      double lam;               //bond angle (degree)
      double chi;               //torsion angle (degree)
      tP2(){}
   };
   class tC2 { /*side chain rotamers*/
   public:
      double e;                 //-kTln( p) of rotamer
      tC2(){}
   };

private:
   int zL0;                             //before alt end group ion states
   std::vector<std::string> o_T0A0atm;  //atom name
   std::vector<int> o_T0A0R0;           //residue offset
   std::vector<std::string> o_J0N2tor;  //pair of 3 char torsion names
   std::vector<std::string> o_Y0N3tor;  //triple of 3 char torsion names
   std::vector<std::string> o_K0N2atm;  //pair of 4 char atom names
   std::vector<bool> o_Q0K2sub;         //degree of freedom
   std::vector<std::string> o_L0L0atm;  //final atom in i to j res substitution
   std::vector<int> o_L0Q6Q0;           //mapping to index of torsion
   std::vector<double> o_C2Q6chi;       //collection of torsion angles (degree)
   std::vector<double> o_L0L0con;       //res-res contact energy

   std::string& T0A0atm(int i,int j){
      return o_T0A0atm.at( i*4 +j);
   }
   int& T0A0R0(int i,int j){
      return o_T0A0R0.at( i*4 +j);
   }
   std::string& J0N2tor(int i,int j){
      return o_J0N2tor.at( i*2 +j);
   }
   std::string& Y0N3tor(int i,int j){
      return o_Y0N3tor.at( i*3 +j);
   }
   std::string& K0N2atm(int i,int j){
      return o_K0N2atm.at( i*2 +j);
   }
   void Q0K2sub(int i,int j,bool a){
      o_Q0K2sub[ i*8 +j]=a;
      return;
   }
   std::string& L0L0atm(int i,int j){
      return o_L0L0atm.at( i*zL0 +j);
   }
   int& L0Q6Q0(int i,int j){
      return o_L0Q6Q0.at( i*5 +j);
   }
   double& C2Q6chi(int i,int j){
      return o_C2Q6chi.at( i*5 +j);
   }
   double& L0L0con(int i,int j){
      return o_L0L0con.at( i*zL0 +j);
   }

public:
   int nL0;                     //number of residues in dataset
   std::vector<tL0> L0;         //
   std::vector<tF0> F0;         //
   std::vector<tB0> B0;         //
   std::vector<tG0> G0;         //
   std::vector<tH0> H0;         //
   std::vector<tQ0> Q0;         //
   std::vector<tX0> X0;         //
   std::vector<tU0> U0;         //
   std::vector<tP0> P0;         //
   std::vector<tT0> T0;         //
   std::vector<tJ0> J0;         //
   std::vector<tY0> Y0;         //
   std::vector<tK0> K0;         //
   std::vector<tP2> P2;         //
   std::vector<tC2> C2;         //

   const std::string& T0A0atm(int i,int j) const {
      return o_T0A0atm.at( i*4 +j);
   }
   const int& T0A0R0(int i,int j) const {
      return o_T0A0R0.at( i*4 +j);
   }
   const std::string& J0N2tor(int i,int j) const {
      return o_J0N2tor.at( i*2 +j);
   }
   const std::string& Y0N3tor(int i,int j) const {
      return o_Y0N3tor.at( i*3 +j);
   }
   const std::string& K0N2atm(int i,int j) const {
      return o_K0N2atm.at( i*2 +j);
   }
   bool Q0K2sub(int i,int j) const {
      return o_Q0K2sub[ i*8 +j];
   }
   const std::string& L0L0atm(int i,int j) const {
      if( i>=zL0 ){
         std::string aa=L0[i].aa;
         if( aa[0]=='z' )aa[0]='e';
         if( aa[3]=='z' )aa[3]='e';
         i=-1;
         for(int k=0;k<zL0;k++){
            if( L0[k].aa==aa ){
               i=k;
               break;
            }
         }
      }
      if( j>=zL0 ){
         std::string aa=L0[j].aa;
         if( aa[0]=='z' )aa[0]='e';
         if( aa[3]=='z' )aa[3]='e';
         j=-1;
         for(int k=0;k<zL0;k++){
            if( L0[k].aa==aa ){
               j=k;
               break;
            }
         }
      }
      return o_L0L0atm.at( i*zL0 +j);
   }
   const int& L0Q6Q0(int i,int j) const {
      return o_L0Q6Q0.at( i*5 +j);
   }
   const double& C2Q6chi(int i,int j) const {
      return o_C2Q6chi.at( i*5 +j);
   }
   const double& L0L0con(int i,int j) const {
      if( i>=zL0 ){
         std::string aa=L0[i].aa;
         if( aa[0]=='z' )aa[0]='e';
         if( aa[3]=='z' )aa[3]='e';
         i=-1;
         for(int k=0;k<zL0;k++){
            if( L0[k].aa==aa ){
               i=k;
               break;
            }
         }
      }
      if( j>=zL0 ){
         std::string aa=L0[j].aa;
         if( aa[0]=='z' )aa[0]='e';
         if( aa[3]=='z' )aa[3]='e';
         j=-1;
         for(int k=0;k<zL0;k++){
            if( L0[k].aa==aa ){
               j=k;
               break;
            }
         }
      }
      return o_L0L0con.at( i*zL0 +j);
   }

   DAT_RESIDUE_MAPPINGS(const DAT_PHYSICS_CONSTS& physics_consts,
                        const DAT_ARRAY_CONSTS& array_consts,
                        const DAT_ENERGY_PARAMS& energy_params);
   int iresidue(std::string aa) const;
   int if0atom(int iL0,std::string atm) const;
   int ib0atom(int iL0,std::string atm) const;
   int ig0atom(int iL0,std::string atm) const;
   int iq0torsion(int iL0,std::string tor) const;
   int ip0atom(int iL0,std::string atm) const;
   int it0torsion(int iL0,std::string tor) const;
   int ip2atom(int iL0,std::string atm) const;
};

#endif
