#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Multipoles.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <sstream>
#include <iomanip>
#include <cmath>

class MEM_DAT_RESIDUE_MAPPINGS {
public:
   std::vector<std::string> o_Lrec;     //lines from input file
   MEM_DAT_RESIDUE_MAPPINGS(){
   }
   std::string& Lrec(int i){
      return o_Lrec.at( i);  }
};

DAT_RESIDUE_MAPPINGS::DAT_RESIDUE_MAPPINGS(
                                const DAT_PHYSICS_CONSTS& physics_consts,
                                const DAT_ARRAY_CONSTS& array_consts,
                                const DAT_ENERGY_PARAMS& energy_params){
   MEM_DAT_RESIDUE_MAPPINGS vv;
   std::ifstream ifile;
   std::string rec;
   int p;
   double fac_pp= std::sqrt( energy_params.fac_pp);
   double fac_h= std::sqrt( energy_params.fac_h);
//
//
// residue_mappings
//
   ifile.open("../dat/residue_mappings");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=1;
   std::istringstream(vv.Lrec(p++).substr( 4, 4))>>zL0;
   p+=5;
   int jQ0=0;
   int jU0=0;
   int jF0=0;
   int jB0=0;
   int jG0=0;
   int jH0=0;
   int jJ0=0;
   int jY0=0;
   int jK0=0;
   for(int iL0=0;iL0<zL0;iL0++){
      L0.push_back( tL0());
      for(int i=0;i<5;i++){
         o_L0Q6Q0.push_back( 0);
      }
      L0[iL0].aa=vv.Lrec(p  ).substr( 5, 4);
      L0[iL0].c1=vv.Lrec(p  )[11];
      L0[iL0].Q0a=jQ0;
      L0[iL0].U0a=jU0;
      L0[iL0].F0a=jF0;
      L0[iL0].B0a=jB0;
      L0[iL0].G0a=jG0;
      L0[iL0].H0a=jH0;
      L0[iL0].J0a=jJ0;
      L0[iL0].Y0a=jY0;
      L0[iL0].K0a=jK0;
      std::istringstream(vv.Lrec(p++).substr(12,36))
            >>L0[iL0].cQ0 >>L0[iL0].cU0
            >>L0[iL0].cF0 >>L0[iL0].cB0 >>L0[iL0].cG0 >>L0[iL0].cH0
            >>L0[iL0].cJ0 >>L0[iL0].cY0 >>L0[iL0].cK0;
      jQ0+=L0[iL0].cQ0;
      jU0+=L0[iL0].cU0;
      jF0+=L0[iL0].cF0;
      jB0+=L0[iL0].cB0;
      jG0+=L0[iL0].cG0;
      jH0+=L0[iL0].cH0;
      jJ0+=L0[iL0].cJ0;
      jY0+=L0[iL0].cY0;
      jK0+=L0[iL0].cK0;
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      int n=(L0[iL0].cF0+15)/16;
      rec.clear();
      for(int i=0;i<n;i++){
         rec+=vv.Lrec(p++).substr( 0,80);
      }
      int i=1;
      for(int iF0=mF0;iF0<=nF0;iF0++){
         F0.push_back( tF0());
         F0[iF0].atm=rec.substr( i, 4);
         i+=5;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      int n=(L0[iL0].cF0+15)/16;
      rec.clear();
      for(int i=0;i<n;i++){
         rec+=vv.Lrec(p++).substr( 0,48);
      }
      std::istringstream irec(rec);
      for(int iF0=mF0;iF0<=nF0;iF0++){
         irec>>F0[iF0].typ;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      int n=(L0[iL0].cF0+15)/16;
      rec.clear();
      for(int i=0;i<n;i++){
         rec+=vv.Lrec(p++).substr( 0,16);
      }
      for(int iF0=mF0;iF0<=nF0;iF0++){
         std::istringstream(rec.substr(iF0-mF0, 1))>>F0[iF0].hb;
      }
   }
   for(int iL0=0;iL0<zL0;iL0++){
      std::string aa=L0[iL0].aa;
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      for(int iF0=mF0;iF0<=nF0;iF0++){
         F0[iF0].lnk=-1;
      }
      if( (aa=="PRO ")||(aa=="ePRO")||(aa=="PROe") ){
         int aF0=-1;
         int bF0=-1;
         for(int iF0=mF0;iF0<=nF0;iF0++){
            std::string atm=F0[iF0].atm;
            if( atm==" CD " )bF0= iF0;
            if( atm==" N  " )aF0= iF0;
         }
         F0[bF0].lnk=aF0;
      }
      if( (aa=="D   ")||(aa=="R   ")||(aa=="RME ")||
          (aa=="RF  ")||(aa=="MOE ")||(aa=="LNA ")||
          (aa=="CET ") ){
         int aF0=-1;
         int bF0=-1;
         for(int iF0=mF0;iF0<=nF0;iF0++){
            std::string atm=F0[iF0].atm;
            if( atm==" C1'" )bF0= iF0;
            if( atm==" O4'" )aF0= iF0;
         }
         F0[bF0].lnk=aF0;
      }
      if( (aa=="LNA ")||(aa=="CET ") ){
         int aF0=-1;
         int bF0=-1;
         for(int iF0=mF0;iF0<=nF0;iF0++){
            std::string atm=F0[iF0].atm;
            if( atm==" C6'" )bF0= iF0;
            if( atm==" C4'" )aF0= iF0;
         }
         F0[bF0].lnk=aF0;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mG0=L0[iL0].G0a;
      int nG0=(mG0-1+L0[iL0].cG0);
      if( nG0<mG0 )continue;
      int n=(L0[iL0].cG0+15)/16;
      rec.clear();
      for(int i=0;i<n;i++){
         rec+=vv.Lrec(p++).substr( 0,64);
      }
      std::istringstream irec(rec);
      for(int iG0=mG0;iG0<=nG0;iG0++){
         G0.push_back( tG0());
         irec>>G0[iG0].F0;
         G0[iG0].F0+=(L0[iL0].F0a-1);
      }
   }
//
// for small nucleic acid end group 5OH
// B0[].F0<mF0
// index B0[].F0 is invalid
// displacement (B0[].F0-mF0) relative to mF1 remains valid
//
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mB0=L0[iL0].B0a;
      int nB0=(mB0-1+L0[iL0].cB0);
      if( nB0<mB0 )continue;
      int n=(L0[iL0].cB0+15)/16;
      rec.clear();
      for(int i=0;i<n;i++){
         rec+=vv.Lrec(p++).substr( 0,64);
      }
      std::istringstream irec(rec);
      for(int iB0=mB0;iB0<=nB0;iB0++){
         B0.push_back( tB0());
         irec>>B0[iB0].F0;
         B0[iB0].F0+=(L0[iL0].F0a-1);
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mH0=L0[iL0].H0a;
      int nH0=(mH0-1+L0[iL0].cH0);
      if( nH0<mH0 )continue;
      int n=(L0[iL0].cH0+15)/16;
      rec.clear();
      for(int i=0;i<n;i++){
         rec+=vv.Lrec(p++).substr( 0,80);
      }
      int i=0;
      for(int iH0=mH0;iH0<=nH0;iH0++){
         H0.push_back( tH0());
         H0[iH0].F0=rec.substr( i, 5);
         i+=5;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      rec=vv.Lrec(p++);
      int i=1;
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         Q0.push_back( tQ0());
         for(int j=0;j<8;j++){
            o_Q0K2sub.push_back(false);
         }
         Q0[iQ0].tor=rec.substr( i, 3);
         i+=4;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      rec=vv.Lrec(p++);
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         std::istringstream(rec.substr(iQ0-mQ0, 1))>>Q0[iQ0].br;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      rec=vv.Lrec(p++);
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         std::istringstream(rec.substr(iQ0-mQ0, 1))>>Q0[iQ0].jnt;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      rec=vv.Lrec(p++);
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         std::istringstream(rec.substr(iQ0-mQ0, 1))>>Q0[iQ0].cbr;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      rec=vv.Lrec(p++);
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         Q0[iQ0].omg=( rec[iQ0-mQ0]=='1' )?  true: false;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      rec=vv.Lrec(p++);
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         std::istringstream(rec.substr(iQ0-mQ0, 1))>>Q0[iQ0].ext;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      std::istringstream irec(vv.Lrec(p++).substr( 0,48));
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         irec>>Q0[iQ0].bse;
         Q0[iQ0].bse+=(L0[iL0].F0a-1);
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      std::istringstream irec(vv.Lrec(p++).substr( 0,48));
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         irec>>Q0[iQ0].cG0;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      std::istringstream irec(vv.Lrec(p++).substr( 0,48));
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         irec>>Q0[iQ0].G0a;
         Q0[iQ0].G0a+=(L0[iL0].G0a-1);
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      std::istringstream irec(vv.Lrec(p++).substr( 0,36));
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         irec>>Q0[iQ0].X0;
         Q0[iQ0].X0+=(L0[iL0].Q0a-1);
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      std::istringstream irec(vv.Lrec(p++).substr( 0,36));
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         irec>>Q0[iQ0].X0a;
         if( Q0[iQ0].X0a<=0 ){
         }else{
            Q0[iQ0].X0a+=(L0[iL0].Q0a-1);
         }
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      std::istringstream irec(vv.Lrec(p++).substr( 0,36));
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         irec>>Q0[iQ0].U0;
         if( Q0[iQ0].U0==0 ){
            Q0[iQ0].U0=-1;
         }else{
            Q0[iQ0].U0+=(L0[iL0].U0a-1);
         }
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      std::istringstream irec(vv.Lrec(p++).substr( 0,60));
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         irec>>Q0[iQ0].chg;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mX0=L0[iL0].Q0a;
      int nX0=(mX0-1+L0[iL0].cQ0);
      if( nX0<mX0 )continue;
      std::istringstream irec(vv.Lrec(p++).substr( 0,48));
      for(int iX0=mX0;iX0<=nX0;iX0++){
         X0.push_back( tX0());
         irec>>X0[iX0].bse;
         X0[iX0].bse+=(L0[iL0].F0a-1);
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mX0=L0[iL0].Q0a;
      int nX0=(mX0-1+L0[iL0].cQ0);
      if( nX0<mX0 )continue;
      std::istringstream irec(vv.Lrec(p++).substr( 0,48));
      for(int iX0=mX0;iX0<=nX0;iX0++){
         irec>>X0[iX0].cF0;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mX0=L0[iL0].Q0a;
      int nX0=(mX0-1+L0[iL0].cQ0);
      if( nX0<mX0 )continue;
      std::istringstream irec(vv.Lrec(p++).substr( 0,48));
      for(int iX0=mX0;iX0<=nX0;iX0++){
         irec>>X0[iX0].F0a;
         X0[iX0].F0a+=(L0[iL0].F0a-1);
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mU0=L0[iL0].U0a;
      int nU0=(mU0-1+L0[iL0].cU0);
      if( nU0<mU0 )continue;
      std::istringstream irec(vv.Lrec(p++).substr( 0,27));
      for(int iU0=mU0;iU0<=nU0;iU0++){
         U0.push_back( tU0());
         irec>>U0[iU0].X0;
         U0[iU0].X0+=(L0[iL0].Q0a-1);
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mU0=L0[iL0].U0a;
      int nU0=(mU0-1+L0[iL0].cU0);
      if( nU0<mU0 )continue;
      rec=vv.Lrec(p++);
      int i=0;
      for(int iU0=mU0;iU0<=nU0;iU0++){
         U0[iU0].bse=rec.substr( i, 5);
         i+=5;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mU0=L0[iL0].U0a;
      int nU0=(mU0-1+L0[iL0].cU0);
      if( nU0<mU0 )continue;
      std::istringstream irec(vv.Lrec(p++).substr( 0,36));
      for(int iU0=mU0;iU0<=nU0;iU0++){
         irec>>U0[iU0].cH0;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mU0=L0[iL0].U0a;
      int nU0=(mU0-1+L0[iL0].cU0);
      if( nU0<mU0 )continue;
      std::istringstream irec(vv.Lrec(p++).substr( 0,36));
      for(int iU0=mU0;iU0<=nU0;iU0++){
         irec>>U0[iU0].H0a;
         U0[iU0].H0a+=(L0[iL0].H0a-1);
      }
   }
   vv.o_Lrec.clear();
//
//
// residue_interface
//
   ifile.open("../dat/residue_interface");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=3;
   std::string message="ERROR: data inconsistency,"
                       " FILE= dat/residue_interface, LINE=";
   int jP0=0;
   int jT0=0;
   for(int iL0=0;iL0<zL0;iL0++){
      L0[iL0].P0a=jP0;
      L0[iL0].T0a=jT0;
      std::string aa(vv.Lrec(p  ), 5, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      std::istringstream(vv.Lrec(p++).substr(10,12))>>L0[iL0].cP0
                                                    >>L0[iL0].cT0
                                                    >>L0[iL0].cO0;
      jP0+=L0[iL0].cP0;
      jT0+=L0[iL0].cT0;
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mP0=L0[iL0].P0a;
      int nP0=(mP0-1+L0[iL0].cP0);
      int n=(L0[iL0].cP0+15)/16;
      rec.clear();
      for(int i=0;i<n;i++){
         rec+=vv.Lrec(p++).substr( 0,80);
      }
      int i=1;
      for(int iP0=mP0;iP0<=nP0;iP0++){
         P0.push_back( tP0());
         P0[iP0].atm=rec.substr( i, 4);
         i+=5;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mP0=L0[iL0].P0a;
      int nP0=(mP0-1+L0[iL0].cP0);
      std::istringstream irec(vv.Lrec(p++).substr( 0,78));
      for(int iP0=mP0;iP0<=nP0;iP0++){
         irec>>P0[iP0].typ;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mP0=L0[iL0].P0a;
      int nP0=(mP0-1+L0[iL0].cP0);
      rec=vv.Lrec(p++).substr( 0,26);
      for(int iP0=mP0;iP0<=nP0;iP0++){
         P0[iP0].sc=( rec[iP0-mP0]=='1' )?  true: false;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mT0=L0[iL0].T0a;
      int nT0=(mT0-1+L0[iL0].cT0);
      if( nT0<mT0 )continue;
      rec=vv.Lrec(p++).substr( 0,48);
      int i=1;
      for(int iT0=mT0;iT0<=nT0;iT0++){
         T0.push_back( tT0());
         for(int j=0;j<4;j++){
            o_T0A0atm.push_back("    ");
            o_T0A0R0.push_back( 0);
         }
         T0[iT0].tor=rec.substr( i, 3);
         i+=4;
      }
   }
   p+=3;
   for(int iL0=0;iL0<zL0;iL0++){
      int mT0=L0[iL0].T0a;
      int nT0=(mT0-1+L0[iL0].cT0);
      if( nT0<mT0 )continue;
      std::string aa(vv.Lrec(p++),25, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< p<<'\n';
         std::exit( 1);
      }
      for(int iT0=mT0;iT0<=nT0;iT0++){
         rec=vv.Lrec(p++).substr( 0,23);
         int i=1;
         for(int iA0=0;iA0<4;iA0++){
            T0A0atm(iT0,iA0)=rec.substr( i, 4);
            i+=6;
         }
      }
      for(int iT0=mT0;iT0<=nT0;iT0++){
         std::istringstream irec(vv.Lrec(p++).substr( 0, 8));
         for(int iA0=0;iA0<4;iA0++){
            irec>>T0A0R0(iT0,iA0);
         }
      }
   }
   vv.o_Lrec.clear();
//
//
// residue_geometry
//
   ifile.open("../dat/residue_geometry");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=2;
   message="ERROR: data inconsistency,"
           " FILE= dat/residue_geometry, LINE=";
   for(int iL0=0;iL0<zL0;iL0++){
      int mB0=L0[iL0].B0a;
      int nB0=(mB0-1+L0[iL0].cB0);
      if( nB0<mB0 )continue;
      std::string aa(vv.Lrec(p++),59, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< p<<'\n';
         std::exit( 1);
      }
      for(int iB0=mB0;iB0<=nB0;iB0++){
         std::string atm(vv.Lrec(p  ), 1, 4);
         if( B0[iB0].F0<L0[iL0].F0a ){
         }else{
            if( atm!=F0[B0[iB0].F0].atm ){
               std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
               std::exit( 1);
            }
         }
         std::istringstream irec(vv.Lrec(p++).substr( 6,51));
         for(int i=0;i<3;i++){
            irec>>B0[iB0].x(i);
            B0[iB0].x(i)/=physics_consts.ANG;
         }
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mG0=L0[iL0].G0a;
      int nG0=(mG0-1+L0[iL0].cG0);
      if( nG0<mG0 )continue;
      std::string aa(vv.Lrec(p++),59, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< p<<'\n';
         std::exit( 1);
      }
      for(int iG0=mG0;iG0<=nG0;iG0++){
         std::string atm(vv.Lrec(p  ), 1, 4);
         if( atm!=F0[G0[iG0].F0].atm ){
            std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
            std::exit( 1);
         }
         std::istringstream irec(vv.Lrec(p++).substr( 6,51));
         for(int i=0;i<3;i++){
            irec>>G0[iG0].b(i);
            G0[iG0].b(i)/=physics_consts.ANG;
         }
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      std::string aa(vv.Lrec(p++),58, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< p<<'\n';
         std::exit( 1);
      }
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         std::string tor(vv.Lrec(p  ), 1, 3);
         rec.clear();
         for(int i=0;i<3;i++){
            rec+=vv.Lrec(p++).substr( 5,51);
         }
         if( tor!=Q0[iQ0].tor ){
            std::cerr<< message<< std::setw(6)<< p<<'\n';
            std::exit( 1);
         }
         std::istringstream irec(rec);
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               irec>>Q0[iQ0].tu(i,j);
            }
         }
      }
   }
   vv.o_Lrec.clear();
//
//
// residue_fe
//
   ifile.open("../dat/residue_fe");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=2;
   message="ERROR: data inconsistency,"
           " FILE= dat/residue_fe, LINE=";
   for(int iL0=0;iL0<zL0;iL0++){
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      int n=(L0[iL0].cF0+15)/16;
      rec.clear();
      for(int i=0;i<n;i++){
         rec+=vv.Lrec(p++).substr( 0,48);
      }
      std::istringstream irec(rec);
      for(int iF0=mF0;iF0<=nF0;iF0++){
         irec>>F0[iF0].lte;
      }
   }
   p+=4;
   for(int iL0=0;iL0<zL0;iL0++){
      if( vv.Lrec(p++).substr( 0,16)!="________________" ){
         std::cerr<< message<< std::setw(6)<< p<<'\n';
         std::exit( 1);
      }
      std::string aa(vv.Lrec(p  ),32, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      double z= (1.00)/std::sqrt( (2.00));
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      for(int iF0=mF0;iF0<=nF0;iF0++){
         if( F0[iF0].lte==-1 )continue;
         std::string atm(vv.Lrec(p  ), 5, 4);
         int jF0;
         std::istringstream(vv.Lrec(p++).substr( 0, 4))>>jF0;
         if( ((jF0+L0[iL0].F0a-1)!=iF0)||(atm!=F0[iF0].atm) ){
            std::cerr<< message<< std::setw(6)<< p<<'\n';
            std::exit( 1);
         }
         if( vv.Lrec(p++).substr( 0,16)!="LOCAL AXES      " ){
            std::cerr<< message<< std::setw(6)<< p<<'\n';
            std::exit( 1);
         }
         F0[iF0].ztip=vv.Lrec(p  ).substr( 8, 4);
         F0[iF0].zbse=vv.Lrec(p++).substr(14, 4);
         F0[iF0].xtip=vv.Lrec(p  ).substr( 8, 4);
         F0[iF0].xbse=vv.Lrec(p++).substr(14, 4);
         if( vv.Lrec(p++).substr( 0,16)!="ATOMIC MULTIPOLE" ){
             std::cerr<< message<< std::setw(6)<< p<<'\n';
             std::exit( 1);
         }
         rec=vv.Lrec(p++).substr( 0,10);
         for(int i=0;i<10;i++){
            rec+=vv.Lrec(p++).substr( 0,30);
         }
         Multipoles a(4);
         double a_c[5][5];
         double a_s[5][5];
         for(int L=0;L<5;L++){
            a.i(L,0)= (0.00);
         }
         std::istringstream(rec)>>a.r(0,0)
                                >>a.r(1,0)>>a_c[1][1]>>a_s[1][1]
                                >>a.r(2,0)>>a_c[2][1]>>a_s[2][1]
                                          >>a_c[2][2]>>a_s[2][2]
                                >>a.r(3,0)>>a_c[3][1]>>a_s[3][1]
                                          >>a_c[3][2]>>a_s[3][2]
                                          >>a_c[3][3]>>a_s[3][3]
                                >>a.r(4,0)>>a_c[4][1]>>a_s[4][1]
                                          >>a_c[4][2]>>a_s[4][2]
                                          >>a_c[4][3]>>a_s[4][3]
                                          >>a_c[4][4]>>a_s[4][4];
         for(int L=1;L<5;L++){
            for(int M=1;M<=L;M++){
               a.r(L, M)= z*a_c[L][M]*array_consts.SGN(M);
               a.r(L,-M)= z*a_c[L][M];
               a.i(L, M)= z*a_s[L][M]*array_consts.SGN(M);
               a.i(L,-M)=-z*a_s[L][M];
            }
         }
         a*=fac_pp;
         F0[iF0].q.truncate(F0[iF0].lte,a);
      }
   }
   vv.o_Lrec.clear();
//
//
// residue_fp
//
   ifile.open("../dat/residue_fp");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=2;
   message="ERROR: data inconsistency,"
           " FILE= dat/residue_fp, LINE=";
   for(int iL0=0;iL0<zL0;iL0++){
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      int n=(L0[iL0].cF0+15)/16;
      rec.clear();
      for(int i=0;i<n;i++){
         rec+=vv.Lrec(p++).substr( 0,48);
      }
      std::istringstream irec(rec);
      for(int iF0=mF0;iF0<=nF0;iF0++){
         irec>>F0[iF0].lhb;
      }
   }
   p+=4;
   for(int iL0=0;iL0<zL0;iL0++){
      if( vv.Lrec(p++).substr( 0,16)!="________________" ){
         std::cerr<< message<< std::setw(6)<< p<<'\n';
         std::exit( 1);
      }
      std::string aa(vv.Lrec(p  ),32, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      char c1=L0[iL0].c1;
      double z= (1.00)/std::sqrt( (2.00));
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      for(int iF0=mF0;iF0<=nF0;iF0++){
         if( F0[iF0].lhb==-1 )continue;
         std::string atm(vv.Lrec(p  ), 5, 4);
         int jF0;
         std::istringstream(vv.Lrec(p  ).substr( 0, 4))>>jF0;
         if( ((jF0+L0[iL0].F0a-1)!=iF0)||(atm!=F0[iF0].atm) ){
            std::cerr<< message<< std::setw(6)<< p<<'\n';
            std::exit( 1);
         }
         std::string grp(vv.Lrec(p++),11,15);
         if( vv.Lrec(p++).substr( 0,16)!="LOCAL AXES      " ){
            std::cerr<< message<< std::setw(6)<< p<<'\n';
            std::exit( 1);
         }
         p+=2;
         if( vv.Lrec(p++).substr( 0,16)!="ATOMIC MULTIPOLE" ){
             std::cerr<< message<< std::setw(6)<< p<<'\n';
             std::exit( 1);
         }
         rec=vv.Lrec(p++).substr( 0,10);
         for(int i=0;i< 6;i++){
            rec+=vv.Lrec(p++).substr( 0,30);
         }
         Multipoles a(3);
         double a_c[4][4];
         double a_s[4][4];
         for(int L=0;L<4;L++){
            a.i(L,0)= (0.00);
         }
         std::istringstream(rec)>>a.r(0,0)
                                >>a.r(1,0)>>a_c[1][1]>>a_s[1][1]
                                >>a.r(2,0)>>a_c[2][1]>>a_s[2][1]
                                          >>a_c[2][2]>>a_s[2][2]
                                >>a.r(3,0)>>a_c[3][1]>>a_s[3][1]
                                          >>a_c[3][2]>>a_s[3][2]
                                          >>a_c[3][3]>>a_s[3][3];
         for(int L=1;L<4;L++){
            for(int M=1;M<=L;M++){
               a.r(L, M)= z*a_c[L][M]*array_consts.SGN(M);
               a.r(L,-M)= z*a_c[L][M];
               a.i(L, M)= z*a_s[L][M]*array_consts.SGN(M);
               a.i(L,-M)=-z*a_s[L][M];
            }
         }
// correction for repulsion offset (~1.08 kcal at 1.8 ang)
         a*=( 1.10);
// correction for 
         if      ( grp=="peptide        " ){
         }else if( grp=="acid_ionized   " ){
         }else if( grp=="imidazole      " ){
         }else if( grp=="amide          " ){
         }else if( grp=="alcohol        " ){
         }else if( grp=="phenol         " ){
         }else if( grp=="acid_neutral   " ){
         }else if( grp=="acid_protonated" ){
         }else if( grp=="phenol_ionized " ){
         }else if( grp=="water          " ){
         }else if( grp=="ether          " ){
         }else if( grp=="alcohol_nuc    " ){
         }else if( grp=="halogen        " ){
         }else if( grp=="phosphate      " ){
         }else if( grp=="carbonyl       " ){
         }else if( grp=="ester          " ){
         }
// correction for dipole-dipole polarization
         if      ( c1=='a' ){
            if      ( atm==" O  " ){
               a.i(1,0)= ( 0.200);
            }else if( atm==" H  " ){
               a.i(1,0)= ( 0.200);
            }else if( atm==" HG " ){
               a.i(1,0)= ( 0.075);
            }else if( atm==" HG1" ){
               a.i(1,0)= ( 0.075);
            }else if( atm==" HE1" ){
               a.i(1,0)= ( 0.150);
            }else if( atm==" HH " ){
               a.i(1,0)= ( 0.100);
            }
         }else if( c1=='e' ){
            if      ( atm==" O  " ){
               a.i(1,0)= ( 0.200);
            }
         }else if( c1=='b' ){
         }
         a*=( .90);
//       a*=fac_pp;
         F0[iF0].p.truncate(F0[iF0].lhb,a);
      }
   }
   vv.o_Lrec.clear();
//
//
// residue_ft
//
   ifile.open("../dat/residue_ft");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=3;
   message="ERROR: data inconsistency,"
           " FILE= dat/residue_ft, LINE=";
   for(int iL0=0;iL0<zL0;iL0++){
      int mY0=L0[iL0].Y0a;
      int nY0=(mY0-1+L0[iL0].cY0);
      if( nY0<mY0 )continue;
      if( vv.Lrec(p++).substr( 0,16)!="________________" ){
         std::cerr<< message<< std::setw(6)<< p<<'\n';
         std::exit( 1);
      }
      std::string aa(vv.Lrec(p  ),82, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      for(int iY0=mY0;iY0<=nY0;iY0++){
         Y0.push_back( tY0());
         o_Y0N3tor.push_back( vv.Lrec(p  ).substr( 4, 3));
         o_Y0N3tor.push_back( vv.Lrec(p  ).substr( 8, 3));
         o_Y0N3tor.push_back( vv.Lrec(p  ).substr(12, 3));
         int n;
         std::istringstream(vv.Lrec(p++).substr(16, 2))>>n;
         Y0[iY0].tau.resize( n);
         for(int i=0;i<n;i++){
            for(int kmin=0;kmin<n;kmin+=6){
               int kmax=( (kmin+6)<n )? (kmin+6): n;
               p++;
               rec.clear();
               for(int j=0;j<n;j++){
                  rec+=vv.Lrec(p++).substr(20,60);
               }
               std::istringstream irec(rec);
               for(int j=0;j<n;j++){
                  for(int k=kmin;k<kmax;k++){
                     irec>>Y0[iY0].tau(i,j,k);
                  }
               }
            }
         }
         Y0[iY0].tau/=physics_consts.CAL;
         Y0[iY0].tau*=energy_params.fac_pp;
      }
   }
   p+=3;
   for(int iL0=0;iL0<zL0;iL0++){
      int mJ0=L0[iL0].J0a;
      int nJ0=(mJ0-1+L0[iL0].cJ0);
      if( nJ0<mJ0 )continue;
      if( vv.Lrec(p++).substr( 0,16)!="________________" ){
         std::cerr<< message<< std::setw(6)<< p<<'\n';
         std::exit( 1);
      }
      std::string aa(vv.Lrec(p  ),72, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      for(int iJ0=mJ0;iJ0<=nJ0;iJ0++){
         J0.push_back( tJ0());
         o_J0N2tor.push_back( vv.Lrec(p  ).substr( 4, 3));
         o_J0N2tor.push_back( vv.Lrec(p  ).substr( 8, 3));
         int n;
         std::istringstream(vv.Lrec(p++).substr(12, 2))>>n;
         J0[iJ0].tau.resize( n);
         for(int jmin=0;jmin<n;jmin+=6){
            int jmax=( (jmin+6)<n )? (jmin+6): n;
            p++;
            rec.clear();
            for(int i=0;i<n;i++){
               rec+=vv.Lrec(p++).substr(10,60);
            }
            std::istringstream irec(rec);
            for(int i=0;i<n;i++){
               for(int j=jmin;j<jmax;j++){
                  irec>>J0[iJ0].tau(i,j);
               }
            }
         }
         J0[iJ0].tau/=physics_consts.CAL;
         J0[iJ0].tau*=energy_params.fac_pp;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      if( vv.Lrec(p++).substr( 0,16)!="________________" ){
         std::cerr<< message<< std::setw(6)<< p<<'\n';
         std::exit( 1);
      }
      std::string aa(vv.Lrec(p  ),62, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
         std::string tor(vv.Lrec(p  ), 1, 3);
         if( tor!=Q0[iQ0].tor ){
            std::cerr<< message<< std::setw(6)<< p<<'\n';
            std::exit( 1);
         }
         if( vv.Lrec(p  ).substr( 8, 5)=="BOUND" ){
            Q0[iQ0].tau.BOUND=true;
            std::istringstream(vv.Lrec(p  ).substr(14,14))>>Q0[iQ0].tau.ch0
                                                          >>Q0[iQ0].tau.ch1;
            Q0[iQ0].tau.ch0*=physics_consts.RAD;
            Q0[iQ0].tau.ch1*=physics_consts.RAD;
         }
         int n;
         std::istringstream(vv.Lrec(p++).substr( 5, 2))>>n;
         Q0[iQ0].tau.resize( n);
         rec.clear();
         p++;
         rec+=vv.Lrec(p++).substr( 0,10);
         for(int imin=1;imin<n;imin+=6){
            p++;
            rec+=vv.Lrec(p++).substr( 0,60);
         }
         std::istringstream irec(rec);
         for(int i=0;i<n;i++){
            irec>>Q0[iQ0].tau(i);
         }
         Q0[iQ0].tau/=physics_consts.CAL;
         Q0[iQ0].tau*=energy_params.fac_pp;
      }
   }
   vv.o_Lrec.clear();
//
//
// residue_fc
//
   ifile.open("../dat/residue_fc");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=2;
   message="ERROR: data inconsistency,"
           " FILE= dat/residue_fc, LINE=";
   for(int iL0=0;iL0<zL0;iL0++){
      int mK0=L0[iL0].K0a;
      int nK0=(mK0-1+L0[iL0].cK0);
      if( nK0<mK0 )continue;
      std::string aa(vv.Lrec(p++),28, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< p<<'\n';
         std::exit( 1);
      }
      for(int iK0=mK0;iK0<=nK0;iK0++){
         K0.push_back( tK0());
         o_K0N2atm.push_back( vv.Lrec(p  ).substr( 1, 4));
         o_K0N2atm.push_back( vv.Lrec(p  ).substr( 7, 4));
         std::istringstream(vv.Lrec(p++).substr(12,14))>>K0[iK0].a
                                                       >>K0[iK0].r;
         K0[iK0].a/=physics_consts.CAL;
         K0[iK0].a*=energy_params.fac_pp;
         K0[iK0].r/=physics_consts.ANG;
      }
   }
   vv.o_Lrec.clear();
//
//
// residue_fh
//
   ifile.open("../dat/residue_fh");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=2;
   message="ERROR: data inconsistency,"
           " FILE= dat/residue_fh, LINE=";
   for(int iL0=0;iL0<zL0;iL0++){
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      int n=(L0[iL0].cF0+15)/16;
      rec.clear();
      for(int i=0;i<n;i++){
         rec+=vv.Lrec(p++).substr( 0,16);
      }
      for(int iF0=mF0;iF0<=nF0;iF0++){
         std::istringstream(rec.substr(iF0-mF0, 1))>>F0[iF0].mu;
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      if( vv.Lrec(p++).substr( 0,16)!="________________" ){
         std::cerr<< message<< std::setw(6)<< p<<'\n';
         std::exit( 1);
      }
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      for(int iF0=mF0;iF0<=nF0;iF0++){
         if( F0[iF0].mu==0 )continue;
         std::string aa(vv.Lrec(p  ),40, 4);
         if( aa!=L0[iL0].aa ){
            std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
            std::exit( 1);
         }
         std::string atm(vv.Lrec(p  ), 5, 4);
         int jF0;
         std::istringstream(vv.Lrec(p  ).substr( 0, 4))>>jF0;
         if( ((jF0+mF0-1)!=iF0)||(atm!=F0[iF0].atm) ){
            std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
            std::exit( 1);
         }
         std::istringstream irec(vv.Lrec(p++).substr(10,28));
         irec>>F0[iF0].gau.sig >>F0[iF0].gau.eta;
         for(int i=0;i<3;i++){
            irec>>F0[iF0].fac[i];
         }
         if( F0[iF0].typ==30 ){
            F0[iF0].gau.sig*=std::sqrt(
                    std::pow(physics_consts.ANG,3)*physics_consts.CAL
                    /((1.05)*(.32e-1))
                                       );
            F0[iF0].gau.sig/=fac_h;
         }else{
            F0[iF0].gau.sig*=std::sqrt(
                    (1.05)*(.32e-1)*std::pow(physics_consts.ANG,3)
                    /physics_consts.CAL
                                       );
            F0[iF0].gau.sig*=fac_h;
         }
         F0[iF0].gau.eta*=std::pow(physics_consts.ANG,2);
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      for(int iF0=mF0;iF0<=nF0;iF0++){
         if( F0[iF0].atm==" w  " ){
            std::string aa(vv.Lrec(p  ),39, 4);
            if( aa!=L0[iL0].aa ){
               std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
               std::exit( 1);
            }
            std::string atm(vv.Lrec(p  ), 5, 4);
            int jF0;
            std::istringstream(vv.Lrec(p  ).substr( 0, 4))>>jF0;
            if( ((jF0+mF0-1)!=iF0)||(atm!=F0[iF0].atm) ){
               std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
               std::exit( 1);
            }
            F0[iF0].wjnt=vv.Lrec(p  ).substr(11, 4);
            std::istringstream irec(vv.Lrec(p++).substr(16,21));
            for(int i=0;i<3;i++){
               irec>>F0[iF0].u(i);
            }
            F0[iF0].u(0)/=((2.80)*physics_consts.CAL);
            F0[iF0].u(0)*=( .50);
////        F0[iF0].u(0)*=energy_params.fac_pp;
         }else{
            F0[iF0].wjnt="    ";
            F0[iF0].u.zero();
         }
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      int n=(L0[iL0].cF0+15)/16;
      rec.clear();
      for(int i=0;i<n;i++){
         rec+=vv.Lrec(p++).substr( 0,48);
      }
      std::istringstream irec(rec);
      for(int iF0=mF0;iF0<=nF0;iF0++){
         irec>>F0[iF0].zet;
      }
   }
   for(int iL0=0;iL0<zL0;iL0++){
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      for(int iF0=mF0;iF0<=nF0;iF0++){
         if( F0[iF0].zet!=0 ){
            F0[iF0].ef[0].sig=(   0.0364569);
            F0[iF0].ef[1].sig=(   0.0231999);
            F0[iF0].ef[2].sig=(   0.0082857);
            F0[iF0].ef[3].sig=(   0.0078714);
            F0[iF0].ef[0].eta=(   0.0700071);
            F0[iF0].ef[1].eta=(   0.0175018);
            F0[iF0].ef[2].eta=(   0.0043754);
            F0[iF0].ef[3].eta=(   0.0010939);
            double z= double( F0[iF0].zet)*(  .10)/( 1.12);
            for(int i=0;i<4;i++){
               F0[iF0].ef[i].sig*=z;
            }
            F0[iF0].zet=1;
         }
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      int n=(L0[iL0].cF0+15)/16;
      rec.clear();
      for(int i=0;i<n;i++){
         rec+=vv.Lrec(p++).substr( 0,48);
      }
      std::istringstream irec(rec);
      for(int iF0=mF0;iF0<=nF0;iF0++){
         irec>>F0[iF0].kap;
      }
   }
   for(int iL0=0;iL0<zL0;iL0++){
      int mF0=L0[iL0].F0a;
      int nF0=(mF0-1+L0[iL0].cF0);
      for(int iF0=mF0;iF0<=nF0;iF0++){
         if( F0[iF0].kap!=0 ){
            double z= physics_consts.ANG*physics_consts.ANG
                     /std::exp( (2.)*std::log( double( F0[iF0].kap))/(3.));
            F0[iF0].vf.sig=(  2.5191);
            F0[iF0].vf.eta=(  0.7745)*z;
            F0[iF0].kap=1;
         }
      }
   }
   vv.o_Lrec.clear();
//
//
// residue_zmatrix
//
   ifile.open("../dat/residue_zmatrix");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=3;
   message="ERROR: data inconsistency,"
           " FILE= dat/residue_zmatrix, LINE=";
   int jP2=0;
   for(int iL0=0;iL0<zL0;iL0++){
      L0[iL0].P2a=jP2;
      std::string aa(vv.Lrec(p  ), 5, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      std::istringstream(vv.Lrec(p++).substr(10, 4))>>L0[iL0].cP2;
      jP2+=L0[iL0].cP2;
   }
   p+=4;
   for(int iL0=0;iL0<zL0;iL0++){
      int mP2=L0[iL0].P2a;
      int nP2=(mP2-1+L0[iL0].cP2);
      if( nP2<mP2 )continue;
      std::string aa(vv.Lrec(p++), 1, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< p<<'\n';
         std::exit( 1);
      }
      for(int iP2=mP2;iP2<=nP2;(p++),iP2++){
         P2.push_back( tP2());
         std::istringstream(vv.Lrec(p  ).substr( 1, 2))>>P2[iP2].grp0;
         P2[iP2].atm0=vv.Lrec(p  ).substr( 4, 4);
         if( iP2==(mP2  ) )continue;
         std::istringstream(vv.Lrec(p  ).substr(10, 2))>>P2[iP2].grp1;
         P2[iP2].atm1=vv.Lrec(p  ).substr(13, 4);
         std::istringstream(vv.Lrec(p  ).substr(18, 6))>>P2[iP2].dst;
         if( iP2==(mP2+1) )continue;
         std::istringstream(vv.Lrec(p  ).substr(25, 2))>>P2[iP2].grp2;
         P2[iP2].atm2=vv.Lrec(p  ).substr(28, 4);
         std::istringstream(vv.Lrec(p  ).substr(33, 7))>>P2[iP2].lam;
         if( iP2==(mP2+2) )continue;
         std::istringstream(vv.Lrec(p  ).substr(41, 2))>>P2[iP2].grp3;
         P2[iP2].atm3=vv.Lrec(p  ).substr(44, 4);
         std::istringstream(vv.Lrec(p  ).substr(49, 8))>>P2[iP2].chi;
      }
   }
   vv.o_Lrec.clear();
//
//
// residue_subsets
//
   ifile.open("../dat/residue_subsets");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=13;
   message="ERROR: data inconsistency,"
           " FILE= dat/residue_subsets, LINE=";
   for(int iL0=0;iL0<zL0;iL0++){
      int mQ0=L0[iL0].Q0a;
      int nQ0=(mQ0-1+L0[iL0].cQ0);
      if( nQ0<mQ0 )continue;
      std::string aa(vv.Lrec(p  ),86, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      rec=vv.Lrec(p++).substr( 0,84);
      int i=0;
      for(int iK2=1;iK2<8;iK2++){
         for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
            if( rec[iQ0-mQ0 +i]=='1' ){
               Q0K2sub(iQ0,iK2,true);
            }
         }
         i+=12;
      }
   }
   vv.o_Lrec.clear();
//
//
// residue_homolog
//
   ifile.open("../dat/residue_homolog");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=3;
   message="ERROR: data inconsistency,"
           " FILE= dat/residue_homolog, LINE=";
   for(int iL0=0;iL0<zL0;iL0++){
      std::string aa(vv.Lrec(p  ), 5, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      L0[iL0].a1=vv.Lrec(p  )[11];
      std::istringstream(vv.Lrec(p++).substr(13,15))>>L0[iL0].del
                                                    >>L0[iL0].ea
                                                    >>L0[iL0].eb;
   }
   p+=2;
   int zL0L0=zL0*zL0;
   o_L0L0atm.resize(zL0L0,"    ");
   for(int i=0;i<zL0L0;i++){
      if( vv.Lrec(p  ).substr( 0, 8)=="________" )break;
      std::string aa(vv.Lrec(p  ), 1, 4);
      int iL0=-1;
      for(int kL0=0;kL0<zL0;kL0++){
         if( L0[kL0].aa==aa ){
            iL0=kL0;
            break;
         }
      }
      std::string ab(vv.Lrec(p  ), 6, 4);
      int jL0=-1;
      for(int kL0=0;kL0<zL0;kL0++){
         if( L0[kL0].aa==ab ){
            jL0=kL0;
            break;
         }
      }
      if( (iL0==-1)||(jL0==-1) ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      std::string atm(vv.Lrec(p++),11, 4);
      L0L0atm(iL0,jL0)=atm;
   }
   vv.o_Lrec.clear();
//
//
// residue_rotamers
//
   ifile.open("../dat/residue_rotamers");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=2;
   message="ERROR: data inconsistency,"
           " FILE= dat/residue_rotamers, LINE=";
   int jC2=0;
   for(int iL0=0;iL0<zL0;iL0++){
      L0[iL0].C2a=jC2;
      std::string aa(vv.Lrec(++p), 5, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      std::istringstream(vv.Lrec(p  ).substr(10, 8))>>L0[iL0].cC2
                                                    >>L0[iL0].nQ6;
      jC2+=L0[iL0].cC2;
      if( L0[iL0].cC2>0 ){
         std::istringstream irec(vv.Lrec(p  ).substr(19,15));
         for(int iQ6=0;iQ6<L0[iL0].nQ6;iQ6++){
            irec>>L0Q6Q0(iL0,iQ6);
            L0Q6Q0(iL0,iQ6)+=(L0[iL0].Q0a-1);
         }
      }
   }
   p+=2;
   for(int iL0=0;iL0<zL0;iL0++){
      int mC2=L0[iL0].C2a;
      int nC2=(mC2-1+L0[iL0].cC2);
      if( nC2<mC2 )continue;
      for(int iC2=mC2;iC2<=nC2;iC2++){
         std::string aa(vv.Lrec(++p),38, 4);
         if( aa!=L0[iL0].aa ){
            std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
            std::exit( 1);
         }
         C2.push_back( tC2());
         for(int i=0;i<5;i++){
            o_C2Q6chi.push_back( (0.00));
         }
         std::istringstream(vv.Lrec(p  ).substr( 3, 7))>>C2[iC2].e;
         std::istringstream irec(vv.Lrec(p  ).substr(11,25));
         for(int iQ6=0;iQ6<L0[iL0].nQ6;iQ6++){
            irec>>C2Q6chi(iC2,iQ6);
         }
      }
   }
   vv.o_Lrec.clear();
//
//
// residue_deform
//
   ifile.open("../dat/residue_deform");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=2;
   message="ERROR: data inconsistency,"
           " FILE= dat/residue_deform, LINE=";
   for(int iL0=0;iL0<zL0;iL0++){
      std::string aa(vv.Lrec(p  ), 5, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      std::istringstream(vv.Lrec(p++).substr(10, 4))>>L0[iL0].G4
                                                    >>L0[iL0].thr;
   }
   vv.o_Lrec.clear();
//
//
// deformation params derived from z-matrices
//
   for(int iL0=0;iL0<zL0;iL0++){
      std::string aa=L0[iL0].aa;
      if( aa[0]=='e' )aa=aa.substr(1,3)+' ';
      if( aa[3]=='e' )aa=aa.substr(0,3)+' ';
      int jL0=0;
      for(int kL0=0;kL0<zL0;kL0++){
         if( L0[kL0].aa==aa )jL0=kL0;
      }
      if( L0[jL0].cP2<12 )continue;
      if( (L0[jL0].c1=='a')||
          (L0[jL0].c1=='e') ){
         int iP2=(L0[jL0].P2a+2);
         std::string atm0=P2[iP2].atm0;
         std::string atm1=P2[iP2].atm1;
         std::string atm2=P2[iP2].atm2;
         int grp0=P2[iP2].grp0;
         int grp1=P2[iP2].grp1;
         int grp2=P2[iP2].grp2;
         if( (atm0==" N  ")&&(grp0== 0)&&
             (atm1==" C  ")&&(grp1==-1)&&
             (atm2==" CA ")&&(grp2==-1) ){
            L0[iL0].dpsi= (P2[iP2].dst/physics_consts.ANG);
            double thet= physics_consts.RAD*( (180.00) -P2[iP2].lam);
            double CT= std::cos( thet);
            double ST= std::sin( thet);
            L0[iL0].Upsi(0,0)= CT;
            L0[iL0].Upsi(1,0)= ST;
            L0[iL0].Upsi(2,0)= (0.00);
            L0[iL0].Upsi(0,1)=-ST;
            L0[iL0].Upsi(1,1)= CT;
            L0[iL0].Upsi(2,1)= (0.00);
            L0[iL0].Upsi(0,2)= (0.00);
            L0[iL0].Upsi(1,2)= (0.00);
            L0[iL0].Upsi(2,2)= (1.00);
         }
         iP2=(L0[jL0].P2a+3);
         atm0=P2[iP2].atm0;
         atm1=P2[iP2].atm1;
         atm2=P2[iP2].atm2;
         std::string atm3=P2[iP2].atm3;
         grp0=P2[iP2].grp0;
         grp1=P2[iP2].grp1;
         grp2=P2[iP2].grp2;
         int grp3=P2[iP2].grp3;
         if( (atm0==" CA ")&&(grp0== 0)&&
             (atm1==" N  ")&&(grp1== 0)&&
             (atm2==" C  ")&&(grp2==-1)&&
             (atm3==" CA ")&&(grp3==-1) ){
            L0[iL0].domg= (P2[iP2].dst/physics_consts.ANG);
            double thet= physics_consts.RAD*( (180.00) -P2[iP2].lam);
            double CT= std::cos( thet);
            double ST= std::sin( thet);
            L0[iL0].Uomg(0,0)= CT;
            L0[iL0].Uomg(1,0)= ST;
            L0[iL0].Uomg(2,0)= (0.00);
            L0[iL0].Uomg(0,1)=-ST;
            L0[iL0].Uomg(1,1)= CT;
            L0[iL0].Uomg(2,1)= (0.00);
            L0[iL0].Uomg(0,2)= (0.00);
            L0[iL0].Uomg(1,2)= (0.00);
            L0[iL0].Uomg(2,2)= (1.00);
         }
         iP2=(L0[jL0].P2a+4);
         atm0=P2[iP2].atm0;
         atm1=P2[iP2].atm1;
         atm2=P2[iP2].atm2;
         atm3=P2[iP2].atm3;
         grp0=P2[iP2].grp0;
         grp1=P2[iP2].grp1;
         grp2=P2[iP2].grp2;
         grp3=P2[iP2].grp3;
         if      ( (atm0==" C  ")&&(grp0== 0)&&
                   (atm1==" CA ")&&(grp1== 0)&&
                   (atm2==" N  ")&&(grp2== 0)&&
                   (atm3==" C  ")&&(grp3==-1) ){
            L0[iL0].dphi= (P2[iP2].dst/physics_consts.ANG);
            double thet= physics_consts.RAD*( (180.00) -P2[iP2].lam);
            double CT= std::cos( thet);
            double ST= std::sin( thet);
            L0[iL0].Uphi(0,0)= CT;
            L0[iL0].Uphi(1,0)= ST;
            L0[iL0].Uphi(2,0)= (0.00);
            L0[iL0].Uphi(0,1)=-ST;
            L0[iL0].Uphi(1,1)= CT;
            L0[iL0].Uphi(2,1)= (0.00);
            L0[iL0].Uphi(0,2)= (0.00);
            L0[iL0].Uphi(1,2)= (0.00);
            L0[iL0].Uphi(2,2)= (1.00);
         }
      }else{
      }
   }
//
//
// residue_screen
//
   ifile.open("../dat/residue_screen");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=7;
   message="ERROR: data inconsistency,"
           " FILE= dat/residue_screen, LINE=";
   for(int iL0=0;iL0<zL0;iL0++){
      std::string aa(vv.Lrec(p  ), 5, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      std::istringstream(vv.Lrec(p++).substr(10,46))>>L0[iL0].dst
                                                    >>L0[iL0].lam
                                                    >>L0[iL0].chi
                                                    >>L0[iL0].pol
                                                    >>L0[iL0].gau.sig
                                                    >>L0[iL0].gau.eta;
      L0[iL0].dst+=(1.00);
      L0[iL0].dst/=physics_consts.ANG;
      L0[iL0].lam*=physics_consts.RAD;
      L0[iL0].chi*=physics_consts.RAD;
   }
   p+=3;
   for(int iL0=0;iL0<zL0;iL0++){
      std::string aa(vv.Lrec(p  ), 5, 4);
      if( aa!=L0[iL0].aa ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      std::istringstream(vv.Lrec(p++).substr(10,14))>>L0[iL0].scsa
                                                    >>L0[iL0].schp;
   }
   p+=2;
   o_L0L0con.resize(zL0L0,(0.00));
   for(int i=0;i<zL0L0;i++){
      if( vv.Lrec(p  ).substr( 0, 8)=="________" )break;
      std::string aa(vv.Lrec(p  ), 1, 4);
      int iL0=-1;
      for(int kL0=0;kL0<zL0;kL0++){
         if( L0[kL0].aa==aa ){
            iL0=kL0;
            break;
         }
      }
      std::string ab(vv.Lrec(p  ), 6, 4);
      int jL0=-1;
      for(int kL0=0;kL0<zL0;kL0++){
         if( L0[kL0].aa==ab ){
            jL0=kL0;
            break;
         }
      }
      if( (iL0==-1)||(jL0==-1) ){
         std::cerr<< message<< std::setw(6)<< (p+1)<<'\n';
         std::exit( 1);
      }
      std::istringstream(vv.Lrec(p++).substr(11, 6))>>L0L0con(iL0,jL0);
   }
   vv.o_Lrec.clear();
//
//
// add alternative ionization state for N- and C-terminal ionizable groups
//
   jQ0=(L0[zL0-1].Q0a+L0[zL0-1].cQ0);
   jU0=(L0[zL0-1].U0a+L0[zL0-1].cU0);
   jF0=(L0[zL0-1].F0a+L0[zL0-1].cF0);
   jB0=(L0[zL0-1].B0a+L0[zL0-1].cB0);
   jG0=(L0[zL0-1].G0a+L0[zL0-1].cG0);
   jH0=(L0[zL0-1].H0a+L0[zL0-1].cH0);
   jJ0=(L0[zL0-1].J0a+L0[zL0-1].cJ0);
   jY0=(L0[zL0-1].Y0a+L0[zL0-1].cY0);
   jK0=(L0[zL0-1].K0a+L0[zL0-1].cK0);
   jP0=(L0[zL0-1].P0a+L0[zL0-1].cP0);
   jT0=(L0[zL0-1].T0a+L0[zL0-1].cT0);
   jP2=(L0[zL0-1].P2a+L0[zL0-1].cP2);
   jC2=(L0[zL0-1].C2a+L0[zL0-1].cC2);
   nL0=zL0;
   for(int iL0=0;iL0<zL0;iL0++){
      if( L0[iL0].c1!='a' )continue;
      std::string aa=L0[iL0].aa;
      if      ( aa[0]=='e' ){
         aa[0]='z';
      }else if( aa[3]=='e' ){
         aa[3]='z';
      }else{
         continue;
      }
      L0.push_back( tL0());
      for(int i=0;i<5;i++){
         o_L0Q6Q0.push_back( 0);
      }
      L0[nL0].aa=aa;
      L0[nL0].c1=L0[iL0].c1;
      L0[nL0].a1=L0[iL0].a1;
      L0[nL0].Q0a=jQ0;
      L0[nL0].U0a=jU0;
      L0[nL0].F0a=jF0;
      L0[nL0].B0a=jB0;
      L0[nL0].G0a=jG0;
      L0[nL0].H0a=jH0;
      L0[nL0].J0a=jJ0;
      L0[nL0].Y0a=jY0;
      L0[nL0].K0a=jK0;
      L0[nL0].cQ0=L0[iL0].cQ0;
      L0[nL0].cU0=L0[iL0].cU0;
      L0[nL0].cF0=L0[iL0].cF0;
      L0[nL0].cB0=L0[iL0].cB0;
      L0[nL0].cG0=L0[iL0].cG0;
      L0[nL0].cH0=L0[iL0].cH0;
      L0[nL0].cJ0=L0[iL0].cJ0;
      L0[nL0].cY0=L0[iL0].cY0;
      L0[nL0].cK0=L0[iL0].cK0;
      L0[nL0].P0a=jP0;
      L0[nL0].T0a=jT0;
      if      ( aa[0]=='z' ){
         L0[nL0].cP0=(L0[iL0].cP0-1);
      }else if( aa[3]=='z' ){
         L0[nL0].cP0=(L0[iL0].cP0+1);
      }
      L0[nL0].cT0=L0[iL0].cT0;
      L0[nL0].cO0=L0[iL0].cO0;
      L0[nL0].P2a=jP2;
      L0[nL0].cP2=L0[iL0].cP2;
      L0[nL0].del=L0[iL0].del;
      L0[nL0].ea=L0[iL0].ea;
      L0[nL0].eb=L0[iL0].eb;
      int nQ6=L0[iL0].nQ6;
      L0[nL0].nQ6=nQ6;
      for(int iQ6=0;iQ6<nQ6;iQ6++){
         L0Q6Q0(nL0,iQ6)=(L0Q6Q0(iL0,iQ6)-L0[iL0].Q0a+jQ0);
      }
      L0[nL0].C2a=jC2;
      L0[nL0].cC2=L0[iL0].cC2;
      L0[nL0].G4=L0[iL0].G4;
      L0[nL0].thr=L0[iL0].thr;
      L0[nL0].dpsi=L0[iL0].dpsi;
      L0[nL0].Upsi=L0[iL0].Upsi;
      L0[nL0].domg=L0[iL0].domg;
      L0[nL0].Uomg=L0[iL0].Uomg;
      L0[nL0].dphi=L0[iL0].dphi;
      L0[nL0].Uphi=L0[iL0].Uphi;
      L0[nL0].dst=L0[iL0].dst;
      L0[nL0].lam=L0[iL0].lam;
      L0[nL0].chi=L0[iL0].chi;
      std::string ab;
      if      ( aa[0]=='z' ){
         std::string ab=aa.substr(1,3)+' ';
      }else if( aa[3]=='z' ){
         std::string ab=aa.substr(0,3)+' ';
      }
      int jL0=0;
      for(int kL0=0;kL0<zL0;kL0++){
         if( L0[kL0].aa==ab )jL0=kL0;
      }
      L0[nL0].gau=L0[jL0].gau;
      L0[nL0].pol=L0[jL0].pol;
      L0[nL0].scsa=L0[iL0].scsa;
      L0[nL0].schp=L0[iL0].schp;

      int aF0=L0[iL0].F0a;
      int bF0=(aF0-1+L0[iL0].cF0);
      for(int iF0=aF0;iF0<=bF0;iF0++){
         F0.push_back( tF0());
         std::string atm=F0[iF0].atm;
         F0[iF0-aF0+jF0].atm=atm;
         F0[iF0-aF0+jF0].typ=F0[iF0].typ;
         F0[iF0-aF0+jF0].hb=F0[iF0].hb;
         int lnk=F0[iF0].lnk;
         if( lnk>-1 ){
            F0[iF0-aF0+jF0].lnk=(lnk-aF0+jF0);
         }else{
            F0[iF0-aF0+jF0].lnk=-1;
         }
         F0[iF0-aF0+jF0].lte=F0[iF0].lte;
         F0[iF0-aF0+jF0].q=F0[iF0].q;
         F0[iF0-aF0+jF0].ztip=F0[iF0].ztip;
         F0[iF0-aF0+jF0].zbse=F0[iF0].zbse;
         F0[iF0-aF0+jF0].xtip=F0[iF0].xtip;
         F0[iF0-aF0+jF0].xbse=F0[iF0].xbse;
         F0[iF0-aF0+jF0].lhb=F0[iF0].lhb;
         F0[iF0-aF0+jF0].p=F0[iF0].p;
         if      ( aa[0]=='z' ){
            if( aa=="zPRO" ){
               if      ( atm=="+CA " ){
                  F0[iF0-aF0+jF0].q.r(0,0)-=(.031399)*fac_pp;
               }else if( atm=="+N  " ){
                  F0[iF0-aF0+jF0].q.r(0,0)-=(.399330)*fac_pp;
               }else if( atm=="+CD " ){
                  F0[iF0-aF0+jF0].q.r(0,0)-=(.031399)*fac_pp;
               }else if( atm=="1H  " ){
                  F0[iF0-aF0+jF0].q.r(0,0)-=(.031399)*fac_pp;
               }else if( atm=="2mn " ){
                  F0[iF0-aF0+jF0].typ=7;
               }else if( atm=="2H  " ){
                  F0[iF0-aF0+jF0].lte=-1;
                  F0[iF0-aF0+jF0].q.zero();
                  F0[iF0-aF0+jF0].lhb=-1;
                  F0[iF0-aF0+jF0].p.zero();
                  F0[iF0-aF0+jF0].typ= 7;
                  F0[iF0-aF0+jF0].hb=3;
               }
            }else{
               if      ( atm=="+CA " ){
                  F0[iF0-aF0+jF0].q.r(0,0)-=(.048439)*fac_pp;
               }else if( atm=="+N  " ){
                  F0[iF0-aF0+jF0].q.r(0,0)-=(.373770)*fac_pp;
               }else if( atm=="1H  " ){
                  F0[iF0-aF0+jF0].q.r(0,0)-=(.048439)*fac_pp;
               }else if( atm=="2H  " ){
                  F0[iF0-aF0+jF0].q.r(0,0)-=(.048439)*fac_pp;
               }else if( atm=="3mn " ){
                  F0[iF0-aF0+jF0].typ=7;
               }else if( atm=="3H  " ){
                  F0[iF0-aF0+jF0].lte=-1;
                  F0[iF0-aF0+jF0].q.zero();
                  F0[iF0-aF0+jF0].lhb=-1;
                  F0[iF0-aF0+jF0].p.zero();
                  F0[iF0-aF0+jF0].typ= 7;
                  F0[iF0-aF0+jF0].hb=3;
               }
            }

         }else if( aa[3]=='z' ){
            if      ( atm=="+CA " ){
               F0[iF0-aF0+jF0].q.r(0,0)+=(.202857143)*fac_pp;
            }else if( atm=="+C  " ){
               F0[iF0-aF0+jF0].q.r(0,0)-=(.270000000)*fac_pp;
            }else if( atm==" O  " ){
               F0[iF0-aF0+jF0].q.r(0,0)+=(.160000000)*fac_pp;
               F0[iF0-aF0+jF0].p.r(3,0)= (-0.20569);
               double a_c[4];
               a_c[1]=(-0.09706);
               a_c[2]=(-0.37265);
               a_c[3]=(-0.13036);
               double z= (1.00)/std::sqrt( (2.00));
               for(int M=1;M<=3;M++){
                  F0[iF0-aF0+jF0].p.r(3, M)= z*a_c[M]*array_consts.SGN(M);
                  F0[iF0-aF0+jF0].p.r(3,-M)= z*a_c[M];
               }
            }else if( atm==" OXT" ){
               F0[iF0-aF0+jF0].ztip=" OXT";
               F0[iF0-aF0+jF0].zbse=" C  ";
               F0[iF0-aF0+jF0].xtip=" HOX";
               F0[iF0-aF0+jF0].xbse=" OXT";
               F0[iF0-aF0+jF0].lte=1;
               Multipoles a( 1);
               a.zero();
               a.r(0,0)=( F0[iF0-aF0+jF0].q.r(0,0) +(.400000000)*fac_pp);
               F0[iF0-aF0+jF0].q=a;
               F0[iF0-aF0+jF0].p.r(3,0)= ( 0.29962);
               double a_c[4];
               a_c[1]=( 0.06164);
               a_c[2]=(-0.41215);
               a_c[3]=( 0.23873);
               double z= (1.00)/std::sqrt( (2.00));
               for(int M=1;M<=3;M++){
                  F0[iF0-aF0+jF0].p.r(3, M)= z*a_c[M]*array_consts.SGN(M);
                  F0[iF0-aF0+jF0].p.r(3,-M)= z*a_c[M];
               }
            }else if( atm==" HOX" ){
               F0[iF0-aF0+jF0].ztip=" HOX";
               F0[iF0-aF0+jF0].zbse=" OXT";
               F0[iF0-aF0+jF0].xtip=" OXT";
               F0[iF0-aF0+jF0].xbse=" C  ";
               F0[iF0-aF0+jF0].lte=1;
               Multipoles a( 1);
               a.zero();
               a.r(0, 0)= (.400000000)*fac_pp;
               a.r(1, 0)= (.048000000)*fac_pp;
               F0[iF0-aF0+jF0].q=a;
               F0[iF0-aF0+jF0].lhb=3;
               F0[iF0-aF0+jF0].p=Multipoles( 3);
               F0[iF0-aF0+jF0].p.zero();
               F0[iF0-aF0+jF0].p.r(3,0)= ( 0.57500);
               F0[iF0-aF0+jF0].typ= 5;
               F0[iF0-aF0+jF0].hb=1;
            }

         }
         F0[iF0-aF0+jF0].gau=F0[iF0].gau;
         F0[iF0-aF0+jF0].mu=F0[iF0].mu;
         for(int i=0;i<3;i++){
            F0[iF0-aF0+jF0].fac[i]=F0[iF0].fac[i];
         }
         F0[iF0-aF0+jF0].u=F0[iF0].u;
         for(int i=0;i<4;i++){
            F0[iF0-aF0+jF0].ef[i]=F0[iF0].ef[i];
         }
         F0[iF0-aF0+jF0].zet=F0[iF0].zet;
         F0[iF0-aF0+jF0].vf=F0[iF0].vf;
         F0[iF0-aF0+jF0].kap=F0[iF0].kap;
         if      ( aa[0]=='z' ){
            if( atm==" N  " )F0[iF0-aF0+jF0].zet=0;
         }else if( aa[3]=='z' ){
            if( atm==" O  " )F0[iF0-aF0+jF0].zet=0;
            if( atm==" OXT" )F0[iF0-aF0+jF0].zet=0;
         }
      }
      int aB0=L0[iL0].B0a;
      int bB0=(aB0-1+L0[iL0].cB0);
      for(int iB0=aB0;iB0<=bB0;iB0++){
         B0.push_back( tB0());
         B0[iB0-aB0+jB0].F0=(B0[iB0].F0-aF0+jF0);
         B0[iB0-aB0+jB0].x=B0[iB0].x;
      }
      int aG0=L0[iL0].G0a;
      int bG0=(aG0-1+L0[iL0].cG0);
      for(int iG0=aG0;iG0<=bG0;iG0++){
         G0.push_back( tG0());
         G0[iG0-aG0+jG0].F0=(G0[iG0].F0-aF0+jF0);
         G0[iG0-aG0+jG0].b=G0[iG0].b;
      }
      int aH0=L0[iL0].H0a;
      int bH0=(aH0-1+L0[iL0].cH0);
      for(int iH0=aH0;iH0<=bH0;iH0++){
         H0.push_back( tH0());
         H0[iH0-aH0+jH0].F0=H0[iH0].F0;
      }
      int aQ0=L0[iL0].Q0a;
      int bQ0=(aQ0-1+L0[iL0].cQ0);
      int aU0=L0[iL0].U0a;
      int bU0=(aU0-1+L0[iL0].cU0);
      for(int iQ0=aQ0;iQ0<=bQ0;iQ0++){
         Q0.push_back( tQ0());
         for(int i=0;i<8;i++){
            o_Q0K2sub.push_back(false);
         }
         Q0[iQ0-aQ0+jQ0].tor=Q0[iQ0].tor;
         Q0[iQ0-aQ0+jQ0].br=Q0[iQ0].br;
         Q0[iQ0-aQ0+jQ0].jnt=Q0[iQ0].jnt;
         Q0[iQ0-aQ0+jQ0].cbr=Q0[iQ0].cbr;
         Q0[iQ0-aQ0+jQ0].omg=Q0[iQ0].omg;
         Q0[iQ0-aQ0+jQ0].ext=Q0[iQ0].ext;
         Q0[iQ0-aQ0+jQ0].bse=(Q0[iQ0].bse-aF0+jF0);
         Q0[iQ0-aQ0+jQ0].cG0=Q0[iQ0].cG0;
         Q0[iQ0-aQ0+jQ0].G0a=(Q0[iQ0].G0a-aG0+jG0);
         if      ( aa[0]=='z' ){
            Q0[iQ0-aQ0+jQ0].chg=Q0[iQ0].chg;
         }else if( aa[3]=='z' ){
            if( Q0[iQ0].tor=="PSI" ){
               Q0[iQ0-aQ0+jQ0].chg=0;
            }else{
               Q0[iQ0-aQ0+jQ0].chg=Q0[iQ0].chg;
            }
         }
         Q0[iQ0-aQ0+jQ0].X0=(Q0[iQ0].X0-aQ0+jQ0);
         Q0[iQ0-aQ0+jQ0].X0a=(Q0[iQ0].X0a-aQ0+jQ0);
         if( Q0[iQ0].U0==-1 ){
            Q0[iQ0-aQ0+jQ0].U0=-1;
         }else{
            Q0[iQ0-aQ0+jQ0].U0=(Q0[iQ0].U0-aU0+jU0);
         }
         Q0[iQ0-aQ0+jQ0].tu=Q0[iQ0].tu;
         Q0[iQ0-aQ0+jQ0].tau=Q0[iQ0].tau;
         for(int iK2=0;iK2<8;iK2++){
            Q0K2sub(iQ0-aQ0+jQ0,iK2,Q0K2sub(iQ0,iK2));
         }
      }
      for(int iX0=aQ0;iX0<=bQ0;iX0++){
         X0.push_back( tX0());
         X0[iX0-aQ0+jQ0].bse=(X0[iX0].bse-aF0+jF0);
         X0[iX0-aQ0+jQ0].cF0=X0[iX0].cF0;
         X0[iX0-aQ0+jQ0].F0a=(X0[iX0].F0a-aF0+jF0);
      }
      for(int iU0=aU0;iU0<=bU0;iU0++){
         U0.push_back( tU0());
         U0[iU0-aU0+jU0].X0=(U0[iU0].X0-aQ0+jQ0);
         U0[iU0-aU0+jU0].bse=U0[iU0].bse;
         U0[iU0-aU0+jU0].cH0=U0[iU0].cH0;
         U0[iU0-aU0+jU0].H0a=(U0[iU0].H0a-aH0+jH0);
      }
      int aP0=L0[iL0].P0a;
      int bP0=(aP0-1+L0[iL0].cP0);
      int nP0=( aa[0]=='z' )? (bP0-1): bP0;
      for(int iP0=aP0;iP0<=nP0;iP0++){
         P0.push_back( tP0());
         P0[iP0-aP0+jP0].atm=P0[iP0].atm;
         P0[iP0-aP0+jP0].typ=P0[iP0].typ;
         P0[iP0-aP0+jP0].sc=P0[iP0].sc;
      }
      if( aa[3]=='z' ){
         P0.push_back( tP0());
         P0[bP0-aP0+1+jP0].atm=" HOX";
         P0[bP0-aP0+1+jP0].typ= 5;
         P0[bP0-aP0+1+jP0].sc=false;
      }
      int aT0=L0[iL0].T0a;
      int bT0=(aT0-1+L0[iL0].cT0);
      for(int iT0=aT0;iT0<=bT0;iT0++){
         T0.push_back( tT0());
         for(int i=0;i<4;i++){
            o_T0A0atm.push_back("    ");
            o_T0A0R0.push_back( 0);
         }
         T0[iT0-aT0+jT0].tor=T0[iT0].tor;
         for(int iA0=0;iA0<4;iA0++){
            T0A0atm(iT0-aT0+jT0,iA0)=T0A0atm(iT0,iA0);
            T0A0R0(iT0-aT0+jT0,iA0)=T0A0R0(iT0,iA0);
         }
      }
      int aJ0=L0[iL0].J0a;
      int bJ0=(aJ0-1+L0[iL0].cJ0);
      for(int iJ0=aJ0;iJ0<=bJ0;iJ0++){
         J0.push_back( tJ0());
         for(int i=0;i<2;i++){
            o_J0N2tor.push_back("   ");
         }
         for(int iN2=0;iN2<2;iN2++){
            J0N2tor(iJ0-aJ0+jJ0,iN2)=J0N2tor(iJ0,iN2);
         }
         J0[iJ0-aJ0+jJ0].tau=J0[iJ0].tau;
      }
      int aY0=L0[iL0].Y0a;
      int bY0=(aY0-1+L0[iL0].cY0);
      for(int iY0=aY0;iY0<=bY0;iY0++){
         Y0.push_back( tY0());
         for(int i=0;i<3;i++){
            o_Y0N3tor.push_back("   ");
         }
         for(int iN3=0;iN3<3;iN3++){
            Y0N3tor(iY0-aY0+jY0,iN3)=Y0N3tor(iY0,iN3);
         }
         Y0[iY0-aY0+jY0].tau=Y0[iY0].tau;
      }
      int aK0=L0[iL0].K0a;
      int bK0=(aK0-1+L0[iL0].cK0);
      for(int iK0=aK0;iK0<=bK0;iK0++){
         K0.push_back( tK0());
         for(int i=0;i<2;i++){
            o_K0N2atm.push_back("    ");
         }
         K0[iK0-aK0+jK0].a=K0[iK0].a;
         K0[iK0-aK0+jK0].r=K0[iK0].r;
         for(int iN2=0;iN2<2;iN2++){
            K0N2atm(iK0-aK0+jK0,iN2)=K0N2atm(iK0,iN2);
         }
      }
      int aP2=L0[iL0].P2a;
      int bP2=(aP2-1+L0[iL0].cP2);
      for(int iP2=aP2;iP2<=bP2;iP2++){
         P2.push_back( tP2());
         P2[iP2-aP2+jP2].grp0=P2[iP2].grp0;
         P2[iP2-aP2+jP2].grp1=P2[iP2].grp1;
         P2[iP2-aP2+jP2].grp2=P2[iP2].grp2;
         P2[iP2-aP2+jP2].grp3=P2[iP2].grp3;
         P2[iP2-aP2+jP2].atm0=P2[iP2].atm0;
         P2[iP2-aP2+jP2].atm1=P2[iP2].atm1;
         P2[iP2-aP2+jP2].atm2=P2[iP2].atm2;
         P2[iP2-aP2+jP2].atm3=P2[iP2].atm3;
         P2[iP2-aP2+jP2].dst=P2[iP2].dst;
         P2[iP2-aP2+jP2].lam=P2[iP2].lam;
         P2[iP2-aP2+jP2].chi=P2[iP2].chi;
      }
      int aC2=L0[iL0].C2a;
      int bC2=(aC2-1+L0[iL0].cC2);
      for(int iC2=aC2;iC2<=bC2;iC2++){
         C2.push_back( tC2());
         for(int i=0;i<5;i++){
            o_C2Q6chi.push_back( (0.00));
         }
         C2[iC2-aC2+jC2].e=C2[iC2].e;
         for(int iQ6=0;iQ6<nQ6;iQ6++){
            C2Q6chi(iC2-aC2+jC2,iQ6)=C2Q6chi(iC2,iQ6);
         }
      }

      jQ0+=L0[nL0].cQ0;
      jU0+=L0[nL0].cU0;
      jF0+=L0[nL0].cF0;
      jB0+=L0[nL0].cB0;
      jG0+=L0[nL0].cG0;
      jH0+=L0[nL0].cH0;
      jJ0+=L0[nL0].cJ0;
      jY0+=L0[nL0].cY0;
      jK0+=L0[nL0].cK0;
      jP0+=L0[nL0].cP0;
      jT0+=L0[nL0].cT0;
      jP2+=L0[nL0].cP2;
      jC2+=L0[nL0].cC2;
      nL0++;
   }
}

int DAT_RESIDUE_MAPPINGS::iresidue(std::string aa) const{
   for(int jL0= 0;jL0<nL0;jL0++){
      if( L0[jL0].aa==aa ){
         return jL0;
      }
   }
   return -1;
}
int DAT_RESIDUE_MAPPINGS::if0atom(int iL0,std::string atm) const{
   int mF0=L0[iL0].F0a;
   int nF0=(mF0+L0[iL0].cF0);
   for(int jF0=mF0;jF0<nF0;jF0++){
      if( F0[jF0].atm==atm ){
         return jF0;
      }
   }
   return -1;
}
int DAT_RESIDUE_MAPPINGS::ib0atom(int iL0,std::string atm) const{
   int mF0=L0[iL0].F0a;
   int mB0=L0[iL0].B0a;
   int nB0=(mB0+L0[iL0].cB0);
   if( nB0>mB0 ){
      for(int jB0=mB0;jB0<nB0;jB0++){
         int jF0=B0[jB0].F0;
         if( jF0<mF0 )continue;
         if( F0[jF0].atm==atm ){
            return jB0;
         }
      }
   }
   return -1;
}
int DAT_RESIDUE_MAPPINGS::ig0atom(int iL0,std::string atm) const{
   int mG0=L0[iL0].G0a;
   int nG0=(mG0+L0[iL0].cG0);
   if( nG0>mG0 ){
      for(int jG0=mG0;jG0<nG0;jG0++){
         int jF0=G0[jG0].F0;
         if( F0[jF0].atm==atm ){
            return jG0;
         }
      }
   }
   return -1;
}
int DAT_RESIDUE_MAPPINGS::iq0torsion(int iL0,std::string tor) const{
   int mQ0=L0[iL0].Q0a;
   int nQ0=(mQ0+L0[iL0].cQ0);
   for(int jQ0=mQ0;jQ0<nQ0;jQ0++){
      if( Q0[jQ0].tor==tor ){
         return jQ0;
      }
   }
   return -1;
}
int DAT_RESIDUE_MAPPINGS::ip0atom(int iL0,std::string atm) const{
   int mP0=L0[iL0].P0a;
   int nP0=(mP0+L0[iL0].cP0);
   for(int jP0=mP0;jP0<nP0;jP0++){
      if( P0[jP0].atm==atm ){
         return jP0;
      }
   }
   return -1;
}
int DAT_RESIDUE_MAPPINGS::it0torsion(int iL0,std::string tor) const{
   int mT0=L0[iL0].T0a;
   int nT0=(mT0+L0[iL0].cT0);
   for(int jT0=mT0;jT0<nT0;jT0++){
      if( T0[jT0].tor==tor ){
         return jT0;
      }
   }
   return -1;
}
int DAT_RESIDUE_MAPPINGS::ip2atom(int iL0,std::string atm) const{
   int mP2=L0[iL0].P2a;
   int nP2=(mP2+L0[iL0].cP2);
   for(int jP2=mP2;jP2<nP2;jP2++){
      if( P2[jP2].grp0!=0 )continue;
      if( P2[jP2].atm0==atm ){
         return jP2;
      }
   }
   return -1;
}
