#ifndef DEF_DAT_REGION_MAPS
#define DEF_DAT_REGION_MAPS

#include "../phi/Fourier1D_Coeffs.hh"
#include "../phi/Fourier2D_Coeffs.hh"
#include <string>
#include <vector>

class DAT_REGION_MAPS {
public:
   class tC6 { /*(del,eps,zet,alp,bet,gam,del) conformations*/
   public:
      std::string cnf;          //6 char suite conf name
      double de0;               //de0 (degree)
      double eps;               //eps (degree)
      double zet;               //zet (degree)
      double alp;               //alp (degree)
      double bet;               //bet (degree)
      double gam;               //gam (degree)
      double del;               //del (degree)
      tC6(){}
   };

private:
   std::vector<char> o_I0alp;   //(phi,psi) region name
   std::vector<char> o_I0bet;   //(phi,psi) region name
   std::vector<int> o_H4H4ala;  //(phi,psi) region for non-gly
   std::vector<int> o_H4H4gly;  //(phi,psi) region for gly
   std::vector<int> o_H4H4scr;  //screen of (phi,psi) deformations
   std::vector<int> o_I1sco;    //defect score
   std::vector<int> o_H4H4dis;  //(phi,psi) disallowed level
   std::vector<int> o_K3H4dis;  //omg disallowed level for {nonpro, pro}

   char& I0alp(int i){
      return o_I0alp.at( i);
   }
   char& I0bet(int i){
      return o_I0bet.at( i);
   }
   int& H4H4ala(int i,int j){
      return o_H4H4ala.at( i*38 +j);
   }
   int& H4H4gly(int i,int j){
      return o_H4H4gly.at( i*38 +j);
   }
   int& H4H4scr(int i,int j){
      return o_H4H4scr.at( i*38 +j);
   }
   int& I1sco(int i){
      return o_I1sco.at( i);
   }
   int& H4H4dis(int i,int j){
      return o_H4H4dis.at( i*38 +j);
   }
   int& K3H4dis(int i,int j){
      return o_K3H4dis.at( i*38 +j);
   }

public:
   std::vector<tC6> C6;         //oligonucleotide suite conformations
   Fourier2D_Coeffs phipsi;     //frac change in e of peptide-peptide Hbond
   Fourier1D_Coeffs phi;        //
   Fourier1D_Coeffs psi;        //

   const char& I0alp(int i) const {
      return o_I0alp.at( i);
   }
   const char& I0bet(int i) const {
      return o_I0bet.at( i);
   }
   const int& H4H4ala(int i,int j) const {
      return o_H4H4ala.at( i*38 +j);
   }
   const int& H4H4gly(int i,int j) const {
      return o_H4H4gly.at( i*38 +j);
   }
   const int& H4H4scr(int i,int j) const {
      return o_H4H4scr.at( i*38 +j);
   }
   const int& I1sco(int i) const {
      return o_I1sco.at( i);
   }
   const int& H4H4dis(int i,int j) const {
      return o_H4H4dis.at( i*38 +j);
   }
   const int& K3H4dis(int i,int j) const {
      return o_K3H4dis.at( i*38 +j);
   }

   DAT_REGION_MAPS();
};

#endif
