#include "../dat/DAT_REGION_MAPS.hh"
#include <string>
#include <vector>
#include <fstream>
#include <sstream>

class MEM_DAT_REGION_MAPS {
public:
   std::vector<std::string> o_Lrec;     //lines from input file
   MEM_DAT_REGION_MAPS(){
   }
   std::string& Lrec(int i){
      return o_Lrec.at( i);  }
};

DAT_REGION_MAPS::DAT_REGION_MAPS():
   o_I0alp(8),
   o_I0bet(8),
   o_H4H4ala(20*38),
   o_H4H4gly(20*38),
   o_H4H4scr(38*38),
   o_I1sco(8),
   o_H4H4dis(38*38),
   o_K3H4dis( 2*38),
   C6(46)
{
   MEM_DAT_REGION_MAPS vv;
   std::ifstream ifile("../dat/region_maps");
   std::string rec;
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();

   for(int iI0=0;iI0<8;iI0++){
      I0alp(iI0)=vv.Lrec(  2)[iI0];
      I0bet(iI0)=vv.Lrec(  4)[iI0];
   }
   int p=7;
   for(int jH4=37;jH4>= 0;jH4--){
      std::istringstream irec(vv.Lrec(p++).substr( 0,40));
      for(int iH4= 0;iH4<20;iH4++){
         irec>>H4H4ala(iH4,jH4);
      }
   }
   p+=2;
   for(int jH4=37;jH4>= 0;jH4--){
      std::istringstream irec(vv.Lrec(p++).substr( 0,40));
      for(int iH4= 0;iH4<20;iH4++){
         irec>>H4H4gly(iH4,jH4);
      }
   }
   p+=2;
   for(int jH4=37;jH4>= 0;jH4--){
      std::istringstream irec(vv.Lrec(p++).substr( 0,76));
      for(int iH4= 0;iH4<38;iH4++){
         irec>>H4H4scr(iH4,jH4);
      }
   }
   p+=2;
   {
      std::istringstream irec(vv.Lrec(p++).substr( 0,16));
      for(int iI1=0;iI1<8;iI1++){
         irec>>I1sco(iI1);
      }
   }
   p+=2;
   for(int jH4=37;jH4>= 0;jH4--){
      std::istringstream irec(vv.Lrec(p++).substr( 0,76));
      for(int iH4= 0;iH4<38;iH4++){
         irec>>H4H4dis(iH4,jH4);
      }
   }
   p+=2;
   for(int iK3=0;iK3<2;iK3++){
      std::istringstream irec(vv.Lrec(p++).substr( 0,76));
      for(int iH4= 0;iH4<38;iH4++){
         irec>>K3H4dis(iK3,iH4);
      }
   }
   p+=3;
   for(int iC6= 0;iC6<46;iC6++){
      C6[iC6].cnf=vv.Lrec(p  ).substr(40, 6);
      std::istringstream(vv.Lrec(p++).substr( 4,35))>>C6[iC6].de0
                                                    >>C6[iC6].eps
                                                    >>C6[iC6].zet
                                                    >>C6[iC6].alp
                                                    >>C6[iC6].bet
                                                    >>C6[iC6].gam
                                                    >>C6[iC6].del;
   }
   p+=2;
   {
      int n;
      std::istringstream(vv.Lrec(p++).substr( 9, 2))>>n;
      phipsi.resize( n);
      for(int jmin=0;jmin<n;jmin+=6){
         int jmax=(jmin+6);
         p++;
         rec.clear();
         for(int i=0;i<n;i++){
            rec+=vv.Lrec(p++).substr(10,60);
         }
         std::istringstream irec(rec);
         for(int i=0;i<n;i++){
            for(int j=jmin;j<jmax;j++){
               irec>>phipsi(i,j);
            }
         }
      }
      phipsi*=( .50);
//    phipsi*=energy_params.fac_pp;
      std::istringstream(vv.Lrec(p++).substr( 5, 2))>>n;
      phi.resize( n);
      {
         rec.clear();
         p++;
         rec+=vv.Lrec(p++).substr( 0,10);
         for(int imin=1;imin<n;imin+=6){
            p++;
            rec+=vv.Lrec(p++).substr( 0,60);
         }
         std::istringstream irec(rec);
         for(int i=0;i<n;i++){
            irec>>phi(i);
         }
      }
      phi*=( .50);
//    phi*=energy_params.fac_pp;
      std::istringstream(vv.Lrec(p++).substr( 5, 2))>>n;
      psi.resize( n);
      {
         rec.clear();
         p++;
         rec+=vv.Lrec(p++).substr( 0,10);
         for(int imin=1;imin<n;imin+=6){
            p++;
            rec+=vv.Lrec(p++).substr( 0,60);
         }
         std::istringstream irec(rec);
         for(int i=0;i<n;i++){
            irec>>psi(i);
         }
      }
      psi*=( .50);
//    psi*=energy_params.fac_pp;
   }

}
