#ifndef DEF_DAT_IGOR_DATA
#define DEF_DAT_IGOR_DATA

#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Rotation_Matrix.hh"
#include <string>
#include <vector>

class DAT_IGOR_DATA {
public:
   class tL1 { /*20 natural amino acids*/
   public:
      std::string a3;           //3 char amino acid name
      char a1;                  //1 char amino acid name
      int O7;                   //index into clusters of amino acids
      int P7;                   //index into clusters of amino acids
      int hphob;                //measure of hydrophob in nonpolar solvent
      double cent;              //position dependent energy sheet center
      double edge;              //sheet edge
      int alt;                  //measure of hydrophob in dock interface
      int doc;                  //measure of hydrophob in water
      int zet;                  //sign of charge
      int kap;                  //size of low dielectric volume
      double rho;               //dist relaxation (bohr)
      Gaussian_Volume ef[4];    //elec field density sqrt(hart/bohr**3)
      Gaussian_Volume vf;       //volume density sc
      tL1(){}
   };
   class tC7 { /*ss states {#,H,E,C}*/
   public:
      char a1;                  //1 char state name
      double p0;                //
      double p1;                //
      tC7(){}
   };
   class tT7 { /*elem types*/
   public:
      char a1;                  //1 char elem name
      int V7;                   //index into clusters of elem types
      int W7;                   //index into clusters of elem types
      int mR7;                  //lower bound for elem length
      int nR7;                  //upper bound for elem length
      tT7(){}
   };
   class tU7 { /*elem (type,length) pair*/
   public:
      int T7;                   //type
      int R7;                   //length
      double e;                 //score0 1-bod impulse
      tU7(){}
   };
   class tE7 { /*res impulses*/
   public:
      int H8;                   //union of 0,1,2, and 3-body patterns
      int C7;                   //index of state
      double e;                 //energy impulse
      tE7(){}
   };
   class tB7 { /*elem impulses*/
   public:
      int H8;                   //union of 0,1,2, and 3-body patterns
      int C7;                   //index of state
      double e;                 //energy impulse
      tB7(){}
   };
   class tO1 { /*twist of hydrophob patch*/
   public:
      class tO1P3 { /*pattern of patch*/
      public:
         class tO1P3C8 { /*dock config*/
         public:
            class tO1P3C8N2 { /*elem of docked pair*/
            public:
               Rotation_Matrix r;   //rotation of elem axis to config
               tO1P3C8N2(){}
            };
         public:
            std::vector<tO1P3C8N2> N2;  //pair of elems
            tO1P3C8():N2( 2){}
         };
      public:
         int oR4;                   //max index plus 1 of R4 map to J4
         std::vector<int> R4J4;     //map of residue strings to patch
         int oJ4;                   //n of patch residues
         double bet;                //angle (radian) elem axis wrt patch axis
         double gam;                //angle (radian) R4 start wrt patch mean
         double dz;                 //del z (angstrom) R4 start wrt patch mean
         double dy;                 //del y (angstrom)
         double dx;                 //del x dock center wrt elem center
         std::vector<tO1P3C8> C8;   //dock config
         tO1P3():R4J4(25, -1){}
      };
   public:
      int oP3;                      //n
      std::vector<tO1P3> P3;        //set of patterns
      tO1(){}
   };
   class tLL { /*pair of patch sizes*/
   public:
      int DC8a[2];              //start index of range
      int DcC8[2];              //n of dock configs with (size,size,direction)
      tLL(){}
   };
   class tC8 { /*dock config*/
   public:
      class tC8N2 { /*bod of docked pair*/
      public:
         class tC8N2J4 { /*residue of patch*/
         public:
            int X;                  //x position in config
            int Y;                  //y position in config
            int B;                  //buried state {0=edge,1=cent}
            tC8N2J4(){}
         };
      public:
         int oJ4;                   //n
         std::vector<tC8N2J4> J4;   //residues of patch
         double the;                //angle (radian) patch axis wrt y-axis
         tC8N2(){}
      };
   public:
      std::vector<char> o_XYa;      //1-char rep of dock config
      std::vector<int> o_XYN2;      //index of elem
      std::vector<int> o_XYJ4;      //index of pattern position
      std::vector<tC8N2> N2;        //pair of elems
      double dy;                    //local y displace of patch 2 wrt 1
      double dz;                    //local z (angstroms)
      int mL;                       //size of space for 1st index
      int nL;                       //2nd index
      std::vector<char> o_LLe;      //optimal dock score
      char& XYa(int i,int j){
         return o_XYa[ i*8 +j];
      }
      int& XYN2(int i,int j){
         return o_XYN2[ i*8 +j];
      }
      int& XYJ4(int i,int j){
         return o_XYJ4[ i*8 +j];
      }
      char& LLe(int i,int j){
         return o_LLe.at( i*nL +j);
      }
      const char& LLe(int i,int j) const {
         return o_LLe.at( i*nL +j);
      }
      tC8():o_XYa(72),o_XYN2(72, -1),o_XYJ4(72, -1),N2( 2){}
   };

private:
   std::vector<int> o_T7R7U7;       //mapping
   std::vector<double> o_U7U7e;     //SCORE0 2-bod impulses
   std::vector<double> o_U7U7U7e;   //SCORE0 3-bod impulses
   std::vector<int> o_R7B8v;        //R filter
   std::vector<int> o_U7C7B8v0;     //UC filter
   std::vector<int> o_U7C7B8v1;     //
   std::vector<int> o_U7C7B8v2;     //
   std::vector<double> o_L1L1h1;    //helix i-->i+1
   std::vector<double> o_L1L1h3;    //helix i-->i+3
   std::vector<double> o_L1L1h4;    //helix i-->i+4
   std::vector<double> o_L1L1e2;    //sheet i-->i+2
   std::vector<double> o_L1L1eia;   //sheet i-->j antiparallel c10
   std::vector<double> o_L1L1eic;   //sheet i-->j antiparallel c14
   std::vector<double> o_L1L1eib;   //sheet i-->j parallel c12
   std::vector<double> o_L1L1eja;   //sheet i-->j+2 antiparallel c10
   std::vector<double> o_L1L1ejc;   //sheet i-->j+2 antiparallel c14
   std::vector<double> o_L1L1ejb;   //sheet i-->j+2 parallel c12
   std::vector<double> o_L1L1eka;   //sheet i-->j-2 antiparallel c10
   std::vector<double> o_L1L1ekc;   //sheet i-->j-2 antiparallel c14
   std::vector<double> o_L1L1ekb;   //sheet i-->j-2 parallel c12
   std::vector<int> o_L1L1sco;      //residue substitution matrix
   std::vector<double> o_abSIG;     //reusable intermediate values
   std::vector<double> o_abETA;     //
   std::vector<double> o_abZ;       //
   std::vector<double> o_abcSIG;    //
   std::vector<double> o_abcETA;    //
   std::vector<double> o_abcZ;      //
   std::vector<double> o_cabETA;    //
   std::vector<double> o_bcaETA;    //
   std::vector<double> o_cczETA;    //
   std::vector<float> o_GKe3;       //electrostatic energy density over lattice
   std::vector<float> o_Ge2;        //
   std::vector<float> o_GGGKe3;     //
   std::vector<int> o_H7o;          //abs value of largest displacement
   std::vector<int> o_H7H7o;        //
   std::vector<int> o_H7H7H7o;      //
   std::vector<int> o_H7i;          //map of displacement space to 0,1,2,...
   std::vector<int> o_H7H7i;        //
   std::vector<int> o_H7H7H7i;      //
   std::vector<double> o_L1L1hp;    //energy of hp-hp sc contact
   std::vector<bool> o_O1O1b;       //pairs of twist compatible for docking
   int oLL;                         //n
   std::vector<int> o_J4J4LL;       //pairs of patch sizes
   std::vector<int> o_BTf;          //dock score B=edge/cent T=res type
   std::vector<int> o_TTf;          //dock score T=res type

   int& T7R7U7(int i,int j){
      return o_T7R7U7.at( i*33 +j);
   }
   double& U7U7e(int i,int j){
      return o_U7U7e.at( i*oU7 +j);
   }
   double& U7U7U7e(int i,int j,int k){
      return o_U7U7U7e.at( i*oU7*oU7 +j*oU7 +k);
   }
   int& R7B8v(int i,int j){
      return o_R7B8v.at( i*oB8 +j);
   }
   int& U7C7B8v0(int i,int j,int k){
      return o_U7C7B8v0.at( i*oC7*oB8 +j*oB8 +k);
   }
   int& U7C7B8v1(int i,int j,int k){
      return o_U7C7B8v1.at( i*oC7*oB8 +j*oB8 +k);
   }
   int& U7C7B8v2(int i,int j,int k){
      return o_U7C7B8v2.at( i*oC7*oB8 +j*oB8 +k);
   }
   double& L1L1h1(int i,int j){
      return o_L1L1h1.at( i*oL1 +j);
   }
   double& L1L1h3(int i,int j){
      return o_L1L1h3.at( i*oL1 +j);
   }
   double& L1L1h4(int i,int j){
      return o_L1L1h4.at( i*oL1 +j);
   }
   double& L1L1e2(int i,int j){
      return o_L1L1e2.at( i*oL1 +j);
   }
   double& L1L1eia(int i,int j){
      return o_L1L1eia.at( i*oL1 +j);
   }
   double& L1L1eic(int i,int j){
      return o_L1L1eic.at( i*oL1 +j);
   }
   double& L1L1eib(int i,int j){
      return o_L1L1eib.at( i*oL1 +j);
   }
   double& L1L1eja(int i,int j){
      return o_L1L1eja.at( i*oL1 +j);
   }
   double& L1L1ejc(int i,int j){
      return o_L1L1ejc.at( i*oL1 +j);
   }
   double& L1L1ejb(int i,int j){
      return o_L1L1ejb.at( i*oL1 +j);
   }
   double& L1L1eka(int i,int j){
      return o_L1L1eka.at( i*oL1 +j);
   }
   double& L1L1ekc(int i,int j){
      return o_L1L1ekc.at( i*oL1 +j);
   }
   double& L1L1ekb(int i,int j){
      return o_L1L1ekb.at( i*oL1 +j);
   }
   int& L1L1sco(int i,int j){
      return o_L1L1sco.at( i*oL1 +j);
   }
   double& abSIG(int i,int j){
      return o_abSIG.at( i*4 +j);
   }
   double& abETA(int i,int j){
      return o_abETA.at( i*4 +j);
   }
   double& abZ(int i,int j){
      return o_abZ.at( i*4 +j);
   }
   double& abcSIG(int i,int j,int k){
      return o_abcSIG.at( i*16 +j*4 +(k-1));
   }
   double& abcETA(int i,int j,int k){
      return o_abcETA.at( i*16 +j*4 +(k-1));
   }
   double& abcZ(int i,int j,int k){
      return o_abcZ.at( i*16 +j*4 +(k-1));
   }
   double& cabETA(int i,int j,int k){
      return o_cabETA.at( i*16 +j*4 +(k-1));
   }
   double& bcaETA(int i,int j,int k){
      return o_bcaETA.at( i*16 +j*4 +(k-1));
   }
   double& cczETA(int i,int j,int k){
      return o_cczETA.at( i*16 +j*4 +(k-1));
   }
   float& GKe3(int i,int j){
      return o_GKe3.at( i*4 +(j-1));
   }
   float& Ge2(int i){
      return o_Ge2.at( i);
   }
   float& GGGKe3(int i,int j,int k,int l){
      return o_GGGKe3.at( i*283084 +j*724 +k*4 +(l-1));
   }
   int& H7o(int i){
      return o_H7o.at(i+6);
   }
   int& H7H7o(int i,int j){
      return o_H7H7o.at( (i+6)*oH7 +(j+6));
   }
   int& H7H7H7o(int i,int j,int k){
      return o_H7H7H7o.at( (i+6)*oH7*oH7 +(j+6)*oH7 +(k+6));
   }
   int& H7i(int i){
      return o_H7i.at(i+6);
   }
   int& H7H7i(int i,int j){
      return o_H7H7i.at( (i+6)*oH7 +(j+6));
   }
   int& H7H7H7i(int i,int j,int k){
      return o_H7H7H7i.at( (i+6)*oH7*oH7 +(j+6)*oH7 +(k+6));
   }
   double& L1L1hp(int i,int j){
      return o_L1L1hp.at( i*oL1 +j);
   }
   void O1O1b(int i,int j,bool a){
      o_O1O1b[ i*oO1 +j]=a;
   }
   int& J4J4LL(int i,int j){
      return o_J4J4LL.at( i*9 +j);
   }
   int& BTf(int i,int j){
      return o_BTf.at( i*3 +j);
   }
   int& TTf(int i,int j){
      return o_TTf.at( i*3 +j);
   }

public:
   int oL1;                     //n
   std::vector<tL1> L1;         //20 natural amino acids
   int oO7;                     //n of clusters of amino acids
   int oP7;                     //n of clusters of amino acids
   int oC7;                     //n
   std::vector<tC7> C7;         //ss states {#,H,E,C}
   int oT7;                     //n
   std::vector<tT7> T7;         //elem types
   int oV7;                     //n of clusters of elem types
   int oW7;                     //n of clusters of elem types
   int oU7;                     //n of elem (type,length) pairs
   std::vector<tU7> U7;         //elem (type,length) pairs
   int oB8;                     //n of bins of interval [0.00,1.00]
   int oH7;                     //n of dispacement range
   int oE7;                     //n
   std::vector<tE7> E7;         //residue impulses
   int oB7;                     //n
   std::vector<tB7> B7;         //elem impulses
   int oO1;                     //n
   std::vector<tO1> O1;         //patch twists
   int oC8;                     //n
   std::vector<tC8> C8;         //dock configs
   std::vector<tLL> LL;         //pairs of patch sizes

   const int& T7R7U7(int i,int j) const {
      return o_T7R7U7.at( i*33 +j);
   }
   const double& U7U7e(int i,int j) const {
      return o_U7U7e.at( i*oU7 +j);
   }
   const double& U7U7U7e(int i,int j,int k) const {
      return o_U7U7U7e.at( i*oU7*oU7 +j*oU7 +k);
   }
   const int& R7B8v(int i,int j) const {
      return o_R7B8v.at( i*oB8 +j);
   }
   const int& U7C7B8v0(int i,int j,int k) const {
      return o_U7C7B8v0.at( i*oC7*oB8 +j*oB8 +k);
   }
   const int& U7C7B8v1(int i,int j,int k) const {
      return o_U7C7B8v1.at( i*oC7*oB8 +j*oB8 +k);
   }
   const int& U7C7B8v2(int i,int j,int k) const {
      return o_U7C7B8v2.at( i*oC7*oB8 +j*oB8 +k);
   }
   const double& L1L1h1(int i,int j) const {
      return o_L1L1h1.at( i*oL1 +j);
   }
   const double& L1L1h3(int i,int j) const {
      return o_L1L1h3.at( i*oL1 +j);
   }
   const double& L1L1h4(int i,int j) const {
      return o_L1L1h4.at( i*oL1 +j);
   }
   const double& L1L1e2(int i,int j) const {
      return o_L1L1e2.at( i*oL1 +j);
   }
   const double& L1L1eia(int i,int j) const {
      return o_L1L1eia.at( i*oL1 +j);
   }
   const double& L1L1eic(int i,int j) const {
      return o_L1L1eic.at( i*oL1 +j);
   }
   const double& L1L1eib(int i,int j) const {
      return o_L1L1eib.at( i*oL1 +j);
   }
   const double& L1L1eja(int i,int j) const {
      return o_L1L1eja.at( i*oL1 +j);
   }
   const double& L1L1ejc(int i,int j) const {
      return o_L1L1ejc.at( i*oL1 +j);
   }
   const double& L1L1ejb(int i,int j) const {
      return o_L1L1ejb.at( i*oL1 +j);
   }
   const double& L1L1eka(int i,int j) const {
      return o_L1L1eka.at( i*oL1 +j);
   }
   const double& L1L1ekc(int i,int j) const {
      return o_L1L1ekc.at( i*oL1 +j);
   }
   const double& L1L1ekb(int i,int j) const {
      return o_L1L1ekb.at( i*oL1 +j);
   }
   const int& L1L1sco(int i,int j) const {
      return o_L1L1sco.at( i*oL1 +j);
   }
   const float& GKe3(int i,int j) const {
      return o_GKe3.at( i*4 +(j-1));
   }
   const float& Ge2(int i) const {
      return o_Ge2.at( i);
   }
   const float& GGGKe3(int i,int j,int k,int l) const {
      return o_GGGKe3.at( i*283084 +j*724 +k*4 +(l-1));
   }
   const int& H7o(int i) const {
      return o_H7o.at(i+6);
   }
   const int& H7H7o(int i,int j) const {
      return o_H7H7o.at( (i+6)*oH7 +(j+6));
   }
   const int& H7H7H7o(int i,int j,int k) const {
      return o_H7H7H7o.at( (i+6)*oH7*oH7 +(j+6)*oH7 +(k+6));
   }
   const int& H7i(int i) const {
      return o_H7i.at(i+6);
   }
   const int& H7H7i(int i,int j) const {
      return o_H7H7i.at( (i+6)*oH7 +(j+6));
   }
   const int& H7H7H7i(int i,int j,int k) const {
      return o_H7H7H7i.at( (i+6)*oH7*oH7 +(j+6)*oH7 +(k+6));
   }
   const double& L1L1hp(int i,int j) const {
      return o_L1L1hp.at( i*oL1 +j);
   }
   const bool O1O1b(int i,int j) const {
      return o_O1O1b[ i*oO1 +j];
   }
   const int& J4J4LL(int i,int j) const {
      return o_J4J4LL.at( i*9 +j);
   }
   const int& BTf(int i,int j) const {
      return o_BTf.at( i*3 +j);
   }
   const int& TTf(int i,int j) const {
      return o_TTf.at( i*3 +j);
   }

   int iresidue(char a1) const;
   int ipatch(char a1);

   DAT_IGOR_DATA(const DAT_PHYSICS_CONSTS& physics_consts,
                 bool DOCKDATA =false);
};

#endif
