#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <sstream>
#include <cmath>

class MEM_DAT_IGOR_DATA {
public:
   std::vector<std::string> o_Lrec;     //lines from input file
   std::vector<int> o_J4iT;             //type over 1st patch of pair
   std::vector<int> o_J4jT;             //type over 2nd patch of pair
   MEM_DAT_IGOR_DATA():
      o_J4iT( 8),
      o_J4jT( 8)
   {
   }
   std::string& Lrec(int i){
      return o_Lrec.at( i);  }
   int& J4iT(int i){
      return o_J4iT.at( i);  }
   int& J4jT(int i){
      return o_J4jT.at( i);  }
};

DAT_IGOR_DATA::DAT_IGOR_DATA(
      const DAT_PHYSICS_CONSTS& physics_consts,
      bool DOCKDATA){
   MEM_DAT_IGOR_DATA vv;
   std::string rec;
   int p=0;

   std::ifstream ifile("../dat/igor_data");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
//
//
// igor model
//
   p=1;
   std::istringstream(vv.Lrec(p++).substr( 4, 2))>>oL1;
   std::istringstream(vv.Lrec(p++).substr( 4, 2))>>oO7;
   std::istringstream(vv.Lrec(p++).substr( 4, 2))>>oP7;
   p+=3;
   for(int iL1=0;iL1<oL1;iL1++){
      L1.push_back( tL1());
      L1[iL1].a3=vv.Lrec(p).substr( 5, 3);
      L1[iL1].a1=vv.Lrec(p)[10];
      std::istringstream(vv.Lrec(p++).substr(12,11))
            >>L1[iL1].O7 >>L1[iL1].P7>>L1[iL1].hphob;
   }
   p+=1;
   std::istringstream(vv.Lrec(p++).substr( 4, 1))>>oC7;
   p+=3;
   for(int iC7=0;iC7<oC7;iC7++){
      C7.push_back( tC7());
      C7[iC7].a1=vv.Lrec(p)[ 6];
      std::istringstream(vv.Lrec(p++).substr( 8,12))
            >>C7[iC7].p0 >>C7[iC7].p1;
   }
   p+=1;
   std::istringstream(vv.Lrec(p++).substr( 4, 2))>>oT7;
   std::istringstream(vv.Lrec(p++).substr( 4, 2))>>oV7;
   std::istringstream(vv.Lrec(p++).substr( 4, 2))>>oW7;
   p+=3;
   for(int iT7=0;iT7<oT7;iT7++){
      T7.push_back( tT7());
      T7[iT7].a1=vv.Lrec(p)[ 6];
      std::istringstream(vv.Lrec(p++).substr( 8,14))
            >>T7[iT7].V7 >>T7[iT7].W7>>T7[iT7].mR7>>T7[iT7].nR7;
   }
   p+=52;
//
//
// SCORE0 impulses
//
   o_T7R7U7.resize(oT7*33, -1);
   oU7=0;
   for(int iT7= 1;iT7<oT7;iT7++){
      int mR7=T7[iT7].mR7;
      int nR7=T7[iT7].nR7;
      for(int iR7=mR7;iR7<=nR7;iR7++){
         T7R7U7(iT7,iR7)=oU7;
         U7.push_back( tU7());
         U7[oU7  ].T7=iT7;
         U7[oU7  ].R7=iR7;
         U7[oU7++].e= (0.00);
      }
   }
   o_U7U7e.resize(oU7*oU7, (0.00));
   o_U7U7U7e.resize(oU7*oU7*oU7, (0.00));
   int n( 0);
   std::istringstream(vv.Lrec(p++))>>n;
   for(int i=0;i<n;i++){
      int iT7(-1),iR7(-1);
      double  e( 0.00);
      std::istringstream(vv.Lrec(p++).substr( 0,16))
            >>iT7 >>iR7 >>e;
      int iU7=T7R7U7(iT7,iR7);
      U7[iU7].e= e;
   }
   p+=2;
   std::istringstream(vv.Lrec(p++))>>n;
   for(int i=0;i<n;i++){
      int iT7(-1),iR7(-1),jT7(-1),jR7(-1);
      double  e( 0.00);
      std::istringstream(vv.Lrec(p++).substr( 0,23))
            >>iT7 >>iR7 >>jT7 >>jR7 >>e;
      int iU7=T7R7U7(iT7,iR7);
      int jU7=T7R7U7(jT7,jR7);
      U7U7e(iU7,jU7)= e;
   }
   p+=2;
   std::istringstream(vv.Lrec(p++))>>n;
   for(int i=0;i<n;i++){
      int iT7(-1),iR7(-1),jT7(-1),jR7(-1),kT7(-1),kR7(-1);
      double  e( 0.00);
      std::istringstream(vv.Lrec(p++).substr( 0,30))
            >>iT7 >>iR7 >>jT7 >>jR7 >>kT7 >>kR7 >>e;
      int iU7=T7R7U7(iT7,iR7);
      int jU7=T7R7U7(jT7,jR7);
      int kU7=T7R7U7(kT7,kR7);
      U7U7U7e(iU7,jU7,kU7)= e;
   }
//
//
// filters
//
   oB8=10;
   o_R7B8v.resize(33*oB8, 0);
   p+=3;
   for(int iR7= 1;iR7<33;iR7++){
      std::istringstream irec(vv.Lrec(p++).substr( 0,20));
      for(int iB8=0;iB8<oB8;iB8++){
         irec>>R7B8v(iR7,iB8);
      }
   }
   o_U7C7B8v0.resize(oU7*oC7*oB8, 0);
   o_U7C7B8v1.resize(oU7*oC7*oB8, 0);
   o_U7C7B8v2.resize(oU7*oC7*oB8, 0);
   p+=3;
   for(int iU7= 0;iU7<oU7;iU7++){
      for(int iC7= 1;iC7<oC7;iC7++){
         std::istringstream irec(vv.Lrec(p++).substr( 0,63));
         for(int iB8=0;iB8<oB8;iB8++){
            irec>>U7C7B8v0(iU7,iC7,iB8);
         }
         for(int iB8=0;iB8<oB8;iB8++){
            irec>>U7C7B8v1(iU7,iC7,iB8);
         }
         for(int iB8=0;iB8<oB8;iB8++){
            irec>>U7C7B8v2(iU7,iC7,iB8);
         }
      }
   }
//
//
// statistical pair contact energies
//
   o_L1L1h1.resize(oL1*oL1);
   o_L1L1h3.resize(oL1*oL1);
   o_L1L1h4.resize(oL1*oL1);
   o_L1L1e2.resize(oL1*oL1);
   p+=4;
   for(int iL1= 1;iL1<oL1;iL1++){
      for(int jL1= 1;jL1<oL1;jL1++){
         int i;
         std::istringstream(vv.Lrec(p++).substr( 6,56))
               >>i >>L1L1h1(iL1,jL1) >>i >>L1L1h3(iL1,jL1)
               >>i >>L1L1h4(iL1,jL1) >>i >>L1L1e2(iL1,jL1);
      }
   }
   o_L1L1eia.resize(oL1*oL1);
   o_L1L1eic.resize(oL1*oL1);
   o_L1L1eib.resize(oL1*oL1);
   p+=6;
   for(int iL1= 1;iL1<oL1;iL1++){
      for(int jL1= 1;jL1<oL1;jL1++){
         int i;
         std::istringstream(vv.Lrec(p++).substr( 6,42))
               >>i >>L1L1eia(iL1,jL1) >>i >>L1L1eic(iL1,jL1)
               >>i >>L1L1eib(iL1,jL1);
      }
   }
   o_L1L1eja.resize(oL1*oL1);
   o_L1L1ejc.resize(oL1*oL1);
   o_L1L1ejb.resize(oL1*oL1);
   o_L1L1eka.resize(oL1*oL1);
   o_L1L1ekc.resize(oL1*oL1);
   o_L1L1ekb.resize(oL1*oL1);
   p+=7;
   for(int iL1= 1;iL1<oL1;iL1++){
      for(int jL1= 1;jL1<oL1;jL1++){
         int i;
         std::istringstream(vv.Lrec(p++).substr( 6,84))
               >>i >>L1L1eja(iL1,jL1) >>i >>L1L1ejc(iL1,jL1)
               >>i >>L1L1ejb(iL1,jL1) >>i >>L1L1eka(iL1,jL1)
               >>i >>L1L1ekc(iL1,jL1) >>i >>L1L1ekb(iL1,jL1);
      }
   }
   p+=4;
   for(int iL1= 1;iL1<oL1;iL1++){
      int i;
      std::istringstream(vv.Lrec(p++).substr( 3,28))
            >>i >>L1[iL1].cent >>i >>L1[iL1].edge;
   }
//
// docking params
// in atomic units of energy (hartree) and distance (bohr)
// energy density [pow(E,2)]/[8*PI]= 1/[8*PI*pow(R,4)]
// [elec potential]/[sqrt(8*PI)]= sig(j)*exp(-eta(j)*pow(R,2))
//
   p+=3;
   for(int iL1= 0;iL1<oL1;iL1++){
      std::istringstream(vv.Lrec(p++).substr( 9,22))
            >>L1[iL1].alt >>L1[iL1].doc
            >>L1[iL1].zet >>L1[iL1].kap
            >>L1[iL1].rho;
      if( L1[iL1].zet!= 0 ){
         double z= double( L1[iL1].zet)/( 1.12);
         L1[iL1].ef[0].sig=(   0.0364569)*z;
         L1[iL1].ef[1].sig=(   0.0231999)*z;
         L1[iL1].ef[2].sig=(   0.0082857)*z;
         L1[iL1].ef[3].sig=(   0.0078714)*z;
         L1[iL1].ef[0].eta=(   0.0700071);
         L1[iL1].ef[1].eta=(   0.0175018);
         L1[iL1].ef[2].eta=(   0.0043754);
         L1[iL1].ef[3].eta=(   0.0010939);
      }
      if( L1[iL1].kap!= 0 ){
         double z= physics_consts.ANG*physics_consts.ANG
                  /std::exp( (2.)*std::log( double( L1[iL1].kap))/(3.));
         L1[iL1].vf.sig=(  2.5191);
         L1[iL1].vf.eta=(  0.7745)*z;
      }
      L1[iL1].rho= (( .125)*L1[iL1].rho/physics_consts.ANG);
   }
//
//
//
//
   p+=4;
   o_L1L1sco.resize(oL1*oL1, 0);
   for(int iL1= 1;iL1<oL1;iL1++){
      std::istringstream irec(vv.Lrec(p++).substr( 0,60));
      for(int jL1= 1;jL1<oL1;jL1++){
         irec>>L1L1sco(iL1,jL1);
      }
   }
   vv.o_Lrec.clear();
//
//
// hashmap consts
//
   oH7=13;
   o_H7o.resize(oH7, -1);
   o_H7H7o.resize(oH7*oH7, -1);
   o_H7H7H7o.resize(oH7*oH7*oH7, -1);
   o_H7i.resize(oH7, -1);
   o_H7H7i.resize(oH7*oH7, -1);
   o_H7H7H7i.resize(oH7*oH7*oH7, -1);
   {
      int i=0;
      for(int iH7=-6;iH7< 7;iH7++){
         H7o(iH7)=std::abs( iH7);
         H7i(iH7)=i++;
      }
      i=0;
      for(int iH7=-6;iH7< 6;iH7++){
         for(int jH7=(iH7+ 1);jH7< 7;jH7++){
            if( (jH7-iH7)>6 ){
            }else{
               if( H7o(jH7)>H7o(iH7) ){
                  H7H7o(iH7,jH7)=H7o(jH7);
               }else{
                  H7H7o(iH7,jH7)=H7o(iH7);
               }
               H7H7i(iH7,jH7)=i++;
            }
         }
      }
      i=0;
      for(int iH7=-6;iH7< 5;iH7++){
         for(int jH7=(iH7+ 1);jH7< 6;jH7++){
            for(int kH7=(jH7+ 1);kH7< 7;kH7++){
               if( (kH7-iH7)>6 ){
               }else{
                  if( H7o(kH7)>H7o(iH7) ){
                     H7H7H7o(iH7,jH7,kH7)=H7o(kH7);
                  }else{
                     H7H7H7o(iH7,jH7,kH7)=H7o(iH7);
                  }
                  H7H7H7i(iH7,jH7,kH7)=i++;
               }
            }
         }
      }
   }
//
//
// hydrophobic pair contact energies
//
   o_L1L1hp.resize(oL1*oL1, (0.00));
   for(int iL1= 1;iL1<oL1;iL1++){
      for(int jL1= 1;jL1<oL1;jL1++){
         if( (L1[iL1].doc> 0)&&
             (L1[jL1].doc> 0) ){
            L1L1hp(iL1,jL1)= (0.15)*double( L1[iL1].doc+L1[jL1].doc);
         }
      }
   }
//
   ifile.open("../dat/igor_impulses");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
//
//
// energy impulses for residue states
//
   p=2;
   std::istringstream(vv.Lrec(p++).substr( 4, 6))>>oE7;
   p+=1;
   for(int iE7=0;iE7<oE7;iE7++){
      E7.push_back( tE7());
      std::istringstream(vv.Lrec(p  ).substr(40, 9))>>E7[iE7].e;
      E7[iE7].e/=(-physics_consts.ekT);
      std::string bufiH7=vv.Lrec(p  ).substr( 7, 3);
      std::string bufiL1=vv.Lrec(p  ).substr(10, 3);
      std::string bufjH7=vv.Lrec(p  ).substr(13, 3);
      std::string bufjL1=vv.Lrec(p  ).substr(16, 3);
      std::string bufkH7=vv.Lrec(p  ).substr(19, 3);
      std::string bufkL1=vv.Lrec(p  ).substr(22, 3);
      int iH7(-1),jH7(-1),kH7(-1);
      int iP7(-1),jP7(-1),kP7(-1), iO7(-1),jO7(-1), iL1(-1);
      if      ( bufkH7!="   " ){
         std::istringstream(bufiH7)>>iH7;
         std::istringstream(bufiL1)>>iP7;
         std::istringstream(bufjH7)>>jH7;
         std::istringstream(bufjL1)>>jP7;
         std::istringstream(bufkH7)>>kH7;
         std::istringstream(bufkL1)>>kP7;
         E7[iE7].H8=( 1 +273 +8208 +H7H7H7i(iH7,jH7,kH7)*343
                     +(  iP7)*49 +(  jP7)*7 +kP7);
      }else if( bufjH7!="   " ){
         std::istringstream(bufiH7)>>iH7;
         std::istringstream(bufiL1)>>iO7;
         std::istringstream(bufjH7)>>jH7;
         std::istringstream(bufjL1)>>jO7;
         E7[iE7].H8=( 1 +273 +H7H7i(iH7,jH7)*144
                     +(  iO7)*12 +jO7);
      }else if( bufiH7!="   " ){
         std::istringstream(bufiH7)>>iH7;
         std::istringstream(bufiL1)>>iL1;
         E7[iE7].H8=( 1 + H7i(iH7)*21
                     +iL1);
      }else{
         E7[iE7].H8=( 0);
      }
      std::string bufi5C7=vv.Lrec(p  ).substr(27, 2);
      std::string bufi4C7=vv.Lrec(p  ).substr(29, 2);
      std::string bufi3C7=vv.Lrec(p  ).substr(31, 2);
      std::string bufi2C7=vv.Lrec(p  ).substr(33, 2);
      std::string bufi1C7=vv.Lrec(p  ).substr(35, 2);
      std::string bufi0C7=vv.Lrec(p++).substr(37, 2);
      int i0C7(-1),i1C7(-1),i2C7(-1),i3C7(-1),i4C7(-1),i5C7(-1);
      std::istringstream(bufi0C7)>>i0C7;
      if      ( bufi5C7!="  " ){
         std::istringstream(bufi5C7)>>i5C7;
         std::istringstream(bufi4C7)>>i4C7;
         std::istringstream(bufi3C7)>>i3C7;
         std::istringstream(bufi2C7)>>i2C7;
         std::istringstream(bufi1C7)>>i1C7;
         E7[iE7].C7=(363+(243*(i5C7-1))+(81*(i4C7-1))+(27*(i3C7-1))
                    +(9*(i2C7-1))+(3*(i1C7-1))+(i0C7-1));
      }else if( bufi4C7!="  " ){
         std::istringstream(bufi4C7)>>i4C7;
         std::istringstream(bufi3C7)>>i3C7;
         std::istringstream(bufi2C7)>>i2C7;
         std::istringstream(bufi1C7)>>i1C7;
         E7[iE7].C7=(120+(81*(i4C7-1))+(27*(i3C7-1))+(9*(i2C7-1))
                    +(3*(i1C7-1))+(i0C7-1));
      }else if( bufi3C7!="  " ){
         std::istringstream(bufi3C7)>>i3C7;
         std::istringstream(bufi2C7)>>i2C7;
         std::istringstream(bufi1C7)>>i1C7;
         E7[iE7].C7=(39+(27*(i3C7-1))+(9*(i2C7-1))+(3*(i1C7-1))+(i0C7-1));
      }else if( bufi2C7!="  " ){
         std::istringstream(bufi2C7)>>i2C7;
         std::istringstream(bufi1C7)>>i1C7;
         E7[iE7].C7=(12+(9*(i2C7-1))+(3*(i1C7-1))+(i0C7-1));
      }else if( bufi1C7!="  " ){
         std::istringstream(bufi1C7)>>i1C7;
         E7[iE7].C7=( 3+(3*(i1C7-1))+(i0C7-1));
      }else{
         E7[iE7].C7=(i0C7-1);
      }
   }
//
//
// energy impulses for element states
//
   p+=2;
   std::istringstream(vv.Lrec(p++).substr( 4, 6))>>oB7;
   p+=1;
   for(int iB7=0;iB7<oB7;iB7++){
      B7.push_back( tB7());
      std::istringstream(vv.Lrec(p  ).substr(40, 9))>>B7[iB7].e;
      B7[iB7].e/=(-physics_consts.ekT);
      std::string bufiH7=vv.Lrec(p  ).substr( 7, 3);
      std::string bufiT7=vv.Lrec(p  ).substr(10, 3);
      std::string bufjH7=vv.Lrec(p  ).substr(13, 3);
      std::string bufjT7=vv.Lrec(p  ).substr(16, 3);
      std::string bufkH7=vv.Lrec(p  ).substr(19, 3);
      std::string bufkT7=vv.Lrec(p  ).substr(22, 3);
      int iH7(-1),jH7(-1),kH7(-1);
      int iW7(-1),jW7(-1),kW7(-1), iV7(-1),jV7(-1), iT7(-1);
      if      ( bufkH7!="   " ){
         std::istringstream(bufiH7)>>iH7;
         std::istringstream(bufiT7)>>iW7;
         std::istringstream(bufjH7)>>jH7;
         std::istringstream(bufjT7)>>jW7;
         std::istringstream(bufkH7)>>kH7;
         std::istringstream(bufkT7)>>kW7;
         B7[iB7].H8=( 1 +273 +8208 +H7H7H7i(iH7,jH7,kH7)*343
                     +(  iW7)*49 +(  jW7)*7 +kW7);
      }else if( bufjH7!="   " ){
         std::istringstream(bufiH7)>>iH7;
         std::istringstream(bufiT7)>>iV7;
         std::istringstream(bufjH7)>>jH7;
         std::istringstream(bufjT7)>>jV7;
         B7[iB7].H8=( 1 +273 +H7H7i(iH7,jH7)*144
                     +(  iV7)*12 +jV7);
      }else if( bufiH7!="   " ){
         std::istringstream(bufiH7)>>iH7;
         std::istringstream(bufiT7)>>iT7;
         B7[iB7].H8=( 1 + H7i(iH7)*21
                     +iT7);
      }else{
         B7[iB7].H8=( 0);
      }
      std::string bufi5C7=vv.Lrec(p  ).substr(27, 2);
      std::string bufi4C7=vv.Lrec(p  ).substr(29, 2);
      std::string bufi3C7=vv.Lrec(p  ).substr(31, 2);
      std::string bufi2C7=vv.Lrec(p  ).substr(33, 2);
      std::string bufi1C7=vv.Lrec(p  ).substr(35, 2);
      std::string bufi0C7=vv.Lrec(p++).substr(37, 2);
      int i0C7(-1),i1C7(-1),i2C7(-1),i3C7(-1),i4C7(-1),i5C7(-1);
      std::istringstream(bufi0C7)>>i0C7;
      if      ( bufi5C7!="  " ){
         std::istringstream(bufi5C7)>>i5C7;
         std::istringstream(bufi4C7)>>i4C7;
         std::istringstream(bufi3C7)>>i3C7;
         std::istringstream(bufi2C7)>>i2C7;
         std::istringstream(bufi1C7)>>i1C7;
         B7[iB7].C7=(363+(243*(i5C7-1))+(81*(i4C7-1))+(27*(i3C7-1))
                    +(9*(i2C7-1))+(3*(i1C7-1))+(i0C7-1));
      }else if( bufi4C7!="  " ){
         std::istringstream(bufi4C7)>>i4C7;
         std::istringstream(bufi3C7)>>i3C7;
         std::istringstream(bufi2C7)>>i2C7;
         std::istringstream(bufi1C7)>>i1C7;
         B7[iB7].C7=(120+(81*(i4C7-1))+(27*(i3C7-1))+(9*(i2C7-1))
                    +(3*(i1C7-1))+(i0C7-1));
      }else if( bufi3C7!="  " ){
         std::istringstream(bufi3C7)>>i3C7;
         std::istringstream(bufi2C7)>>i2C7;
         std::istringstream(bufi1C7)>>i1C7;
         B7[iB7].C7=(39+(27*(i3C7-1))+(9*(i2C7-1))+(3*(i1C7-1))+(i0C7-1));
      }else if( bufi2C7!="  " ){
         std::istringstream(bufi2C7)>>i2C7;
         std::istringstream(bufi1C7)>>i1C7;
         B7[iB7].C7=(12+(9*(i2C7-1))+(3*(i1C7-1))+(i0C7-1));
      }else if( bufi1C7!="  " ){
         std::istringstream(bufi1C7)>>i1C7;
         B7[iB7].C7=( 3+(3*(i1C7-1))+(i0C7-1));
      }else{
         B7[iB7].C7=(i0C7-1);
      }
   }
   vv.o_Lrec.clear();
   if( !DOCKDATA )return;
//
//
// reusable intermediate values
//
   o_abSIG.resize(16);
   o_abETA.resize(16);
   o_abZ.resize(16);
   o_abcSIG.resize(64);
   o_abcETA.resize(64);
   o_abcZ.resize(64);
   o_cabETA.resize(64);
   o_bcaETA.resize(64);
   o_cczETA.resize(64);
   for(int i=0;i<4;i++){
      double aSIG= L1[ 9].ef[i].sig;
      double aETA= L1[ 9].ef[i].eta;
      for(int j=0;j<4;j++){
         double bSIG= L1[ 9].ef[j].sig;
         double bETA= L1[ 9].ef[j].eta;
         abSIG(i,j)= (4.)*aSIG*bSIG;
         abETA(i,j)= aETA*bETA/( aETA +bETA);
         abZ(i,j)= std::exp( (1.5)
                  *std::log( physics_consts.PI/( aETA +bETA)));
         for(int k=1;k<5;k++){
            double z= physics_consts.ANG*physics_consts.ANG
                     /std::exp( (2.)*std::log( double( k))/(3.));
            double cSIG=(  2.5191);
            double cETA=(  0.7745)*z;
            abcSIG(i,j,k)= (4.)*aSIG*bSIG*cSIG;
            abcETA(i,j,k)= aETA*bETA/( aETA +bETA +cETA);
            abcZ(i,j,k)= std::exp( (1.5)
                        *std::log( physics_consts.PI/( aETA +bETA +cETA)));
            cabETA(i,j,k)= aETA*cETA/( aETA +bETA +cETA);
            bcaETA(i,j,k)= bETA*cETA/( aETA +bETA +cETA);
            cczETA(i,j,k)= cETA*cETA/( aETA +bETA +cETA);
         }
      }
   }
//
//
// electrostatic energy density components over lattice
//
   double dr=(  .10)/physics_consts.ANG;
   double dthe=(   1.00)*physics_consts.RAD;
   o_Ge2.resize(391);
   o_GKe3.resize(391*4);
   o_GGGKe3.resize(391*391*181*4);
   {
      double Rac=( 2.90)/physics_consts.ANG;
      for(int jG=  0;jG<391;jG++){
         Rac+=dr;
         double RRac= Rac*Rac;
         for(int l=1;l<5;l++){
//
            double e3=(  0.00);
            for(int i=0;i<4;i++){
               for(int j=i;j<4;j++){
                  double f=( j==i )? (1.): (2.);
                  double p0= abcSIG(i,j,l)*abcETA(i,j,l)*abcZ(i,j,l);
                  double p1= std::exp(( -cabETA(i,j,l) -bcaETA(i,j,l))*RRac);
                  double p2=( (1.5) +RRac*cczETA(i,j,l));
                  e3+=f*p0*p1*p2;
               }
            }
            GKe3(jG,l)= e3;
//
         }
      }
   }
   {
      double Rab=( 2.90)/physics_consts.ANG;
      for(int iG=  0;iG<391;iG++){
         Rab+=dr;
         double RRab= Rab*Rab;
//
         double e2=(  0.00);
         for(int i=0;i<4;i++){
            for(int j=i;j<4;j++){
               double f=( j==i )? (1.): (2.);
               double q0= abSIG(i,j)*abETA(i,j)*abZ(i,j);
               double q1= std::exp(-abETA(i,j)*RRab);
               double q2=( (1.5) -abETA(i,j)*RRab);
               e2+=f*q0*q1*q2;
            }
         }
         Ge2(iG)= e2;
//
         double Rac=( 2.90)/physics_consts.ANG;
         for(int jG=  0;jG<391;jG++){
            Rac+=dr;
            double RRac= Rac*Rac;
            double the=-dthe;
            for(int kG=  0;kG<181;kG++){
               the+=dthe;
               double Cthe= std::cos( the);
               double RRbc=( RRab +RRac -(2.)*Rab*Rac*Cthe);
               for(int l=1;l<5;l++){
//
                  double e3=(  0.00);
                  for(int i=0;i<4;i++){
                     for(int j=i;j<4;j++){
                        double f=( j==i )? (1.): (2.);
                        double p0= abcSIG(i,j,l)*abcETA(i,j,l)*abcZ(i,j,l);
                        double p1= std::exp( -abcETA(i,j,l)*RRab
                                             -cabETA(i,j,l)*RRac
                                             -bcaETA(i,j,l)*RRbc);
                        double p2=( (1.5) +( .5)*(
                          RRab*( (-2.)*abcETA(i,j,l)
                                -cabETA(i,j,l) -bcaETA(i,j,l) -cczETA(i,j,l))
                         +RRac*(-cabETA(i,j,l) +bcaETA(i,j,l) +cczETA(i,j,l))
                         +RRbc*( cabETA(i,j,l) -bcaETA(i,j,l) +cczETA(i,j,l))
                                    ));
                        e3+=f*p0*p1*p2;
                     }
                  }
                  GGGKe3(iG,jG,kG,l)= e3;
//
               }
            }
         }
      }
   }
//
   ifile.open("../dat/igor_dock");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=1;
//
//
// patterns for hydrophobic patches
//
   std::istringstream(vv.Lrec(p++).substr( 4, 2))>>oO1;
   p+=3;
   for(int iO1= 0;iO1<oO1;iO1++){
      O1.push_back( tO1());
      std::istringstream(vv.Lrec(p++).substr(12, 3))
            >>O1[iO1].oP3;
   }
   p+=3;
   for(int iO1= 0;iO1<oO1;iO1++){
      p+=7;
      int oP3=O1[iO1].oP3;
      for(int iP3= 0;iP3<oP3;iP3++){
         O1[iO1].P3.push_back( tO1::tO1P3());
         rec=vv.Lrec(p  ).substr( 7,25);
         std::istringstream(vv.Lrec(p++).substr(33, 7))>>O1[iO1].P3[iP3].bet;
         O1[iO1].P3[iP3].bet*=physics_consts.RAD;
         O1[iO1].P3[iP3].oJ4=0;
         if( iO1< 4 ){
            O1[iO1].P3[iP3].oR4=0;
            double Cgam=( 0.00);
            double Sgam=( 0.00);
            double z=( 0.00);
            for(int iR4= 0;iR4<25;iR4++){
               if( rec[iR4]=='-' ){
               }else{
                  O1[iO1].P3[iP3].R4J4[iR4]=int(rec[iR4]-'0');
                  O1[iO1].P3[iP3].oJ4++;
                  O1[iO1].P3[iP3].oR4=(iR4+ 1);
                  double gam= double( iR4)*physics_consts.PI/(1.80);
                  Cgam+=std::cos(gam);
                  Sgam+=std::sin(gam);
                  z+=double( iR4)*( 1.50);
               }
            }
            double d= std::sqrt( Cgam*Cgam +Sgam*Sgam);
            Cgam/=d;
            Sgam/=d;
            double gam= std::atan2(Sgam,Cgam);
            O1[iO1].P3[iP3].gam=-gam;
            z/=double( O1[iO1].P3[iP3].oJ4);
            O1[iO1].P3[iP3].dz=-z;
            O1[iO1].P3[iP3].dy=( 0.00);
            O1[iO1].P3[iP3].dx=( 3.75);
         }else{
            double z=( 0.00);
            double y=( 0.00);
            int jX=0;
            int jY=0;
            for(int iR4= 0;iR4<25;iR4++){
               if( rec[iR4]=='-' ){
               }else{
                  O1[iO1].P3[iP3].R4J4[iR4]=int(rec[iR4]-'0');
                  O1[iO1].P3[iP3].oJ4++;
                  int iX=(iR4/5);
                  int iY=(iR4%5);
                  y+=double( iX)*( 5.00);
                  z+=double( iY)*( 6.00);
                  if( iX>jX )jX=iX;
                  if( iY>jY )jY=iY;
               }
            }
            z/=double( O1[iO1].P3[iP3].oJ4);
            y/=double( O1[iO1].P3[iP3].oJ4);
            O1[iO1].P3[iP3].oR4=( jX*5 +jY +1);
            O1[iO1].P3[iP3].gam=( 0.00);
            O1[iO1].P3[iP3].dz=-z;
            O1[iO1].P3[iP3].dy=-y;
            O1[iO1].P3[iP3].dx=( 5.00);
         }
      }
   }
//
//
// pairs of twist compatible for docking
//
   p+=2;
   o_O1O1b.resize(oO1*oO1);
   for(int iO1= 0;iO1< 8;iO1++){
      rec=vv.Lrec(p++);
      for(int jO1= 0;jO1< 8;jO1++){
         if( rec[jO1]=='1' ){
            O1O1b(iO1,jO1,true );
         }else{
            O1O1b(iO1,jO1,false);
         }
      }
   }
//
//
// dock configs
//
   p+=1;
   oLL=17;
   LL.resize(oLL);
   o_J4J4LL.resize(9*9,-1);
   int pC8=0;
   for(int iLL= 0;iLL<oLL;iLL++){
      int m(-1),n(-1);
      std::istringstream(vv.Lrec(p+2).substr(14, 4))>>m >>n;
      J4J4LL(m,n)=iLL;
      p+=20;
      int nC8=(vv.Lrec(p  ).size()/11);
      for(int jC8= 0;jC8<nC8;jC8++){
         int iC8=(pC8+jC8);
         C8.push_back( tC8());
         C8[iC8].N2[ 0].oJ4=m;
         C8[iC8].N2[ 0].J4.resize(m);
         C8[iC8].N2[ 1].oJ4=n;
         C8[iC8].N2[ 1].J4.resize(n);
         for(int iX= 0;iX< 9;iX++){
            for(int iY= 0;iY< 8;iY++){
               C8[iC8].XYa(iX,iY)=vv.Lrec(p+ 7-iY)[ jC8*11 + 1 +iX];
               int i=ipatch( C8[iC8].XYa(iX,iY));
               if( i>-1 ){
                  int iN2=(i/8);
                  int iJ4=(i%8);
                  C8[iC8].XYN2(iX,iY)=iN2;
                  C8[iC8].XYJ4(iX,iY)=iJ4;
                  C8[iC8].N2[iN2].J4[iJ4].X=iX;
                  C8[iC8].N2[iN2].J4[iJ4].Y=iY;
               }
            }
         }
         for(int iN2=0;iN2<2;iN2++){
            int oJ4=C8[iC8].N2[iN2].oJ4;
            for(int iJ4= 0;iJ4<oJ4;iJ4++){
               int iX=C8[iC8].N2[iN2].J4[iJ4].X;
               int iY=C8[iC8].N2[iN2].J4[iJ4].Y;
               int iB=( (C8[iC8].XYJ4(iX   ,iY+ 1)>-1)&&
                        (C8[iC8].XYJ4(iX   ,iY- 1)>-1)&&
                        (C8[iC8].XYJ4(iX+ 1,iY   )>-1)&&
                        (C8[iC8].XYJ4(iX- 1,iY   )>-1) )? 1: 0;
               C8[iC8].N2[iN2].J4[iJ4].B=iB;
            }
         }
         double N2y[2],N2z[2];
         for(int iN2=0;iN2<2;iN2++){
            N2y[iN2]=( 0.00);
            N2z[iN2]=( 0.00);
            int oJ4=C8[iC8].N2[iN2].oJ4;
            for(int iJ4= 0;iJ4<oJ4;iJ4++){
               N2y[iN2]+=double( C8[iC8].N2[iN2].J4[iJ4].X);
               N2z[iN2]+=double( C8[iC8].N2[iN2].J4[iJ4].Y);
            }
            N2y[iN2]/=double( oJ4);
            N2z[iN2]/=double( oJ4);
         }
         C8[iC8].dy= ( 4.00)*( N2y[ 1] -N2y[ 0]);
         C8[iC8].dz= ( 4.00)*( N2z[ 1] -N2z[ 0]);
      }
      p+=8;
      for(int jC8= 0;jC8<nC8;jC8++){
         int iC8=(pC8+jC8);
         std::istringstream(vv.Lrec(p++).substr( 3,16))
               >>C8[iC8].N2[ 0].the>>C8[iC8].N2[ 1].the;
         for(int iN2=0;iN2<2;iN2++){
            C8[iC8].N2[iN2].the*=physics_consts.RAD;
         }
      }
      LL[iLL].DC8a[ 0]=pC8;
      LL[iLL].DcC8[ 0]=(nC8/2);
      LL[iLL].DC8a[ 1]=pC8 +(nC8/2);
      LL[iLL].DcC8[ 1]=(nC8/2);
      pC8+=nC8;
   }
   oC8=pC8;
//
// energies as a func of residue type and edge/center status
// T={ 0:EKQRTWY, 1:ACG, 2:FILMV, 3:DHNPS}
//
   p+=2;
   o_BTf.resize( 6);
   for(int iB=0;iB<2;iB++){
      std::istringstream(vv.Lrec(p++))>>BTf(iB, 0) >>BTf(iB, 1) >>BTf(iB, 2);
   }
//
//
// contact energies
//
   p+=2;
   o_TTf.resize( 9);
   for(int iT=0;iT<3;iT++){
      std::istringstream(vv.Lrec(p++))>>TTf(iT, 0) >>TTf(iT, 1) >>TTf(iT, 2);
   }
   vv.o_Lrec.clear();
//
//
// dock scores over patch pairs with complementary twists
//
   for(int iLL= 0;iLL<oLL;iLL++){
      for(int iD=0;iD<2;iD++){
         int iC8min=LL[iLL].DC8a[iD];
         int iC8max=(iC8min+LL[iLL].DcC8[iD]);
         for(int iC8=iC8min;iC8<iC8max;iC8++){
            int m=C8[iC8].N2[ 0].oJ4;
            int n=C8[iC8].N2[ 1].oJ4;
            int mL=std::pow( 3, m);
            int nL=std::pow( 3, n);
            C8[iC8].mL=mL;
            C8[iC8].nL=nL;
            C8[iC8].o_LLe.resize(mL*nL);
//
//
// compositions of 1st patch
//
            vv.J4iT( 0)=-1;
            int iJ4=0;
            while( true ){
               vv.J4iT(iJ4)++;
               if( vv.J4iT(iJ4)> 2 ){
                  if( iJ4==0 ){
                     break;
                  }else{
                     iJ4--;
                     continue;
                  }
               }else{
                  if( iJ4==(m-1) ){
                     int iL=0;
                     int ifac=1;
                     for(int pJ4=0;pJ4<m;pJ4++){
                        iL+=(vv.J4iT(pJ4)*ifac);
                        ifac*=3;
                     }
//
//
// compositions of 2nd patch
//
                     vv.J4jT( 0)=-1;
                     int jJ4=0;
                     while( true ){
                        vv.J4jT(jJ4)++;
                        if( vv.J4jT(jJ4)> 2 ){
                           if( jJ4== 0 ){
                              break;
                           }else{
                              jJ4--;
                              continue;
                           }
                        }else{
                           if( jJ4==(n-1) ){
                              int jL=0;
                              int jfac=1;
                              for(int pJ4=0;pJ4<n;pJ4++){
                                 jL+=(vv.J4jT(pJ4)*jfac);
                                 jfac*=3;
                              }
//
//
// iteration over dock configs
//
                              char ipck=0;
                              for(int pJ4=0;pJ4<m;pJ4++){
                                 ipck+=BTf(C8[iC8].N2[0].J4[pJ4].B,
                                           vv.J4iT(pJ4));
                                 int iX=C8[iC8].N2[0].J4[pJ4].X;
                                 int iY=C8[iC8].N2[0].J4[pJ4].Y;
                                 int lJ4=C8[iC8].XYJ4(iX   ,iY+ 1);
                                 if( lJ4>-1 ){
                                    ipck+=TTf(vv.J4iT(pJ4),vv.J4jT(lJ4));
                                 }
                                 lJ4=C8[iC8].XYJ4(iX   ,iY- 1);
                                 if( lJ4>-1 ){
                                    ipck+=TTf(vv.J4iT(pJ4),vv.J4jT(lJ4));
                                 }
                                 lJ4=C8[iC8].XYJ4(iX+ 1,iY   );
                                 if( lJ4>-1 ){
                                    ipck+=TTf(vv.J4iT(pJ4),vv.J4jT(lJ4));
                                 }
                                 lJ4=C8[iC8].XYJ4(iX- 1,iY   );
                                 if( lJ4>-1 ){
                                    ipck+=TTf(vv.J4iT(pJ4),vv.J4jT(lJ4));
                                 }
                              }
                              for(int pJ4=0;pJ4<n;pJ4++){
                                 ipck+=BTf(C8[iC8].N2[1].J4[pJ4].B,
                                           vv.J4jT(pJ4));
                              }
                              C8[iC8].LLe(iL,jL)=( ipck/2 +64);
//
                           }else{
                              jJ4++;
                              vv.J4jT(jJ4)=-1;
                           }
                        }
                     }
//
                  }else{
                    iJ4++;
                    vv.J4iT(iJ4)=-1;
                  }
               }
            }
//
         }
      }
   }
//
//
// config params
//
   double N2sgn[ 2];
   N2sgn[ 0]=( 1.00);
   N2sgn[ 1]=(-1.00);
   for(int iO1= 0;iO1<oO1;iO1++){
      int oP3=O1[iO1].oP3;
      for(int iP3= 0;iP3<oP3;iP3++){
         O1[iO1].P3[iP3].C8.resize(oC8);
         int oJ4=O1[iO1].P3[iP3].oJ4;
         double bet= O1[iO1].P3[iP3].bet;
         for(int iC8= 0;iC8<oC8;iC8++){
            for(int iN2= 0;iN2< 2;iN2++){
               if( C8[iC8].N2[iN2].oJ4!=oJ4 ){
               }else{
                  double the=( C8[iC8].N2[iN2].the +N2sgn[iN2]*bet);
                  double Cthe= std::cos( the);
                  double Sthe= std::sin( the);
                  O1[iO1].P3[iP3].C8[iC8].N2[iN2].r(0,2)=( 0.00);
                  O1[iO1].P3[iP3].C8[iC8].N2[iN2].r(1,2)= Cthe;
                  O1[iO1].P3[iP3].C8[iC8].N2[iN2].r(2,2)= Sthe;
                  O1[iO1].P3[iP3].C8[iC8].N2[iN2].r(0,0)= N2sgn[iN2];
                  O1[iO1].P3[iP3].C8[iC8].N2[iN2].r(1,0)=( 0.00);
                  O1[iO1].P3[iP3].C8[iC8].N2[iN2].r(2,0)=( 0.00);
                  O1[iO1].P3[iP3].C8[iC8].N2[iN2].r(0,1)=( 0.00);
                  O1[iO1].P3[iP3].C8[iC8].N2[iN2].r(1,1)= Sthe*N2sgn[iN2];
                  O1[iO1].P3[iP3].C8[iC8].N2[iN2].r(2,1)=-Cthe*N2sgn[iN2];
               }
            }
         }
      }
   }
}

int DAT_IGOR_DATA::iresidue(char a1) const {
   int iL1=-1;
   for(int jL1= 0;jL1<oL1;jL1++){
      if( L1[jL1].a1==a1 ){
         iL1=jL1;
         break;
      }
   }
   return iL1;
}
int DAT_IGOR_DATA::ipatch(char a1){
   int i(-1),j(-1);
   if      ( a1=='1' ){
      i=0;
      j=0;
   }else if( a1=='2' ){
      i=0;
      j=1;
   }else if( a1=='3' ){
      i=0;
      j=2;
   }else if( a1=='4' ){
      i=0;
      j=3;
   }else if( a1=='5' ){
      i=0;
      j=4;
   }else if( a1=='6' ){
      i=0;
      j=5;
   }else if( a1=='7' ){
      i=0;
      j=6;
   }else if( a1=='8' ){
      i=0;
      j=7;
   }else if( a1=='a' ){
      i=1;
      j=0;
   }else if( a1=='b' ){
      i=1;
      j=1;
   }else if( a1=='c' ){
      i=1;
      j=2;
   }else if( a1=='d' ){
      i=1;
      j=3;
   }else if( a1=='e' ){
      i=1;
      j=4;
   }else if( a1=='f' ){
      i=1;
      j=5;
   }else if( a1=='g' ){
      i=1;
      j=6;
   }else if( a1=='h' ){
      i=1;
      j=7;
   }else if( a1==' ' ){
   }else{
      std::cerr<<"ERROR: Undefined Character="
               <<a1+".\n";
      std::exit( 1);
   }
   return ( i*8 +j);
}
