#ifndef DEF_DAT_ENERGY_PARAMS
#define DEF_DAT_ENERGY_PARAMS

#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include <string>
#include <vector>

class DAT_ENERGY_PARAMS {
public:
   class tS3 { /*atom pair types for disulfide bond crosslinking*/
   public:
      double a;                         //harmonic force const (hart/bohr**2)
      double r;                         //target distance (bohr)
      tS3(){}
   };
   class tT2 { /*atom types*/
   public:
      double Rsph;                      //atom radius (bohr)
      tT2(){}
   };
   class tL3 { /*peptide residues in ising model data set*/
   public:
      std::string aa;                   //amino acid name
      int X7a;                          //start index into set of states
      int cX7;                          //number of states
      tL3(){}
   };
   class tL4 { /*nucleotide residues in ising model data set*/
   public:
      std::string aa;                   //amino acid name
      int Y7a;                          //start index into set of states
      int cY7;                          //number of states
      tL4(){}
   };

private:
   /*parameter sets adjusted to fit experimental data*/
   std::vector<double> o_pre;           //structure prediction
   std::vector<double> o_ion;           //ionization state
   std::vector<double> o_sta;           //stability
   std::vector<double> o_sol;           //solubility
   std::vector<double> o_Qhs;           //transfer dG from solid to hydrated
   double& pre(int i){
      return o_pre.at( i);
   }
   double& sta(int i){
      return o_sta.at( i);
   }
   double& sol(int i){
      return o_sol.at( i);
   }

   /*Fr*/
   std::vector<double> o_T2T2e;         //(hart)
   std::vector<double> o_T2T2r;         //(bohr)
   std::vector<double> o_T2T2a;         //buffer parameter to soften repulsion
   /*Fe*/
   /*Fs*/
   std::vector<int> o_S2S2S3;           //atom pair type
   std::vector<int> o_S2S2b4;           //binary flag {0=not 1--4, 1=1--4}
   int& S2S2S3(int i,int j){
      return o_S2S2S3.at( i*5 +j);
   }
   int& S2S2b4(int i,int j){
      return o_S2S2b4.at( i*5 +j);
   }
   /*Ft*/
   /*Fc*/
   std::vector<double> o_W0a;           //harmonic force const (hart/bohr**2)
   double& W0a(int i){                  //offset index, index range={-8:16}
      return o_W0a.at(i+8);
   }
   /*Fh*/
   /*Fm*/
   /*Fp*/

   /*free energy of unfolded state*/
   int oX7;                             //dimension of states
   std::vector<double> o_X7e;           //1-bod energy impulses (kcal)
   std::vector<double> o_X7X7e;         //2-bod energy impulses (kcal)
   int oY7;                             //dimension of states
   std::vector<double> o_Y7e;           //1-bod energy impulses (kcal)
   double& X7e(int i){
      return o_X7e.at( i);
   }
   double& X7X7e(int i,int j){
      return o_X7X7e.at( i*oX7 +j);
   }
   double& Y7e(int i){
      return o_Y7e.at( i);
   }

public:
   /*parameter sets adjusted to fit experimental data*/
   const double& pre(int i) const {
      return o_pre.at( i);
   }
   double& ion(int i){
      return o_ion.at( i);
   }
   const double& ion(int i) const {
      return o_ion.at( i);
   }
   const double& sta(int i) const {
      return o_sta.at( i);
   }
   const double& sol(int i) const {
      return o_sol.at( i);
   }
   double& Qhs(int i){
      return o_Qhs.at( i);
   }
   const double& Qhs(int i) const {
      return o_Qhs.at( i);
   }
   /*weights of energy surface components pp, h, ps, ss*/
   double fac_pp;                       //Fpp= protein-protien
   double fac_h;                        //Fh=  hydrophobic
   double fac_ps;                       //Fps= protein-solvent
   double fac_ss;                       //Fss= solvent-solvent
   double fac_qd;                       //Fqd= fullchg-induced dipole
   double fac_uh;                       //Fuh= unpaired H-Bond don or acc
   double fac_cc;                       //Fcc= cleft +cavity volume

   /*Fr*/
   double& T2T2e(int i,int j){
      return o_T2T2e.at( i*32 +j);
   }
   double& T2T2r(int i,int j){
      return o_T2T2r.at( i*32 +j);
   }
   double& T2T2a(int i,int j){
      return o_T2T2a.at( i*32 +j);
   }
   const double& T2T2e(int i,int j) const {
      return o_T2T2e.at( i*32 +j);
   }
   const double& T2T2r(int i,int j) const {
      return o_T2T2r.at( i*32 +j);
   }
   const double& T2T2a(int i,int j) const {
      return o_T2T2a.at( i*32 +j);
   }
   /*Fe*/
   int LTE;                             //expansion truncated at 1/(R**(LTE+1))
   /*Fs*/
   std::vector<tS3> S3;                 //
   const int& S2S2S3(int i,int j) const {
      return o_S2S2S3.at( i*5 +j);
   }
   const int& S2S2b4(int i,int j) const {
      return o_S2S2b4.at( i*5 +j);
   }
   /*Ft*/
   /*Fc*/
   const double& W0a(int i) const {
      return o_W0a.at(i+8);
   }
   /*Fh*/
   /*Fm*/
   double Rprobe;                       //probe radius (bohr)
   std::vector<tT2> T2;                 //
   /*Fp*/
   double dFhb;                         //polarization contrib to H-bond (kcal)

   /*free energy of unfolded state*/
   int oL3;                             //dimension of residues
   std::vector<tL3> L3;                 //
   const double& X7e(int i) const {
      return o_X7e.at( i);
   }
   const double& X7X7e(int i,int j) const {
      return o_X7X7e.at( i*oX7 +j);
   }
   int oL4;                             //dimension of residues
   std::vector<tL4> L4;                 //
   const double& Y7e(int i) const {
      return o_Y7e.at( i);
   }

   DAT_ENERGY_PARAMS(const DAT_PHYSICS_CONSTS& physics_consts,
                     const Structure& s =Structure());
};

#endif
//
// coefficients of QSAR properties for model of solubility= free energy of
//  hydration relative to aggregated phase
// Fhs= Qhs[ 0]*(hydrophobic surf area)
//     +Qhs[ 1]*(polar surf area)
//     +Qhs[ 2]*(Fps)
//     +Qhs[ 3]*(Fss)
//     +Qhs[ 4]*(total charge squared)
//     +Qhs[ 5]*(total number of full charges)
// func of (pH,T,ionconc)
//
