#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <sstream>
#include <cmath>

class MEM_DAT_ENERGY_PARAMS {
public:
   std::vector<std::string> o_Lrec;     //lines from input file
   MEM_DAT_ENERGY_PARAMS(){
   }
   std::string& Lrec(int i){
      return o_Lrec.at( i);  }
};

DAT_ENERGY_PARAMS::DAT_ENERGY_PARAMS(const DAT_PHYSICS_CONSTS& physics_consts,
                                     const Structure& s):
   o_pre( 7),
   o_ion(24),
   o_sta(34),
   o_sol(14),
   o_Qhs( 6),
   o_T2T2e(32*32),
   o_T2T2r(32*32),
   o_T2T2a(32*32),
   o_S2S2S3(5*5),
   o_S2S2b4(5*5),
   o_W0a(25),
   oX7(863),
   o_X7e(oX7),
   o_X7X7e(oX7*oX7),
   oY7(4652),
   o_Y7e(oY7),
   S3( 4),
   T2(32),
   oL3(27),
   L3(oL3),
   oL4(26),
   L4(oL4)
{
   MEM_DAT_ENERGY_PARAMS vv;
   std::ifstream ifile;
   std::string rec;
   int p;
//
//
// parameter sets adjusted to fit experimental data
//
//
// structure prediction
   pre( 0)=(  0.60000);         //pp
   pre( 1)=(  1.25000);         //h
   pre( 2)=(  0.87460);         //ps
   pre( 3)=(  0.72670);         //ss
   pre( 4)=(  1.00000);         //qd
   pre( 5)=(  1.00000);         //uh
   pre( 6)=(  1.00000);         //cc
//
// ionstate
   ion( 0)=(  0.24974);         //pp
   ion( 1)=(  0.22780);         //ps
   ion( 2)=(  0.20062);         //ss
   ion( 3)=(  0.28886);         //ddF= (1/x)*ln( 1 +x*ddF)
   ion( 4)=(  0.21547);         //hbond to unprotonated group
   ion( 5)=(  0.000);           //eala Tdf additional to model peptide
   ion( 6)=(  0.000);           //asp
   ion( 7)=(  0.000);           //cyh
   ion( 8)=(  0.000);           //glu
   ion( 9)=(  0.000);           //his
   ion(10)=(  0.000);           //lys
   ion(11)=(  0.000);           //tyr
   ion(12)=(  0.000);           //alae
   ion(13)=(  0.000);           //hie
   ion(14)=(  0.00009);         //counterion distribution
   ion(15)=(  2.030);           //eala Tdf average over model peptide confs
   ion(16)=(  -.250);           //asp
   ion(17)=( -5.130);           //cyh
   ion(18)=(   .400);           //glu
   ion(19)=(  4.960);           //his
   ion(20)=(-10.210);           //lys
   ion(21)=( -6.730);           //tyr
   ion(22)=( -1.690);           //alae
   ion(23)=(  4.040);           //hie
//
// stabiliy
   sta( 0)=(  0.23956);         //pp
   sta( 1)=(  0.75826);         //h
   sta( 2)=(  0.21357);         //ps(.8915)( .9319)
   sta( 3)=(  0.17619);         //ss(.7354)( .8833)
   sta( 4)=(  0.27604);         //(1/T)
   sta( 5)=(  0.74958);         //for ddG>0, ddG= ( 1/x05)*ln( 1 +x05*ddG)
   sta( 6)=(  1.05992);         //for ddG<0, ddG= (-1/x06)*ln( 1 -x06*ddG)
   sta( 7)=( -4.17999);         //ALA reference energy added to unfolded
   sta( 8)=( -0.81440);         //ASP
   sta( 9)=( -1.43620);         //CYH
   sta(10)=(  0.94409);         //GLU
   sta(11)=( -0.46414);         //PHE
   sta(12)=( -2.76721);         //GLY
   sta(13)=( -1.12254);         //HIS
   sta(14)=( -0.99838);         //ILE
   sta(15)=(  3.63744);         //LYS
   sta(16)=(  0.96796);         //LEU
   sta(17)=(  1.02649);         //MET
   sta(18)=( -0.67224);         //ASN
   sta(19)=( -1.26101);         //PRO
   sta(20)=(  0.64010);         //GLN
   sta(21)=(  5.20364);         //ARG
   sta(22)=( -1.18293);         //SER
   sta(23)=( -1.23131);         //THR
   sta(24)=( -1.70724);         //VAL
   sta(25)=( -2.15720);         //TRP
   sta(26)=(  1.95980);         //TYR
   sta(27)=(  1.53184);         //HIE
   sta(28)=(  1.81801);         //HIP
   sta(29)=(  0.20803);         //ASZ
   sta(30)=(  0.00000);         //CYZ
   sta(31)=(  2.05739);         //GLZ
   sta(32)=(  0.00000);         //LYZ
   sta(33)=(  0.00000);         //TYZ
//
// solubility
   sol( 0)=(  0.104946);        //a= x00 +(x01/2)*[ 1 +tanh( x12*( ic -x13))]
   sol( 1)=(  0.045192);        //
   sol( 2)=( -0.081648);        //b= x02 +(x03/2)*[ 1 +tanh( x12*( ic -x13))]
   sol( 3)=(  0.025156);        //
   sol( 4)=(  0.003548);        //c= x04 +(x05/2)*[ 1 +tanh( x12*( ic -x13))]
   sol( 5)=( -0.001793);        //
   sol( 6)=(  0.003104);        //d= x06 +(x07/2)*[ 1 +tanh( x12*( ic -x13))]
   sol( 7)=( -0.001559);        //
   sol( 8)=( -0.002670);        //e= x08 +(x09/2)*[ 1 +tanh( x12*( ic -x13))]
   sol( 9)=(  0.003833);        //
   sol(10)=( -0.053186);        //f= x10 +(x11/2)*[ 1 +tanh( x12*( ic -x13))]
   sol(11)=(  0.003547);        //
   sol(12)=(  2.502267);        //Fsol= a*Qha +b*Qpa +c*Qps +d*Qss +e*Qtq +f*Qfq
   sol(13)=(  1.921146);        //
//
// coefficients of QSAR properties for model of solubility
// func of (pH,T,ionconc)
//
   double ionconc= (0.00);      //conc of ammonium sulfate (mol/l)
   double ztanh=( (1.) +std::tanh( sol(12)*( ionconc -sol(13))));
   ztanh*=(.50);
   Qhs( 0)= sol( 0) +sol( 1)*ztanh;
   Qhs( 1)= sol( 2) +sol( 3)*ztanh;
   Qhs( 2)= sol( 4) +sol( 5)*ztanh;
   Qhs( 3)= sol( 6) +sol( 7)*ztanh;
   Qhs( 4)= sol( 8) +sol( 9)*ztanh;
   Qhs( 5)= sol(10) +sol(11)*ztanh;
//
//
// weights of energy surface components pp, h, ps, ss
//
   fac_pp= pre( 0);
   fac_h=  pre( 1);
   fac_ps= pre( 2);
   fac_ss= pre( 3);
   fac_qd= pre( 4);
   fac_uh= pre( 5);
   fac_cc= pre( 6);
//
//
// read parameters of restchm
//
   ifile.open("../dat/energy_params");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();

   p=3;
   for(int iT2= 0;iT2<32;iT2++){
      for(int jT2=iT2;jT2<32;jT2++){
         std::istringstream(vv.Lrec(p++).substr( 0,36))>>T2T2e(iT2,jT2)
                                                       >>T2T2r(iT2,jT2)
                                                       >>T2T2a(iT2,jT2);
         T2T2e(iT2,jT2)/=physics_consts.CAL;
         T2T2e(iT2,jT2)*=fac_pp;
         T2T2r(iT2,jT2)/=physics_consts.ANG;
         if( jT2==iT2 )continue;
         T2T2e(jT2,iT2)= T2T2e(iT2,jT2);
         T2T2r(jT2,iT2)= T2T2r(iT2,jT2);
         T2T2a(jT2,iT2)= T2T2a(iT2,jT2);
      }
   }
   p+=2;
   std::istringstream(vv.Lrec(p++).substr( 4, 1))>>LTE;
   p+=3;
   std::istringstream(vv.Lrec(p++))>>S3[0].a >>S3[1].a >>S3[2].a >>S3[3].a;
   for(int iS3=0;iS3<4;iS3++){
      S3[iS3].a*=std::pow(physics_consts.ANG,2)/physics_consts.CAL;
      S3[iS3].a*=fac_pp;
   }
   p+=1;
   std::istringstream(vv.Lrec(p++))>>S3[0].r >>S3[1].r >>S3[2].r >>S3[3].r;
   for(int iS3=0;iS3<4;iS3++){
      S3[iS3].r/=physics_consts.ANG;
   }
   p+=1;
   for(int iS2= 0;iS2<5;iS2++){
      std::istringstream irec(vv.Lrec(p++));
      for(int jS2=0;jS2<5;jS2++){
         irec>>S2S2S3(iS2,jS2);
      }
   }
   p+=1;
   for(int iS2= 0;iS2<5;iS2++){
      std::istringstream irec(vv.Lrec(p++));
      for(int jS2=0;jS2<5;jS2++){
         irec>>S2S2b4(iS2,jS2);
      }
   }
   p+=5;
   {
      rec.clear();
      for(int i=0;i<4;i++){
         rec+=vv.Lrec(p++).substr( 0,80);
      }
      std::istringstream irec(rec);
      for(int iW0=-8;iW0<17;iW0++){
         irec>>W0a(iW0);
         W0a(iW0)/=physics_consts.CAL;
         W0a(iW0)*=fac_pp;
      }
   }
   p+=4;
   std::istringstream(vv.Lrec(p++).substr( 7, 5))>>Rprobe;
   Rprobe/=physics_consts.ANG;
   p+=1;
   {
      rec.clear();
      for(int i=0;i<4;i++){
         rec+=vv.Lrec(p++).substr( 0,40);
      }
      std::istringstream irec(rec);
      for(int iT2= 0;iT2<32;iT2++){
         irec>>T2[iT2].Rsph;
         T2[iT2].Rsph/=physics_consts.ANG;
      }
   }
   p+=2;
   std::istringstream(vv.Lrec(p++).substr( 5, 5))>>dFhb;
   dFhb*=fac_pp;
   vv.o_Lrec.clear();
//
//
// read energy impulses 1-bod and 2 bod
//
   ifile.open("../dat/energy_impulses");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();

   p=0;
   int mX7=0;
   for(int iL3= 0;iL3<oL3;iL3++){
      L3[iL3].aa=vv.Lrec(p  ).substr( 1, 4);
      L3[iL3].X7a=mX7;
      std::istringstream(vv.Lrec(p++).substr( 5, 4))>>L3[iL3].cX7;
      int nX7=(mX7-1+L3[iL3].cX7);
      for(int iX7=mX7;iX7<=nX7;iX7++){
         double pp,h,ps,ss;
         std::istringstream(vv.Lrec(p++).substr( 0,48))>>pp>>h>>ps>>ss;
         X7e(iX7)=( sta( 0)*pp
                   +sta( 1)*h
                   +sta( 2)*ps
                   +sta( 3)*ss);
      }
      mX7+=L3[iL3].cX7;
   }
   for(int iL3= 0;iL3<oL3;iL3++){
      int iX7min=L3[iL3].X7a;
      int iX7max=(iX7min-1+L3[iL3].cX7);
      for(int jL3= 0;jL3<oL3;jL3++){
         std::string aa0=vv.Lrec(p  ).substr( 1, 4);
         std::string aa1=vv.Lrec(p++).substr( 5, 4);
         if( (aa0!=L3[iL3].aa)||(aa1!=L3[jL3].aa) ){
            std::cerr<<"ERROR: Amino acid name mismatch.\n";
            std::exit( 1);
         }
         int jX7min=L3[jL3].X7a;
         int jX7max=(jX7min-1+L3[jL3].cX7);
         for(int iX7=iX7min;iX7<=iX7max;iX7++){
            for(int jX7=jX7min;jX7<=jX7max;jX7++){
               double pp,h,ps,ss;
               std::istringstream(vv.Lrec(p++).substr( 0,48))>>pp>>h>>ps>>ss;
               X7X7e(iX7,jX7)=( sta( 0)*pp
                               +sta( 1)*h
                               +sta( 2)*ps
                               +sta( 3)*ss);
               X7X7e(iX7,jX7)-=( X7e(iX7) +X7e(jX7));
            }
         }
      }
   }
   int mY7=0;
   for(int iL4= 0;iL4<oL4;iL4++){
      L4[iL4].aa=vv.Lrec(p  ).substr( 1, 4);
      L4[iL4].Y7a=mY7;
      std::istringstream(vv.Lrec(p++).substr( 5, 4))>>L4[iL4].cY7;
      int nY7=(mY7-1+L4[iL4].cY7);
      for(int iY7=mY7;iY7<=nY7;iY7++){
         double pp,h,ps,ss;
         std::istringstream(vv.Lrec(p++).substr( 0,48))>>pp>>h>>ps>>ss;
         Y7e(iY7)=( sta( 0)*pp
                   +sta( 1)*h
                   +sta( 2)*ps
                   +sta( 3)*ss);
      }
      mY7+=L4[iL4].cY7;
   }
   vv.o_Lrec.clear();
//
//
// optionally patch fac_h, fac_ps, and fac_ss
//
   if( int(s.Z0.size())==0 ){
   }else{
//
      int oZ0=s.nZ0;
      int oR0=(s.Z0[oZ0-1].R0a+s.Z0[oZ0-1].cR0);
//
      double q( 0.00),qm( 0.00),qp( 0.00);
      int n( 0);
      for(int iR0= 0;iR0<oR0;iR0++){
         std::string aa=s.R0[iR0].aa;
         std::string ab=s.R0[iR0].aa;
         if( (ab[0]=='e')||(ab[0]=='z') )ab=ab.substr(1,3)+' ';
         if( (ab[3]=='e')||(ab[3]=='z') )ab=ab.substr(0,3)+' ';
         if( aa[0]=='e' ){
            q++;
            qp++;
         }
         if      ( (ab=="ASP ")||(ab=="GLU ")||(ab=="TYZ ")||(ab=="CYZ ")||
                   (ab=="PO  ")||(ab=="PSR ")||(ab=="PSS ")||(ab=="GM  ")||
                   (ab=="TM  ")||(ab=="UM  ") ){
            q--;
            qm++;
         }else if( (ab=="LYS ")||(ab=="ARG ")||(ab=="ORN ")||(ab=="HIP ")||
                   (ab=="AP  ")||(ab=="GP  ")||(ab=="CP  ") ){
            q++;
            qp++;
         }else if( (ab=="5PO ")||(ab=="3PO ")||(ab=="SEP ")||(ab=="THP ")||
                   (ab=="TYP ") ){
            q-=(2.00);
            qm+=(2.00);
         }
         if( aa[3]=='e' ){
            q--;
            qm++;
         }
         char c1=s.R0[iR0].c1;
         if( c1=='p' ){
            n++;
         }
      }
//
      double v= double( oR0);
      double r3= ((3.)*v*(140.00))/((4.)*physics_consts.PI);
      double r= std::exp( std::log( r3)/(3.));
      double a= ((4.)*physics_consts.PI)*std::pow(( r -(2.5962))/(5.1925), 2);
//
      double ps_ion( 1.00),ss_ion( 1.00), h_ion( 1.00),
             qd_ion( 1.00),uh_ion( 1.00),cc_ion( 1.00);
      if      ( n>16 ){
         ps_ion=(  1.000);
         ss_ion=(  1.000);
         h_ion=(  1.380);
         qd_ion=(  1.000);
         uh_ion=(  1.000);
         cc_ion=(  1.000);
      }else if( q<(  0.00) ){
         double n= physics_consts.CAL*physics_consts.ANG*( q*q)/r;
         double d=( n +a*( 8.00)
                   +physics_consts.CAL*physics_consts.ANG
                   *(.50)*( qm/(3.40) +qp/(3.80)));
         ps_ion-=(.0375)*(n/d);
         ss_ion-=(.0375)*(n/d);
         h_ion+=(0.80)*(-q/a);
      }else{
         h_ion+=(0.20)*( q/a);
      }
//
      fac_ps*=ps_ion;
      fac_ss*=ss_ion;
      fac_h*=h_ion;
      fac_qd*=qd_ion;
      fac_uh*=uh_ion;
      fac_cc*=cc_ion;
   }
}
