#ifndef DEF_DAT_DISULFIDE_LINKS
#define DEF_DAT_DISULFIDE_LINKS

#include <string>
#include <vector>

class DAT_DISULFIDE_LINKS {
public:
   class tL5 { /*physical atoms of CYS modified for crosslinking*/
   public:
      std::string atm;          //4 char atom name
      /*atom types for disulfide bond crosslinking*/
      int sg;                   //newly added forward group
      int sf;                   //backward or previously added forward group
      tL5(){}
   };
   class tJ5 { /*string of CYS torsions [forward order] modified for
                 crosslinking*/
   public:
      std::string tor;          //3 char name of torsion
      int L5a;                  //start index into L5
      int cL5;                  //number of L5 atoms in forward group
      tJ5(){}
   };
   class tK5 { /*string of CYS torsions [backward order] modified for
                 crosslinking*/
   public:
      std::string tor;          //3 char name of torsion
      int L5a;                  //start index into L5
      int cL5;                  //number of L5 atoms in backward group
      tK5(){}
   };

private:
   /*N2={CYS residues of disulfide bonded pair}*/
   /*group contributions to crosslink function*/
   std::vector<int> o_O5N2J5sq;         //forward group
   std::vector<int> o_O5N2K5sx;         //backward group
   /*atom types for disulfide bond crosslinking*/
   std::vector<int> o_O5N2L5sg;         //newly added forward group
   std::vector<int> o_O5N2L5sf;         //backward or prev added forward group
   /*patterns of variable torsions within the chain connecting the crosslink*/
   std::vector<int> o_N1N1N1N1N1N1O5;   //same chain
   std::vector<int> o_N1N1N1N1O5;       //different chains

   int& O5N2J5sq(int i,int j,int k){
      return o_O5N2J5sq.at( i*2*4 +j*4 +k);
   }
   int& O5N2K5sx(int i,int j,int k){
      return o_O5N2K5sx.at( i*2*4 +j*4 +k);
   }
   int& O5N2L5sg(int i,int j,int k){
      return o_O5N2L5sg.at( i*2*6 +j*6 +k);
   }
   int& O5N2L5sf(int i,int j,int k){
      return o_O5N2L5sf.at( i*2*6 +j*6 +k);
   }
   int& N1N1N1N1N1N1O5(int i,int j,int k,int l,int m,int n){
      return o_N1N1N1N1N1N1O5.at( i*32 +j*16 +k*8 +l*4 +m*2 +n);
   }
   int& N1N1N1N1O5(int i,int j,int k,int l){
      return o_N1N1N1N1O5.at( i*8 +j*4 +k*2 +l);
   }

public:
   std::vector<tL5> L5;                 //
   std::vector<tJ5> J5;                 //
   std::vector<tK5> K5;                 //

   const int& O5N2J5sq(int i,int j,int k) const {
      return o_O5N2J5sq.at( i*2*4 +j*4 +k);
   }
   const int& O5N2K5sx(int i,int j,int k) const {
      return o_O5N2K5sx.at( i*2*4 +j*4 +k);
   }
   const int& O5N2L5sg(int i,int j,int k) const {
      return o_O5N2L5sg.at( i*2*6 +j*6 +k);
   }
   const int& O5N2L5sf(int i,int j,int k) const {
      return o_O5N2L5sf.at( i*2*6 +j*6 +k);
   }
   const int& N1N1N1N1N1N1O5(int i,int j,int k,int l,int m,int n) const {
      return o_N1N1N1N1N1N1O5.at( i*32 +j*16 +k*8 +l*4 +m*2 +n);
   }
   const int& N1N1N1N1O5(int i,int j,int k,int l) const {
      return o_N1N1N1N1O5.at( i*8 +j*4 +k*2 +l);
   }

   DAT_DISULFIDE_LINKS();
   int ij5torsion(std::string tor) const;
   int ik5torsion(std::string tor) const;
   int il5atom(std::string atm) const;
};

#endif
//
// For CYS residues of disulfide crosslinks, some residue parameters will be
// modified dependent on the topology of forward groups.
//
