#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include <string>
#include <vector>
#include <sstream>

class MEM_DAT_DISULFIDE_LINKS {
private:
   std::vector<std::string> o_L5rec;    //
   std::vector<std::string> o_J5rec;    //
   std::vector<std::string> o_K5rec;    //
   std::vector<std::string> o_O5rec;    //
public:
   MEM_DAT_DISULFIDE_LINKS():
      o_L5rec( 6),
      o_J5rec( 4),
      o_K5rec( 4),
      o_O5rec(16)
   {
   }
   std::string& L5rec(int i){
      return o_L5rec.at( i);  }
   std::string& J5rec(int i){
      return o_J5rec.at( i);  }
   std::string& K5rec(int i){
      return o_K5rec.at( i);  }
   std::string& O5rec(int i){
      return o_O5rec.at( i);  }
};

DAT_DISULFIDE_LINKS::DAT_DISULFIDE_LINKS():
   o_O5N2J5sq(16*2*4),
   o_O5N2K5sx(16*2*4, 0),
   o_O5N2L5sg(16*2*6, 0),
   o_O5N2L5sf(16*2*6, 4),
   o_N1N1N1N1N1N1O5(64),
   o_N1N1N1N1O5(16),
   L5(6),
   J5(4),
   K5(4)
{
   MEM_DAT_DISULFIDE_LINKS vv;

   vv.L5rec( 0)=" CA  1 3";
   vv.L5rec( 1)=" CB  2 2";
   vv.L5rec( 2)="1HB  1 3";
   vv.L5rec( 3)="2HB  1 3";
   vv.L5rec( 4)=" SG  3 1";
   vv.L5rec( 5)=" sln 4 0";
   for(int iL5=0;iL5<6;iL5++){
      L5[iL5].atm=vv.L5rec(iL5).substr( 0, 4);
      std::istringstream(vv.L5rec(iL5).substr( 4, 4))>>L5[iL5].sg
                                                     >>L5[iL5].sf;
   }

   vv.J5rec( 0)="OMG 0 1";
   vv.J5rec( 1)="PHI 1 1";
   vv.J5rec( 2)="CH1 2 3";
   vv.J5rec( 3)="CH2 5 1";
   for(int iJ5=0;iJ5<4;iJ5++){
      J5[iJ5].tor=vv.J5rec(iJ5).substr( 0, 3);
      std::istringstream(vv.J5rec(iJ5).substr( 3, 4))>>J5[iJ5].L5a
                                                     >>J5[iJ5].cL5;
   }

   vv.K5rec( 0)="PSI 0 1";
   vv.K5rec( 1)="CH1 1 1";
   vv.K5rec( 2)="CH2 2 3";
   vv.K5rec( 3)="PHI 5 1";
   for(int iK5=0;iK5<4;iK5++){
      K5[iK5].tor=vv.K5rec(iK5).substr( 0, 3);
      std::istringstream(vv.K5rec(iK5).substr( 3, 4))>>K5[iK5].L5a
                                                     >>K5[iK5].cL5;
   }
//
// uncontracted forward groups
//  1=1st res ch2
//  2=1st res ch1
//  3=2nd res omg
//  4=2nd res phi
//  5=2nd res ch1
//  6=2nd res ch2
// topology=[base](1st forward group)(2nd forward group)
//                  1st residue       2nd residue
//                  K5sx     J5sq     J5sq      topology of forward groups
   vv.O5rec( 0)="  1 1 1 1  0 0 0 0  1 1 1 1"; //[12](3456)
                                               //[2](1)(3456)
                                               //(12)(3456)
   vv.O5rec( 1)="  1 1 1 1  0 0 1 1 -1 1 1 1"; //[3](12)(456)
   vv.O5rec( 2)="  1 1 1 1  0 0 1 1 -1-1 1 1"; //[34](12)(56)
   vv.O5rec( 3)="  1 1 1 1  0 0 1 1 -1-1-1 1"; //[345](12)(6)
   vv.O5rec( 4)="  0 0 0 0  0 0 1 1 -1-1-1-1"; //[3456](12)
   vv.O5rec( 5)="  1 1 1 1  0 0 0 1 -1 1 1 1"; //[23](1)(456)
   vv.O5rec( 6)="  1 1 1 1  0 0 0 1 -1-1 1 1"; //[234](1)(56)
   vv.O5rec( 7)="  1 1 1 1  0 0 0 1 -1-1-1 1"; //[2345](1)(6)
   vv.O5rec( 8)="  0 0 0 0  0 0 0 1 -1-1-1-1"; //[23456](1)
   vv.O5rec( 9)="  1 1 1 1  0 0 0 0  0 1 1 1"; //[123](456)
   vv.O5rec(10)="  1 1 1 1  0 0 0 0  0 0 1 1"; //[1234](56)
   vv.O5rec(11)="  1 1 1 1  0 0 0 0  0 0 0 1"; //[12345](6)
   vv.O5rec(12)="  0 0 0 0 -1-1-1-1  1 1 1 1"; //[12](3456)
   vv.O5rec(13)="  0 0 0 0 -1-1-1-1  0 1 1 1"; //[123](456)
   vv.O5rec(14)="  0 0 0 0 -1-1-1-1  0 0 1 1"; //[1234](56)
   vv.O5rec(15)="  0 0 0 0 -1-1-1-1  0 0 0 1"; //[12345](6)
   for(int iO5=0;iO5<16;iO5++){
      std::istringstream irec(vv.O5rec(iO5));
      int i;
      for(int iN2=0;iN2<1;iN2++){
         for(int iK5=0;iK5<4;iK5++){
            irec>>i;
            O5N2K5sx(iO5,iN2,iK5)=i;
            if( i==1 ){
               int mL5=K5[iK5].L5a;
               int nL5=(mL5-1+K5[iK5].cL5);
               for(int iL5=mL5;iL5<=nL5;iL5++){
                  O5N2L5sf(iO5,iN2,iL5)=L5[iL5].sf;
               }
            }
         }
      }
      for(int iN2=0;iN2<2;iN2++){
         for(int iJ5=0;iJ5<4;iJ5++){
            irec>>i;
            O5N2J5sq(iO5,iN2,iJ5)=i;
            if      ( i== 1 ){
               int mL5=J5[iJ5].L5a;
               int nL5=(mL5-1+J5[iJ5].cL5);
               for(int iL5=mL5;iL5<=nL5;iL5++){
                  O5N2L5sg(iO5,iN2,iL5)=L5[iL5].sg;
               }
            }else if( i==-1 ){
               int mL5=K5[iJ5].L5a;
               int nL5=(mL5-1+K5[iJ5].cL5);
               for(int iL5=mL5;iL5<=nL5;iL5++){
                  O5N2L5sf(iO5,iN2,iL5)=L5[iL5].sf;
               }
            }
         }
      }
   }

   int buf;
   std::istringstream irec(
   " -1 000000 11 000001 10 000010 10 000011"
   "  9 000100  9 000101  9 000110  9 000111"
   "  0 001000  0 001001  0 001010  0 001011"
   "  0 001100  0 001101  0 001110  0 001111"
   "  4 010000  3 010001  2 010010  2 010011"
   "  1 010100  1 010101  1 010110  1 010111"
   "  0 011000  0 011001  0 011010  0 011011"
   "  0 011100  0 011101  0 011110  0 011111"
   "  8 100000  7 100001  6 100010  6 100011"
   "  5 100100  5 100101  5 100110  5 100111"
   "  0 101000  0 101001  0 101010  0 101011"
   "  0 101100  0 101101  0 101110  0 101111"
   "  4 110000  3 110001  2 110010  2 110011"
   "  1 110100  1 110101  1 110110  1 110111"
   "  0 111000  0 111001  0 111010  0 111011"
   "  0 111100  0 111101  0 111110  0 111111");
   for(int iN1=0;iN1<2;iN1++){
      for(int jN1=0;jN1<2;jN1++){
         for(int kN1=0;kN1<2;kN1++){
            for(int lN1=0;lN1<2;lN1++){
               for(int mN1=0;mN1<2;mN1++){
                  for(int nN1=0;nN1<2;nN1++){
                     irec>>N1N1N1N1N1N1O5(iN1,jN1,kN1,lN1,mN1,nN1)>>buf;
                  }
               }
            }
         }
      }
   }

   std::istringstream jrec(
   " -1   0000 15   0001 14   0010 14   0011"
   " 13   0100 13   0101 13   0110 13   0111"
   " 12   1000 12   1001 12   1010 12   1011"
   " 12   1100 12   1101 12   1110 12   1111");
   for(int iN1=0;iN1<2;iN1++){
      for(int jN1=0;jN1<2;jN1++){
         for(int kN1=0;kN1<2;kN1++){
            for(int lN1=0;lN1<2;lN1++){
               jrec>>N1N1N1N1O5(iN1,jN1,kN1,lN1)>>buf;
            }
         }
      }
   }
}
int DAT_DISULFIDE_LINKS::ij5torsion(std::string tor) const{
   for(int jJ5=0;jJ5<4;jJ5++){
      if( J5[jJ5].tor==tor ){
         return jJ5;
      }
   }
   return -1;
}
int DAT_DISULFIDE_LINKS::ik5torsion(std::string tor) const{
   for(int jK5=0;jK5<4;jK5++){
      if( K5[jK5].tor==tor ){
         return jK5;
      }
   }
   return -1;
}
int DAT_DISULFIDE_LINKS::il5atom(std::string atm) const{
   for(int jL5=0;jL5<6;jL5++){
      if( L5[jL5].atm==atm ){
         return jL5;
      }
   }
   return -1;
}
