#ifndef DEF_DAT_DEFORM_PARAMS
#define DEF_DAT_DEFORM_PARAMS

#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include <vector>

class DAT_DEFORM_PARAMS {
public:
   class tC4 { /*(psi,omg,phi) conformations*/
   public:
      double psi;                       //psi (degree)
      double omg;                       //omg (degree)
      double phi;                       //phi (degree)
      tC4(){}
   };
   class tG4 { /*subsets of C4 (psi,omg,phi) conformations*/
   public:
      int mC4;                          //start index into set of (psi,phi) defs
      int nC4;                          //number of (psi,phi) defs
      tG4(){}
   };
   class tC6 { /*(del,eps,zet,alp,bet,gam,del) conformations*/
   public:
      std::string cnf;                  //6 char suite conf name
      double de0;                       //de0 (degree)
      double eps;                       //eps (degree)
      double zet;                       //zet (degree)
      double alp;                       //alp (degree)
      double bet;                       //bet (degree)
      double gam;                       //gam (degree)
      double del;                       //del (degree)
      tC6(){}
   };

private:
   std::vector<double> o_C4C4p;         //2-bod probability
   std::vector<int> o_C4C4C7;           //secondary structure state
   std::vector<double> o_C4C4d;         //distance squared (degree**2)
   std::vector<int> o_S4S4sub;          //subsets of [-pi,pi)

   double& C4C4p(int i,int j){
      return o_C4C4p.at( i*60 +j);
   }
   int& C4C4C7(int i,int j){
      return o_C4C4C7.at( i*60 +j);
   }
   double& C4C4d(int i,int j){
      return o_C4C4d.at( i*60 +j);
   }
   int& S4S4sub(int i,int j,int k){
      return o_S4S4sub.at( i*270 +j*3 +k);
   }

public:
   Rotation_Matrix Uomg;                //rot about z(C --N --CA)
   Rotation_Matrix Uphi;                //rot about z(N --CA--C )
   Rotation_Matrix Upsi;                //rot about z(CA--C --N )
   Rotation_Matrix Ucis;                //
   Rotation_Matrix Rcis;                //R(psi)U(psi)R(omg)U(omg)R(phi) cis-pro
   Coordinates bpsi;                    //local coord (CA--C --CA)(angstrom)
   Coordinates bphi;                    //local coord (N --CA--C )(angstrom)
   Coordinates bcis;                    //cis-pro (CA--C --C )(angstrom)
   std::vector<tC4> C4;                 //peptide plane conformations
   std::vector<tG4> G4;                 //groups of conformations
   std::vector<tC6> C6;                 //oligonucleotide suite conformations

   const double& C4C4p(int i,int j) const {
      return o_C4C4p.at( i*60 +j);
   }
   const int& C4C4C7(int i,int j) const {
      return o_C4C4C7.at( i*60 +j);
   }
   const double& C4C4d(int i,int j) const {
      return o_C4C4d.at( i*60 +j);
   }
   const int& S4S4sub(int i,int j,int k) const {
      return o_S4S4sub.at( i*270 +j*3 +k);
   }

   DAT_DEFORM_PARAMS();
};

#endif
