#include "../dat/DAT_DEFORM_PARAMS.hh"
#include <string>
#include <vector>
#include <fstream>
#include <sstream>

class MEM_DAT_DEFORM_PARAMS {
private:
   std::vector<int> o_S4bit;            //
public:
   std::vector<std::string> o_Lrec;     //lines from input file
   MEM_DAT_DEFORM_PARAMS():
      o_S4bit(30)
   {
   }
   int& S4bit(int i){
      return o_S4bit.at( i);  }
   std::string& Lrec(int i){
      return o_Lrec.at( i);  }
};

DAT_DEFORM_PARAMS::DAT_DEFORM_PARAMS():
   o_C4C4p(60*60),
   o_C4C4C7(60*60),
   o_C4C4d(60*60, (0.00)),
   o_S4S4sub(90*90*3, 0),
   C4(60),
   G4(5),
   C6(46)
{
   MEM_DAT_DEFORM_PARAMS vv;
   std::string rec;
   int p;
//
//
// deform_params
//
   std::ifstream ifile("../dat/deform_params");
   while( !std::getline(ifile,rec).eof() ){
      vv.o_Lrec.push_back(rec);
   }
   ifile.close();
   p=2;
   for(int i=0;i<3;i++){
      std::istringstream(vv.Lrec(p++))>>Uomg(i,0)>>Uomg(i,1)>>Uomg(i,2);
   }
   p++;
   for(int i=0;i<3;i++){
      std::istringstream(vv.Lrec(p++))>>Uphi(i,0)>>Uphi(i,1)>>Uphi(i,2);
   }
   p++;
   for(int i=0;i<3;i++){
      std::istringstream(vv.Lrec(p++))>>Upsi(i,0)>>Upsi(i,1)>>Upsi(i,2);
   }
   p++;
   for(int i=0;i<3;i++){
      std::istringstream(vv.Lrec(p++))>>Ucis(i,0)>>Ucis(i,1)>>Ucis(i,2);
   }
   p++;
   for(int i=0;i<3;i++){
      std::istringstream(vv.Lrec(p++))>>Rcis(i,0)>>Rcis(i,1)>>Rcis(i,2);
   }
   p+=2;
   std::istringstream(vv.Lrec(p++))>>bpsi(0)>>bpsi(1)>>bpsi(2);
   p++;
   std::istringstream(vv.Lrec(p++))>>bphi(0)>>bphi(1)>>bphi(2);
   p++;
   std::istringstream(vv.Lrec(p++))>>bcis(0)>>bcis(1)>>bcis(2);
   p+=3;
   for(int iC4= 1;iC4<60;iC4++){
      std::istringstream(vv.Lrec(p++).substr( 4,15))>>C4[iC4].psi
                                                    >>C4[iC4].omg
                                                    >>C4[iC4].phi;
   }
   p+=2;
   {
      std::istringstream irec(vv.Lrec(p++));
      for(int iG4=0;iG4<5;iG4++){
         irec>>G4[iG4].mC4;
      }
   }
   p++;
   {
      std::istringstream irec(vv.Lrec(p++));
      for(int iG4=0;iG4<5;iG4++){
         irec>>G4[iG4].nC4;
      }
   }
   p+=2;
   rec.clear();
   for(int i=0;i<360;i++){
      rec+=vv.Lrec(p++).substr( 0,70);
   }
   {
      std::istringstream irec(rec);
      for(int iC4= 0;iC4<60;iC4++){
         for(int jC4= 0;jC4<60;jC4++){
            irec>>C4C4p(iC4,jC4);
         }
      }
   }
   p+=2;
   rec.clear();
   for(int i=0;i<60;i++){
      rec+=vv.Lrec(p++).substr( 0,60);
   }
   {
      std::istringstream irec(rec);
      for(int iC4= 0;iC4<60;iC4++){
         for(int jC4= 0;jC4<60;jC4++){
            irec>>C4C4C7(iC4,jC4);
         }
      }
   }
   p+=3;
   for(int iC6= 0;iC6<46;iC6++){
      C6[iC6].cnf=vv.Lrec(p  ).substr(40, 6);
      std::istringstream(vv.Lrec(p++).substr( 4,35))>>C6[iC6].de0
                                                    >>C6[iC6].eps
                                                    >>C6[iC6].zet
                                                    >>C6[iC6].alp
                                                    >>C6[iC6].bet
                                                    >>C6[iC6].gam
                                                    >>C6[iC6].del;
   }
//
//
// distance between confs
//
   for(int iC4= 1;iC4<60;iC4++){
      for(int jC4= 1;jC4<60;jC4++){
         double d0=( C4[jC4].psi -C4[iC4].psi);
         if      ( d0>( 180.00) ){
            d0-=(360.00);
         }else if( d0<(-180.00) ){
            d0+=(360.00);
         }
         double d1=( C4[jC4].omg -C4[iC4].omg);
         double d2=( C4[jC4].phi -C4[iC4].phi);
         if      ( d2>( 180.00) ){
            d2-=(360.00);
         }else if( d2<(-180.00) ){
            d2+=(360.00);
         }
         C4C4d(iC4,jC4)=( d0*d0 +d1*d1 +d2*d2);
      }
   }
//
//
// useful subsets of circular arc
//
   vv.S4bit( 0)=1;
   for(int j= 1;j<30;j++){
      vv.S4bit(j)=(vv.S4bit( 0)<<j);
   }
   for(int iS4= 0;iS4<90;iS4++){
      for(int jS4= 0;jS4<90;jS4++){
         if( iS4<=jS4 ){
            for(int pS4=iS4;pS4<=jS4;pS4++){
               int i=(pS4/30);
               int j=(pS4%30);
               S4S4sub(iS4,jS4, i)+=vv.S4bit(j);
            }
         }else{
            for(int pS4= iS4;pS4<90;pS4++){
               int i=(pS4/30);
               int j=(pS4%30);
               S4S4sub(iS4,jS4, i)+=vv.S4bit(j);
            }
            for(int pS4= 0;pS4<=jS4;pS4++){
               int i=(pS4/30);
               int j=(pS4%30);
               S4S4sub(iS4,jS4, i)+=vv.S4bit(j);
            }
         }
      }
   }
}
