#ifndef DEF_DAT_ARRAY_CONSTS
#define DEF_DAT_ARRAY_CONSTS

#include "../phi/Rotation_Matrix.hh"
#include "../phi/Rotation_Tensor.hh"

class DAT_ARRAY_CONSTS {
private:
   double o_SGN[129];                   //sign
   double o_CG[64][64][15];             //Clebsch-Gordan coeffs
   /*polynomial coeffs for spherical harmonics and derivatives wrt theta*/
   double o_SH[4][64];                  //function
   double o_dSHt[2][4][64];             //1st derivative
   double o_ddSHtt[4][4][64];           //2nd derivative
   /*coeffs of 1st derivative of rotation tensor*/
   double o_LMl[64];                    //factor for dROTq elems (M,M-1)(M-1,M)
   double o_LMu[64];                    //factor for dROTq elems (M,M+1)(M+1,M)

   /*getters for arrays with offset or compacted indexes*/
   double& SGN(int i){
      return o_SGN[i +64];
   }
   double& CG(int L1,int L2,int L,int M1,int M2){
      return o_CG[L1*L1+L1+M1][L2*L2+L2+M2][L];
   }
   double& SH(int K,int L,int M){
      return o_SH[K][L*L+L+M];
   }
   double& dSHt(int j,int K,int L,int M){
      return o_dSHt[j][K][L*L+L+M];
   }
   double& ddSHtt(int j,int K,int L,int M){
      return o_ddSHtt[j][K][L*L+L+M];
   }
   double& LMl(int L,int M){
      return o_LMl[L*L+L+M];
   }
   double& LMu(int L,int M){
      return o_LMu[L*L+L+M];
   }

public:
   double FAC[65];                      //factorial
   double TR[8][8];                     //coeffs for multipole translation
   /*P(alp)= rotation of bases by alp about x-axis
     rotatedbasis(j)=P(i,j)initialbasis(i)
     using notation * to indicate complex conjugate
     rotatedcoords(i)=P*transpose(i,j)initialcoords(j)
     Q(bet)= rotation of bases by bet about y-axis
     R(gam)= rotation of bases by gam about z-axis
     ROT=(R*transpose)(Q*transpose)(P*transpose)
     dROT[i]= derivative of ROT wrt rotation of bases about i-axis
     ddROT[i][j]= dROT[i]dROT[j]*/
   /*rotation of cartesian coordinates
     bases are coordinate axes*/
   Rotation_Matrix dROTx[3];            //1st
   Rotation_Matrix ddROTx[3][3];        //2nd
   /*rotation of multipoles
     bases are spherical harmonics
     true coordinates transform as
     rotatedmpoles(i)=P*transpose(i,j)initialmpoles(j)
     multipoles, not being true coordinates, transform as
     rotatedmpoles(i)=Ptranspose(i,j)initialmpoles(j)*/
   Rotation_Tensor dROTq[3];            //1st
   Rotation_Tensor ddROTq[3][3];        //2nd
   /**/
   double C[64][64];                    //coeffs for multipole products

   /*getters for arrays with offset or compacted indexes*/
   const double& SGN(int i) const {
      return o_SGN[i +64];
   }
   const double& CG(int L1,int L2,int L,int M1,int M2) const {
      return o_CG[L1*L1+L1+M1][L2*L2+L2+M2][L];
   }
   const double& SH(int K,int L,int M) const {
      return o_SH[K][L*L+L+M];
   }
   const double& dSHt(int j,int K,int L,int M) const {
      return o_dSHt[j][K][L*L+L+M];
   }
   const double& ddSHtt(int j,int K,int L,int M) const {
      return o_ddSHtt[j][K][L*L+L+M];
   }
   const double& SH(int K,int LM) const {
      return o_SH[K][LM];
   }
   const double& dSHt(int j,int K,int LM) const {
      return o_dSHt[j][K][LM];
   }
   const double& ddSHtt(int j,int K,int LM) const {
      return o_ddSHtt[j][K][LM];
   }
   const double& LMl(int L,int M) const {
      return o_LMl[L*L+L+M];
   }
   const double& LMu(int L,int M) const {
      return o_LMu[L*L+L+M];
   }
   const double& LMl(int j) const {
      return o_LMl[j];
   }
   const double& LMu(int j) const {
      return o_LMu[j];
   }

   DAT_ARRAY_CONSTS();
};

#endif
