#include "../dat/DAT_ARRAY_CONSTS.hh"
#include <cmath>

DAT_ARRAY_CONSTS::DAT_ARRAY_CONSTS(){
   double z, a,b,c, f,g;
//
//
//
   FAC[0]= (1.00);
   z= (0.00);
   for(int i=1;i<65;i++){
      z++;
      FAC[i]= FAC[i-1]*z;
   }
//
//
//
   SGN( 0)= (1.00);
   z= (1.00);
   for(int i=1;i<65;i++){
      z=-z;
      SGN( i)= z;
      SGN(-i)= z;
   }
//
//
//
   for(int L1=0;L1<8;L1++){
      for(int L2=0;L2<8;L2++){
         for(int M1=-L1;M1<=L1;M1++){
            for(int M2=-L2;M2<=L2;M2++){
               for(int L= 0;L<15;L++){
                  CG(L1,L2,L,M1,M2)= (0.00);
               }
            }
         }
      }
   }

   for(int L1=0;L1<8;L1++){
      for(int L2=0;L2<8;L2++){
         int Lmax=(L1+L2);
         int Lmin=( L1>=L2 )? (L1-L2): (L2-L1);
         for(int M1=-L1;M1<=L1;M1++){
            for(int M2=-L2;M2<=L2;M2++){
               int M=(M1+M2);
               for(int L=Lmin;L<=Lmax;L++){
                  if( M> L )continue;
                  if( M<-L )continue;

                  a= FAC[L+L1-L2];
                  a*=FAC[L-L1+L2];
                  a*=FAC[L1+L2-L];
                  a*=FAC[L+M1+M2];
                  a*=FAC[L-M1-M2];
                  b= FAC[L+L1+L2+1];
                  b*=FAC[L1-M1];
                  b*=FAC[L1+M1];
                  b*=FAC[L2-M2];
                  b*=FAC[L2+M2];
                  c= std::sqrt( a/b);

                  int Kmin=( (M1+M2)-(L1-L2)>0 )? (M1+M2)-(L1-L2): 0;
                  int Kmax=( L-(L1-L2)<L+(M1+M2) )? L-(L1-L2): L+(M1+M2);
                  z= (0.00);
                  for(int K=Kmin;K<=Kmax;K++){
                     f= SGN(L2+M2+K);
                     f*=std::sqrt( 2*L+1);
                     f*=FAC[L+L2+M1-K];
                     f*=FAC[L1-M1+K];
                     g= FAC[L-L1+L2-K];
                     g*=FAC[L+M1+M2-K];
                     g*=FAC[K];
                     g*=FAC[L1-L2-M1-M2+K];
                     z+=( f/g);
                  }

                  CG(L1,L2,L,M1,M2)= c*z;
               }
            }
         }
      }
   }
//
//
//
   for(int L1=0;L1<8;L1++){
      for(int L2=0;L2<8;L2++){
         int L=(L1+L2);
         z= FAC[2*L]/( FAC[2*L1]*FAC[2*L2]);
         TR[L1][L2]= SGN(L2)*std::sqrt( z);
      }
   }
//
//
//
   for(int L=0;L<8;L++){
      for(int M=-L;M<=L;M++){
         for(int K=0;K<4;K++){
            SH(K,L,M)= (0.00);
            dSHt(0,K,L,M)= (0.00);
            dSHt(1,K,L,M)= (0.00);
            ddSHtt(0,K,L,M)= (0.00);
            ddSHtt(1,K,L,M)= (0.00);
            ddSHtt(2,K,L,M)= (0.00);
            ddSHtt(3,K,L,M)= (0.00);
         }
      }
   }

   for(int L=0;L<8;L++){
      for(int M=-L;M<=L;M++){
         int MM=( M>=0 )? M:-M;
         a=( M>=0 )? SGN( M): (1.00);
         a*=std::sqrt( FAC[L-MM]/FAC[L+MM]);
         a/=std::pow(2.00,L);
         int Kmax=(L-MM)/2;
         for(int K=0;K<=Kmax;K++){
            f= SGN(K);
            f*=FAC[2*(L-K)];
            g= FAC[L-K];
            g*=FAC[K];
            g*=FAC[L-MM-2*K];
            z=( a*f/g);
            SH(K,L,M)= z;
            dSHt(0,K,L,M)= z*( MM);
            dSHt(1,K,L,M)=-z*( L-MM-2*K);
            ddSHtt(0,K,L,M)= z*( MM)*( MM-1);
            ddSHtt(1,K,L,M)=-z*( MM)*( L-MM-2*K+1);
            ddSHtt(2,K,L,M)=-z*( MM+1)*( L-MM-2*K);
            ddSHtt(3,K,L,M)= z*( L-MM-2*K)*( L-MM-2*K-1);
         }
      }
   }
//
//
//
   for(int L=0;L<8;L++){
      for(int M=-L;M<=L;M++){
         LMl(L,M)= (.50)*std::sqrt( (L+M)*(L-M+1));
         LMu(L,M)= (.50)*std::sqrt( (L+M+1)*(L-M));
      }
   }
//
//
//
   for(int i=0;i<3;i++){
      dROTx[i].zero();
      for(int j=0;j<3;j++){
         ddROTx[i][j].zero();
      }
   }

   dROTx[0](2,1)=(-1.00);
   dROTx[0](1,2)=( 1.00);
   dROTx[1](2,0)=( 1.00);
   dROTx[1](0,2)=(-1.00);
   dROTx[2](1,0)=(-1.00);
   dROTx[2](0,1)=( 1.00);

   ddROTx[0][0](1,1)=(-1.00);
   ddROTx[0][0](2,2)=(-1.00);
   ddROTx[1][0](0,1)=( 1.00);
   ddROTx[2][0](0,2)=( 1.00);
   ddROTx[0][1](1,0)=( 1.00);
   ddROTx[1][1](0,0)=(-1.00);
   ddROTx[1][1](2,2)=(-1.00);
   ddROTx[2][1](1,2)=( 1.00);
   ddROTx[0][2](2,0)=( 1.00);
   ddROTx[1][2](2,1)=( 1.00);
   ddROTx[2][2](0,0)=(-1.00);
   ddROTx[2][2](1,1)=(-1.00);
//
//
//
   for(int i=0;i<3;i++){
      dROTq[i].zero();
      for(int j=0;j<3;j++){
         ddROTq[i][j].zero();
      }
   }

   for(int L=0;L<8;L++){
      for(int M=-L;M<=L;M++){

         if( (M-1)>=-L ){
            dROTq[0].i(M  ,M-1,L)=-LMl(L,M);
            dROTq[1].r(M  ,M-1,L)= LMl(L,M);
         }
         if( (M+1)<= L ){
            dROTq[0].i(M  ,M+1,L)=-LMu(L,M);
            dROTq[1].r(M  ,M+1,L)=-LMu(L,M);
         }
         dROTq[2].i(M  ,M  ,L)=-M;

         if( (M-2)>=-L ){
            ddROTq[0][0].r(M  ,M-2,L)=-LMl(L,M  )*LMl(L,M-1);
            ddROTq[1][0].i(M  ,M-2,L)=-LMl(L,M  )*LMl(L,M-1);
            ddROTq[0][1].i(M  ,M-2,L)=-LMl(L,M  )*LMl(L,M-1);
            ddROTq[1][1].r(M  ,M-2,L)= LMl(L,M  )*LMl(L,M-1);
         }
         if( L==0 ){
            ddROTq[0][0].r(M  ,M  ,L)= (0.00);
            ddROTq[1][0].i(M  ,M  ,L)= (0.00);
            ddROTq[0][1].i(M  ,M  ,L)= (0.00);
            ddROTq[1][1].r(M  ,M  ,L)= (0.00);
         }else{
            if      ( M==-L ){
               ddROTq[0][0].r(M  ,M  ,L)=-LMu(L,M  )*LMl(L,M+1);
               ddROTq[1][0].i(M  ,M  ,L)=+LMu(L,M  )*LMl(L,M+1);
               ddROTq[0][1].i(M  ,M  ,L)=-LMu(L,M  )*LMl(L,M+1);
               ddROTq[1][1].r(M  ,M  ,L)=-LMu(L,M  )*LMl(L,M+1);
            }else if( M== L ){
               ddROTq[0][0].r(M  ,M  ,L)=-LMl(L,M  )*LMu(L,M-1);
               ddROTq[1][0].i(M  ,M  ,L)=-LMl(L,M  )*LMu(L,M-1);
               ddROTq[0][1].i(M  ,M  ,L)= LMl(L,M  )*LMu(L,M-1);
               ddROTq[1][1].r(M  ,M  ,L)=-LMl(L,M  )*LMu(L,M-1);
            }else{
               ddROTq[0][0].r(M  ,M  ,L)=-LMl(L,M  )*LMu(L,M-1)
                                         -LMu(L,M  )*LMl(L,M+1);
               ddROTq[1][0].i(M  ,M  ,L)=-LMl(L,M  )*LMu(L,M-1)
                                         +LMu(L,M  )*LMl(L,M+1);
               ddROTq[0][1].i(M  ,M  ,L)= LMl(L,M  )*LMu(L,M-1)
                                         -LMu(L,M  )*LMl(L,M+1);
               ddROTq[1][1].r(M  ,M  ,L)=-LMl(L,M  )*LMu(L,M-1)
                                         -LMu(L,M  )*LMl(L,M+1);
            }
         }
         if( (M+2)<= L ){
            ddROTq[0][0].r(M  ,M+2,L)=-LMu(L,M  )*LMu(L,M+1);
            ddROTq[1][0].i(M  ,M+2,L)= LMu(L,M  )*LMu(L,M+1);
            ddROTq[0][1].i(M  ,M+2,L)= LMu(L,M  )*LMu(L,M+1);
            ddROTq[1][1].r(M  ,M+2,L)= LMu(L,M  )*LMu(L,M+1);
         }
         if( (M-1)>=-L ){
            ddROTq[2][0].r(M  ,M-1,L)=-LMl(L,M)*(M);
            ddROTq[2][1].i(M  ,M-1,L)=-LMl(L,M)*(M);
            ddROTq[0][2].r(M  ,M-1,L)=-LMl(L,M)*(M-1);
            ddROTq[1][2].i(M  ,M-1,L)=-LMl(L,M)*(M-1);
         }
         if( (M+1)<= L ){
            ddROTq[2][0].r(M  ,M+1,L)=-LMu(L,M)*(M);
            ddROTq[2][1].i(M  ,M+1,L)= LMu(L,M)*(M);
            ddROTq[0][2].r(M  ,M+1,L)=-LMu(L,M)*(M+1);
            ddROTq[1][2].i(M  ,M+1,L)= LMu(L,M)*(M+1);
         }
         ddROTq[2][2].r(M  ,M  ,L)=-(M*M);

      }
   }
//
//
//
   for(int L1=0;L1<8;L1++){
      for(int L2=0;L2<8;L2++){
         int L=(L1+L2);
         for(int M1=-L1,j1=(L1*L1);M1<=L1;M1++,j1++){
            for(int M2=-L2,j2=(L2*L2);M2<=L2;M2++,j2++){
               C[j1][j2]= TR[L1][L2]*CG(L1,L2,L,M1,M2);
            }
         }
      }
   }

}
