#include "../con/Con_Automatic.hh"
#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <iomanip>

void Mechanical_System::CON_WRITE(Con_Automatic& aut,
                                  const DAT_PHYSICS_CONSTS& physics_consts,
                                  Output_Streams& out,
                                  Subset_Contracted_System::tM3& con,
                                  Conf_Dependent_System& dep) const {
   std::string hrule="________________________________________"
                     "________________________________________\n";
   out.FILE3<< std::fixed;

   for(int iZ0= 0;iZ0<nZ0;iZ0++){
//    out.FILE3<<hrule;
      if( out.VERBOSE&& out.SHELL ){
         out.FILE3<<"   cQ2"<<" cQ2bb"<<"   cF2"<<"   cG3"
                  <<"   cB3"<<"   cH2"<<"   cJ2"<<"   cY2"
                  <<"   cE1"<<"   cC1"<<'\n';
         out.FILE3<< std::setw( 6)<<con.Z0[iZ0].cQ2
                  << std::setw( 6)<<con.Z0[iZ0].cQ2bb
                  << std::setw( 6)<<con.Z0[iZ0].cF2
                  << std::setw( 6)<<con.Z0[iZ0].cG3
                  << std::setw( 6)<<con.Z0[iZ0].cB3
                  << std::setw( 6)<<con.Z0[iZ0].cH2
                  << std::setw( 6)<<con.Z0[iZ0].cJ2
                  << std::setw( 6)<<con.Z0[iZ0].cY2
                  << std::setw( 6)<<con.Z0[iZ0].cE1
                  << std::setw( 6)<<con.Z0[iZ0].cC1<<'\n';
      }
//
// write Q2
//
//    int mQ2=con.Z0[iZ0].Q2a;
//    int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
//    out.FILE3<<"  iQ2"<<" tor"
//             <<"  br"<<" omg"<<"  cE1"<<" cut"
//             <<"  jnt"<<" cbr"<<" bseF2"<<"  cG3"
//             <<"   G3a"<<'\n';
//    out.FILE3<< std::setw( 5)<<mQ2
//             <<"    "
//             << std::setw( 4)<<con.Q2[mQ2].br
//             << std::setw( 4)<<con.Q2[mQ2].omg
//             << std::setw( 5)<<con.Q2[mQ2].cE1
//             << std::setw( 4)<<int(aut.Q2[mQ2].cut)<<'\n';
//    if( nQ2>mQ2 ){
//       for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
//          out.FILE3<< std::setw( 5)<<iQ2
//                   <<' '<<con.Q2[iQ2].tor
//                   << std::setw( 4)<<con.Q2[iQ2].br
//                   << std::setw( 4)<<con.Q2[iQ2].omg
//                   << std::setw( 5)<<con.Q2[iQ2].cE1
//                   << std::setw( 4)<<int(aut.Q2[iQ2].cut)
//                   << std::setw( 5)<<con.Q2[iQ2].jnt
//                   << std::setw( 4)<<con.Q2[iQ2].cbr
//                   << std::setw( 6)<<con.Q2[iQ2].bseF2
//                   << std::setw( 5)<<con.Q2[iQ2].cG3
//                   << std::setw( 6)<<con.Q2[iQ2].G3a<<'\n';
//       }
//    }
//
// write B3,G3,H2
//
//    out.FILE3<<"   iB3"<<"  atm"
//             <<"  B3F2"<<"  sb"<<" cC1"<<'\n';
//    int mB3=con.Z0[iZ0].B3a;
//    int nB3=(mB3-1+con.Z0[iZ0].cB3);
//    for(int iB3=mB3;iB3<=nB3;iB3++){
//       out.FILE3<< std::setw( 6)<<iB3
//                <<' '<<con.F2[con.B3[iB3].F2].atm
//                << std::setw( 6)<<con.B3[iB3].F2
//                << std::setw( 4)<<con.B3[iB3].sb
//                << std::setw( 4)<<con.B3[iB3].cC1<<'\n';
//    }
//    int mG3=con.Z0[iZ0].G3a;
//    int nG3=(mG3-1+con.Z0[iZ0].cG3);
//    if( nG3>=mG3 ){
//       out.FILE3<<"   iG3"<<"  atm"
//                <<"  G3F2"<<"  b4"<<"  sg"<<" cC1"<<'\n';
//       for(int iG3=mG3;iG3<=nG3;iG3++){
//          out.FILE3<< std::setw( 6)<<iG3
//                   <<' '<<con.F2[con.G3[iG3].F2].atm
//                   << std::setw( 6)<<con.G3[iG3].F2
//                   << std::setw( 4)<<con.G3[iG3].b4
//                   << std::setw( 4)<<con.G3[iG3].sg
//                   << std::setw( 4)<<con.G3[iG3].cC1<<'\n';
//       }
//    }
//    int mH2=con.Z0[iZ0].H2a;
//    int nH2=(mH2-1+con.Z0[iZ0].cH2);
//    if( nH2>=mH2 ){
//       out.FILE3<<"   iH2"<<"  atm"
//                <<"  H2F2"<<"  b4"<<'\n';
//       for(int iH2=mH2;iH2<=nH2;iH2++){
//          out.FILE3<< std::setw( 6)<<iH2
//                   <<' '<<con.F2[con.H2[iH2].F2].atm
//                   << std::setw( 6)<<con.H2[iH2].F2
//                   << std::setw( 4)<<con.H2[iH2].b4<<'\n';
//       }
//    }
//
// write F2
//
//    out.FILE3<< std::setprecision(4);
//    out.FILE3<<"   iF2"<<"  atm "
//             <<"            "<<"  x "<<"            "
//             <<" typ"<<"  hb"<<"   lnk"<<"  b4"<<"  sf"
//             <<" lte"<<"  mu"<<"      "<<"      "<<"   fac"
//             <<"    sig"<<"    eta"<<'\n';
//    int mF2=con.Z0[iZ0].F2a;
//    int nF2=(mF2-1+con.Z0[iZ0].cF2);
//    for(int iF2=mF2;iF2<=nF2;iF2++){
//       out.FILE3<< std::setw( 6)<<iF2
//                <<' '<<con.F2[iF2].atm<<' ';
//       for(int i=0;i<3;i++){
//          out.FILE3<< std::setw( 9)<<dep.F2[ iF2].x(i);
//       }
//       out.FILE3<<' '<< std::setw( 4)<<con.F2[iF2].typ
//                     << std::setw( 4)<<con.F2[iF2].hb
//                     << std::setw( 6)<<con.F2[iF2].lnk
//                     << std::setw( 4)<<con.F2[iF2].b4
//                     << std::setw( 4)<<con.F2[iF2].sf
//                     << std::setw( 4)<<con.F2[iF2].lte
//                     << std::setw( 4)<<con.F2[iF2].mu;
//       for(int i=0;i<3;i++){
//          out.FILE3<< std::setw( 6)<<con.F2[ iF2].fac[i];
//       }
//       out.FILE3<< std::setw( 7)<<con.F2[iF2].gau.sig
//                << std::setw( 7)<<con.F2[iF2].gau.eta<<'\n';
//    }
//
// write E1
//
//    int mE1=con.Z0[iZ0].E1a;
//    int nE1=(mE1-1+con.Z0[iZ0].cE1);
//    if( nE1>=mE1 ){
//       out.FILE3<<"   iE1"
//                <<" sse"<<"  Z0"<<" lam"<<"   k "
//                <<"   Q3"<<"   X2"<<'\n';
//       for(int iE1=mE1;iE1<=nE1;iE1++){
//          out.FILE3<< std::setw( 6)<<iE1
//                   << std::setw( 4)<<con.E1[iE1].sse
//                   << std::setw( 4)<<con.E1[iE1].Z0
//                   << std::setw( 4)<<con.E1[iE1].lam
//                   << std::setw( 5)<<con.E1[iE1].k
//                   << std::setw( 5)<<con.E1[iE1].Q3
//                   << std::setw( 5)<<con.E1[iE1].X2<<'\n';
//       }
//    }
//
// write C1
//
//    int mC1=con.Z0[iZ0].C1a;
//    int nC1=(mC1-1+con.Z0[iZ0].cC1);
//    if( nC1>=mC1 ){
//       out.FILE3<<"  iC1"
//                <<"  Z0"<<" lam"<<"   k "<<"   F2a"
//                <<" CC"<<'\n';
//       for(int iC1=mC1;iC1<=nC1;iC1++){
//          out.FILE3<< std::setw( 5)<<iC1
//                   << std::setw( 4)<<con.C1[iC1].Z0
//                   << std::setw( 4)<<con.C1[iC1].lam
//                   << std::setw( 5)<<con.C1[iC1].k
//                   << std::setw( 6)<<con.C1[iC1].F2a
//                   << std::setw( 2)<<int(con.C1[iC1].CYCLE)<<'\n';
//       }
//    }
//
// write J2
//
//    int mJ2=con.Z0[iZ0].J2a;
//    int nJ2=(mJ2-1+con.Z0[iZ0].cJ2);
//    if( nJ2>=mJ2 ){
//       out.FILE3<<"  iJ2"<<"     "<<" N2Q2"
//                         <<"    "<<" tor"<<'\n';
//       for(int iJ2=mJ2;iJ2<=nJ2;iJ2++){
//          out.FILE3<< std::setw( 5)<<iJ2;
//          for(int iN2=0;iN2<2;iN2++){
//             out.FILE3<< std::setw( 5)<<dep.J2N2Q2(iJ2,iN2);
//          }
//          for(int iN2=0;iN2<2;iN2++){
//             out.FILE3<<' '<<con.Q2[dep.J2N2Q2(iJ2,iN2)].tor;
//          }
//          out.FILE3<<'\n';
//       }
//    }
//
// write Y2
//
//    int mY2=con.Z0[iZ0].Y2a;
//    int nY2=(mY2-1+con.Z0[iZ0].cY2);
//    if( nY2>=mY2 ){
//       out.FILE3<<"  iY2"<<"     "<<"     "<<" N3Q2"
//                         <<"    "<<"    "<<" tor"<<'\n';
//       for(int iY2=mY2;iY2<=nY2;iY2++){
//          out.FILE3<< std::setw( 5)<<iY2;
//          for(int iN3=0;iN3<3;iN3++){
//             out.FILE3<< std::setw( 5)<<dep.Y2N3Q2(iY2,iN3);
//          }
//          for(int iN3=0;iN3<3;iN3++){
//             out.FILE3<<' '<<con.Q2[dep.Y2N3Q2(iY2,iN3)].tor;
//          }
//          out.FILE3<<'\n';
//       }
//    }
//
// write Q2tu
//
//    mQ2=con.Z0[iZ0].Q2a;
//    nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
//    out.FILE3<< std::setprecision(10);
//    out.FILE3<<"  iQ2"<<" tor"<<"  "
//             <<"      chi      "<<"  "
//             <<"             "<<"      tu"<<'\n';
//    for(int i=0;i<3;i++){
//       if( i==0 ){
//          out.FILE3<< std::setw( 5)<<mQ2
//                   <<"    "<<"  "
//                   << std::setw(15)<<0.00<<"  ";
//       }else{
//          out.FILE3<<"                            ";
//       }
//       for(int j=0;j<3;j++){
//          out.FILE3<< std::setw(13)<<dep.Q2[mQ2].tu(i,j);
//       }
//       out.FILE3<<'\n';
//    }
//    if( nQ2>mQ2 ){
//       for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
//          for(int i=0;i<3;i++){
//             if( i==0 ){
//                double chi= dep.Q2[iQ2].chi/physics_consts.RAD;
//                out.FILE3<< std::setw( 5)<<iQ2
//                         <<' '<<con.Q2[iQ2].tor<<"  "
//                         << std::setw(15)<<chi<<"  ";
//             }else{
//                out.FILE3<<"                            ";
//             }
//             for(int j=0;j<3;j++){
//                out.FILE3<< std::setw(13)<<dep.Q2[ iQ2].tu(i,j);
//             }
//             out.FILE3<<'\n';
//          }
//       }
//    }
//
// write Q1,X1,U1,Q3,X2
//
//    int mQ1=Z0[iZ0].Q1a;
//    int nQ1=(mQ1-1+Z0[iZ0].cQ1);
//    out.FILE3<<"  iQ1"<<" tor"<<"   G3a"<<" cG3"
//             <<" lte"<<'\n';
//    for(int iQ1=mQ1;iQ1<=nQ1;iQ1++){
//       bool bse=(iQ1==mQ1);
//       out.FILE3<< std::setw( 5)<<iQ1
//                <<' '<<((bse)?"   ":Q1[iQ1].tor)
//                << std::setw( 6)<<con.Q1[iQ1].G3a
//                << std::setw( 4)<<con.Q1[iQ1].cG3
//                << std::setw( 4)<<con.Q1[iQ1].lte<<'\n';
//    }
//    int mX1=(mQ1+1);
//    int nX1=nQ1;
//    if( nX1>=mX1 ){
//       out.FILE3<<"  iX1"<<"   F2a"<<" cF2"<<" lte"<<'\n';
//       for(int iX1=mX1;iX1<=nX1;iX1++){
//          out.FILE3<< std::setw( 5)<<iX1
//                   << std::setw( 6)<<con.X1[iX1].F2a
//                   << std::setw( 4)<<con.X1[iX1].cF2
//                   << std::setw( 4)<<con.X1[iX1].lte<<'\n';
//       }
//    }
//    int mU1=Z0[iZ0].U1a;
//    int nU1=(mU1-1+Z0[iZ0].cU1);
//    if( nU1>=mU1 ){
//       out.FILE3<<"  iU1"<<"   H2a"<<" cH2"<<'\n';
//       for(int iU1=mU1;iU1<=nU1;iU1++){
//          out.FILE3<< std::setw( 5)<<iU1
//                   << std::setw( 6)<<con.U1[iU1].H2a
//                   << std::setw( 4)<<con.U1[iU1].cH2<<'\n';
//       }
//    }
//    int mQ3=con.Z0[iZ0].Q3a;
//    int nQ3=(mQ3-1+con.Z0[iZ0].cQ3);
//    out.FILE3<<"  iQ3"<<" lte"<<'\n';
//    for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
//       out.FILE3<< std::setw( 5)<<iQ3
//                << std::setw( 4)<<con.Q3[iQ3].lte<<'\n';
//    }
//    int mX2=con.Z0[iZ0].X2a;
//    int nX2=(mX2-1+con.Z0[iZ0].cX2);
//    if( nX2>=mX2 ){
//       out.FILE3<<"  iX2"<<" lte"<<'\n';
//       for(int iX2=mX2;iX2<=nX2;iX2++){
//          out.FILE3<< std::setw( 5)<<iX2
//                   << std::setw( 4)<<con.X2[iX2].lte<<'\n';
//       }
//    }
//
// write B6,G6
//
//    if( oB6>0 ){
//       out.FILE3<<"  iB6"<<"  Z0"<<"   R0"<<"  L0"<<'\n';
//       for(int iB6= 0;iB6<con.oB6;iB6++){
//          out.FILE3<< std::setw( 5)<<iB6
//                   << std::setw( 6)<<con.B6[iB6].Z0
//                   << std::setw( 4)<<con.B6[iB6].R0
//                   << std::setw( 4)<<con.B6[iB6].L0<<'\n';
//       }
//    }
//    if( oG6>0 ){
//       out.FILE3<<"  iG6"<<"  Z0"<<"   R0"<<"  L0"<<'\n';
//       for(int iG6= 0;iG6<con.oG6;iG6++){
//          out.FILE3<< std::setw( 5)<<iG6
//                   << std::setw( 6)<<con.G6[iG6].Z0
//                   << std::setw( 4)<<con.G6[iG6].R0
//                   << std::setw( 4)<<con.G6[iG6].L0<<'\n';
//       }
//    }
   }
// out.FILE3<<hrule;
   return;
}
