#include "../con/Con_Automatic.hh"
#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <cstdlib>
#include <cmath>

class MEM_con_q2 {
private:
   std::vector<int> o_J1J2;             //
public:
   MEM_con_q2(int o):
      o_J1J2(o,-1)
   {
   }
   int& J1J2(int i){
      return o_J1J2.at( i);  }
};

void Mechanical_System::CON_Q2(Con_Automatic& aut,
                               const DAT_ARRAY_CONSTS& array_consts,
                               const DAT_ENERGY_PARAMS& energy_params,
                               const Thread_Options& opt,
                               Subset_Contracted_System::tM3& con,
                               Conf_Dependent_System& dep){
   int oJ1=( Z0[nZ0-1].J1a +Z0[nZ0-1].cJ1);
   MEM_con_q2 vv(oJ1);
//
//
// set forward groups exclusions
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
         aut.Q2[iQ2].cut=false;
      }
      if( opt.MODE==("bb ") ){
         int iQ2min=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int iQ2=iQ2min;iQ2<=nQ2;iQ2++){
            if( con.Q2[iQ2].tor.substr(0,2)=="NU" )continue;
            aut.Q2[iQ2].cut=true;
         }
      }
   }
//
//
// populate Conf_Dependent_System, 1st pass
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ1=Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      int mQ2=con.Z0[iZ0].Q2a;
//    int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ1>mQ1 ){
         int iQ2=mQ2;
         for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
            if( con.Q1[iQ1].sub ){
               dep.Q2[++iQ2].chi= dep.Q1[iQ1].chi;
            }
         }
      }
   }
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mB1=Z0[iZ0].B1a;
      int nB1=(mB1-1+Z0[iZ0].cB1);
      for(int iB1=mB1;iB1<=nB1;iB1++){
         aut.F1[B1[iB1].F1].x=B1[iB1].x;
      }
   }
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ1=Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      for(int iQ1=mQ1;iQ1<=nQ1;iQ1++){
         aut.Q1[iQ1].tu=Q1[iQ1].tu;
      }
      int mF1=Z0[iZ0].F1a;
      int nF1=(mF1-1+Z0[iZ0].cF1);
      for(int iF1=mF1;iF1<=nF1;iF1++){
         aut.F1[iF1].q=F1[iF1].q;
         aut.F1[iF1].p=F1[iF1].p;
      }
   }
   int mGEN=0;
   int mJ2=0;
   int mY2=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ1=Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      aut.Q2[mQ2].Q1=mQ1;
      aut.Q1[mQ1].Q2=mQ2;
      if( nQ1>mQ1 ){
         int iQ2=mQ2;
         for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
            int mG1=Q1[iQ1].G1a;
            int nG1=(mG1-1+Q1[iQ1].cG1);
            if( con.Q1[iQ1].sub ){
               iQ2++;
               aut.Q2[iQ2].Q1=iQ1;
               aut.Q1[iQ1].Q2=iQ2;
               dep.Q2[iQ2].tu=Q1[iQ1].tu;
               int jQ1=Q1[iQ1].jnt;
               if( !con.Q1[jQ1].sub ){
                  dep.Q2[iQ2].tu=aut.Q1[jQ1].tu*dep.Q2[iQ2].tu;
               }
               for(int iG1=mG1;iG1<=nG1;iG1++){
                  aut.G1[iG1].b=G1[iG1].b;
                  aut.F1[G1[iG1].F1].x=G1[iG1].b;
               }
               dep.Q2[iQ2].tau=Q1[iQ1].tau;
            }else{
               aut.Q1[iQ1].tu.extend(dep.Q1[iQ1].chi);
               int jQ1=Q1[iQ1].jnt;
               if( !con.Q1[jQ1].sub ){
                  aut.Q1[iQ1].tu=aut.Q1[jQ1].tu*aut.Q1[iQ1].tu;
               }
               int jQ2=aut.Q1[jQ1].Q2;
               aut.Q1[iQ1].Q2=jQ2;
               for(int iG1=mG1;iG1<=nG1;iG1++){
                  aut.F1[G1[iG1].F1].x.generate(aut.F1[Q1[iQ1].bse].x,
                                                aut.Q1[iQ1].tu,
                                                G1[iG1].b);
               }
               if( jQ2==mQ2 ){
               }else{
                  for(int iG1=mG1;iG1<=nG1;iG1++){
                     aut.G1[iG1].b=aut.F1[G1[iG1].F1].x;
                  }
               }
               for(int iG1=mG1;iG1<=nG1;iG1++){
                  int iF1=G1[iG1].F1;
                  if( F1[iF1].lte<1 )continue;
                  aut.F1[iF1].q.rotate(array_consts,aut.Q1[iQ1].tu);
                  if( F1[iF1].lhb>0 ){
                     aut.F1[iF1].p.rotate(array_consts,aut.Q1[iQ1].tu);
                  }
               }
            }
         }
      }
      aut.Z0[iZ0].GENa=mGEN;
      if( nQ1>mQ1 ){
         int iGEN=(mGEN-1);
         int iQ1=mQ1;
         int iQ1hold=(mQ1+Z0[iZ0].cQ1bb);
         for(int icQ1=(nQ1-mQ1);icQ1>0;icQ1--){
            if( Q1[iQ1].omg==1 ){
               int L=iQ1hold;
               iQ1hold=(iQ1+1);
               iQ1=L;
            }else{
               iQ1++;
            }
            if( aut.Q1[iQ1].Q2>mQ2 ){
               aut.GEN[++iGEN].Q1=iQ1;
            }
         }
         aut.Z0[iZ0].cGEN=(iGEN-mGEN+1);
      }else{
         aut.Z0[iZ0].cGEN=0;
      }
      if( nQ2>mQ2 ){
         int iORD=-1;
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            aut.Q2[iQ2].ORD=++iORD;
         }
      }
      mGEN=aut.Z0[iZ0].GENa;
      int nGEN=(mGEN-1+aut.Z0[iZ0].cGEN);
      if( nGEN>mGEN ){
         int iGENmin=(mGEN+1);
         for(int iGENmax=nGEN;iGENmax>mGEN;iGENmax--){
            bool ORDERED=true;
            int iORD=aut.Q2[aut.Q1[aut.GEN[mGEN].Q1].Q2].ORD;
            for(int iGEN=iGENmin;iGEN<=iGENmax;iGEN++){
               int jORD=aut.Q2[aut.Q1[aut.GEN[iGEN].Q1].Q2].ORD;
               if( jORD<iORD ){
                  int L=aut.GEN[iGEN].Q1;
                  aut.GEN[iGEN].Q1=aut.GEN[iGEN-1].Q1;
                  aut.GEN[iGEN-1].Q1=L;
                  ORDERED=false;
               }else{
                  iORD=jORD;
               }
            }
            if( ORDERED )break;
         }
      }
      int iG2=(con.Z0[iZ0].G2a-1);
      if( nGEN>=mGEN ){
         for(int iGEN=mGEN;iGEN<=nGEN;iGEN++){
            int iQ1=aut.GEN[iGEN].Q1;
            int mG1=Q1[iQ1].G1a;
            int nG1=(mG1-1+Q1[iQ1].cG1);
            for(int iG1=mG1;iG1<=nG1;iG1++){
               dep.G2[++iG2].b=aut.G1[iG1].b;
            }
         }
         mGEN=(nGEN+1);
      }
      con.Z0[iZ0].J2a=mJ2;
      int mJ1=Z0[iZ0].J1a;
      int nJ1=(mJ1-1+Z0[iZ0].cJ1);
      if( nJ1>=mJ1 ){
         int iJ2=mJ2;
         for(int iJ1=mJ1;iJ1<=nJ1;iJ1++){
            vv.J1J2(iJ1)=-1;
            int iQ1=J1N2Q1(iJ1,0);
            int jQ1=J1N2Q1(iJ1,1);
            if( con.Q1[iQ1].sub ){
               int iQ2=aut.Q1[iQ1].Q2;
               if( con.Q1[jQ1].sub ){
                  int jQ2=aut.Q1[jQ1].Q2;
                  vv.J1J2(iJ1)=iJ2;
                  dep.J2N2Q2(iJ2,0)=iQ2;
                  dep.J2N2Q2(iJ2,1)=jQ2;
                  dep.J2[iJ2++].tau=J1[iJ1].tau;
               }else{
                  dep.Q2[iQ2].tau.fix2(J1[iJ1].tau,
                                       dep.Q1[jQ1].chi);
               }
            }else{
               if( con.Q1[jQ1].sub ){
                  int jQ2=aut.Q1[jQ1].Q2;
                  dep.Q2[jQ2].tau.fix1(J1[iJ1].tau,
                                       dep.Q1[iQ1].chi);
               }else{
               }
            }
         }
         con.Z0[iZ0].cJ2=(iJ2-mJ2);
         mJ2=iJ2;
      }else{
         con.Z0[iZ0].cJ2=0;
      }
      con.Z0[iZ0].Y2a=mY2;
      int mY1=Z0[iZ0].Y1a;
      int nY1=(mY1-1+Z0[iZ0].cY1);
      if( nY1>=mY1 ){
         int iY2=mY2;
         for(int iY1=mY1;iY1<=nY1;iY1++){
            int iQ1=Y1N3Q1(iY1,0);
            int jQ1=Y1N3Q1(iY1,1);
            int kQ1=Y1N3Q1(iY1,2);
            if( con.Q1[iQ1].sub ){
               int iQ2=aut.Q1[iQ1].Q2;
               if( con.Q1[jQ1].sub ){
                  int jQ2=aut.Q1[jQ1].Q2;
                  if( con.Q1[kQ1].sub ){
                     int kQ2=aut.Q1[kQ1].Q2;
                     dep.Y2N3Q2(iY2,0)=iQ2;
                     dep.Y2N3Q2(iY2,1)=jQ2;
                     dep.Y2N3Q2(iY2,2)=kQ2;
                     dep.Y2[iY2++].tau=Y1[iY1].tau;
                  }else{
                     int ijJ1=Y1N3J1(iY1,0);
                     int ijJ2=vv.J1J2(ijJ1);
                     dep.J2[ijJ2].tau.fix3(Y1[iY1].tau,
                                           dep.Q1[kQ1].chi);
                  }
               }else{
                  if( con.Q1[kQ1].sub ){
                     int ikJ1=Y1N3J1(iY1,1);
                     int ikJ2=vv.J1J2(ikJ1);
                     dep.J2[ikJ2].tau.fix2(Y1[iY1].tau,
                                           dep.Q1[jQ1].chi);
                  }else{
                     dep.Q2[iQ2].tau.fix23(Y1[iY1].tau,
                                           dep.Q1[jQ1].chi,
                                           dep.Q1[kQ1].chi);
                  }
               }
            }else{
               if( con.Q1[jQ1].sub ){
                  int jQ2=aut.Q1[jQ1].Q2;
                  if( con.Q1[kQ1].sub ){
                     int jkJ1=Y1N3J1(iY1,2);
                     int jkJ2=vv.J1J2(jkJ1);
                     dep.J2[jkJ2].tau.fix1(Y1[iY1].tau,
                                           dep.Q1[iQ1].chi);
                  }else{
                     dep.Q2[jQ2].tau.fix13(Y1[iY1].tau,
                                           dep.Q1[iQ1].chi,
                                           dep.Q1[kQ1].chi);
                  }
               }else{
                  if( con.Q1[kQ1].sub ){
                     int kQ2=aut.Q1[kQ1].Q2;
                     dep.Q2[kQ2].tau.fix12(Y1[iY1].tau,
                                           dep.Q1[iQ1].chi,
                                           dep.Q1[jQ1].chi);
                  }else{
                  }
               }
            }
         }
         con.Z0[iZ0].cY2=(iY2-mY2);
         mY2=iY2;
      }else{
         con.Z0[iZ0].cY2=0;
      }
//
//
// neutralize forward groups
//
      int nQ2bb=(mQ2-1+con.Z0[iZ0].cQ2bb);
// con.Q2[nQ2+1].jnt=mQ2
      if( nQ2>nQ2bb ){
         for(int iQ2=(nQ2bb+1);iQ2<=nQ2;iQ2++){
            if( con.Q2[iQ2+1].jnt!=iQ2 ){
               int br=con.Q2[iQ2].br;
               for(int jQ2=iQ2;con.Q2[jQ2].br==br;jQ2=con.Q2[jQ2].jnt){
                  int mG2=con.Q2[jQ2].G2a;
                  int nG2=(mG2-1+con.Q2[jQ2].cG2);
                  std::string atm='+'+F1[con.Q2[jQ2].bseF1].atm.substr(1,3);
                  int jG2=-1;
                  double z=-con.Q2[jQ2].chg*((.001)/(1.12))
                                           *std::sqrt( energy_params.fac_pp);
                  for(int iG2=mG2;iG2<=nG2;iG2++){
                     int iF1=con.G2[iG2].F1;
                     if( F1[iF1].lte<0 )continue;
                     z+=aut.F1[iF1].q.r(0,0);
                     if( F1[iF1].atm==atm )jG2=iG2;
                  }
                  if( jG2==-1 )std::exit( 2);
                  aut.F1[con.Q2[jQ2].bseF1].q.r(0,0)+=z;
                  aut.F1[con.G2[jG2].F1].q.r(0,0)-=z;
               }
            }
         }
      }
      if( nQ2bb>mQ2 ){
         for(int iQ2=nQ2bb;iQ2>mQ2;iQ2=con.Q2[iQ2].jnt){
            int mG2=con.Q2[iQ2].G2a;
            int nG2=(mG2-1+con.Q2[iQ2].cG2);
            std::string atm='+'+F1[con.Q2[iQ2].bseF1].atm.substr(1,3);
            int jG2=-1;
            double z=-con.Q2[iQ2].chg*((.001)/(1.12))
                                     *std::sqrt( energy_params.fac_pp);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               int iF1=con.G2[iG2].F1;
               if( F1[iF1].lte<0 )continue;
               z+=aut.F1[iF1].q.r(0,0);
               if( F1[iF1].atm==atm )jG2=iG2;
            }
            if( jG2==-1 )std::exit( 2);
            aut.F1[con.Q2[iQ2].bseF1].q.r(0,0)+=z;
            aut.F1[con.G2[jG2].F1].q.r(0,0)-=z;
         }
      }
//
//
// reduce full charges of ionized groups
//
      int mF1=Z0[iZ0].F1a;
      int nF1=(mF1-1+Z0[iZ0].cF1);
      for(int iF1=mF1;iF1<=nF1;iF1++){
         if( !F1[iF1].ion )continue;
         aut.F1[iF1].q.r(0,0)+=F1[iF1].off;
      }
   }
//
//
// number of minimization degrees of freedom
//
   con.oU2=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      if( con.Z0[iZ0].sub ){
         con.oU2+=6;
      }
      con.oU2+=(con.Z0[iZ0].cQ2-1);
   }
//
//
// structure torsion angles
//
   for(int iR0= 0;iR0<con.oR0;iR0++){
      con.R0[iR0].U2phi=-1;
      con.R0[iR0].U2psi=-1;
      con.R0[iR0].Q1phi=-1;
      con.R0[iR0].Q1psi=-1;
   }
   int iU2=-1;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      if( con.Z0[iZ0].sub )iU2+=6;
   }
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ1=Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      int mQ2=con.Z0[iZ0].Q2a;
//    int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ1>mQ1 ){
         int iQ2=mQ2;
         for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
            std::string tor=Q1[iQ1].tor;
            int iF1=Q1[iQ1].bse;
            int iR0=F1[iF1].R0;
            if( con.Q1[iQ1].sub ){
               iQ2++;
               iU2++;
               if      ( tor=="PHI" ){
                  con.R0[iR0].U2phi=iU2;
                  con.R0[iR0].Q1phi=iQ1;;
               }else if( tor=="PSI" ){
                  con.R0[iR0].U2psi=iU2;
                  con.R0[iR0].Q1psi=iQ1;
               }
            }else{
               if      ( tor=="PHI" ){
                  con.R0[iR0].Q1phi=iQ1;;
               }else if( tor=="PSI" ){
                  con.R0[iR0].Q1psi=iQ1;
               }
            }
         }
      }
   }
   return;
}
