#include "../con/Con_Automatic.hh"
#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>

class MEM_con_f2 {
private:
   std::vector<Coordinates> o_F1x;      //coords (bohr)
   std::vector<Multipoles> o_F1q;       //multipoles
   std::vector<Multipoles> o_F1p;       //polarizability site
public:
   MEM_con_f2(int o):
      o_F1x(o),
      o_F1q(o),
      o_F1p(o)
   {
   }
   Coordinates& F1x(int i){
      return o_F1x.at( i);  }
   Multipoles& F1q(int i){
      return o_F1q.at( i);  }
   Multipoles& F1p(int i){
      return o_F1p.at( i);  }
};

void Mechanical_System::CON_F2(Con_Automatic& aut,
                               const DAT_PHYSICS_CONSTS& physics_consts,
                               const DAT_ARRAY_CONSTS& array_consts,
                               const DAT_ENERGY_PARAMS& energy_params,
                               Output_Streams& out,
                               Subset_Contracted_System::tM3& con,
                               Conf_Dependent_System& dep){
//
// out.FILE3<<"  jZ0"<<"  jR0"<<"  atm"<<"  "
//          <<"  iZ0"<<"  iR0"<<"  atm"<<"  "
//          <<"    Fr\n";
//
   int oF1=F1.size();
   MEM_con_f2 vv(oF1);
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mF1=Z0[iZ0].F1a;
      int nF1=(mF1-1+Z0[iZ0].cF1);
      for(int iF1=mF1;iF1<=nF1;iF1++){
         vv.F1x(iF1)=aut.F1[iF1].x;
         vv.F1q(iF1)=aut.F1[iF1].q;
         vv.F1p(iF1)=aut.F1[iF1].p;
      }
   }
//
//
// initiate con.F1[].imp, aut.E0[].imp
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mF1=Z0[iZ0].F1a;
      int nF1=(mF1-1+Z0[iZ0].cF1);
      for(int iF1=mF1;iF1<=nF1;iF1++){
         con.F1[iF1].imp=0;
      }
      int mE0=con.Z0[iZ0].E0a;
      int nE0=(mE0-1+con.Z0[iZ0].cE0);
      if( nE0>=mE0 ){
         for(int iE0=mE0;iE0<=nE0;iE0++){
            aut.E0[iE0].imp=0;
         }
      }
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ2>mQ2 ){
         for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
            con.F1[con.Q2[iQ2].bseF1].imp=1;
         }
      }
      int mB2=con.Z0[iZ0].B2a;
      int nB2=(mB2-1+con.Z0[iZ0].cB2);
      for(int iB2=mB2;iB2<=nB2;iB2++){
         if( con.B2[iB2].cC1>0 )con.F1[con.B2[iB2].F1].imp=1;
      }
      int mG2=con.Z0[iZ0].G2a;
      int nG2=(mG2-1+con.Z0[iZ0].cG2);
      if( nG2>=mG2 ){
         for(int iG2=mG2;iG2<=nG2;iG2++){
            if( con.G2[iG2].cC1>0 )con.F1[con.G2[iG2].F1].imp=1;
         }
      }
      int mC1=con.Z0[iZ0].C1a;
      int nC1=(mC1-1+con.Z0[iZ0].cC1);
      if( nC1>=mC1 ){
         for(int iC1=mC1;iC1<=nC1;iC1++){
            int jF1=con.C1[iC1].F1a;
            int lam=con.C1[iC1].lam;
            if      ( lam==0 ){
               con.F1[jF1].imp=1;
            }else if( lam==1 ){
               con.F1[H1[jF1].F1].imp=1;
            }else if( lam==2 ){
               con.F1[con.G2[jF1].F1].imp=1;
            }else if( lam==3 ){
               con.F1[con.B2[jF1].F1].imp=1;
            }
         }
      }
   }
//
// calc aut.Fr, aut.Fe, aut.Fs, aut.Fh
// set con.F1[].imp, aut.E0[].imp
//
   aut.Fr= (0.00);
   aut.Fe= (0.00);
   aut.Fs= (0.00);
   aut.Fh= (0.00);
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int mE0=con.Z0[iZ0].E0a;

      aut.TRANS=dep.Z0[iZ0].trans;
      double alp= dep.Z0[iZ0].rot(0);
      double bet= dep.Z0[iZ0].rot(1);
      double gam= dep.Z0[iZ0].rot(2);
      aut.ROT=Rotation_Matrix(alp,bet,gam);

      int iQ2=mQ2;
      int mB2=con.Z0[iZ0].B2a;
      int nB2=(mB2-1+con.Z0[iZ0].cB2);
      for(int iB2=mB2;iB2<=nB2;iB2++){
         int iF1=con.B2[iB2].F1;
         Coordinates b=aut.F1[iF1].x;
         aut.F1[iF1].x.generate(aut.TRANS,aut.ROT,b);
         aut.F1[iF1].q.rotate(array_consts,aut.ROT);
         aut.F1[iF1].p.rotate(array_consts,aut.ROT);
         if( !F1[iF1].ion ){
         }else{
            aut.F1[iF1].q.r(0,0)+=( .375)*F1[iF1].off;
         }
      }
      int nE0=(mE0-1+con.Q2[iQ2].cE0);
      if( nE0>=mE0 ){
         for(int iE0=mE0;iE0<=nE0;iE0++){
            CON_BPAIR(aut,
                      physics_consts,array_consts,energy_params,
                      out,con,
                      iZ0,iQ2,mQ2,iE0);
         }
      }
      mE0=(nE0+1);

      aut.PR[ 0]=aut.ROT;
      if( nQ2>mQ2 ){
         iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int br=con.Q2[iQ2].br;
            int cbr=con.Q2[iQ2].cbr;
            aut.PR[br].extend(aut.PR[cbr],
                              dep.Q2[iQ2].tu,
                              dep.Q2[iQ2].chi);
            int mG2=con.Q2[iQ2].G2a;
            int nG2=(mG2-1+con.Q2[iQ2].cG2);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               int iF1=con.G2[iG2].F1;
               aut.F1[iF1].x.generate(aut.F1[con.Q2[iQ2].bseF1].x,
                                      aut.PR[br],
                                      dep.G2[iG2].b);
               aut.F1[iF1].q.rotate(array_consts,aut.PR[br]);
               aut.F1[iF1].p.rotate(array_consts,aut.PR[br]);
               if( !F1[iF1].ion ){
               }else{
                  aut.F1[iF1].q.r(0,0)+=( .375)*F1[iF1].off;
               }
            }
            int nE0=(mE0-1+con.Q2[iQ2].cE0);
            if( nE0>=mE0 ){
               for(int iE0=mE0;iE0<=nE0;iE0++){
                  CON_BPAIR(aut,
                            physics_consts,array_consts,energy_params,
                            out,con,
                            iZ0,iQ2,mQ2,iE0);
               }
            }
            mE0=(nE0+1);
         }
      }
   }
   aut.Fr*=physics_consts.CAL;
   aut.Fe*=physics_consts.CAL;
   aut.Fs*=physics_consts.CAL;
   aut.Fh*=physics_consts.CAL;
//
//
// complete sub-block pairs if truncated by cutoff exclusion
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
//    int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int mE0=con.Z0[iZ0].E0a;
      int nE0=(mE0-1+con.Z0[iZ0].cE0);
      int jE0=(mE0+con.Q2[mQ2].cE0);
      if( nE0>=mE0 ){
         for(int iE0=mE0;iE0<=nE0;iE0++){
            int iQ3=con.E0[iE0].Q3;
            int mQ1=con.Q3[iQ3].Q1a;
            int nQ1=(mQ1-1+con.Q3[iQ3].cQ1);
            for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
               int iQ1=con.Q1[pQ1].ord;
               int m_2=con.Q1[iQ1].G2a;
               int n_2=(m_2-1+Q1[iQ1].cG2);
               for(int i_2=m_2;i_2<=n_2;i_2++){
                  int iF1=( iE0<jE0 )? con.B2[i_2].F1: con.G2[i_2].F1;
                  if( F1[iF1].lte>=0 )con.F1[iF1].imp=1;
               }
            }
            int lam=con.E0[iE0].lam;
            if      ( lam==0 ){
               int jX1=con.E0[iE0].X2;
               int aF1=X1[jX1].F1a;
               int bF1=(aF1-1+X1[jX1].cF1);
               for(int jF1=aF1;jF1<=bF1;jF1++){
                  if( F1[jF1].lte>=0 )con.F1[jF1].imp=1;
               }

            }else if( lam==1 ){
               int jU1=con.E0[iE0].X2;
               int aH1=U1[jU1].H1a;
               int bH1=(aH1-1+U1[jU1].cH1);
               for(int jH1=aH1;jH1<=bH1;jH1++){
                  int jF1=H1[jH1].F1;
                  if( F1[jF1].lte>=0 )con.F1[jF1].imp=1;
               }

            }else if( lam==2 ){
               int jQ1=con.E0[iE0].X2;
               int aG2=con.Q1[jQ1].G2a;
               int bG2=(aG2-1+Q1[jQ1].cG2);
               for(int jG2=aG2;jG2<=bG2;jG2++){
                  int jF1=con.G2[jG2].F1;
                  if( F1[jF1].lte>=0 )con.F1[jF1].imp=1;
               }

            }else if( lam==3 ){
               int jQ1=con.E0[iE0].X2;
               int aB2=con.Q1[jQ1].G2a;
               int bB2=(aB2-1+Q1[jQ1].cG2);
               for(int jB2=aB2;jB2<=bB2;jB2++){
                  int jF1=con.B2[jB2].F1;
                  if( F1[jF1].lte>=0 )con.F1[jF1].imp=1;
               }

            }else if( lam==4 ){
               int jX2=con.E0[iE0].X2;
               int aX1=con.X2[jX2].X1a;
               int bX1=(aX1-1+con.X2[jX2].cX1);
               for(int pX1=aX1;pX1<=bX1;pX1++){
                  int jX1=con.X1[pX1].ord;
                  int aF1=X1[jX1].F1a;
                  int bF1=(aF1-1+X1[jX1].cF1);
                  for(int jF1=aF1;jF1<=bF1;jF1++){
                     if( F1[jF1].lte>=0 )con.F1[jF1].imp=1;
                  }
               }

            }else if( lam==6 ){
               int jQ3=con.E0[iE0].X2;
               int aQ1=con.Q3[jQ3].Q1a;
               int bQ1=(aQ1-1+con.Q3[jQ3].cQ1);
               for(int qQ1=aQ1;qQ1<=bQ1;qQ1++){
                  int jQ1=con.Q1[qQ1].ord;
                  int aG2=con.Q1[jQ1].G2a;
                  int bG2=(aG2-1+Q1[jQ1].cG2);
                  for(int jG2=aG2;jG2<=bG2;jG2++){
                     int jF1=con.G2[jG2].F1;
                     if( F1[jF1].lte>=0 )con.F1[jF1].imp=1;
                  }
               }

            }else if( lam==7 ){
               int jQ3=con.E0[iE0].X2;
               int aQ1=con.Q3[jQ3].Q1a;
               int bQ1=(aQ1-1+con.Q3[jQ3].cQ1);
               for(int qQ1=aQ1;qQ1<=bQ1;qQ1++){
                  int jQ1=con.Q1[qQ1].ord;
                  int aB2=con.Q1[jQ1].G2a;
                  int bB2=(aB2-1+Q1[jQ1].cG2);
                  for(int jB2=aB2;jB2<=bB2;jB2++){
                     int jF1=con.B2[jB2].F1;
                     if( F1[jF1].lte>=0 )con.F1[jF1].imp=1;
                  }
               }

            }
         }
      }
   }
//
//
// include physical atom with satellite mpoles
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ1=Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      if( nQ1>mQ1 ){
         for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
            int mG1=Q1[iQ1].G1a;
            int nG1=(mG1-1+Q1[iQ1].cG1);
            for(int iG1=mG1;iG1<=nG1;iG1++){
               int iF1=G1[iG1].F1;
               int lte=F1[iF1].lte;
               int iT2=F1[iF1].typ;
               if( (lte>=0)&&(iT2== 7)&&(con.F1[iF1].imp==1) ){
                  con.F1[Q1[iQ1].bse].imp=1;
               }
            }
         }
      }
   }
//
//
// force G2[iQ2] to be nonempty
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ2>mQ2 ){
         for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
            con.Q2[iQ2].cG3=0;
            int mG2=con.Q2[iQ2].G2a;
            int nG2=(mG2-1+con.Q2[iQ2].cG2);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               int iF1=con.G2[iG2].F1;
               if( con.F1[iF1].imp==1 )con.Q2[iQ2].cG3++;
            }
            if( con.Q2[iQ2].cG3==0 ){
               con.Q2[iQ2].cG3=1;
               con.F1[con.G2[mG2].F1].imp=1;
            }
         }
      }
   }
//
//
// no degrees of freedom implies full system in base
//
   bool RIGID=true;
   for(int iF1= 0;iF1<oF1;iF1++){
      if( con.F1[iF1].imp==1 )RIGID=false;
   }
   if( RIGID ){
      for(int iF1= 0;iF1<oF1;iF1++){
         con.F1[iF1].imp=1;
      }
   }
//
//
// contract atoms
//
   int mF2=0;
   int mB3=0;
   int mG3=0;
   int mH2=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      con.Z0[iZ0].F2a=mF2;
      con.Z0[iZ0].B3a=mB3;
      con.Z0[iZ0].G3a=mG3;
      con.Z0[iZ0].H2a=mH2;
      int iF2=(mF2-1);
      int mF1=Z0[iZ0].F1a;
      int nF1=(mF1-1+Z0[iZ0].cF1);
      for(int iF1=mF1;iF1<=nF1;iF1++){
         if( con.F1[iF1].imp==0 )continue;
         con.F2.push_back( Subset_Contracted_System::tM3::tM3F2());
         aut.F1[iF1].F2=++iF2;
         con.F2[iF2].atm=F1[iF1].atm;
         dep.F2[iF2].x=vv.F1x(iF1);
         con.F2[iF2].typ=F1[iF1].typ;
         con.F2[iF2].hb=F1[iF1].hb;
         con.F2[iF2].lnk=F1[iF1].lnk;
         con.F2[iF2].b4=con.F1[iF1].b4;
         con.F2[iF2].sf=con.F1[iF1].sf;
         con.F2[iF2].lte=F1[iF1].lte;
         dep.F2[iF2].q=vv.F1q(iF1);
         con.F2[iF2].lhb=F1[iF1].lhb;
         dep.F2[iF2].p=vv.F1p(iF1);
         con.F2[iF2].ion= F1[iF1].ion;
         con.F2[iF2].off= F1[iF1].off;
         con.F2[iF2].gau=F1[iF1].gau;
         con.F2[iF2].mu=F1[iF1].mu;
         for(int i=0;i<3;i++){
            con.F2[iF2].fac[i]=F1[iF1].fac[i];
         }
         if( F1[iF1].typ==30 ){
            con.F2[iF2].wjnt=F1[iF1].wjnt;
            con.F2[iF2].u=F1[iF1].u;
         }
         for(int i=0;i<4;i++){
            con.F2[iF2].ef[i]=F1[iF1].ef[i];
         }
         con.F2[iF2].zet=F1[iF1].zet;
         con.F2[iF2].vf=F1[iF1].vf;
         con.F2[iF2].kap=F1[iF1].kap;
         con.F2[iF2].R0=F1[iF1].R0;
      }
      for(int jF2=mF2;jF2<=iF2;jF2++){
         for(int i=0;i<3;i++){
            int fac=con.F2[jF2].fac[i];
            if( fac>-1 ){
               con.F2[jF2].fac[i]=aut.F1[fac].F2;
            }
         }
         int lnk=con.F2[jF2].lnk;
         if( lnk>-1 ){
            con.F2[jF2].lnk=aut.F1[lnk].F2;
         }
      }
      int iB3=(mB3-1);
      int mB2=con.Z0[iZ0].B2a;
      int nB2=(mB2-1+con.Z0[iZ0].cB2);
      for(int iB2=mB2;iB2<=nB2;iB2++){
         if( con.F1[con.B2[iB2].F1].imp==0 )continue;
         con.B3.push_back( Subset_Contracted_System::tM3::tM3B3());
         aut.B2[iB2].B3=++iB3;
         con.B3[iB3].F2=aut.F1[con.B2[iB2].F1].F2;
         con.B3[iB3].sb=con.B2[iB2].sb;
         con.B3[iB3].cC1=con.B2[iB2].cC1;
      }
      int iG3=(mG3-1);
      int mG2=con.Z0[iZ0].G2a;
      int nG2=(mG2-1+con.Z0[iZ0].cG2);
      if( nG2>=mG2 ){
         for(int iG2=mG2;iG2<=nG2;iG2++){
            if( con.F1[con.G2[iG2].F1].imp==0 )continue;
            con.G3.push_back( Subset_Contracted_System::tM3::tM3G3());
            aut.G2[iG2].G3=++iG3;
            con.G3[iG3].F2=aut.F1[con.G2[iG2].F1].F2;
            con.G3[iG3].b4=con.G2[iG2].b4;
            con.G3[iG3].sg=con.G2[iG2].sg;
            con.G3[iG3].cC1=con.G2[iG2].cC1;
            dep.G3[iG3].b=dep.G2[iG2].b;
         }
      }
      int iH2=(mH2-1);
      int mH1=Z0[iZ0].H1a;
      int nH1=(mH1-1+Z0[iZ0].cH1);
      if( nH1>=mH1 ){
         for(int iH1=mH1;iH1<=nH1;iH1++){
            if( con.F1[H1[iH1].F1].imp==0 )continue;
            con.H2.push_back( Subset_Contracted_System::tM3::tM3H2());
            aut.H1[iH1].H2=++iH2;
            con.H2[iH2].F2=aut.F1[H1[iH1].F1].F2;
            con.H2[iH2].b4=con.H1[iH1].b4;
         }
      }
      con.Z0[iZ0].cF2=(iF2-mF2+1);
      con.Z0[iZ0].cB3=(iB3-mB3+1);
      con.Z0[iZ0].cG3=(iG3-mG3+1);
      con.Z0[iZ0].cH2=(iH2-mH2+1);
      mF2+=con.Z0[iZ0].cF2;
      mB3+=con.Z0[iZ0].cB3;
      mG3+=con.Z0[iZ0].cG3;
      mH2+=con.Z0[iZ0].cH2;
   }
   con.oF2=con.F2.size();
   con.oB3=con.B3.size();
   con.oG3=con.G3.size();
   con.oH2=con.H2.size();
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ1=Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+Z0[iZ0].cQ1);
      int mX1=(mQ1+1);
      int nX1=nQ1;
      int mU1=Z0[iZ0].U1a;
      int nU1=(mU1-1+Z0[iZ0].cU1);
      for(int iQ1=mQ1;iQ1<=nQ1;iQ1++){
         int jQ1=aut.Q2[aut.Q1[iQ1].Q2].Q1;
         con.Q1[iQ1].G3a=-1;
         con.Q1[iQ1].cG3=0;
         if( jQ1>mQ1 ){
            int mG2=con.Q1[iQ1].G2a;
            int nG2=(mG2-1+Q1[iQ1].cG2);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               int iF1=con.G2[iG2].F1;
               if( con.F1[iF1].imp==0 )continue;
               con.Q1[iQ1].cG3++;
               if( con.Q1[iQ1].G3a==-1 )con.Q1[iQ1].G3a=aut.G2[iG2].G3;
            }
         }else{
            int mB2=con.Q1[iQ1].G2a;
            int nB2=(mB2-1+Q1[iQ1].cG2);
            for(int iB2=mB2;iB2<=nB2;iB2++){
               int iF1=con.B2[iB2].F1;
               if( con.F1[iF1].imp==0 )continue;
               con.Q1[iQ1].cG3++;
               if( con.Q1[iQ1].G3a==-1 )con.Q1[iQ1].G3a=aut.B2[iB2].B3;
            }
         }
      }
      if( nX1>=mX1 ){
         for(int iX1=mX1;iX1<=nX1;iX1++){
            con.X1[iX1].F2a=-1;
            con.X1[iX1].cF2=0;
            int mF1=X1[iX1].F1a;
            int nF1=(mF1-1+X1[iX1].cF1);
            for(int iF1=mF1;iF1<=nF1;iF1++){
               if( con.F1[iF1].imp==0 )continue;
               con.X1[iX1].cF2++;
               if( con.X1[iX1].F2a==-1 )con.X1[iX1].F2a=aut.F1[iF1].F2;
            }
         }
      }
      if( nU1>=mU1 ){
         for(int iU1=mU1;iU1<=nU1;iU1++){
            con.U1[iU1].H2a=-1;
            con.U1[iU1].cH2=0;
            int mH1=U1[iU1].H1a;
            int nH1=(mH1-1+U1[iU1].cH1);
            for(int iH1=mH1;iH1<=nH1;iH1++){
               int iF1=H1[iH1].F1;
               if( con.F1[iF1].imp==0 )continue;
               con.U1[iU1].cH2++;
               if( con.U1[iU1].H2a==-1 )con.U1[iU1].H2a=aut.H1[iH1].H2;
            }
         }
      }
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ2>mQ2 ){
         int iG3=con.Z0[iZ0].G3a;
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            con.Q2[iQ2].bseF2=aut.F1[con.Q2[iQ2].bseF1].F2;
            con.Q2[iQ2].G3a=iG3;
            iG3+=con.Q2[iQ2].cG3;
         }
      }
   }
//
//
// initiate deformation screen
//
   con.oB6=0;
   con.oG6=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2bb=(mQ2-1+con.Z0[iZ0].cQ2bb);
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         int mF1=R0[iR0].F1a;
         int nF1=(mF1-1+R0[iR0].cF1);
         for(int iF1=mF1;iF1<=nF1;iF1++){
            if( con.F1[iF1].imp==0 )continue;
            int iF2=aut.F1[iF1].F2;
            std::string atm=F1[iF1].atm;
            if      ( c1=='a' ){
               if( atm==" N  " )con.R0N6F2(iR0, 0)=iF2;
               if( atm==" CA " )con.R0N6F2(iR0, 1)=iF2;
               if( atm==" C  " )con.R0N6F2(iR0, 2)=iF2;
               if( atm==" H  " )con.R0N6F2(iR0, 3)=iF2;
               if( atm==" CB " )con.R0N6F2(iR0, 4)=iF2;
               if( atm==" O  " )con.R0N6F2(iR0, 5)=iF2;
            }else if( c1=='e' ){
            }else if( c1=='r' ){
               if( atm==" C5'" )con.R0N6F2(iR0, 0)=iF2;
               if( atm==" C4'" )con.R0N6F2(iR0, 1)=iF2;
               if( atm==" C3'" )con.R0N6F2(iR0, 2)=iF2;
               if( atm==" O4'" )con.R0N6F2(iR0, 4)=iF2;
               if( atm==" C2'" )con.R0N6F2(iR0, 5)=iF2;
            }else if( c1=='b' ){
               if      ( (aa=="A   ")||(aa=="AP  ")||(aa=="G   ")||
                         (aa=="GP  ")||(aa=="GM  ") ){
                  if( atm==" C2 " )con.R0N6F2(iR0, 0)=iF2;
                  if( atm==" N1 " )con.R0N6F2(iR0, 1)=iF2;
                  if( atm==" C6 " )con.R0N6F2(iR0, 2)=iF2;
               }else if( (aa=="T   ")||(aa=="TM  ")||(aa=="C   ")||
                         (aa=="CP  ")||(aa=="U   ")||(aa=="UM  ") ){
                  if( atm==" C2 " )con.R0N6F2(iR0, 0)=iF2;
                  if( atm==" N3 " )con.R0N6F2(iR0, 1)=iF2;
                  if( atm==" C4 " )con.R0N6F2(iR0, 2)=iF2;
               }
            }else if( c1=='p' ){
               if      ( (aa=="PO  ")||(aa=="PSR ")||(aa=="PSS ") ){
                  if( atm==" O3'" )con.R0N6F2(iR0, 0)=iF2;
                  if( atm==" P  " )con.R0N6F2(iR0, 1)=iF2;
                  if( atm==" O5'" )con.R0N6F2(iR0, 2)=iF2;
                  if( atm==" O1P" )con.R0N6F2(iR0, 4)=iF2;
               }else if( aa=="5PO " ){
                  if( atm==" O1P" )con.R0N6F2(iR0, 0)=iF2;
                  if( atm==" P  " )con.R0N6F2(iR0, 1)=iF2;
                  if( atm==" O5'" )con.R0N6F2(iR0, 2)=iF2;
               }else if( aa=="3PO " ){
                  if( atm==" O3'" )con.R0N6F2(iR0, 0)=iF2;
                  if( atm==" P  " )con.R0N6F2(iR0, 1)=iF2;
                  if( atm==" O1P" )con.R0N6F2(iR0, 2)=iF2;
               }
            }else if( c1=='s' ){
            }
         }
         if( con.R0N6F2(iR0, 0)==-1 )continue;
         if( con.R0N6F2(iR0, 1)==-1 )continue;
         if( con.R0N6F2(iR0, 2)==-1 )continue;
         bool GENERATED=false;
         for(int iQ2=(mQ2+1);iQ2<=nQ2bb;iQ2++){
            if( F1[con.Q2[iQ2].bseF1].R0==iR0 )GENERATED=true;
         }
         if( GENERATED ){
            con.G6.push_back( Subset_Contracted_System::tM3::tM3G6());
            for(int i=0;i<3;i++){
               con.o_G6N3F2.push_back(-1);
            }
            con.G6[con.oG6].Z0=iZ0;
            con.G6[con.oG6].R0=iR0;
            con.G6[con.oG6].L0=R0[iR0].L0;
            for(int iN3=0;iN3<3;iN3++){
               con.G6N3F2(con.oG6,iN3)=con.R0N6F2(iR0,iN3);
            }
            con.oG6++;
         }else{
            con.B6.push_back( Subset_Contracted_System::tM3::tM3B6());
            for(int i=0;i<3;i++){
               con.o_B6N3F2.push_back(-1);
            }
            con.B6[con.oB6].Z0=iZ0;
            con.B6[con.oB6].R0=iR0;
            con.B6[con.oB6].L0=R0[iR0].L0;
            for(int iN3=0;iN3<3;iN3++){
               con.B6N3F2(con.oB6,iN3)=con.R0N6F2(iR0,iN3);
            }
            con.oB6++;
         }
      }
   }
//
//
// number of physical atoms
//
   con.oA5=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mF2=con.Z0[iZ0].F2a;
      int nF2=(mF2-1+con.Z0[iZ0].cF2);
      for(int iF2=mF2;iF2<=nF2;iF2++){
         dep.F2[iF2].bur=false;
         if( con.F2[iF2].lte<0 )continue;
         if( con.F2[iF2].typ>17 )continue;
         con.oA5++;
      }
   }
   return;
}
