#include "../con/Con_Automatic.hh"
#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Gaussian_Volume.hh"
//#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <iostream>
//#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_con_f {
public:
   class tG5G5G5 { /*bins of a 3D grid*/
   public:
      int i;                    //start index into set of dots
      int n;                    //number of dots in bin
      tG5G5G5():i(-1),n( 0){}
   };
   class tR0R0 { /*peptide-peptide H-bond, H-->O*/
   public:
      double e;                 //interaction energy
      double R;                 //H-bond length (angstrom)
      bool a;                   //R below 2.4 ang
      bool b;                   //R below threshold
      bool o;                   //R below overlap
      double C;                 //chains of peptide plane alignment
      double B;                 //patterns of H-bonds in helices or sheets
      double D;                 //chg mod by adjacent peptide planes
      tR0R0():
         e( 0.00),
         R( 0.00),
         a(false),
         b(false),
         o(false),
         C( 0.00),
         B( 0.00),
         D( 0.00)
      {}
   };
   class tF1F1 { /*other H-bond, H-->O*/
   public:
      int iF1;                  //1st index of atom pair
      int jF1;                  //2nd index
      double e;                 //interaction energy
      double R;                 //H-bond length
      bool a;                   //R below 2.4 ang
      bool b;                   //R below threshold
      bool o;                   //R below overlap
      double C;                 //chains of peptide plane alignment
      double B;                 //patterns of H-bonds in helices or sheets
      double D;                 //chg mod by adjacent peptide planes
      tF1F1():
         e( 0.00),
         R( 0.00),
         a(false),
         b(false),
         o(false),
         C( 0.00),
         B( 0.00),
         D( 0.00)
      {}
   };
private:
   std::vector<tG5G5G5> o_G5G5G5;       //3D grid
   std::vector<int> o_DOTF1;            //index of atom
   std::vector<int> o_DOTG5;            //mapping to bin of 3D grid
   std::vector<int> o_DOTord;           //mapping order to dot index
   std::vector<int> o_DOTinv;           //mapping dot index to order
   int oR0;                             //
   std::vector<tR0R0> o_R0R0;           //peptide-peptide H-bond, H-->O
public:
   int oF1F1;                           //
   std::vector<tF1F1> o_F1F1;           //other H-bond, H-->O
   MEM_con_f(int o,int r):
      o_G5G5G5(35937),
      o_DOTF1(o),
      o_DOTG5(o),
      o_DOTord(o),
      o_DOTinv(o),
      oR0(r),
      o_R0R0(r*r)
   {
   }
   tG5G5G5& G5G5G5(int x,int y,int z){
      return o_G5G5G5.at( 1089*(x+16) +33*(y+16) +(z+16));  }
   tG5G5G5& G5G5G5(int j){
      return o_G5G5G5.at(j);  }
   int& DOTF1(int i){
      return o_DOTF1.at( i);  }
   int& DOTG5(int i){
      return o_DOTG5.at( i);  }
   int& DOTord(int i){
      return o_DOTord.at( i);  }
   int& DOTinv(int i){
      return o_DOTinv.at( i);  }
   tR0R0& R0R0(int i,int j){
      return o_R0R0.at( i*oR0 +j);  }
   tF1F1& F1F1(int i){
      return o_F1F1.at( i);  }
};

void Mechanical_System::CON_F(Con_Automatic& aut,
                              const DAT_PHYSICS_CONSTS& physics_consts,
                              const DAT_ARRAY_CONSTS& array_consts,
                              const DAT_ENERGY_PARAMS& energy_params,
                              const DAT_REGION_MAPS& region_maps,
                              const Thread_Options& opt,
                              Output_Streams& out,
                              Subset_Contracted_System::tM3& con,
                              Conf_Dependent_System& dep){
   int oF1=F1.size();
   int oR0=R0.size();
   MEM_con_f vv(oF1,oR0);
//
//
// calc Ft
//
   double Ft= (0.00);
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ2=(con.Z0[iZ0].Q2a+1);
      int nQ2=(mQ2-2+con.Z0[iZ0].cQ2);
      if( nQ2>=mQ2 ){
         for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
            if( aut.Q2[iQ2].cut )continue;
            Ft+=dep.Q2[iQ2].tau.f(dep.Q2[iQ2].chi);
         }
      }
      int mJ2=con.Z0[iZ0].J2a;
      int nJ2=(mJ2-1+con.Z0[iZ0].cJ2);
      if( nJ2>=mJ2 ){
         for(int iJ2=mJ2;iJ2<=nJ2;iJ2++){
            int iQ2=dep.J2N2Q2(iJ2,0);
            int jQ2=dep.J2N2Q2(iJ2,1);
            if( aut.Q2[iQ2].cut||
                aut.Q2[jQ2].cut )continue;
            Ft+=dep.J2[iJ2].tau.f(dep.Q2[iQ2].chi,
                                  dep.Q2[jQ2].chi);
         }
      }
      int mY2=con.Z0[iZ0].Y2a;
      int nY2=(mY2-1+con.Z0[iZ0].cY2);
      if( nY2>=mY2 ){
         for(int iY2=mY2;iY2<=nY2;iY2++){
            int iQ2=dep.Y2N3Q2(iY2,0);
            int jQ2=dep.Y2N3Q2(iY2,1);
            int kQ2=dep.Y2N3Q2(iY2,2);
            if( aut.Q2[iQ2].cut||
                aut.Q2[jQ2].cut||
                aut.Q2[kQ2].cut )continue;
            Ft+=dep.Y2[iY2].tau.f(dep.Q2[iQ2].chi,
                                  dep.Q2[jQ2].chi,
                                  dep.Q2[kQ2].chi);
         }
      }
   }
   Ft*=physics_consts.CAL;
//
//
// calc Fc, Fb
//
   double Fc= (0.00);
   double Fb= (0.00);
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mC1=con.Z0[iZ0].C1a;
      int nC1=(mC1-1+con.Z0[iZ0].cC1);
      if( nC1<mC1 )continue;
      int mB2=con.Z0[iZ0].B2a;
      int nB2=(mB2-1+con.Z0[iZ0].cB2);
      for(int iB2=mB2;iB2<=nB2;iB2++){
         nC1=(mC1-1+con.B2[iB2].cC1);
         if( nC1<mC1 )continue;
         int iF1=con.B2[iB2].F1;
         for(int iC1=mC1;iC1<=nC1;iC1++){
//          int jZ0=con.C1[iC1].Z0;
            int lam=con.C1[iC1].lam;
            int jF1=con.C1[iC1].F1a;
            if      ( lam==0 ){
            }else if( lam==1 ){
               jF1=H1[jF1].F1;
            }else if( lam==2 ){
               jF1=con.G2[jF1].F1;
            }else if( lam==3 ){
               jF1=con.B2[jF1].F1;
            }
            Coordinates D=( aut.F1[iF1].x -aut.F1[jF1].x);
            double R= D.r();
            double r0= con.C1[iC1].d0;
            if( con.C1[iC1].CYCLE ){
               double a0= con.C1[iC1].a0;
               Fb+=a0*std::pow(( R -r0),2);
            }else{
//             int iW0=con.C1[iC1].W0;
               int iW0=opt.iW0_active;
               double a0= energy_params.W0a(iW0);
               Fc+=a0*std::pow(( R -r0),2);
            }
         }
         mC1+=con.B2[iB2].cC1;
      }
      int mG2=con.Z0[iZ0].G2a;
      int nG2=(mG2-1+con.Z0[iZ0].cG2);
      if( nG2>=mG2 ){
         for(int iG2=mG2;iG2<=nG2;iG2++){
            nC1=(mC1-1+con.G2[iG2].cC1);
            if( nC1<mC1 )continue;
            int iF1=con.G2[iG2].F1;
            for(int iC1=mC1;iC1<=nC1;iC1++){
//             int jZ0=con.C1[iC1].Z0;
               int lam=con.C1[iC1].lam;
               int jF1=con.C1[iC1].F1a;
               if      ( lam==0 ){
               }else if( lam==1 ){
                  jF1=H1[jF1].F1;
               }else if( lam==2 ){
                  jF1=con.G2[jF1].F1;
               }else if( lam==3 ){
                  jF1=con.B2[jF1].F1;
               }
               Coordinates D=( aut.F1[iF1].x -aut.F1[jF1].x);
               double R= D.r();
               double r0= con.C1[iC1].d0;
               if( con.C1[iC1].CYCLE ){
                  double a0= con.C1[iC1].a0;
                  Fb+=a0*std::pow(( R -r0),2);
               }else{
//                int iW0=con.C1[iC1].W0;
                  int iW0=opt.iW0_active;
                  double a0= energy_params.W0a(iW0);
                  Fc+=a0*std::pow(( R -r0),2);
               }
            }
            mC1+=con.G2[iG2].cC1;
         }
      }
   }
   Fc*=physics_consts.CAL;
   Fb*=physics_consts.CAL;
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ") )return;
//
//
// calc aut.F1[].v
//
   int oDOT=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int mB2=con.Z0[iZ0].B2a;
      int nB2=(mB2-1+con.Z0[iZ0].cB2);
      for(int iB2=mB2;iB2<=nB2;iB2++){
         int iF1=con.B2[iB2].F1;
         if( F1[iF1].mu!=1 )continue;
         vv.DOTF1(oDOT++)=iF1;
      }
      if( nQ2>mQ2 ){
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            if( aut.Q2[iQ2].cut )continue;
            int mG2=con.Q2[iQ2].G2a;
            int nG2=(mG2-1+con.Q2[iQ2].cG2);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               int iF1=con.G2[iG2].F1;
               if( F1[iF1].mu!=1 )continue;
               vv.DOTF1(oDOT++)=iF1;
            }
         }
      }
   }
   Coordinates xMIN;            //min value of dot coords
   Coordinates xMAX;            //max value of dot coords
   Coordinates xMID;            //mid value of dot coords
   Coordinates xDEL;            //bin size of grid
   for(int i=0;i<3;i++){
      xMIN(i)=( 1.00e+6);
      xMAX(i)=(-1.00e+6);
      for(int iDOT= 0;iDOT<oDOT;iDOT++){
         int iF1=vv.DOTF1(iDOT);
         if( aut.F1[iF1].x(i)<xMIN(i) )xMIN(i)= aut.F1[iF1].x(i);
         if( aut.F1[iF1].x(i)>xMAX(i) )xMAX(i)= aut.F1[iF1].x(i);
      }
      xMID(i)=( xMIN(i) +xMAX(i))/(2.00);
      xDEL(i)=( xMAX(i) -xMIN(i) +(.02))/(33.00);
      if( xDEL(i)<((4.00)/physics_consts.ANG) ){
         xDEL(i)= ((4.00)/physics_consts.ANG);
      }
   }
   for(int iDOT= 0;iDOT<oDOT;iDOT++){
      int iF1=vv.DOTF1(iDOT);
      int iG5[3];
      for(int i=0;i<3;i++){
         double z=( aut.F1[iF1].x(i) -xMID(i))/xDEL(i);
         iG5[i]=int( std::floor( (.50) +z));
      }
      vv.DOTG5(iDOT)= 1089*(iG5[0]+16)
                       +33*(iG5[1]+16)
                          +(iG5[2]+16);
   }
   for(int iDOT= 0;iDOT<oDOT;iDOT++){
      int i=vv.DOTG5(iDOT);
      vv.G5G5G5(i).n++;
   }
   {
      int iDOT=0;
      for(int i= 0;i<35937;i++){
         if( vv.G5G5G5(i).n==0 )continue;
         vv.G5G5G5(i).i=iDOT;
         iDOT+=vv.G5G5G5(i).n;
      }
   }
   for(int iDOT= 0;iDOT<oDOT;iDOT++){
      int i=vv.DOTG5(iDOT);
      vv.DOTord(vv.G5G5G5(i).i++)=iDOT;
   }
   for(int i= 0;i<35937;i++){
      if( vv.G5G5G5(i).n==0 )continue;
      vv.G5G5G5(i).i-=vv.G5G5G5(i).n;
   }
   for(int iDOT= 0;iDOT<oDOT;iDOT++){
      vv.DOTinv(vv.DOTord(iDOT))=iDOT;
   }
   for(int iDOT= 0;iDOT<oDOT;iDOT++){
      int jDOT=vv.DOTord(iDOT);
      int kDOT=vv.DOTinv(iDOT);
      int L=vv.DOTF1(iDOT);
      vv.DOTF1(iDOT)=vv.DOTF1(jDOT);
      vv.DOTF1(jDOT)=L;
      L=vv.DOTG5(iDOT);
      vv.DOTG5(iDOT)=vv.DOTG5(jDOT);
      vv.DOTG5(jDOT)=L;
      vv.DOTord(iDOT)=iDOT;
      vv.DOTinv(iDOT)=iDOT;
      vv.DOTord(kDOT)=jDOT;
      vv.DOTinv(jDOT)=kDOT;
   }
   for(int aG5=-16;aG5<= 16;aG5++){
      int iG5min=(aG5-2);
      int iG5max=(aG5+2);
      if( iG5min<-16 )iG5min=-16;
      if( iG5max> 16 )iG5max= 16;
      for(int bG5=-16;bG5<= 16;bG5++){
         int jG5min=(bG5-2);
         int jG5max=(bG5+2);
         if( jG5min<-16 )jG5min=-16;
         if( jG5max> 16 )jG5max= 16;
         for(int cG5=-16;cG5<= 16;cG5++){
            int kG5min=(cG5-2);
            int kG5max=(cG5+2);
            if( kG5min<-16 )kG5min=-16;
            if( kG5max> 16 )kG5max= 16;
            int i=( 1089*(aG5+16) +33*(bG5+16) +(cG5+16));
            if( vv.G5G5G5(i).n==0 )continue;
            int iDOTmin=vv.G5G5G5(i).i;
            int iDOTmax=(iDOTmin-1+vv.G5G5G5(i).n);
            for(int iDOT=iDOTmin;iDOT<=iDOTmax;iDOT++){
               int iF1=vv.DOTF1(iDOT);
               if( F1[iF1].typ!=30 )continue;
               aut.F1[iF1].v= (0.00);
               for(int iG5=iG5min;iG5<=iG5max;iG5++){
                  for(int jG5=jG5min;jG5<=jG5max;jG5++){
                     for(int kG5=kG5min;kG5<=kG5max;kG5++){
                        int j=( 1089*(iG5+16) +33*(jG5+16) +(kG5+16));
                        if( vv.G5G5G5(j).n==0 )continue;
                        int jDOTmin=vv.G5G5G5(j).i;
                        int jDOTmax=(jDOTmin-1+vv.G5G5G5(j).n);
                        for(int jDOT=jDOTmin;jDOT<=jDOTmax;jDOT++){
                           int jF1=vv.DOTF1(jDOT);
                           if( F1[jF1].typ==30 )continue;
                           double RR=( aut.F1[jF1].x -aut.F1[iF1].x).rr();
                           double v= pairf(physics_consts,
                                           F1[iF1].gau,F1[jF1].gau,
                                           RR);
                           aut.F1[iF1].v+=v;
                        }
                     }
                  }
               }
            }
         }
      }
   }
//
//
// calc Fw
//
   double Fw= (0.00);
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int mB2=con.Z0[iZ0].B2a;
      int nB2=(mB2-1+con.Z0[iZ0].cB2);
      for(int iB2=mB2;iB2<=nB2;iB2++){
         int iF1=con.B2[iB2].F1;
         if( F1[iF1].typ!=30 )continue;
         double x=( F1[iF1].u(1)*aut.F1[iF1].v -F1[iF1].u(2));
         double f= F1[iF1].u(0)*( (-1.00) +std::tanh( x));
         Fw+=f;
      }
      if( nQ2>mQ2 ){
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            if( aut.Q2[iQ2].cut )continue;
            int mG2=con.Q2[iQ2].G2a;
            int nG2=(mG2-1+con.Q2[iQ2].cG2);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               int iF1=con.G2[iG2].F1;
               if( F1[iF1].typ!=30 )continue;
               double x=( F1[iF1].u(1)*aut.F1[iF1].v -F1[iF1].u(2));
               double f= F1[iF1].u(0)*( (-1.00) +std::tanh( x));
               Fw+=f;
            }
         }
      }
   }
   Fw*=physics_consts.CAL;
//
//
// reduction of full chg elec field by dielec medium
//
   Gaussian_Volume vf;
   {
      double z= physics_consts.ANG*physics_consts.ANG;
      vf.sig=(  2.5191);
      vf.eta=(  0.7745)*z;
   }
   for(int iF1= 0;iF1<oF1;iF1++){
      aut.F1[iF1].fq= (1.00);
      if( F1[iF1].zet==0 )continue;
      double RRij=( 0.00);
      double e2=(  0.00);
      for(int i=0;i<4;i++){
         for(int j=0;j<4;j++){
            e2+=eef(physics_consts,
                    F1[iF1].ef[i],
                    F1[iF1].ef[j],
                    RRij);
         }
      }
      double e3=(  0.00);
      for(int kF1= 0;kF1<oF1;kF1++){
         int kT2=F1[kF1].typ;
         if( (kT2< 8)||(kT2>17) )continue;
         if( F1[kF1].mu!=1 )continue;
         double RRik=( aut.F1[iF1].x -aut.F1[kF1].x).rr();
         double RRjk= RRik;
         for(int i=0;i<4;i++){
            for(int j=0;j<4;j++){
               e3+=eevf(physics_consts,
                        F1[iF1].ef[i],
                        F1[iF1].ef[j],
                        vf,
                        RRij,
                        RRik,
                        RRjk);
            }
         }
      }
      if( e3> e2 )e3= e2;
      double x= (e3/e2);
      double b= std::exp( (1.50)*std::log( ( .375)));
      double a=( (1.00) -b);
      aut.F1[iF1].fq=( a*x +b);
   }
//
//
// calc gaussian approx of Fm
//
   double fac_m2= (  .000);
   double fac_m3= (  .375);
   double Fp_e= (0.00);
   for(int iF1= 0;iF1<oF1;iF1++){
      if( F1[iF1].zet==0 )continue;
      for(int jF1=iF1;jF1<oF1;jF1++){
         if( F1[jF1].zet==0 )continue;
         double z=(( jF1==iF1 )? (1.00): (2.00))
                 *aut.F1[iF1].fq*aut.F1[jF1].fq;
         double RRij=( aut.F1[iF1].x -aut.F1[jF1].x).rr();
         double ee= (0.00);
         for(int i=0;i<4;i++){
            for(int j=0;j<4;j++){
               ee+=eef(physics_consts,
                       F1[iF1].ef[i],
                       F1[jF1].ef[j],
                       RRij);
            }
         }
         Fp_e+=(fac_m2*z*ee);
         for(int kF1= 0;kF1<oF1;kF1++){
            if( F1[kF1].kap==0 )continue;
            double RRik=( aut.F1[iF1].x -aut.F1[kF1].x).rr();
            double RRjk=( aut.F1[jF1].x -aut.F1[kF1].x).rr();
            double eev= (0.00);
            for(int i=0;i<4;i++){
               for(int j=0;j<4;j++){
                  eev+=eevf(physics_consts,
                            F1[iF1].ef[i],
                            F1[jF1].ef[j],
                            F1[kF1].vf,
                            RRij,
                            RRik,
                            RRjk);
               }
            }
            Fp_e+=(fac_m3*z*eev);
         }
      }
   }
   Fp_e*=physics_consts.CAL;
//
//
// peptide-peptide H-bond crosslinks
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<nR0;iR0++){
         char ci=R0[iR0].c1;
         if( (ci!='a')&&(ci!='e') )continue;
         int iF1=R0[iR0+ 1].F1h;
         if( iF1==-1 )continue;
         Coordinates n=( aut.F1[R0[iR0+ 1].F1n].x
                        -aut.F1[iF1].x).normalize();
         for(int jZ0= 0;jZ0<nZ0;jZ0++){
            int aR0=Z0[jZ0].R0a;
            int bR0=(aR0-1+Z0[jZ0].cR0);
            for(int jR0=aR0;jR0<bR0;jR0++){
               char cj=R0[jR0].c1;
               if( (cj!='a')&&(cj!='e') )continue;
               if( std::abs( jR0-iR0)<2 )continue;
               int jF1=R0[jR0   ].F1o;
               Coordinates m=( aut.F1[jF1].x
                              -aut.F1[R0[jR0   ].F1c].x).normalize();
//
//
// separation
//
               Coordinates x=( aut.F1[iF1].x -aut.F1[jF1].x);
               double R= x.r();
               if( R<(1.00e-12) )R= (1.00e-12);
               double ZZ= (1.00)/R;
               double CT= (x(2)*ZZ);
               double ST= std::sqrt( (1.00) -CT*CT);
               double CP,SP;
               if( ST>(1.00e-12) ){
                  CP= (x(0)*ZZ)/ST;
                  SP= (x(1)*ZZ)/ST;
               }else{
                  CP= (1.00);
                  SP= (0.00);
               }
               double Cnx= ZZ*dot(n,x);
               double Cmx= ZZ*dot(m,x);
//
//
// subset of (donor,acceptor) pairs
//
               vv.R0R0(iR0,jR0).b=( (R<((12.00)/physics_consts.ANG))&&
                                    (Cnx>( 0.00))&&
                                    (Cmx>( 0.00)) );
               if( vv.R0R0(iR0,jR0).b ){
//
//
// H-bond geom
//
// double the(   0.00),phi(   0.00),alp(   0.00),bet(   0.00);
// Rotation_Matrix ROT,ROTg,ROTh;
// {
//    Coordinates w=( aut.F1[jF1].x
//                   -aut.F1[R0[jR0   ].F1c].x).normalize();
//    Coordinates u=( aut.F1[R0[jR0   ].F1c].x
//                   -aut.F1[R0[jR0+ 1].F1n].x);
//    double uw= dot(u,w);
//    u-=uw*w;;
//    u.normalize();
//    Coordinates v=cross(w,u);
//    for(int i=0;i<3;i++){
//       ROT(i,0)= u(i);
//       ROT(i,1)= v(i);
//       ROT(i,2)= w(i);
//    }
//    Coordinates g=transpose(ROT)*x;
//    double Cthe= (g(2)*ZZ);
//    double Sthe= std::sqrt( (1.00) -Cthe*Cthe);
//    double Cphi,Sphi;
//    if( Sthe>(1.00e-12) ){
//       Cphi= (g(0)*ZZ)/Sthe;
//       Sphi= (g(1)*ZZ)/Sthe;
//    }else{
//       Cphi= (1.00);
//       Sphi= (0.00);
//    }
//    the= std::atan2(Sthe,Cthe);
//    phi= std::atan2(Sphi,Cphi);
//    ROTg=Rotation_Matrix(phi,the,(   0.00));
//    ROTg=ROT*transpose(ROTg);
//    Coordinates y=( aut.F1[R0[iR0+ 1].F1n].x
//                   -aut.F1[iF1].x).normalize();
//    Coordinates h=transpose(ROTg)*y;
//    double Cbet= h(2);
//    double Sbet= std::sqrt( (1.00) -Cbet*Cbet);
//    double Calp,Salp;
//    if( Sbet>(1.00e-12) ){
//       Calp= h(0)/Sbet;
//       Salp= h(1)/Sbet;
//    }else{
//       Calp= (1.00);
//       Salp= (0.00);
//    }
//    bet= std::atan2(Sbet,Cbet);
//    alp= std::atan2(Salp,Calp);
//    ROTh=Rotation_Matrix(alp,bet,(   0.00));
//    ROTh=ROTg*transpose(ROTh);
// }
//
//
// interaction energy
//
                  aut.q1.populate( 3,aut.F1[jF1].p);
                  aut.q2.populate( 3,aut.F1[iF1].p);
                  aut.QQ.populate( 6);
                  aut.QQ.product(array_consts,aut.q1,aut.q2);
                  aut.H.populate(array_consts, 6,CT,ST,CP,SP);
                  double Lr[8];
                  Lr[ 1]= ZZ;
                  for(int L=2;L<8;L++){
                     Lr[L  ]= ZZ*Lr[L-1];
                  }
                  double Fe= (0.00);
                  for(int L=0;L<7;L++){
                     double z= (0.00);
                     for(int M=-L;M<=L;M++){
                        double F_r=( aut.QQ.r(L,M)*aut.H.r(L,M)
                                    -aut.QQ.i(L,M)*aut.H.i(L,M));
                        z+=F_r;
                     }
                     Fe+=Lr[L+1]*z;
                  }
                  double EPS= ( 1.22)/physics_consts.CAL;
                  double RHO= ( 1.81)/physics_consts.ANG;
                  double ZZcore= (RHO*ZZ);
                  Fe+= EPS*std::pow( ZZcore, 14);
//
//
// populate pairs of subset
//
                  vv.R0R0(iR0,jR0).e= Fe;
                  vv.R0R0(iR0,jR0).R= (R*physics_consts.ANG);
                  vv.R0R0(iR0,jR0).a=( R<(( 2.40)/physics_consts.ANG) );
                  vv.R0R0(iR0,jR0).o=( R<(( 1.70)/physics_consts.ANG) );
                  int N4N2Q1[4][2];
                  N4N2Q1[0][0]=con.R0[iR0   ].Q1phi;
                  N4N2Q1[0][1]=con.R0[iR0   ].Q1psi;
                  N4N2Q1[1][0]=con.R0[iR0+ 1].Q1phi;
                  N4N2Q1[1][1]=con.R0[iR0+ 1].Q1psi;
                  N4N2Q1[2][0]=con.R0[jR0   ].Q1phi;
                  N4N2Q1[2][1]=con.R0[jR0   ].Q1psi;
                  N4N2Q1[3][0]=con.R0[jR0+ 1].Q1phi;
                  N4N2Q1[3][1]=con.R0[jR0+ 1].Q1psi;
                  for(int i=0;i<4;i++){
                     vv.R0R0(iR0,jR0).D+=
                          region_maps.phi.f(dep.Q1[ N4N2Q1[i][0]].chi);
                     vv.R0R0(iR0,jR0).D+=
                          region_maps.psi.f(dep.Q1[ N4N2Q1[i][1]].chi);
                     vv.R0R0(iR0,jR0).D+=
                          region_maps.phipsi.f(dep.Q1[ N4N2Q1[i][0]].chi,
                                               dep.Q1[ N4N2Q1[i][1]].chi);
                  }
// if( R<(( 2.40)/physics_consts.ANG) ){
//    double e= (Fe*physics_consts.CAL);
//    out.FILE3<< std::fixed;
//    out.FILE3<<" iR0="<< std::setw( 3)<<(iR0+ 2)
//             <<" jR0="<< std::setw( 3)<<(jR0+ 1)
//             <<std::setprecision( 2)
//             <<" R="<< std::setw( 5)<<(R*physics_consts.ANG)
//             <<" the="<< std::setw( 7)<<(the/physics_consts.RAD)
//             <<" phi="<< std::setw( 7)<<(phi/physics_consts.RAD)
//             <<" bet="<< std::setw( 7)<<(bet/physics_consts.RAD)
//             <<" alp="<< std::setw( 7)<<(alp/physics_consts.RAD)
//             <<std::setprecision( 4)
//             <<" e="<< std::setw( 8)<<e
//             <<" eD="<< std::setw( 8)<<(e*vv.R0R0(iR0,jR0).D)
//             <<std::endl;
//    Multipoles pj=aut.F1[jF1].p;
//    Multipoles pi=aut.F1[iF1].p;
//    pj.rotate(array_consts,transpose(ROT ));
//    pi.rotate(array_consts,transpose(ROTh));
//    double pj_c[4][4],pj_s[4][4];
//    double pi_c[4][4],pi_s[4][4];
//    {
//       double z= (1.00)/std::sqrt( (2.00));
//       for(int L=1;L<4;L++){
//          for(int M=1;M<=L;M++){
//             pj_c[L][M]= z*( pj.r(L, M)*array_consts.SGN(M) +pj.r(L,-M));
//             pj_s[L][M]= z*( pj.i(L, M)*array_consts.SGN(M) -pj.i(L,-M));
//             pi_c[L][M]= z*( pi.r(L, M)*array_consts.SGN(M) +pi.r(L,-M));
//             pi_s[L][M]= z*( pi.i(L, M)*array_consts.SGN(M) -pi.i(L,-M));
//          }
//       }
//    }
//    out.FILE3<<"________"<<std::endl;
//    out.FILE3<<std::setprecision( 5);
//    out.FILE3<<std::setw(10)<<pj.r(0,0)<<std::endl;
//    out.FILE3<<std::setw(10)<<pj.r(1,0)
//             <<std::setw(10)<<pj_c[1][1]
//             <<std::setw(10)<<pj_s[1][1]<<std::endl;
//    out.FILE3<<std::setw(10)<<pj.r(2,0)
//             <<std::setw(10)<<pj_c[2][1]
//             <<std::setw(10)<<pj_s[2][1]<<std::endl;
//    out.FILE3<<"          "
//             <<std::setw(10)<<pj_c[2][2]
//             <<std::setw(10)<<pj_s[2][2]<<std::endl;
//    out.FILE3<<std::setw(10)<<pj.r(3,0)
//             <<std::setw(10)<<pj_c[3][1]
//             <<std::setw(10)<<pj_s[3][1]<<std::endl;
//    out.FILE3<<"          "
//             <<std::setw(10)<<pj_c[3][2]
//             <<std::setw(10)<<pj_s[3][2]<<std::endl;
//    out.FILE3<<"          "
//             <<std::setw(10)<<pj_c[3][3]
//             <<std::setw(10)<<pj_s[3][3]<<std::endl;
//    out.FILE3<<"________"<<std::endl;
//    out.FILE3<<std::setprecision( 5);
//    out.FILE3<<std::setw(10)<<pi.r(0,0)<<std::endl;
//    out.FILE3<<std::setw(10)<<pi.r(1,0)
//             <<std::setw(10)<<pi_c[1][1]
//             <<std::setw(10)<<pi_s[1][1]<<std::endl;
//    out.FILE3<<std::setw(10)<<pi.r(2,0)
//             <<std::setw(10)<<pi_c[2][1]
//             <<std::setw(10)<<pi_s[2][1]<<std::endl;
//    out.FILE3<<"          "
//             <<std::setw(10)<<pi_c[2][2]
//             <<std::setw(10)<<pi_s[2][2]<<std::endl;
//    out.FILE3<<std::setw(10)<<pi.r(3,0)
//             <<std::setw(10)<<pi_c[3][1]
//             <<std::setw(10)<<pi_s[3][1]<<std::endl;
//    out.FILE3<<"          "
//             <<std::setw(10)<<pi_c[3][2]
//             <<std::setw(10)<<pi_s[3][2]<<std::endl;
//    out.FILE3<<"          "
//             <<std::setw(10)<<pi_c[3][3]
//             <<std::setw(10)<<pi_s[3][3]<<std::endl;
// }
               }
            }
         }
      }
   }
//
//
// other H-bond crosslinks
//
   int iF1F1=-1;
   for(int iF1= 0;iF1<oF1;iF1++){
      if( F1[iF1].lhb==-1 )continue; 
      int iT2=F1[iF1].typ;
      if( (iT2!= 2)&&(iT2!= 5) )continue;
      std::string atmi=F1[iF1].atm;
      int iR0=F1[iF1].R0;
      for(int jF1= 0;jF1<oF1;jF1++){
         if( F1[jF1].lhb==-1 )continue;
         int jT2=F1[jF1].typ;
         if( (jT2== 2)||(jT2== 5) )continue;
         std::string atmj=F1[jF1].atm;
         int jR0=F1[jF1].R0;
         if( std::abs( jR0-iR0)<2 )continue;
         if( (atmi==" H  ")&&
             (atmj==" O  ") )continue;
         iF1F1++;
         vv.o_F1F1.push_back( MEM_con_f::tF1F1());
//
//
// separation
//
         Coordinates x=( aut.F1[iF1].x -aut.F1[jF1].x);
         double R= x.r();
         if( R<(1.00e-12) )R= (1.00e-12);
         double ZZ= (1.00)/R;
         double CT= (x(2)*ZZ);
         double ST= std::sqrt( (1.00) -CT*CT);
         double CP,SP;
         if( ST>(1.00e-12) ){
            CP= (x(0)*ZZ)/ST;
            SP= (x(1)*ZZ)/ST;
         }else{
            CP= (1.00);
            SP= (0.00);
         }
//
         double Cnx( 0.00);
         if( atmi==" H  " ){
            Coordinates n=( aut.F1[R0[iR0].F1n].x
                           -aut.F1[iF1].x).normalize();
            Cnx= ZZ*dot(n,x);
         }
         double Cmx( 0.00);
         if( atmi==" O  " ){
            Coordinates m=( aut.F1[jF1].x
                           -aut.F1[R0[jR0].F1c].x).normalize();
            Cmx= ZZ*dot(m,x);
         }
         vv.F1F1(iF1F1).b=( (R<((12.00)/physics_consts.ANG))&&
                            (Cnx>=( 0.00))&&
                            (Cmx>=( 0.00)) );
         if( vv.F1F1(iF1F1).b ){
//
//
// interaction energy
//
            aut.q1.populate( 3,aut.F1[jF1].p);
            aut.q2.populate( 3,aut.F1[iF1].p);
            aut.QQ.populate( 6);
            aut.QQ.product(array_consts,aut.q1,aut.q2);
            aut.H.populate(array_consts, 6,CT,ST,CP,SP);
            double Lr[8];
            Lr[ 1]= ZZ;
            for(int L=2;L<8;L++){
               Lr[L  ]= ZZ*Lr[L-1];
            }
            double Fe= (0.00);
            for(int L=0;L<7;L++){
               double z= (0.00);
               for(int M=-L;M<=L;M++){
                  double F_r=( aut.QQ.r(L,M)*aut.H.r(L,M)
                              -aut.QQ.i(L,M)*aut.H.i(L,M));
                  z+=F_r;
               }
               Fe+=Lr[L+1]*z;
            }
            double EPS= ( 1.22)/physics_consts.CAL;
            double RHO= ( 1.71)/physics_consts.ANG;
            double ZZcore= (RHO*ZZ);
            Fe+= EPS*std::pow( ZZcore, 14);
//
//
// assemble subset
//
            vv.F1F1(iF1F1).iF1= iF1;
            vv.F1F1(iF1F1).jF1= jF1;
            vv.F1F1(iF1F1).e= Fe;
            vv.F1F1(iF1F1).R= (R*physics_consts.ANG);
            vv.F1F1(iF1F1).a=( R<(( 2.40)/physics_consts.ANG) );
            vv.F1F1(iF1F1).o=( R<(( 1.65)/physics_consts.ANG) );
// double the(   0.00),phi(   0.00),alp(   0.00),bet(   0.00);
// Rotation_Matrix ROT,ROTg,ROTh;
            int N4N2Q1[4][2];
            if( atmi==" H  " ){
               N4N2Q1[0][0]=con.R0[iR0- 1].Q1phi;
               N4N2Q1[0][1]=con.R0[iR0- 1].Q1psi;
               N4N2Q1[1][0]=con.R0[iR0   ].Q1phi;
               N4N2Q1[1][1]=con.R0[iR0   ].Q1psi;
               for(int i=0;i<2;i++){
                   vv.F1F1(iF1F1).D+=
                       region_maps.phi.f(dep.Q1[ N4N2Q1[i][0]].chi);
                   vv.F1F1(iF1F1).D+=
                       region_maps.psi.f(dep.Q1[ N4N2Q1[i][1]].chi);
                   vv.F1F1(iF1F1).D+=
                       region_maps.phipsi.f(dep.Q1[ N4N2Q1[i][0]].chi,
                                            dep.Q1[ N4N2Q1[i][1]].chi);
               }
//
//
// H-bond geom
//
// {
//    Coordinates u=( aut.F1[iF1].x
//                   -aut.F1[R0[iR0].F1n].x).normalize();
//    Coordinates w=-x;
//    w.normalize();
//    double Cbet= dot(w,u);
//    bet= std::acos( Cbet)/physics_consts.RAD;
// }
            }
            if( (atmj==" O  ")&&(jR0<(oR0- 1)) ){
               N4N2Q1[2][0]=con.R0[jR0   ].Q1phi;
               N4N2Q1[2][1]=con.R0[jR0   ].Q1psi;
               N4N2Q1[3][0]=con.R0[jR0+ 1].Q1phi;
               N4N2Q1[3][1]=con.R0[jR0+ 1].Q1psi;
               for(int i=2;i<4;i++){
                   vv.F1F1(iF1F1).D+=
                       region_maps.phi.f(dep.Q1[ N4N2Q1[i][0]].chi);
                   vv.F1F1(iF1F1).D+=
                       region_maps.psi.f(dep.Q1[ N4N2Q1[i][1]].chi);
                   vv.F1F1(iF1F1).D+=
                       region_maps.phipsi.f(dep.Q1[ N4N2Q1[i][0]].chi,
                                            dep.Q1[ N4N2Q1[i][1]].chi);
               }
//
//
// H-bond geom
//
// {
//    Coordinates v=( aut.F1[R0[jR0].F1c].x
//                   -aut.F1[jF1].x).normalize();
//    Coordinates w=-x;
//    w.normalize();
//    double Cthe= dot(w,v);
//    the= std::acos( Cthe)/physics_consts.RAD;
// }
            }
// if( R<(( 2.40)/physics_consts.ANG) ){
//    double e= (vv.F1F1(iF1F1).e*physics_consts.CAL);
//    out.FILE3<< std::fixed;
//    out.FILE3<<" iF1=["<< std::setw( 3)<<(iR0+ 1)<<atmi<<']'
//             <<" jF1=["<< std::setw( 3)<<(jR0+ 1)<<atmj<<']'
//             << std::setprecision( 2)
//             <<" R="<< std::setw( 5)<<(R*physics_consts.ANG)
//             <<" the="<< std::setw( 7)<<the
//             <<" bet="<< std::setw( 7)<<bet
//             << std::setprecision( 4)
//             <<" e="<< std::setw( 8)<<e
//             <<" eD="<< std::setw( 8)<<(e*vv.F1F1(iF1F1).D)
//             <<std::endl;
// }
         }
      }
   }
   vv.oF1F1=(iF1F1+ 1);
//
//
// chains of peptide plane alignment
//
   double z= ( .50)*physics_consts.CAL/(-2.25);
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int jR0= 0;jR0<oR0;jR0++){
         if( !vv.R0R0(iR0,jR0).b )continue;
         for(int lR0= 0;lR0<oR0;lR0++){
            if( !vv.R0R0(jR0,lR0).b )continue;
            if( std::abs( lR0-iR0)<2 )continue;
            if( (!vv.R0R0(iR0,jR0).o)&&(!vv.R0R0(jR0,lR0).o) ){
               if( (jR0==(iR0- 2))&&(lR0==(jR0- 2)) ){
                  vv.R0R0(iR0,jR0).C+=( 1.44)*z*vv.R0R0(jR0,lR0).e;
                  vv.R0R0(jR0,lR0).C+=( 1.44)*z*vv.R0R0(iR0,jR0).e;
               }else{
                  vv.R0R0(iR0,jR0).C+=z*vv.R0R0(jR0,lR0).e;
                  vv.R0R0(jR0,lR0).C+=z*vv.R0R0(iR0,jR0).e;
               }
            }
         }
      }
   }
   for(int iF1F1= 0;iF1F1<vv.oF1F1;iF1F1++){
      if( !vv.F1F1(iF1F1).b )continue;
      int pF1=vv.F1F1(iF1F1).iF1;
      std::string atmp=F1[pF1].atm;
      int pR0=F1[pF1].R0;
      int qF1=vv.F1F1(iF1F1).jF1;
      std::string atmq=F1[qF1].atm;
      int qR0=F1[qF1].R0;
      if( atmp==" H  " ){
         for(int iR0= 0;iR0<oR0;iR0++){
            if( std::abs( iR0-qR0)<2 )continue;
            if( !vv.R0R0(iR0,pR0- 1).b )continue;
            if( (!vv.F1F1(iF1F1).o)&&(!vv.R0R0(iR0,pR0- 1).o) ){
               if( pR0==(iR0- 1) ){
                  vv.R0R0(iR0,pR0- 1).C+=( 1.20)*z*vv.F1F1(iF1F1).e;
                  vv.F1F1(iF1F1).C+=( 1.20)*z*vv.R0R0(iR0,pR0- 1).e;
               }else{
                  vv.R0R0(iR0,pR0- 1).C+=z*vv.F1F1(iF1F1).e;
                  vv.F1F1(iF1F1).C+=z*vv.R0R0(iR0,pR0- 1).e;
               }
            }
         }
      }
      if( atmq==" O  " ){
         for(int jR0= 0;jR0<oR0;jR0++){
            if( std::abs( jR0-pR0)<2 )continue;
            if( !vv.R0R0(qR0,jR0).b )continue;
            if( (!vv.F1F1(iF1F1).o)&&(!vv.R0R0(qR0,jR0).o) ){
               if( jR0==(qR0- 2) ){
                  vv.R0R0(qR0,jR0).C+=( 1.20)*z*vv.F1F1(iF1F1).e;
                  vv.F1F1(iF1F1).C+=( 1.20)*z*vv.R0R0(qR0,jR0).e;
               }else{
                  vv.R0R0(qR0,jR0).C+=z*vv.F1F1(iF1F1).e;
                  vv.F1F1(iF1F1).C+=z*vv.R0R0(qR0,jR0).e;
               }
            }
         }
      }
   }
//
// patterns of H-bonds in helices or sheets
// helix, disfavor 3-10 and 4-13
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=(mR0+ 2);iR0<(nR0- 1);iR0++){
         int jR0=(iR0- 2);
         int kR0=(iR0+ 1);
         if( !vv.R0R0(iR0,jR0).b )continue;
         if( !vv.R0R0(kR0,jR0).b )continue;
         if( (!vv.R0R0(iR0,jR0).o)&&(!vv.R0R0(kR0,jR0).o) ){
            vv.R0R0(iR0,jR0).B-=( 1.20)*z*vv.R0R0(kR0,jR0).e;
            vv.R0R0(kR0,jR0).B-=( 1.20)*z*vv.R0R0(iR0,jR0).e;
         }
      }
   }
//
//
// helix, disfavor 4-13 and 5-16
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=(mR0+ 3);iR0<(nR0- 1);iR0++){
         int jR0=(iR0- 3);
         int kR0=(iR0+ 1);
         if( !vv.R0R0(iR0,jR0).b )continue;
         if( !vv.R0R0(kR0,jR0).b )continue;
         if( (!vv.R0R0(iR0,jR0).o)&&(!vv.R0R0(kR0,jR0).o) ){
            if( R0[kR0].aa=="GLY " ){
               vv.R0R0(iR0,jR0).B+=(  .25)*z*vv.R0R0(kR0,jR0).e;
               vv.R0R0(kR0,jR0).B+=(  .25)*z*vv.R0R0(iR0,jR0).e;
	    }else{
               vv.R0R0(iR0,jR0).B-=( 1.00)*z*vv.R0R0(kR0,jR0).e;
               vv.R0R0(kR0,jR0).B-=( 1.00)*z*vv.R0R0(iR0,jR0).e;
            }
         }
      }
   }
//
//
// helix, disfavor 3-10 and 5-16
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=(mR0+ 2);iR0<(nR0- 2);iR0++){
         int jR0=(iR0- 2);
         int kR0=(iR0+ 2);
         if( !vv.R0R0(iR0,jR0).b )continue;
         if( !vv.R0R0(kR0,jR0).b )continue;
         if( (!vv.R0R0(iR0,jR0).o)&&(!vv.R0R0(kR0,jR0).o) ){
            if( R0[kR0].aa=="GLY " ){
               vv.R0R0(iR0,jR0).B-=( 1.20)*z*vv.R0R0(kR0,jR0).e;
               vv.R0R0(kR0,jR0).B-=( 1.20)*z*vv.R0R0(iR0,jR0).e;
            }else{
               vv.R0R0(iR0,jR0).B-=( 1.20)*z*vv.R0R0(kR0,jR0).e;
               vv.R0R0(kR0,jR0).B-=( 1.20)*z*vv.R0R0(iR0,jR0).e;
            }
         }
      }
   }
//
//
// helix, favor consecutive 4-13 
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=(mR0+ 3);iR0<(nR0- 1);iR0++){
         int jR0=(iR0- 3);
         int kR0=(iR0+ 1);
         int lR0=(jR0+ 1);
         if( !vv.R0R0(iR0,jR0).b )continue;
         if( !vv.R0R0(kR0,lR0).b )continue;
         if( (!vv.R0R0(iR0,jR0).o)&&(!vv.R0R0(kR0,lR0).o) ){
            if( R0[kR0].aa=="GLY " ){
               vv.R0R0(iR0,jR0).B-=(  .15)*z*vv.R0R0(kR0,lR0).e;
               vv.R0R0(kR0,lR0).B-=(  .15)*z*vv.R0R0(iR0,jR0).e;
            }else{
               vv.R0R0(iR0,jR0).B+=(  .85)*z*vv.R0R0(kR0,lR0).e;
               vv.R0R0(kR0,lR0).B+=(  .85)*z*vv.R0R0(iR0,jR0).e;
            }
         }
      }
   }
//
//
// helix, favor consecutive 3-10
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=(mR0+ 2);iR0<(nR0- 1);iR0++){
         int jR0=(iR0- 2);
         int kR0=(iR0+ 1);
         int lR0=(jR0+ 1);
         if( !vv.R0R0(iR0,jR0).b )continue;
         if( !vv.R0R0(kR0,lR0).b )continue;
         if( (!vv.R0R0(iR0,jR0).o)&&(!vv.R0R0(kR0,lR0).o) ){
            if( R0[kR0].aa=="GLY " ){
               vv.R0R0(iR0,jR0).B-=(  .18)*z*vv.R0R0(kR0,lR0).e;
               vv.R0R0(kR0,lR0).B-=(  .18)*z*vv.R0R0(iR0,jR0).e;
            }else{
               vv.R0R0(iR0,jR0).B+=( 1.00)*z*vv.R0R0(kR0,lR0).e;
               vv.R0R0(kR0,lR0).B+=( 1.00)*z*vv.R0R0(iR0,jR0).e;
            }
         }
      }
   }
//
//
// helix, disfavor consecutive 5-16 
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=(mR0+ 4);iR0<(nR0- 1);iR0++){
         int jR0=(iR0- 4);
         int kR0=(iR0+ 1);
         int lR0=(jR0+ 1);
         if( !vv.R0R0(iR0,jR0).b )continue;
         if( !vv.R0R0(kR0,lR0).b )continue;
         if( (!vv.R0R0(iR0,jR0).o)&&(!vv.R0R0(kR0,lR0).o) ){
            if( R0[kR0].aa=="GLY " ){
               vv.R0R0(iR0,jR0).B-=( 1.75)*z*vv.R0R0(kR0,lR0).e;
               vv.R0R0(kR0,lR0).B-=( 1.75)*z*vv.R0R0(iR0,jR0).e;
            }else{
               vv.R0R0(iR0,jR0).B-=( 1.25)*z*vv.R0R0(kR0,lR0).e;
               vv.R0R0(kR0,lR0).B-=( 1.25)*z*vv.R0R0(iR0,jR0).e;
            }
         }
      }
   }
//
//
// helix, disfavor consecutive 4-13, 5-16 
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=(mR0+ 3);iR0<(nR0- 2);iR0++){
         int jR0=(iR0- 3);
         int kR0=(iR0+ 2);
         int lR0=(jR0+ 1);
         if( !vv.R0R0(iR0,jR0).b )continue;
         if( !vv.R0R0(kR0,lR0).b )continue;
         if( (!vv.R0R0(iR0,jR0).o)&&(!vv.R0R0(kR0,lR0).o) ){
            if( R0[kR0].aa=="GLY " ){
               vv.R0R0(iR0,jR0).B-=(  .00)*z*vv.R0R0(kR0,lR0).e;
               vv.R0R0(kR0,lR0).B-=(  .00)*z*vv.R0R0(iR0,jR0).e;
            }else{
               vv.R0R0(iR0,jR0).B-=( 1.25)*z*vv.R0R0(kR0,lR0).e;
               vv.R0R0(kR0,lR0).B-=( 1.25)*z*vv.R0R0(iR0,jR0).e;
            }
         }
      }
   }
//
//
// sheet, antiparallel
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<(nR0- 1);iR0++){
         for(int jZ0= 0;jZ0<nZ0;jZ0++){
            int aR0=Z0[jZ0].R0a;
            int bR0=(aR0-1+Z0[jZ0].cR0);
            for(int jR0=(aR0+ 1);jR0<bR0;jR0++){
               if( !vv.R0R0(iR0,jR0).b )continue;
               int kR0=(jR0- 1);
               int lR0=(iR0+ 1);
               if( !vv.R0R0(kR0,lR0).b )continue;
               if( (!vv.R0R0(iR0,jR0).o)&&(!vv.R0R0(kR0,lR0).o) ){
                  vv.R0R0(iR0,jR0).B+=( .50)*z*vv.R0R0(kR0,lR0).e;
                  vv.R0R0(kR0,lR0).B+=( .50)*z*vv.R0R0(iR0,jR0).e;
               }
            }
         }
      }
   }
//
//
// sheet, antiparallel
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=(mR0+ 1);iR0<nR0;iR0++){
         for(int jZ0= 0;jZ0<nZ0;jZ0++){
            int aR0=Z0[jZ0].R0a;
            int bR0=(aR0-1+Z0[jZ0].cR0);
            for(int jR0=aR0;jR0<(bR0- 1);jR0++){
               if( !vv.R0R0(iR0,jR0).b )continue;
               int kR0=(jR0+ 1);
               int lR0=(iR0- 1);
               if( !vv.R0R0(kR0,lR0).b )continue;
               if( (!vv.R0R0(iR0,jR0).o)&&(!vv.R0R0(kR0,lR0).o) ){
                  vv.R0R0(iR0,jR0).B+=( .50)*z*vv.R0R0(kR0,lR0).e;
                  vv.R0R0(kR0,lR0).B+=( .50)*z*vv.R0R0(iR0,jR0).e;
               }
            }
         }
      }
   }
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<(nR0- 2);iR0++){
         for(int jZ0= 0;jZ0<nZ0;jZ0++){
            int aR0=Z0[jZ0].R0a;
            int bR0=(aR0-1+Z0[jZ0].cR0);
            for(int jR0=(aR0+ 2);jR0<bR0;jR0++){
               if( !vv.R0R0(iR0,jR0).b )continue;
               int kR0=(iR0+ 2);
               int lR0=(jR0- 2);
               if( !vv.R0R0(kR0,lR0).b )continue;
               if( (!vv.R0R0(iR0,jR0).o)&&(!vv.R0R0(kR0,lR0).o) ){
                  vv.R0R0(iR0,jR0).B+=( .50)*z*vv.R0R0(kR0,lR0).e;
                  vv.R0R0(kR0,lR0).B+=( .50)*z*vv.R0R0(iR0,jR0).e;
               }
            }
         }
      }
   }
//
//
// sheet parallel
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=(mR0+ 1);iR0<nR0;iR0++){
         for(int jZ0= 0;jZ0<nZ0;jZ0++){
            int aR0=Z0[jZ0].R0a;
            int bR0=(aR0-1+Z0[jZ0].cR0);
            for(int jR0=(aR0+ 1);jR0<bR0;jR0++){
               if( !vv.R0R0(iR0,jR0).b )continue;
               int kR0=(jR0- 1);
               int lR0=(iR0- 1);
               if( !vv.R0R0(kR0,lR0).b )continue;
               if( (!vv.R0R0(iR0,jR0).o)&&(!vv.R0R0(kR0,lR0).o) ){
                  vv.R0R0(iR0,jR0).B+=( .50)*z*vv.R0R0(kR0,lR0).e;
                  vv.R0R0(kR0,lR0).B+=( .50)*z*vv.R0R0(iR0,jR0).e;
               }
            }
         }
      }
   }
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<(nR0- 1);iR0++){
         for(int jZ0= 0;jZ0<nZ0;jZ0++){
            int aR0=Z0[jZ0].R0a;
            int bR0=(aR0-1+Z0[jZ0].cR0);
            for(int jR0=aR0;jR0<(bR0- 1);jR0++){
               if( !vv.R0R0(iR0,jR0).b )continue;
               int kR0=(jR0+ 1);
               int lR0=(iR0+ 1);
               if( !vv.R0R0(kR0,lR0).b )continue;
               if( (!vv.R0R0(iR0,jR0).o)&&(!vv.R0R0(kR0,lR0).o) ){
                  vv.R0R0(iR0,jR0).B+=( .50)*z*vv.R0R0(kR0,lR0).e;
                  vv.R0R0(kR0,lR0).B+=( .50)*z*vv.R0R0(iR0,jR0).e;
               }
            }
         }
      }
   }
//
//
// calc Fp resolved into components
//
   double Fp_a= (0.00);
   double Fp_b= (0.00);
   double Fp_c= (0.00);
   double Fp_d= (0.00);
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int jR0= 0;jR0<oR0;jR0++){
         if( !vv.R0R0(iR0,jR0).b )continue;
         double e= (vv.R0R0(iR0,jR0).e*physics_consts.CAL);
         double C= vv.R0R0(iR0,jR0).C;
         double B= vv.R0R0(iR0,jR0).B;
         double D= vv.R0R0(iR0,jR0).D;
         Fp_a+=e;
         Fp_b+=e*( .50)*B;
         Fp_c+=e*( .50)*C;
         Fp_d+=e*D;
// double R= vv.R0R0(iR0,jR0).R;
// if( R> (2.40) )continue;
// out.FILE3<< std::fixed;
// out.FILE3<<" iR0="<< std::setw( 3)<<(iR0+ 2)
//          <<" jR0="<< std::setw( 3)<<(jR0+ 1)
//          << std::setprecision( 4)
//          <<" C="<< std::setw( 8)<<C
//          <<" B="<< std::setw( 8)<<B
//          << std::setprecision( 2)
//          <<" R="<< std::setw( 5)<<R
//          << std::setprecision( 4)
//          <<" e="<< std::setw( 8)<<e
//          <<" eC="<< std::setw( 8)<<(e*( .50)*C)
//          <<" eB="<< std::setw( 8)<<(e*( .50)*B)
//          <<std::endl;
      }
   }
   for(int iF1F1= 0;iF1F1<vv.oF1F1;iF1F1++){
      if( !vv.F1F1(iF1F1).b )continue;
      double e= (vv.F1F1(iF1F1).e*physics_consts.CAL);
      double C= vv.F1F1(iF1F1).C;
      double B= vv.F1F1(iF1F1).B;
      double D= vv.F1F1(iF1F1).D;
      Fp_a+=e;
      Fp_b+=e*( .50)*B;
      Fp_c+=e*( .50)*C;
      Fp_d+=e*D;
// double R= vv.F1F1(iF1F1).R;
// if( R> (2.40) )continue;
// int iF1=vv.F1F1(iF1F1).iF1;
// int jF1=vv.F1F1(iF1F1).jF1;
// std::string atmi=F1[iF1].atm;
// int iR0=F1[iF1].R0;
// std::string atmj=F1[jF1].atm;
// int jR0=F1[jF1].R0;
// out.FILE3<< std::fixed<< std::setprecision( 5);
// out.FILE3<<" iF1=["<< std::setw( 3)<<(iR0+ 1)<<atmi<<']'
//          <<" jF1=["<< std::setw( 3)<<(jR0+ 1)<<atmj<<']'
//          << std::setprecision( 4)
//          <<" C="<< std::setw( 8)<<C
//          <<" B="<< std::setw( 8)<<B
//          << std::setprecision( 2)
//          <<" R="<< std::setw( 5)<<R
//          << std::setprecision( 4)
//          <<" e="<< std::setw( 8)<<e
//          <<" eC="<< std::setw( 8)<<(e*( .50)*C)
//          <<" eB="<< std::setw( 8)<<(e*( .50)*B)
//          <<std::endl;
   }
   double Fp=( Fp_a +Fp_b +Fp_c +Fp_d +Fp_e);
//
//
// diagnostic output
//
   std::string hrule="________________________________________"
                     "________________________________________\n";
   if( out.VERBOSE&& false ){
      double TOT=( aut.Fr +aut.Fe +aut.Fs +Ft +Fc +Fb +aut.Fh +Fp +Fw);
      out.FILE3<< std::fixed<< std::setprecision(2);
      out.FILE3<<"      F  \n";
      out.FILE3<< std::setw( 9)<<TOT<<'\n';
      out.FILE3<<"     Fr  "
               <<"     Fe  "
               <<"     Fs  "
               <<"     Ft  "
               <<"     Fc  "
               <<"     Fb  "
               <<"     Fh  "
               <<"     Fm  "
               <<"     Fw  "
               <<"     Fp  \n";
      out.FILE3<< std::setw( 9)<<aut.Fr
               << std::setw( 9)<<aut.Fe
               << std::setw( 9)<<aut.Fs
               << std::setw( 9)<<Ft
               << std::setw( 9)<<Fc
               << std::setw( 9)<<Fb
               << std::setw( 9)<<aut.Fh
               << std::setw( 9)<<( 0.00)
               << std::setw( 9)<<Fw
               << std::setw( 9)<<Fp<<'\n';
      out.FILE3<<"     Fg  "
               <<"     Fp_a"
               <<"     Fp_b"
               <<"     Fp_c"
               <<"     Fp_d"
               <<"     Fp_e\n";
      out.FILE3<< std::setw( 9)<<( 0.00)
               << std::setw( 9)<<Fp_a
               << std::setw( 9)<<Fp_b
               << std::setw( 9)<<Fp_c
               << std::setw( 9)<<Fp_d
               << std::setw( 9)<<Fp_e<<'\n';
   }
   return;
}
