#include "../con/Con_Automatic.hh"
#include "../con/Subset_Contracted_System.hh"
#include "../set/Mechanical_System.hh"

void Mechanical_System::CON_E1(Con_Automatic& aut,
                               Subset_Contracted_System::tM3& con){
   int mE0=0;
   int mE1=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      con.Z0[iZ0].E1a=mE1;
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
//
//
// initiate sub-block multipoles
//
      {
         int mQ1=Z0[iZ0].Q1a;
         int nQ1=(mQ1-1+Z0[iZ0].cQ1);
         for(int iQ1=mQ1;iQ1<=nQ1;iQ1++){
            con.Q1[iQ1].lte=-1;
         }
         int mX1=(mQ1+1);
         int nX1=nQ1;
         if( nX1>=mX1 ){
            for(int iX1=mX1;iX1<=nX1;iX1++){
               con.X1[iX1].lte=-1;
            }
         }
         int mQ3=con.Z0[iZ0].Q3a;
         int nQ3=(mQ3-1+con.Z0[iZ0].cQ3);
         for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
            con.Q3[iQ3].lte=-1;
         }
         int mX2=con.Z0[iZ0].X2a;
         int nX2=(mX2-1+con.Z0[iZ0].cX2);
         if( nX2>=mX2 ){
            for(int iX2=mX2;iX2<=nX2;iX2++){
               con.X2[iX2].lte=-1;
            }
         }
      }
//
//
// contract sub-block pairs
//
      int iQ2=mQ2;
      int iE1=(mE1-1);
      con.Q2[iQ2].cE1=0;
      int nE0=(mE0-1+con.Q2[iQ2].cE0);
      if( nE0>=mE0 ){
         for(int iE0=mE0;iE0<=nE0;iE0++){
            if( aut.E0[iE0].imp==0 )continue;
            con.E1.push_back(
              Subset_Contracted_System::tM3::tM3E1());
            iE1++;
            con.Q2[iQ2].cE1++;
            con.E1[iE1].sse=con.E0[iE0].sse;
            con.E1[iE1].Z0=con.E0[iE0].Z0;
            int lam=con.E0[iE0].lam;
            con.E1[iE1].lam=lam;
            con.E1[iE1].k=con.E0[iE0].k;
            int iQ3=con.E0[iE0].Q3;
            con.E1[iE1].Q3=iQ3;
            con.Q3[iQ3].lte=7;
            int mQ1=con.Q3[iQ3].Q1a;
            int nQ1=(mQ1-1+con.Q3[iQ3].cQ1);
            for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
               int iQ1=con.Q1[pQ1].ord;
               con.Q1[iQ1].lte=7;
            }
            int jX2=con.E0[iE0].X2;
            con.E1[iE1].X2=jX2;
            if      ( lam==0 ){
            }else if( lam==1 ){
            }else if( lam==2||lam==3 ){
            }else if( lam==4 ){
            }else if( lam==6||lam==7 ){
               int jQ3=jX2;
               con.Q3[jQ3].lte=7;
               int aQ1=con.Q3[jQ3].Q1a;
               int bQ1=(aQ1-1+con.Q3[jQ3].cQ1);
               for(int qQ1=aQ1;qQ1<=bQ1;qQ1++){
                  int jQ1=con.Q1[qQ1].ord;
                  con.Q1[jQ1].lte=7;
               }
            }
         }
         mE0+=con.Q2[iQ2].cE0;
         mE1+=con.Q2[iQ2].cE1;
      }
      if( nQ2>mQ2 ){
         iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            con.Q2[iQ2].cE1=0;
            nE0=(mE0-1+con.Q2[iQ2].cE0);
            if( nE0>=mE0 ){
               for(int iE0=mE0;iE0<=nE0;iE0++){
                  if( aut.E0[iE0].imp==0 )continue;
                  con.E1.push_back(
                    Subset_Contracted_System::tM3::tM3E1());
                  iE1++;
                  con.Q2[iQ2].cE1++;
                  con.E1[iE1].sse=con.E0[iE0].sse;
                  con.E1[iE1].Z0=con.E0[iE0].Z0;
                  int lam=con.E0[iE0].lam;
                  con.E1[iE1].lam=lam;
                  con.E1[iE1].k=con.E0[iE0].k;
                  int iQ3=con.E0[iE0].Q3;
                  con.E1[iE1].Q3=iQ3;
                  con.Q3[iQ3].lte=7;
                  int mQ1=con.Q3[iQ3].Q1a;
                  int nQ1=(mQ1-1+con.Q3[iQ3].cQ1);
                  for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
                     int iQ1=con.Q1[pQ1].ord;
                     con.Q1[iQ1].lte=7;
                  }
                  int jX2=con.E0[iE0].X2;
                  con.E1[iE1].X2=jX2;
                  if      ( lam==0 ){
                     int jX1=jX2;
                     con.X1[jX1].lte=7;
                  }else if( lam==1 ){
                  }else if( lam==2||lam==3 ){
                     int jQ1=jX2;
                     con.Q1[jQ1].lte=7;
                  }else if( lam==4 ){
                     con.X2[jX2].lte=7;
                     int aX1=con.X2[jX2].X1a;
                     int bX1=(aX1-1+con.X2[jX2].cX1);
                     for(int pX1=aX1;pX1<=bX1;pX1++){
                        int jX1=con.X1[pX1].ord;
                        con.X1[jX1].lte=7;
                     }
                  }else if( lam==6||lam==7 ){
                     int jQ3=jX2;
                     con.Q3[jQ3].lte=7;
                     int aQ1=con.Q3[jQ3].Q1a;
                     int bQ1=(aQ1-1+con.Q3[jQ3].cQ1);
                     for(int qQ1=aQ1;qQ1<=bQ1;qQ1++){
                        int jQ1=con.Q1[qQ1].ord;
                        con.Q1[jQ1].lte=7;
                     }
                  }
               }
               mE0+=con.Q2[iQ2].cE0;
               mE1+=con.Q2[iQ2].cE1;
            }
         }
      }
      con.Z0[iZ0].cE1=(mE1-con.Z0[iZ0].E1a);
//
//
// set backward atom index of distance constraints
//
      int mC1=con.Z0[iZ0].C1a;
      int nC1=(mC1-1+con.Z0[iZ0].cC1);
      if( nC1>=mC1 ){
         for(int iC1=mC1;iC1<=nC1;iC1++){
            int j__=con.C1[iC1].F1a;
            int lam=con.C1[iC1].lam;
            if      ( lam==0 ){
               con.C1[iC1].F2a=aut.F1[j__].F2;
            }else if( lam==1 ){
               con.C1[iC1].F2a=aut.H1[j__].H2;
            }else if( lam==2 ){
               con.C1[iC1].F2a=aut.G2[j__].G3;
            }else if( lam==3 ){
               con.C1[iC1].F2a=aut.B2[j__].B3;
            }
         }
      }
   }
   con.oE1=con.E1.size();
   return;
}
