#include "../con/Con_Automatic.hh"
#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"

void Mechanical_System::CON_BPAIR(Con_Automatic& aut,
                                  const DAT_PHYSICS_CONSTS& physics_consts,
                                  const DAT_ARRAY_CONSTS& array_consts,
                                  const DAT_ENERGY_PARAMS& energy_params,
                                  Output_Streams& out,
                                  Subset_Contracted_System::tM3& con,
                                  int iZ0,int iQ2,int mQ2,int iE0){
//
// calc aut.Fr, aut.Fe, aut.Fs, aut.Fh
// set con.F1[].imp, aut.E0[].imp
//
   int iQ3=con.E0[iE0].Q3;
   int mQ1=con.Q3[iQ3].Q1a;
   int nQ1=(mQ1-1+con.Q3[iQ3].cQ1);
   int jZ0=con.E0[iE0].Z0;
   int lam=con.E0[iE0].lam;
   if      ( lam==0 ){
      int jX1=con.E0[iE0].X2;
      int aF1=X1[jX1].F1a;
      int bF1=(aF1-1+X1[jX1].cF1);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG2=con.Q1[iQ1].G2a;
         int nG2=(mG2-1+Q1[iQ1].cG2);
         for(int iG2=mG2;iG2<=nG2;iG2++){
            int iF1=con.G2[iG2].F1;
            for(int jF1=aF1;jF1<=bF1;jF1++){
               CON_APAIR(aut,
                         physics_consts,array_consts,energy_params,
                         out,con,
                         jF1,jZ0,iE0,iF1,iG2,iQ2,iZ0);
            }
         }
      }

   }else if( lam==1 ){
      int jU1=con.E0[iE0].X2;
      int aH1=U1[jU1].H1a;
      int bH1=(aH1-1+U1[jU1].cH1);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG2=con.Q1[iQ1].G2a;
         int nG2=(mG2-1+Q1[iQ1].cG2);
         for(int iG2=mG2;iG2<=nG2;iG2++){
            int iF1=con.G2[iG2].F1;
            for(int jH1=aH1;jH1<=bH1;jH1++){
               int jF1=H1[jH1].F1;
               CON_APAIR(aut,
                         physics_consts,array_consts,energy_params,
                         out,con,
                         jF1,jZ0,iE0,iF1,iG2,iQ2,iZ0);
            }
         }
      }

   }else if( (lam==2)||(lam==3) ){
      int jQ1=con.E0[iE0].X2;
      int aG2=con.Q1[jQ1].G2a;
      int bG2=(aG2-1+Q1[jQ1].cG2);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG2=con.Q1[iQ1].G2a;
         int nG2=(mG2-1+Q1[iQ1].cG2);
         for(int iG2=mG2;iG2<=nG2;iG2++){
            int iF1=con.G2[iG2].F1;
            for(int jG2=aG2;jG2<=bG2;jG2++){
               int jF1=( lam==3 )? con.B2[jG2].F1: con.G2[jG2].F1;
               CON_APAIR(aut,
                         physics_consts,array_consts,energy_params,
                         out,con,
                         jF1,jZ0,iE0,iF1,iG2,iQ2,iZ0);
            }
         }
      }

   }else if( lam==4 ){
      int jX2=con.E0[iE0].X2;
      int aX1=con.X2[jX2].X1a;
      int bX1=(aX1-1+con.X2[jX2].cX1);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG2=con.Q1[iQ1].G2a;
         int nG2=(mG2-1+Q1[iQ1].cG2);
         for(int pX1=aX1;pX1<=bX1;pX1++){
            int jX1=con.X1[pX1].ord;
            int aF1=X1[jX1].F1a;
            int bF1=(aF1-1+X1[jX1].cF1);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               int iF1=con.G2[iG2].F1;
               for(int jF1=aF1;jF1<=bF1;jF1++){
                  CON_APAIR(aut,
                            physics_consts,array_consts,energy_params,
                            out,con,
                            jF1,jZ0,iE0,iF1,iG2,iQ2,iZ0);
               }
            }
         }
      }

   }else if( (lam==6)||(lam==7) ){
      int jQ3=con.E0[iE0].X2;
      int aQ1=con.Q3[jQ3].Q1a;
      int bQ1=(aQ1-1+con.Q3[jQ3].cQ1);
      for(int pQ1=mQ1;pQ1<=nQ1;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int mG2=con.Q1[iQ1].G2a;
         int nG2=(mG2-1+Q1[iQ1].cG2);
         for(int qQ1=aQ1;qQ1<=bQ1;qQ1++){
            int jQ1=con.Q1[qQ1].ord;
            int aG2=con.Q1[jQ1].G2a;
            int bG2=(aG2-1+Q1[jQ1].cG2);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               int iF1=( iQ2==mQ2 )? con.B2[iG2].F1: con.G2[iG2].F1;
               for(int jG2=aG2;jG2<=bG2;jG2++){
                  int jF1=( lam==7 )? con.B2[jG2].F1: con.G2[jG2].F1;
                  CON_APAIR(aut,
                            physics_consts,array_consts,energy_params,
                            out,con,
                            jF1,jZ0,iE0,iF1,iG2,iQ2,iZ0);
               }
            }
         }
      }

   }
   return;
}
