#include "../con/Con_Automatic.hh"
#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>
#include <cmath>

void Mechanical_System::CON_APAIR(Con_Automatic& aut,
                                  const DAT_PHYSICS_CONSTS& physics_consts,
                                  const DAT_ARRAY_CONSTS& array_consts,
                                  const DAT_ENERGY_PARAMS& energy_params,
                                  Output_Streams& out,
                                  Subset_Contracted_System::tM3& con,
                                  int jF1,
                                  int jZ0,
                                  int iE0,
                                  int iF1,
                                  int i_2,
                                  int iQ2,
                                  int iZ0){
//
// calc aut.Fr, aut.Fe, aut.Fs, aut.Fh
// set con.F1[].imp, aut.E0[].imp
//
   int iT2=F1[iF1].typ;
   int jT2=F1[jF1].typ;
   if( iT2==31 )return;
   if( jT2==31 )return;
   if( (iT2==30)&&(jT2==30) )return;
   if( aut.Q2[iQ2].cut||aut.Q2[con.E0[iE0].k].cut )return;
   int iHB=F1[iF1].hb;
   int jHB=F1[jF1].hb;
//
//
// patch (iT2,jT2) (iHB,jHB)
//
   if      ( (jHB==1)&&(iHB==2) ){
      if      ( (F1[jF1].atm==" H  ")&&
                (F1[iF1].atm==" O  ") ){
         if( F1[jF1].R0==(F1[iF1].R0+ 2) ){
            jT2= 1;
            jHB=3;
         }
      }else if( (F1[jF1].atm==" HG ")&&
                (F1[iF1].atm==" O  ") ){
         if( F1[jF1].R0==(F1[iF1].R0+ 1) ){
            jT2= 1;
            jHB=3;
         }
      }
   }else if( (jHB==2)&&(iHB==1) ){
      if      ( (F1[jF1].atm==" O  ")&&
                (F1[iF1].atm==" H  ") ){
         if( F1[iF1].R0==(F1[jF1].R0+ 2) ){
            iT2= 1;
            iHB=3;
         }
      }else if( (F1[jF1].atm==" O  ")&&
                (F1[iF1].atm==" HG ") ){
         if( F1[iF1].R0==(F1[jF1].R0+ 1) ){
            iT2= 1;
            iHB=3;
         }
      }
   }

   Coordinates D=( aut.F1[iF1].x -aut.F1[jF1].x);
   double RR= D.rr();
   if( RR>=aut.RRcut )return;

   int LTE1=F1[jF1].lte;
   int LTE2=F1[iF1].lte;
   if( (LTE1>=0)&&(LTE2>=0) ){
      aut.E0[iE0].imp=1;
      con.F1[iF1].imp=1;
      con.F1[jF1].imp=1;

      double R= std::sqrt( RR);
      if( R<(1.00e-12) )R= (1.00e-12);
      double CT= (D(2)/R);
      double ST= std::sqrt( (1.00) -CT*CT);
      double CP,SP;
      if( ST>(1.00e-12) ){
         CP= (D(0)/R)/ST;
         SP= (D(1)/R)/ST;
      }else{
         CP= (1.00);
         SP= (0.00);
      }
//Fe
      aut.q1.populate(LTE1,aut.F1[jF1].q);
      aut.q2.populate(LTE2,aut.F1[iF1].q);
      int LTEe=(LTE1+LTE2);
      if( LTEe>energy_params.LTE )LTEe=energy_params.LTE;
      aut.QQ.populate(LTEe);
      aut.QQ.product(array_consts,aut.q1,aut.q2);

      aut.H.populate(array_consts,LTEe,CT,ST,CP,SP);

      double ZZ= (1.00)/R;
      double Lr[8];
      Lr[ 1]= ZZ;
      for(int L=2;L<=(LTEe+1);L++){
         Lr[L  ]= ZZ*Lr[L-1];
      }

      for(int L=0;L<=LTEe;L++){
         double z= (0.00);
         for(int M=-L;M<=L;M++){
            double F_r=( aut.QQ.r(L,M)*aut.H.r(L,M)
                        -aut.QQ.i(L,M)*aut.H.i(L,M));
//          double F_i=( aut.QQ.r(L,M)*aut.H.i(L,M)
//                      +aut.QQ.i(L,M)*aut.H.r(L,M));
            z+=F_r;
         }
         aut.Fe+=Lr[L+1]*z;
      }
//Fr
      int eHB=(jHB&iHB);
      if( eHB>0 )eHB=1;

      int iS3=-1;
      if( con.E0[iE0].sse==1 ){
         int i=( con.F1[jF1].sf&  7);
         int k=(con.F1[jF1].sf-i);
         if( iQ2>con.Z0[iZ0].Q2a ){
            int j=( con.G2[i_2].sg&  7);
            if( (con.G2[i_2].sg-j)==k )iS3=energy_params.S2S2S3(i,j);
         }else{
            int j=( con.B2[i_2].sb&  7);
            if( (con.B2[i_2].sb-j)==k )iS3=energy_params.S2S2S3(i,j);
         }
         if( iS3==-2 )return;
         if( iS3>0 ){
            iT2=31;
            jT2=31;
         }
      }

      double EPS= energy_params.T2T2e(iT2,jT2);
      double RHO= energy_params.T2T2r(iT2,jT2);
      ZZ= (R/RHO);
      double alp= energy_params.T2T2a(iT2,jT2);
      double FF=( (1.00) +alp)/( ZZ +alp);
      double GG= (1.12)/( std::pow(ZZ,7) +(.12));
      double e= EPS*( std::pow(FF,7)*( GG -(2.00)));
      if( jF1==F1[iF1].lnk )e= (0.00);
//    if( e>aut.Ecut ){
//       out.FILE3<< std::setw( 5)<<jZ0
//                << std::setw( 5)<<F1[jF1].R0
//                <<' '<<F1[jF1].atm<<"  "
//                << std::setw( 5)<<iZ0
//                << std::setw( 5)<<F1[iF1].R0
//                <<' '<<F1[iF1].atm<<"  "
//                << std::scientific<< std::setprecision(3)
//                << std::setw(10)<<(physics_consts.CAL*e);
//    }
      aut.Fr+=e;

      if( eHB==0 ){
         ZZ= std::sqrt( (2.00));
         int dT2,aT2;
         if( (iT2== 2)||(iT2== 5) ){
            dT2=(iT2-1);
            aT2=jT2;
            aut.QQ.populate(1,aut.F1[iF1].q);
            double u0= aut.QQ.r(1,-1)*ZZ;
            double u1=-aut.QQ.i(1,-1)*ZZ;
            double u2= aut.QQ.r(1, 0);
            double z= (-1.00)/std::sqrt( u0*u0 +u1*u1 +u2*u2);
            aut.QQ*=z;
         }else{
            dT2=(jT2-1);
            aT2=iT2;
            aut.QQ.populate(1,aut.F1[jF1].q);
            double u0= aut.QQ.r(1,-1)*ZZ;
            double u1=-aut.QQ.i(1,-1)*ZZ;
            double u2= aut.QQ.r(1, 0);
            double z= ( 1.00)/std::sqrt( u0*u0 +u1*u1 +u2*u2);
            aut.QQ*=z;
         }
         aut.H.populate(array_consts,1,CT,ST,CP,SP);

         double C= (0.00);
         for(int M=-1;M<=1;M++){
            double F_r=( aut.QQ.r(1,M)*aut.H.r(1,M)
                        -aut.QQ.i(1,M)*aut.H.i(1,M));
//          double F_i=( aut.QQ.r(1,M)*aut.H.i(1,M)
//                      +aut.QQ.i(1,M)*aut.H.r(1,M));
            C+=F_r;
         }
         double F=( (1.00) -C*C*C*C);

         EPS= energy_params.T2T2e(dT2,aT2);
         RHO= energy_params.T2T2r(dT2,aT2);
         ZZ= (R/RHO);
         alp= energy_params.T2T2a(dT2,aT2);
         FF=( (1.00) +alp)/( ZZ +alp);
         GG= (1.12)/( std::pow(ZZ,7) +(.12));
         double G= EPS*( std::pow(FF,7)*( GG -(2.00)));

         EPS= energy_params.T2T2e(iT2,jT2);
         RHO= energy_params.T2T2r(iT2,jT2);
         ZZ= (R/RHO);
         alp= energy_params.T2T2a(iT2,jT2);
         FF=( (1.00) +alp)/( ZZ +alp);
         GG= (1.12)/( std::pow(ZZ,7) +(.12));
         G-=EPS*( std::pow(FF,7)*( GG -(2.00)));

         aut.Fr+=F*G;

         if( F1[jF1].ion||F1[iF1].ion ){
            EPS= energy_params.T2T2e(dT2,aT2)*(  .32);
            RHO= energy_params.T2T2r(dT2,aT2);
            ZZ= (R/RHO);
            alp= energy_params.T2T2a(dT2,aT2);
            FF=( (1.00) +alp)/( ZZ +alp);
            GG= (1.12)/( std::pow(ZZ,7) +(.12));
            e= EPS*( std::pow(FF,7)*( GG -(2.00)));
            aut.Fr+=e;
         }
      }
//Fs
      if( iS3>=0 ){
         double a0= energy_params.S3[iS3].a;
         double r0= energy_params.S3[iS3].r;
         aut.Fs+=a0*std::pow(( R -r0),2);
         if( iS3==2 ){
            double Es= std::pow( (1.00)/(R*physics_consts.ANG), 9);
            aut.Fs+=Es;
         }
      }
   }
//Fh
   int n1=F1[jF1].mu;
   int n2=F1[iF1].mu;
   if( (n1>0)&&(n2>0) ){
      if      ( iT2==30 ){
         if( n1==1 ){
            aut.E0[iE0].imp=1;
            con.F1[iF1].imp=1;
            con.F1[jF1].imp=1;
         }
      }else if( jT2==30 ){
         if( n2==1 ){
            aut.E0[iE0].imp=1;
            con.F1[iF1].imp=1;
            con.F1[jF1].imp=1;
         }
      }else{
         if( jZ0==iZ0 ){
            for(int i1= 0;i1<n1;i1++){
               for(int i2= 0;i2<n2;i2++){
                  if( F1[iF1].fac[i2]==F1[jF1].fac[i1] )return;
               }
            }
         }
         aut.E0[iE0].imp=1;
         con.F1[iF1].imp=1;
         con.F1[jF1].imp=1;
         for(int i1= 0;i1<n1;i1++){
            con.F1[F1[jF1].fac[i1]].imp=1;
         }
         for(int i2= 0;i2<n2;i2++){
            con.F1[F1[iF1].fac[i2]].imp=1;
         }
         double z1= array_consts.SGN(n1+n2-1);
         double z2= pairf(physics_consts,
                          F1[jF1].gau,F1[iF1].gau,
                          RR);
         aut.Fh+=(z1*z2);
      }
   }
   return;
}
