#include "../con/Con_Automatic.hh"
#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <iomanip>

void Mechanical_System::CON(const DAT_PHYSICS_CONSTS& physics_consts,
                            const DAT_ARRAY_CONSTS& array_consts,
                            const DAT_ENERGY_PARAMS& energy_params,
                            const DAT_REGION_MAPS& region_maps,
                            const Thread_Options& opt,
                            Output_Streams& out,
                            Subset_Contracted_System& col,
                            Conf_Dependent_System& dep){
   int oZ0=Z0.size();
   int oQ1=X1.size();
   int oF1=F1.size();
   int oG1=G1.size();
   int oH1=H1.size();
   int oE0=0;
   for(int iM3= 0;iM3<col.nM3;iM3++){
      Subset_Contracted_System::tM3& con=col.M3[iM3];
      int o=con.E0.size();
      if( o>oE0 )oE0=o;
   }
   Con_Automatic aut(oZ0,oQ1,oF1,oG1,oH1,oE0);

   aut.RRcut= opt.Rcut/physics_consts.ANG;
   aut.RRcut*=aut.RRcut;
   aut.Ecut= (3.00)/physics_consts.CAL;

   if( out.VERBOSE&&false ){
      out.FILE3<< std::fixed<< std::setprecision(3);
      out.FILE3<<" Rcut="<< std::setw( 8)<<opt.Rcut<<'\n';
   }

   for(int iM3= 0;iM3<col.nM3;iM3++){
      Subset_Contracted_System::tM3& con=col.M3[iM3];
      if( out.VERBOSE&& out.SHELL ){
         out.FILE3<<" subset name="<<con.QSUB<<'\n';
      }
      CON_Q2(aut,array_consts,energy_params,opt,con,dep);
      CON_F2(aut,physics_consts,array_consts,energy_params,
             out,con,dep);
      CON_E1(aut,con);
      CON_F(aut,physics_consts,array_consts,energy_params,region_maps,
            opt,out,con,dep);
      CON_WRITE(aut,physics_consts,out,con,dep);
   }

   return;
}
