#ifndef DEF_SUBSET_CONTRACTED_SYSTEM
#define DEF_SUBSET_CONTRACTED_SYSTEM

#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>

class Subset_Contracted_System {
public:
   class tM3 { /*subset of degrees of freedom in local minimization*/
   public:
      class tM3Z0 { /*chains in system of molecules*/
      public:
         bool sub;              //chain translation+rotation {t=free,f=rigid}
         int Q2a;               //start index into variable torsions
         int cQ2bb;             //number of variable bb torsions
         int cQ2;               //number of variable torsions
         int G2a;               //start index into atoms of forward groups
         int cG2;               //number of atoms of forward groups
         int B2a;               //start index into atoms of base groups
         int cB2;               //number of atoms of base groups
         int Q3a;               //start index into forward sub-blocks
         int cQ3;               //number of forward sub-blocks
         int E0a;               //start index into sub-block pairs
         int cE0;               //number of sub-block pairs
         int C1a;               //start index into distance constraints
         int cC1;               //number of distance constraints
         int X2a;               //start index into backward sub-blocks
         int cX2;               //number of backward sub-blocks
         int F2a;               //start index into atoms
         int cF2;               //number of atoms
         int G3a;               //start index into atoms of forward groups
         int cG3;               //number of atoms of forward groups
         int B3a;               //start index into atoms of base groups
         int cB3;               //number of atoms of base groups
         int H2a;               //start index into atoms of sc backward groups
         int cH2;               //number of atoms of sc backward groups
         int J2a;               //start index into pairs of adjacent torsions
         int cJ2;               //number of pairs of adjacent torsions
         int Y2a;               //start index into triples of adjacent torsions
         int cY2;               //number of triples of adjacent torsions
         int E1a;               //start index into sub-block pairs
         int cE1;               //number of sub-block pairs
         tM3Z0(){}
      };
      class tM3R0 { /*residues*/
      public:
         int U2phi;             //map to index of phi torsion
         int U2psi;             //
         int Q1phi;             //
         int Q1psi;             //
         tM3R0(){}
      };
      class tM3Q1 { /*torsions [forward order]*/
      public:
         bool sub;              //torsion rotation {t=free,f=rigid}
         int G2a;               //start index into atoms of forward groups
         int ord;               //order of sub-block addition
         int G3a;               //start index into atoms of forward groups
         int cG3;               //number of atoms of forward group
         int lte;               //largest L of forward group multipoles
         tM3Q1(){}
      };
      class tM3X1 { /*torsions [backward order]*/
      public:
         int ord;               //order of sub-block addition
         int F2a;               //start index into atoms of backward groups
         int cF2;               //number of atoms of backward group
         int lte;               //largest L of backward group multipoles
         tM3X1(){}
      };
      class tM3U1 { /*side chain torsions [branch backward order]*/
      public:
         int H2a;               //start index into atoms of sc backward groups
         int cH2;               //number of atoms of sc backward group
         tM3U1(){}
      };
      class tM3F1 { /*atoms [backward order]*/
      public:
         int sf;                //atom type for disulfide crosslink
         int b4;                //connectivity to base of backward torsion
         int imp;               //subset for atom contraction
         tM3F1(){}
      };
      class tM3H1 { /*atoms in backward groups of branch torsions [branch
                      backward order]*/
      public:
         int b4;                //connectivity to base of sc backward torsion
         tM3H1(){}
      };
      class tM3S1 { /*disulfide bonds in torsion-contracted system of
                      molecules*/
      public:
         tM3S1(){}
      };
      class tM3Q2 { /*torsions in contracted chains [forward order]*/
      public:
         std::string tor;       //3 char torsion name
         int br;                //branch order
         int bseF1;             //base atom of forward torsion
         int cG2;               //number of atoms of forward group
         int chg;               //cumulative charge of forward group
         int jnt;               //connected torsion in tree
         int cbr;               //branch order of connected torsion
         int omg;               //end of bb or sc string in order of generation
         int G2a;               //start index into atoms of forward groups
         int Q3a;               //start index into forward sub-blocks
         int cQ3;               //number of forward sub-blocks
         int X2a;               //start index into backward sub-blocks
         int cX2;               //number of backward sub-blocks
         int cE0;               //number of sub-block pairs
         int cG3;               //number of atoms of forward group
         int bseF2;             //base atom of forward torsion
         int G3a;               //start index into atoms of forward groups
         int cE1;               //number of sub-block pairs
         tM3Q2(){}
      };
      class tM3B2 { /*atoms in torsion-contracted chain base groups [forward
                      order]*/
      public:
         int F1;                //mapping to backward numbering
         int sb;                //atom type for disulfide crosslink
         int cC1;               //number of distance constraints
         tM3B2(){}
      };
      class tM3G2 { /*atoms in torsion-contracted chain forward groups [forward
                      order]*/
      public:
         int F1;                //mapping to backward numbering
         int b4;                //connectivity to base of forward torsion
         int sg;                //atom type for disulfide crosslink
         int cC1;               //number of distance constraints
         tM3G2(){}
      };
      class tM3E0 { /*sub-block pairs with interaction energy*/
      public:
         int Z0;                //chain
         int lam;               //sub-block index order
         int k;                 //terminal of connecting chain of torsions
         int Q3;                //forward sub-block
         int X2;                //backward sub-block
         int sse;               //disulfide crosslink
         tM3E0(){}
      };
      class tM3C1 { /*atom pairs with distance constraint with 2nd atom in
                      order of generation*/
      public:
         int Z0;                //chain
         int lam;               //atom index order
         int k;                 //terminal of connecting chain of torsions
         int F1a;               //atom index
         bool CYCLE;            //closes an intraresidue covalent cycle
         int W0;                //index of harmonic coefficient
         double a0;             //harmonic coeff (hartree)
         double d0;             //target distance (bohr)
         int F2a;               //atom index
         tM3C1(){}
      };
      class tM3F2 { /*atoms in atom-contracted chains [backward order]*/
      public:
         std::string atm;       //atom name
         int typ;               //atom type
         int hb;                //hydrogen bond type
         int lnk;               //index of backward atom of 1-2 atom pair
         int b4;                //connectivity to base of backward torsion
         int sf;                //atom type for disulfide crosslink
         int lte;               //largest L of atomic multipoles
         int lhb;               //maximum L of multipoles
         bool ion;              //contained in ionized group
         double off;            //charge overlay to dampen full charges
         Gaussian_Volume gau;   //volume density sqrt(hart/bohr**3)
         int mu;                //number of intersecting atoms
         int fac[3];            //intersecting atoms
         std::string wjnt;      //water site donor or acceptor
         Coordinates u;         //u0*[-1.0+tanh( u1*excluded_volume -u2)]
         Gaussian_Volume ef[4]; //elec field density sqrt(hart/bohr**3)
         int zet;               //charge
         Gaussian_Volume vf;    //volume density sqrt(1/bohr**3)
         int kap;               //low dielectric site
         int R0;                //mapping to set of residues
         tM3F2(){}
      };
      class tM3B3 { /*atoms in atom-contracted chain base groups [forward
                      order]*/
      public:
         int F2;                //mapping to backward numbering
         int sb;                //atom type for disulfide crosslink
         int cC1;               //number of distance constraints
         tM3B3(){}
      };
      class tM3G3 { /*atoms in atom-contracted chain forward groups [forward
                      order]*/
      public:
         int F2;                //mapping to backward numbering
         int b4;                //connectivity to base of forward torsion
         int sg;                //atom type for disulfide crosslink
         int cC1;               //number of distance constraints
         tM3G3(){}
      };
      class tM3H2 { /*atoms in backward groups of branch torsions [branch
                      backward order]*/
      public:
         int F2;                //mapping to backward numbering
         int b4;                //connectivity to base of sc backward torsion
         tM3H2(){}
      };
      class tM3Q3 { /*collections of groups [forward or base] forming
                      sub-residue fragments*/
      public:
         int Q1a;               //start index into forward groups
         int cQ1;               //number of forward groups
         int lte;               //largest L of forward sub-block multipoles
         tM3Q3(){}
      };
      class tM3X2 { /*collections of groups [backward] forming sub-residue
                      fragments*/
      public:
         int X1a;               //start index into backward groups
         int cX1;               //number of backward groups
         int lte;               //largest L of backward sub-block multipoles
         tM3X2(){}
      };
      class tM3E1 { /*sub-block pairs with interaction energy following
                      contraction*/
      public:
         int sse;               //disulfide crosslink
         int Z0;                //chain
         int lam;               //sub-block index order
         int k;                 //terminal of connecting chain of torsions
         int Q3;                //forward sub-block
         int X2;                //backward sub-block
         tM3E1(){}
      };
      class tM3B6 { /*base residues used in deformation screen*/
      public:
         int Z0;                //chain
         int R0;                //residue in chains
         int L0;                //residue in dataset
         tM3B6(){}
      };
      class tM3G6 { /*generated residues used in deformation screen*/
      public:
         int Z0;                //chain
         int R0;                //residue in chains
         int L0;                //residue in dataset
         tM3G6(){}
      };

   private:
      std::vector<bool> o_R0Q0sub;      //torsion rotation {t=free,f=rigid}
      std::vector<int> o_Y3R1;          //packing unit
      std::vector<int> o_R0N6F2;        //mapping {N ,CA,C ,H ,CB,O } to F2

   public:
      std::vector<int> o_S1N2Z0;        //mapping to chain
      std::vector<int> o_S1N2R0;        //mapping to residue
      /*group contribution to crosslink function*/
      std::vector<int> o_S1N2Q0sq;      //forward group
      std::vector<int> o_S1N2X0sx;      //backward group (offset by +1 torsion)
      /*atom types for disulfide bond crosslinking*/
      std::vector<int> o_S1N2F0sf;      //backward or prev added forward group
      std::vector<int> o_S1N2G0sg;      //newly added forward group
      std::vector<int> o_S1N2B0sb;      //newly added base group
      std::vector<int> o_B6N3F2;        //mapping {N ,CA,C } to F2
      std::vector<int> o_G6N3F2;        //mapping {N ,CA,C } to F2
      int oZ0;                  //
      int oR0;                  //
      int oQ1;                  //
      int oX1;                  //
      int oU1;                  //
      int oF1;                  //
      int oH1;                  //
      int oS1;                  //
      int oQ2;                  //
      int oB2;                  //
      int oG2;                  //
      int oE0;                  //
      int oC1;                  //
      int oF2;                  //
      int oB3;                  //
      int oG3;                  //
      int oH2;                  //
      int oQ3;                  //
      int oX2;                  //
      int oE1;                  //
      int oB6;                  //
      int oG6;                  //
      int oU2;                  //number of minimization degrees of freedom
      int oA5;                  //number of physical atoms

      std::string QSUB;         //name of subset of degrees of freedom
      int nY3;                  //number of side chains in a packing unit
      /*uncontracted sets*/
      std::vector<tM3Z0> Z0;    //chains in system of molecules
      std::vector<tM3R0> R0;    //residues
      std::vector<tM3Q1> Q1;    //torsions [forward order]
      std::vector<tM3X1> X1;    //torsions [backward order]
      std::vector<tM3U1> U1;    //side chain torsions [branch backward order]
      std::vector<tM3F1> F1;    //atoms [backward order]
      std::vector<tM3H1> H1;    //atoms in backward groups of branch torsions
      /*torsion-contracted sets*/
      std::vector<tM3S1> S1;    //disulfide bonds in system
      std::vector<tM3Q2> Q2;    //torsions [forward order]
      std::vector<tM3B2> B2;    //atoms in chain base groups [forward order]
      std::vector<tM3G2> G2;    //atoms in chain forward groups [forward order]
      std::vector<tM3E0> E0;    //sub-block pairs with interaction energy
      std::vector<tM3C1> C1;    //atom pairs with distance constraint
      /*atom-contracted sets*/
      std::vector<tM3F2> F2;    //atoms [backward order]
      std::vector<tM3B3> B3;    //atoms in chain base groups [forward order]
      std::vector<tM3G3> G3;    //atoms in chain forward groups [forward order]
      std::vector<tM3H2> H2;    //atoms in backward groups of branch torsions
      /*sub-residue fragments*/
      std::vector<tM3Q3> Q3;    //collections of groups [forward or base]
      std::vector<tM3X2> X2;    //collections of groups [backward]
      std::vector<tM3E1> E1;    //sub-block pairs with interaction energy
      /*triples of atoms used in deformation screen*/
      std::vector<tM3B6> B6;    //base residues
      std::vector<tM3G6> G6;    //generated residues

      void R0Q0sub(int i,int j,bool a){
         o_R0Q0sub[ i*16 +j]=a;
      }
      bool R0Q0sub(int i,int j) const {
         return o_R0Q0sub[ i*16 +j];
      }

      int& Y3R1(int i){
         return o_Y3R1.at( i);
      }
      int& R0N6F2(int i,int j){
         return o_R0N6F2.at( i*6 +j);
      }
      int& S1N2Z0(int i,int j){
         return o_S1N2Z0.at( i*2 +j);
      }
      int& S1N2R0(int i,int j){
         return o_S1N2R0.at( i*2 +j);
      }
      int& S1N2Q0sq(int i,int j,int k){
         return o_S1N2Q0sq.at( i*32 +j*16 +k);
      }
      int& S1N2X0sx(int i,int j,int k){
         return o_S1N2X0sx.at( i*32 +j*16 +k);
      }
      int& S1N2F0sf(int i,int j,int k){
         return o_S1N2F0sf.at( i*512 +j*256 +k);
      }
      int& S1N2G0sg(int i,int j,int k){
         return o_S1N2G0sg.at( i*512 +j*256 +k);
      }
      int& S1N2B0sb(int i,int j,int k){
         return o_S1N2B0sb.at( i*128 +j*64 +k);
      }
      int& B6N3F2(int i,int j){
         return o_B6N3F2.at( i*3 +j);
      }
      int& G6N3F2(int i,int j){
         return o_G6N3F2.at( i*3 +j);
      }

      const int& Y3R1(int i) const {
         return o_Y3R1.at( i);
      }
      const int& R0N6F2(int i,int j) const {
         return o_R0N6F2.at( i*6 +j);
      }
      const int& S1N2Z0(int i,int j) const {
         return o_S1N2Z0.at( i*2 +j);
      }
      const int& S1N2R0(int i,int j) const {
         return o_S1N2R0.at( i*2 +j);
      }
      const int& S1N2Q0sq(int i,int j,int k) const {
         return o_S1N2Q0sq.at( i*32 +j*16 +k);
      }
      const int& S1N2X0sx(int i,int j,int k) const {
         return o_S1N2X0sx.at( i*32 +j*16 +k);
      }
      const int& S1N2F0sf(int i,int j,int k) const {
         return o_S1N2F0sf.at( i*512 +j*256 +k);
      }
      const int& S1N2G0sg(int i,int j,int k) const {
         return o_S1N2G0sg.at( i*512 +j*256 +k);
      }
      const int& S1N2B0sb(int i,int j,int k) const {
         return o_S1N2B0sb.at( i*128 +j*64 +k);
      }
      const int& B6N3F2(int i,int j) const {
         return o_B6N3F2.at( i*3 +j);
      }
      const int& G6N3F2(int i,int j) const {
         return o_G6N3F2.at( i*3 +j);
      }

      tM3(int cZ0,int cR0,int cQ1,int cU1,int cF1,int cH1,int cQ2):
         o_R0Q0sub(cR0*16),
         o_Y3R1(12),
         o_R0N6F2(cR0*6,-1),
         oZ0(cZ0),
         oR0(cR0),
         oQ1(cQ1),
         oX1(cQ1),
         oU1(cU1),
         oF1(cF1),
         oH1(cH1),
         oQ2(cQ2),
         Z0(oZ0),
         R0(oR0),
         Q1(oQ1+1),
         X1(oX1),
         U1(oU1),
         F1(oF1),
         H1(oH1),
         Q2(oQ2+1)
      {
      }
   };

public:
   int nM3;                     //number
   std::vector<tM3> M3;         //set of subsets of degrees of freedom

   Subset_Contracted_System(const DAT_DISULFIDE_LINKS& disulfide_links,
                            const DAT_RESIDUE_MAPPINGS& residue_mappings,
                            const Thread_Options& opt,
                            const Structure& str,
                            const Search_Subspace& sub);
};

#endif
