#ifndef DEF_CON_AUTOMATIC
#define DEF_CON_AUTOMATIC

#include "../phi/Coordinates.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../phi/Scratch_Multipoles.hh"
#include "../phi/Spherical_Harmonics.hh"
#include <vector>

class Con_Automatic {
public:
   class tZ0 { /*chains in system of molecules*/
   public:
      int GENa;                 //start index into forward subgroups
      int cGEN;                 //number of forward subgroups
      tZ0(){}
   };
   class tQ1 { /*torsions in chains [forward order]*/
   public:
      Rotation_Matrix tu;       //t(chi about x-axis)u(lam about z-axis)
      int Q2;                   //map to forward variable torsion
      tQ1(){}
   };
   class tF1 { /*atoms in chains [backward order]*/
   public:
      Coordinates x;            //coords (bohr)
      Multipoles q;             //multipoles
      Multipoles p;             //polarizability site
      int F2;                   //mapping to atom-contracted set
      double v;                 //w site excluded volume (bohr**3)
      double fq;                //factor of chg decrease by dielec medium
      tF1(){}
   };
   class tG1 { /*atoms in chain forward groups [forward order]*/
   public:
      Coordinates b;            //untransformed coords (bohr)
      tG1(){}
   };
   class tH1 { /*atoms in chain backward groups of branch torsions [branch
                 backward order]*/
   public:
      int H2;                   //mapping to atom-contracted set
      tH1(){}
   };
   class tQ2 { /*torsions in torsion-contracted chains [forward order]*/
   public:
      bool cut;                 //include forward group interactions
      int Q1;                   //map to forward torsion
      int ORD;                  //map to order of generation
      tQ2(){}
   };
   class tGEN { /*generated groups*/
   public:
      int Q1;                   //map to forward torsion
      tGEN(){}
   };
   class tB2 { /*atoms in torsion-contracted chain base groups [forward
                 order]*/
   public:
      int B3;                   //mapping to atom-contracted set
      tB2(){}
   };
   class tG2 { /*atoms in torsion-contracted chain forward groups [forward
                 order]*/
   public:
      int G3;                   //mapping to atom-contracted set
      tG2(){}
   };
   class tE0 { /*sub-block pairs with interaction energy*/
   public:
      int imp;                  //contains a significant interaction
      tE0(){}
   };

public:
   double RRcut;                        //cutoff distance (bohr**2)
   double Ecut;                         //cutoff energy (hartree)
   std::vector<tZ0> Z0;                 //chains
   std::vector<tQ1> Q1;                 //torsions [forward order]
   std::vector<tF1> F1;                 //atoms [backward order]
   std::vector<tG1> G1;                 //atoms in forward groups
   std::vector<tH1> H1;                 //atoms in branch backward groups
   std::vector<tQ2> Q2;                 //torsions contracted [forward order]
   std::vector<tGEN> GEN;               //generated groups
   std::vector<tB2> B2;                 //atoms contracted in base groups
   std::vector<tG2> G2;                 //atoms contracted in forward groups
   std::vector<tE0> E0;                 //sub-block pairs with interact energy
   /*energy components*/
   double Fr;                           //repulsion +dispersion
   double Fe;                           //electrostatic
   double Fs;                           //disulfide bond
   double Fh;                           //hydrophobic
   Coordinates TRANS;                   //
   Rotation_Matrix ROT;                 //
   Rotation_Matrix PR[ 3];              //
   /*construction+destruction outside of inner loop*/
   Scratch_Multipoles q1;               //
   Scratch_Multipoles q2;               //
   Scratch_Multipoles QQ;               //
   Spherical_Harmonics H;               //

   Con_Automatic(int oZ0,int oQ1,int oF1,int oG1,int oH1,int oE0):
      Z0(oZ0),
      Q1(oQ1+1),
      F1(oF1),
      G1(oG1),
      H1(oH1),
      Q2(oQ1+1),
      GEN(oQ1),
      B2(oF1),
      G2(oG1),
      E0(oE0)
   {
   }
};

#endif
