#ifndef avp_Bridging_Header_h
#define avp_Bridging_Header_h

#import <simd/simd.h>

typedef struct {
  matrix_float4x4 modelMatrix;
  matrix_float4x4 viewMatrix;
  matrix_float4x4 projectionMatrix;
  matrix_float3x3 normalMatrix;
} Uniforms;

typedef enum {
  unused = 0,
  Sunlight = 1,
  Spotlight = 2,
  Pointlight = 3,
  Ambientlight = 4
} LightType;

typedef struct {
  vector_float3 position;  // for a sunlight, this is direction
  vector_float3 color;
  vector_float3 specularColor;
  float intensity;
  vector_float3 attenuation;
  LightType type;
  float coneAngle;
  vector_float3 coneDirection;
  float coneAttenuation;
} Light;

typedef struct {
  uint lightCount;
  vector_float3 cameraPosition;
  uint tiling;
} FragmentUniforms;

typedef enum {
  BufferIndexVertices = 0,
  BufferIndexUniforms = 11,
  BufferIndexLights = 12,
  BufferIndexFragmentUniforms = 13,
  BufferIndexMaterials = 14
} BufferIndices;

typedef enum {
  Position = 0,
  Normal = 1,
  UV = 2,
  Tangent = 3,
  Bitangent = 4,
  Color = 5,
  Joints = 6,
  Weights = 7
} Attributes;

typedef enum {
  BaseColorTexture = 0,
  NormalTexture = 1
} Textures;

struct Material {
  vector_float3 baseColor;
  vector_float3 specularColor;
  float roughness;
  float metalness;
  vector_float3 ambientOcclusion;
  float shininess;
};

#endif
