import SwiftUI

protocol ViewRepresentable: NSViewRepresentable {
  associatedtype ViewType = NSViewType
  func makeView(context: Context) -> ViewType
  func updateView(_ view: ViewType, context: Context)
}

extension ViewRepresentable {
  func makeNSView(context: Context) -> ViewType {
    makeView(context: context)
  }
  func updateNSView(_ nsView: ViewType, context: Context) {
    updateView(nsView, context: context)
  }
}
