import Foundation

class Tube {

   struct Vertex { /*vertex*/
      var x: (Double,Double,Double)     //position
      var c: (Double,Double,Double)     //normal to surface
      init() {
         x = ( 0.00, 0.00, 0.00)
         c = ( 0.00, 0.00, 0.00)
      }
   }
   struct Face { /*face*/
      var v: (Int,Int,Int)              //triple of vertex indexes
      init() {
         v = ( -1, -1, -1)
      }
   }
   struct Sphere { /*sphere*/
      var V: Array<Vertex>              //vertices
      var oV: Int                       //number
      var F: Array<Face>                //faces
      var oF: Int                       //number
      init() {
         oV = 42
         V = Array(repeating: Vertex(), count: oV)
         oF = 80
         F = Array(repeating: Face(), count: oF)
         let PI: Double = 3.141592653589790
//       let RAD: Double = 0.01745329251994328
//
//
// vertices, normals
//
         let dthe: Double = ( 0.504107211534508)
         let dphi: Double = ( 0.20) * PI
         V[ 0].x = ( 0.00, 0.00, 1.00)
         var the: Double = dthe
         var Cthe: Double = cos( the)
         var Sthe: Double = sin( the)
         var phi: Double = (-2.00) * dphi
         for jV: Int in  1..<6 {
            phi += ( 2.00) * dphi
            let Cphi: Double = cos( phi)
            let Sphi: Double = sin( phi)
            V[jV].x = ( Sthe * Cphi, Sthe * Sphi, Cthe)
         }
         the = ( 2.00) * dthe
         Cthe = cos( the)
         Sthe = sin( the)
         phi = -dphi
         for jV: Int in  6..<16 {
            phi += dphi
            let Cphi: Double = cos( phi)
            let Sphi: Double = sin( phi)
            V[jV].x = ( Sthe * Cphi, Sthe * Sphi, Cthe)
         }
         the = ( 0.50) * PI
         Cthe = cos( the)
         Sthe = sin( the)
         phi = (-0.50) * dphi
         for jV: Int in 16..<26 {
            phi += dphi
            let Cphi: Double = cos( phi)
            let Sphi: Double = sin( phi)
            V[jV].x = ( Sthe * Cphi, Sthe * Sphi, Cthe)
         }
         the = ( PI - ( 2.00) * dthe)
         Cthe = cos( the)
         Sthe = sin( the)
         phi = ( 0.00)
         for jV: Int in 26..<36 {
            phi += dphi
            let Cphi: Double = cos( phi)
            let Sphi: Double = sin( phi)
            V[jV].x = ( Sthe * Cphi, Sthe * Sphi, Cthe)
         }
         the = ( PI - dthe)
         Cthe = cos( the)
         Sthe = sin( the)
         phi = -dphi
         for jV: Int in 36..<41 {
            phi += ( 2.00) * dphi
            let Cphi: Double = cos( phi)
            let Sphi: Double = sin( phi)
            V[jV].x = ( Sthe * Cphi, Sthe * Sphi, Cthe)
         }
         V[41].x = ( 0.00, 0.00,-1.00)
         let r: Double = ( 0.05)
         for jV: Int in  0..<42 {
            V[jV].c = V[jV].x
            V[jV].x.0 *= r
            V[jV].x.1 *= r
            V[jV].x.2 *= r
         }
//
//
// faces
//
//                 0               |
//  1     2     3     4     5     1|
//  6  7  8  9 10 11 12 13 14 15  6|
// 16 17 18 19 20 21 22 23 24 25 16|
// 26 27 28 29 30 31 32 33 34 35 26|
// 36    37    38    39    40    36|
//                41               |
//
         F[ 0].v = (  0,  1,  2)
         F[ 1].v = (  0,  2,  3)
         F[ 2].v = (  0,  3,  4)
         F[ 3].v = (  0,  4,  5)
         F[ 4].v = (  0,  5,  1)
//
         F[ 5].v = (  1,  6,  7)
         F[ 6].v = (  1,  7,  2)
         F[ 7].v = (  2,  7,  8)
         F[ 8].v = (  2,  8,  9)
         F[ 9].v = (  2,  9,  3)
         F[10].v = (  3,  9, 10)
         F[11].v = (  3, 10, 11)
         F[12].v = (  3, 11,  4)
         F[13].v = (  4, 11, 12)
         F[14].v = (  4, 12, 13)
         F[15].v = (  4, 13,  5)
         F[16].v = (  5, 13, 14)
         F[17].v = (  5, 14, 15)
         F[18].v = (  5, 15,  1)
         F[19].v = (  1, 15,  6)
//
         F[20].v = (  6, 16,  7)
         F[21].v = (  7, 16, 17)
         F[22].v = (  7, 17,  8)
         F[23].v = (  8, 17, 18)
         F[24].v = (  8, 18,  9)
         F[25].v = (  9, 18, 19)
         F[26].v = (  9, 19, 10)
         F[27].v = ( 10, 19, 20)
         F[28].v = ( 10, 20, 11)
         F[29].v = ( 11, 20, 21)
         F[30].v = ( 11, 21, 12)
         F[31].v = ( 12, 21, 22)
         F[32].v = ( 12, 22, 13)
         F[33].v = ( 13, 22, 23)
         F[34].v = ( 13, 23, 14)
         F[35].v = ( 14, 23, 24)
         F[36].v = ( 14, 24, 15)
         F[37].v = ( 15, 24, 25)
         F[38].v = ( 15, 25,  6)
         F[39].v = (  6, 25, 16)
//
         F[40].v = ( 16, 26, 17)
         F[41].v = ( 17, 26, 27)
         F[42].v = ( 17, 27, 18)
         F[43].v = ( 18, 27, 28)
         F[44].v = ( 18, 28, 19)
         F[45].v = ( 19, 28, 29)
         F[46].v = ( 19, 29, 20)
         F[47].v = ( 20, 29, 30)
         F[48].v = ( 20, 30, 21)
         F[49].v = ( 21, 30, 31)
         F[50].v = ( 21, 31, 22)
         F[51].v = ( 22, 31, 32)
         F[52].v = ( 22, 32, 23)
         F[53].v = ( 23, 32, 33)
         F[54].v = ( 23, 33, 24)
         F[55].v = ( 24, 33, 34)
         F[56].v = ( 24, 34, 25)
         F[57].v = ( 25, 34, 35)
         F[58].v = ( 25, 35, 16)
         F[59].v = ( 16, 35, 26)
//
         F[60].v = ( 26, 36, 27)
         F[61].v = ( 27, 36, 37)
         F[62].v = ( 27, 37, 28)
         F[63].v = ( 28, 37, 29)
         F[64].v = ( 29, 37, 38)
         F[65].v = ( 29, 38, 30)
         F[66].v = ( 30, 38, 31)
         F[67].v = ( 31, 38, 39)
         F[68].v = ( 31, 39, 32)
         F[69].v = ( 32, 39, 33)
         F[70].v = ( 33, 39, 40)
         F[71].v = ( 33, 40, 34)
         F[72].v = ( 34, 40, 35)
         F[73].v = ( 35, 40, 36)
         F[74].v = ( 35, 36, 26)
//
         F[75].v = ( 36, 41, 37)
         F[76].v = ( 37, 41, 38)
         F[77].v = ( 38, 41, 39)
         F[78].v = ( 39, 41, 40)
         F[79].v = ( 40, 41, 36)
      }
   }
   struct Cylinder { /*cylinder*/
      var V: Array<Vertex>              //vertices
      var oV: Int                       //number
      var F: Array<Face>                //faces
      var oF: Int                       //number
      init() {
         oV = 20
         V = Array(repeating: Vertex(), count: oV)
         oF = 20
         F = Array(repeating: Face(), count: oF)
         let PI: Double = 3.141592653589790
//       let RAD: Double = 0.01745329251994328
//
//
// vertices, normals
//
         let r: Double = ( 0.05)
         let dphi: Double = ( 0.20) * PI
         var phi: Double = (-0.50) * dphi
         for jV: Int in  0..<10 {
            phi += dphi
            let Cphi: Double = cos( phi)
            let Sphi: Double = sin( phi)
            V[     jV].x = ( r * Cphi, r * Sphi, ( 0.00))
            V[     jV].c = ( Cphi, Sphi, ( 0.00))
            V[10 + jV].x = ( V[jV].x.0, V[jV].x.1, ( 1.00))
            V[10 + jV].c = V[jV].c
         }
//
//
// faces
//
         var pF: Int = 0
         for iV: Int in  0..<10 {
            let jV = (iV + 1) % 10
            F[pF    ].v = ( iV     , jV     , 10 + iV)
            F[pF + 1].v = ( 10 + jV, 10 + iV, jV)
            pF += 2
         }
      }
   }
   struct Material { /*material*/
      var V: Array<Vertex>              //vertices
      var oV: Int                       //number
      var F: Array<Face>                //faces
      var oF: Int                       //number
      var rgb: (Double,Double,Double)   //color
      var rfac: Double                  //scale factor for bond radius
      init(o: (Int,Int)) {
         oV = 0
         V = Array(repeating: Vertex(), count: o.0)
         oF = 0
         F = Array(repeating: Face(), count: o.1)
         rgb = ( 1.00, 1.00, 1.00)
         rfac = 1.00
      }
   }

   let sph = Sphere()                   //sphere
   let cyl = Cylinder()                 //cylinder
   var M: Array<Material> = []          //materials
   init(Mo: Array<(Int,Int)>) {
      for iM: Int in 0..<8 {
         M.append( Material(o: Mo[iM]))
         switch iM {
         case 0:  // backbone
            M[iM].rgb = ( 0.00, 1.00, 0.00)
         case 1:  // side_chain
            M[iM].rgb = ( 1.00, 0.80, 0.00)
         case 2:  // hb_donor
            M[iM].rgb = ( 0.00, 1.00, 1.00)
         case 3:  // neg_charge
            M[iM].rgb = ( 0.40, 0.15, 0.15)
            M[iM].rfac=( 3.00)
         case 4:  // pos_charge
            M[iM].rgb = ( 0.15, 0.15, 0.80)
            M[iM].rfac=( 3.00)
         case 5:  // disulfide
            M[iM].rgb = ( 1.00, 0.00, 0.00)
         case 6:  // phosphorothiate
            M[iM].rgb = ( 1.00, 0.60, 0.30)
         case 7:  // hb_dots
            M[iM].rgb = ( 1.00, 1.00, 1.00)
            M[iM].rfac=( 1.80)
         default:
            continue
         }
      }
   }

   func addbond(_ L: Bool,_ B: Bool,_ U: Bool,
                _ x0: Coordinates,
                _ x1: Coordinates,
                _ iM: Int) {
//
//
// translate +rotate +scale bond, accumulate to M
//
      let TRANS: Coordinates = x1
      var ROT: Rotation_Matrix = Rotation_Matrix()
      var x: Coordinates = Coordinates()
      var c: Coordinates = Coordinates()
      if(  B ){
         let n: Coordinates = ( x0 - x1)
         let d: Double = n.r()
         n.normalize()
         let Cbet: Double = n.x.2
         let Sbet: Double = sqrt( (1.00) - Cbet * Cbet)
         var Calp: Double ,Salp: Double
         if( Sbet > (1.00e-12) ){
            Calp = n.x.0/Sbet
            Salp = n.x.1/Sbet
         }else{
            Calp = (1.00)
            Salp = (0.00)
         }
         let alp: Double = atan2(Salp,Calp)
         let bet: Double = atan2(Sbet,Cbet)
         let gam: Double = -alp
         ROT = transpose(a: Rotation_Matrix(alp: alp,bet: bet,gam: gam))
         var oV: Int = M[iM].oV
         var pV: Int = oV
         var pF: Int = M[iM].oF
         for jV: Int in  0..<cyl.oV {
            x.x = cyl.V[jV].x
            x.x.0 *= M[iM].rfac
            x.x.1 *= M[iM].rfac
            x.x.2 *= d
            x = ( TRANS + (ROT * x))
            c.x = cyl.V[jV].c
            c = (ROT * c)
            M[iM].V[pV].x = x.x
            M[iM].V[pV].c = c.x
            pV += 1
         }
         for jF: Int in  0..<cyl.oF {
            M[iM].F[pF].v.0 = oV + cyl.F[jF].v.0
            M[iM].F[pF].v.1 = oV + cyl.F[jF].v.1
            M[iM].F[pF].v.2 = oV + cyl.F[jF].v.2
            pF += 1
         }
         if(  U ){
            oV += 20
            for jV: Int in  0..<26 {
               x.x = sph.V[jV].x
               x *= M[iM].rfac
               x.x.2 += d
               x = ( TRANS + (ROT * x))
               c.x = sph.V[jV].c
               c = (ROT * c)
               M[iM].V[pV].x = x.x
               M[iM].V[pV].c = c.x
               pV += 1
            }
            for jF: Int in  0..<40 {
               M[iM].F[pF].v.0 = oV + sph.F[jF].v.0
               M[iM].F[pF].v.1 = oV + sph.F[jF].v.1
               M[iM].F[pF].v.2 = oV + sph.F[jF].v.2
               pF += 1
            }
            if(  L ){
               for jV: Int in 16..<42 {
                  x.x = sph.V[jV].x
                  x *= M[iM].rfac
                  x = ( TRANS + (ROT *  x))
                  c.x = sph.V[jV].c
                  c = (ROT * c)
                  M[iM].V[pV].x = x.x
                  M[iM].V[pV].c = c.x
                  pV += 1
               }
               for jF: Int in 40..<80 {
                  M[iM].F[pF].v.0 = oV + sph.F[jF].v.0
                  M[iM].F[pF].v.1 = oV + sph.F[jF].v.1
                  M[iM].F[pF].v.2 = oV + sph.F[jF].v.2
                  pF += 1
               }
            }
         }
         M[iM].oV = pV
         M[iM].oF = pF

      }else{
         if(  L && U ){
            let oV: Int = M[iM].oV
            var pV: Int = oV
            var pF: Int = M[iM].oF
            for jV: Int in  0..<sph.oV {
               x.x = sph.V[jV].x
               x = ( TRANS + (M[iM].rfac * x))
               M[iM].V[pV].x = x.x
               M[iM].V[pV].c = sph.V[jV].c
               pV += 1
            }
            for jF: Int in  0..<sph.oF {
               M[iM].F[pF].v.0 = oV + sph.F[jF].v.0
               M[iM].F[pF].v.1 = oV + sph.F[jF].v.1
               M[iM].F[pF].v.2 = oV + sph.F[jF].v.2
               pF += 1
            }
            M[iM].oV = pV
            M[iM].oF = pF
         }

      }
   }

}
