import Foundation

class Rotation_Matrix {
   var row0: (Double,Double,Double)    //row 0
   var row1: (Double,Double,Double)    //row 1
   var row2: (Double,Double,Double)    //row 2

   init() { 
      row0 = ( 1.00, 0.00, 0.00)
      row1 = ( 0.00, 1.00, 0.00)
      row2 = ( 0.00, 0.00, 1.00)
   }
//
// construct
// P(alp,bet,gam)= rotation of bases by euler angles
// rotatedbasis(j)=P(i,j)initialbasis(i)
// rotatedcoords(i)=Ptranspose(i,j)initialcoords(j)
// p=Ptranspose
//
   init(alp: Double,bet: Double,gam: Double) {
      let Calp: Double = cos( alp)
      let Salp: Double = sin( alp)
      let Cbet: Double = cos( bet)
      let Sbet: Double = sin( bet)
      let Cgam: Double = cos( gam)
      let Sgam: Double = sin( gam)
      row0 = (  Calp * Cbet * Cgam - Salp * Sgam,
                Salp * Cbet * Cgam + Calp * Sgam,
               -Sbet * Cgam)
      row1 = ( -Calp * Cbet * Sgam - Salp * Cgam,
               -Salp * Cbet * Sgam + Calp * Cgam,
                Sbet * Sgam)
      row2 = (  Calp * Sbet,
                Salp * Sbet,
                Cbet)
   }

   init(euler: (Float, Float, Float)) {
      let alp: Double = Double( euler.0)
      let bet: Double = Double( euler.1)
      let gam: Double = Double( euler.2)
      let Calp: Double = cos( alp)
      let Salp: Double = sin( alp)
      let Cbet: Double = cos( bet)
      let Sbet: Double = sin( bet)
      let Cgam: Double = cos( gam)
      let Sgam: Double = sin( gam)
      row0 = (  Calp * Cbet * Cgam - Salp * Sgam,
                Salp * Cbet * Cgam + Calp * Sgam,
               -Sbet * Cgam)
      row1 = ( -Calp * Cbet * Sgam - Salp * Cgam,
               -Salp * Cbet * Sgam + Calp * Cgam,
                Sbet * Sgam)
      row2 = (  Calp * Sbet,
                Salp * Sbet,
                Cbet)
   }

   init(_ a: (Float, Float, Float)) { 
      let alp: Double = Double( a.0)
      let bet: Double = Double( a.1)
      let gam: Double = Double( a.2)
      let Calp: Double = cos( alp)
      let Salp: Double = sin( alp)
      let Cbet: Double = cos( bet)
      let Sbet: Double = sin( bet)
      let Cgam: Double = cos( gam)
      let Sgam: Double = sin( gam)
      row0 = (  Cbet * Cgam,
               -Cbet * Sgam,
                Sbet)
      row1 = (  Salp * Sbet * Cgam + Calp * Sgam,
               -Salp * Sbet * Sgam + Calp * Cgam,
               -Salp * Cbet)
      row2 = ( -Calp * Sbet * Cgam + Salp * Sgam,
                Calp * Sbet * Sgam + Salp * Cgam,
                Calp * Cbet)
   }
//
//
// euler angles
//
   func euler() -> (Float,Float,Float) {
      let Cbet: Double = row2.2
      var zz: Double = ( (1.00) - Cbet * Cbet)
      if( zz < ( 1.00e-25) ){ zz = ( 1.00e-25) }
      let Sbet: Double = sqrt( zz)
      let bet: Double = atan2(Sbet,Cbet)
      var alp: Double, gam: Double
      if( Sbet < ( 1.00e-12) ){
         gam = (0.00)
         var Calp: Double, Salp: Double
         if( Cbet > (0.00) ){
            Calp = row0.0
            Salp = row0.1
         }else{
            Calp = -row0.0
            Salp = -row0.1
         }
         alp = atan2(Salp,Calp)
      }else{
         let Calp: Double = ( row2.0 / Sbet)
         let Salp: Double = ( row2.1 / Sbet)
         alp = atan2(Salp,Calp)
         let Cgam: Double = (-row0.2 / Sbet)
         let Sgam: Double = ( row1.2 / Sbet)
         gam = atan2(Sgam,Cgam)
      }
      let x: (Float,Float,Float) = (  Float( alp), Float( bet), Float( gam))
      return x
   }

   static func *= (left: inout Rotation_Matrix,
                   a: Double) {
      left.row0.0 *= a
      left.row0.1 *= a
      left.row0.2 *= a
      left.row1.0 *= a
      left.row1.1 *= a
      left.row1.2 *= a
      left.row2.0 *= a
      left.row2.1 *= a
      left.row2.2 *= a
   }

   func identity() {
      row0 = ( 1.00, 0.00, 0.00)
      row1 = ( 0.00, 1.00, 0.00)
      row2 = ( 0.00, 0.00, 1.00)
   }
}
//
//
// global operators
//
func * (a: Double,
        b: Rotation_Matrix) -> Rotation_Matrix {
   let t: Rotation_Matrix = Rotation_Matrix()
   t.row0.0 = a * b.row0.0
   t.row0.1 = a * b.row0.1
   t.row0.2 = a * b.row0.2
   t.row1.0 = a * b.row1.0
   t.row1.1 = a * b.row1.1
   t.row1.2 = a * b.row1.2
   t.row2.0 = a * b.row2.0
   t.row2.1 = a * b.row2.1
   t.row2.2 = a * b.row2.2
   return t
}
func * (a: Rotation_Matrix,
        b: Rotation_Matrix) -> Rotation_Matrix {
   let t: Rotation_Matrix = Rotation_Matrix()
   t.row0.0 = a.row0.0 * b.row0.0 + a.row0.1 * b.row1.0 + a.row0.2 * b.row2.0
   t.row0.1 = a.row0.0 * b.row0.1 + a.row0.1 * b.row1.1 + a.row0.2 * b.row2.1
   t.row0.2 = a.row0.0 * b.row0.2 + a.row0.1 * b.row1.2 + a.row0.2 * b.row2.2
   t.row1.0 = a.row1.0 * b.row0.0 + a.row1.1 * b.row1.0 + a.row1.2 * b.row2.0
   t.row1.1 = a.row1.0 * b.row0.1 + a.row1.1 * b.row1.1 + a.row1.2 * b.row2.1
   t.row1.2 = a.row1.0 * b.row0.2 + a.row1.1 * b.row1.2 + a.row1.2 * b.row2.2
   t.row2.0 = a.row2.0 * b.row0.0 + a.row2.1 * b.row1.0 + a.row2.2 * b.row2.0
   t.row2.1 = a.row2.0 * b.row0.1 + a.row2.1 * b.row1.1 + a.row2.2 * b.row2.1
   t.row2.2 = a.row2.0 * b.row0.2 + a.row2.1 * b.row1.2 + a.row2.2 * b.row2.2
   return t
}
//
//
// global functions
//
func transpose(a: Rotation_Matrix) -> Rotation_Matrix {
   let t: Rotation_Matrix = Rotation_Matrix()
   t.row0.0 = a.row0.0
   t.row0.1 = a.row1.0
   t.row0.2 = a.row2.0
   t.row1.0 = a.row0.1
   t.row1.1 = a.row1.1
   t.row1.2 = a.row2.1
   t.row2.0 = a.row0.2
   t.row2.1 = a.row1.2
   t.row2.2 = a.row2.2
   return t
}
