import Foundation

class ResidueMappings {

   struct tL0 { /*residue in dataset*/
      var aa: String            //4 char residue name
      var c1: Character         //1 char class name
      var P0a: Int              //start indexes into set
      var cP0: Int              //numbers of set elements
      init() {
         aa = ""
         c1 = "a"
         P0a = -1
         cP0 = -1
      }
   }
   struct tP0 { /*physical atom in residues [iupac order]*/
      var atm: String           //4 char atom name
      var typ: Int              //atom type
      var L: Bool               //render lower hemisphere
      var B: Bool               //render cylinder
      var U: Bool               //render upper hemisphere
      var atm1: String          //4 char connected atom name
      var grp1: Int             //residue offset
      var M: Int                //color
      init() {
         atm = ""
         typ = -1
         L = false
         B = false
         U = false
         atm1 = ""
         grp1 = -1
         M = -1
      }
   }

   var nL0: Int                 //number of residues in dataset
   var L0: Array<tL0>           //set of residues
   var P0: Array<tP0>           //set of atoms

   func iresidue(aa: String) -> Int {
      for jL0: Int in  0..<nL0 {
         if( L0[jL0].aa == aa ){
            return jL0;
         }
      }
      return -1;
   }
   func ip0atom(iL0: Int, atm: String) -> Int {
      let mP0: Int = L0[iL0].P0a
      let nP0: Int = ( mP0 - 1 + L0[iL0].cP0)
      for iP0: Int in mP0...nP0 {
         if( P0[iP0].atm == atm ){
            return iP0;
         }
      }
      return -1;
   }

   init() {
      nL0 = 136
      L0 = Array(repeating: tL0(), count:  nL0)
      P0 = Array(repeating: tP0(), count: 2127)
      var rec: String
      var p: Int
      var i: String.Index
      var j: String.Index
//
//
// read residue data
//
      let url: URL? = Bundle.main.url(forResource: "Models/mappings", withExtension: "txt")
      if( url == nil ) {
         print("ERROR: File mappings.txt not found.")
         exit( 1)
      }
      var Lrec: Array<String> = []
      do {
         let data: Data = try Data(contentsOf: url!)
         let contents: String? = String(data: data, encoding: .utf8)
         if( contents == nil ) {
            print("ERROR: Failure reading file mappings.txt.")
            exit( 1)
         }
         Lrec = contents!.components(separatedBy: "\n") as [String]
      } catch {
         print("ERROR: Failure reading file mappings.txt.")
         exit( 1)
      }
//
//
// populate instance of ResidueMappings
//
      p = 3
      let message: String = "ERROR: data inconsistency, FILE= mappings, LINE="
      var jP0: Int = 0
      for iL0: Int in  0..<nL0 {
         L0[iL0].P0a = jP0
         rec = Lrec[ p]
         i = rec.index(rec.startIndex, offsetBy:  5)
         j = rec.index(i,offsetBy:  4)
         L0[iL0].aa = String( rec[i..<j])
         i = rec.index(rec.startIndex, offsetBy: 11)
         L0[iL0].c1 = rec[i]
         i = rec.index(rec.startIndex, offsetBy: 12)
         j = rec.index(i,offsetBy:  4)
         L0[iL0].cP0 = Int( rec[i..<j].trim())!
         jP0 += L0[iL0].cP0
         p += 1
      }
      p += 2
      for iL0: Int in  0..<nL0 {
         let mP0: Int = L0[iL0].P0a
         let nP0: Int = ( mP0 - 1 + L0[iL0].cP0)
         let n: Int = ( L0[iL0].cP0 + 15) / 16
         rec = ""
         for _: Int in  0..<n {
            i = Lrec[ p].startIndex
            j = Lrec[ p].index(i, offsetBy: 80)
            rec += String( Lrec[ p][i..<j])
            p += 1
         }
         j = rec.startIndex
         for iP0: Int in mP0...nP0 {
            i = rec.index(j, offsetBy:  1)
            j = rec.index(i, offsetBy:  4)
            P0[iP0].atm = String( rec[i..<j])
         }
      }
      p += 2
      for iL0: Int in  0..<nL0 {
         let mP0: Int = L0[iL0].P0a
         let nP0: Int = ( mP0 - 1 + L0[iL0].cP0)
         i = Lrec[ p].startIndex
         j = Lrec[ p].index(i, offsetBy: 78)
         rec = String( Lrec[ p][i..<j])
         i = rec.startIndex
         for iP0: Int in mP0...nP0 {
            j = rec.index(i, offsetBy:  3)
            P0[iP0].typ = Int( rec[i..<j].trim())!
            i = j
         }
         p += 1
      }
      p += 2
      for iL0: Int in  0..<nL0 {
         let mP0: Int = L0[iL0].P0a
         let nP0: Int = ( mP0 - 1 + L0[iL0].cP0)
         i = Lrec[ p].index(Lrec[ p].startIndex,offsetBy:  1)
         j = Lrec[ p].index(i, offsetBy:  4)
         let aa: String = String( Lrec[ p][i..<j])
         if( aa != L0[iL0].aa ){
            print(message + String( p))
            exit( 1)
         }
         p += 1
         for iP0: Int in mP0...nP0 {
            i = Lrec[ p].startIndex
            j = Lrec[ p].index(i, offsetBy: 21)
            rec = String( Lrec[ p][i..<j])
            i = rec.index(rec.startIndex, offsetBy:  5)
            j = rec.index(i, offsetBy:  4)
            let atm: String = String( rec[i..<j])
            if( atm != P0[iP0].atm ){
               print(message + String( p))
               exit( 1)
            }
            i = rec.index(rec.startIndex,offsetBy:  1)
            P0[iP0].L = ( rec[ i] == Character( "1") )
            j = rec.index(i,offsetBy:  1)
            P0[iP0].B = ( rec[ j] == Character( "1") )
            j = rec.index(i,offsetBy:  2)
            P0[iP0].U = ( rec[ j] == Character( "1") )
            if( P0[iP0].B ){
               i = rec.index(rec.startIndex, offsetBy: 13)
               j = rec.index(i,offsetBy:  4)
               P0[iP0].atm1 = String( rec[i..<j])
               i = rec.index(rec.startIndex, offsetBy: 10)
               j = rec.index(i,offsetBy:  2)
               P0[iP0].grp1 = Int( rec[i..<j].trim())!
            }
            i = rec.index(rec.startIndex, offsetBy: 18)
            j = rec.index(i,offsetBy:  3)
            P0[iP0].M = Int( rec[i..<j].trim())!
            p += 1
         }
      }
   }
}

extension Substring {
   func trim() -> String {
      return self.trimmingCharacters(in: CharacterSet.whitespaces)
   }
}
