import MetalKit

func lighting() -> [Light] {
  var lights: [Light] = []

  var light = buildDefaultLight()
  light.position = [ 0.0, 0.0, 2.0]
  light.intensity = 0.50
  lights.append(light)

  light = buildDefaultLight()
  light.position = [-1.5, 0.0, 2.0]
  light.intensity = 0.25
  lights.append(light)

  light = buildDefaultLight()
  light.position = [ 1.5, 0.0, 2.0]
  light.intensity = 0.25
  lights.append(light)

  light = buildDefaultLight()
  light.position = [ 0.0,-1.5, 2.0]
  light.intensity = 0.25
  lights.append(light)

  light = buildDefaultLight()
  light.position = [ 0.0, 1.5, 2.0]
  light.intensity = 0.25
  lights.append(light)

//  light = buildDefaultLight()
//  light.position = [ 0.0, 0.0,-2.0]
//  light.intensity = 0.2
//  lights.append(light)

  light = buildDefaultLight()
  light.intensity = 0.1
  light.type = Ambientlight
  lights.append(light)

  return lights
}

func buildDefaultLight() -> Light {
  var light = Light()
  light.position = [ 0.0, 0.0, 0.0]
  light.color = [ 1, 1, 1]
  light.specularColor = [ 0.6, 0.6, 0.6]
  light.intensity = 1.0
  light.attenuation = SIMD3<Float>( 1, 0, 0)
  light.type = Sunlight
  return light
}
