import SwiftUI
import MetalKit

class Node {

  var name: String = "untitled"
  var position: (Float,Float,Float) = ( 0, 0, 0)
  var quadx: Float = ( 0.00)
  var quady: Float = ( 0.00)
  var rotation: (Float,Float,Float) = ( 0, 0, 0)
  var scale: (Float,Float,Float) = ( 1, 1, 1)
  var modelMatrix: float4x4 {
    let translateMatrix = float4x4(translation: ( position.0 + quadx, position.1 + quady,
                                                  position.2))
//    let rotateMatrix = float4x4(quaternion)
    let rotateMatrix = float4x4(euler: rotation)
    let scaleMatrix = float4x4(scaling: scale)
    return translateMatrix * rotateMatrix * scaleMatrix
  }

  func update(deltaTime: Float) {
    // override this
  }

  var parent: Node?
  var children: [Node] = []

  final func add(childNode: Node) {
    children.append(childNode)
    childNode.parent = self
  }

  final func remove(childNode: Node) {
    for child in childNode.children {
      child.parent = self
      children.append(child)
    }
    childNode.children = []
    guard
      let index = (children.firstIndex { $0 === childNode })
    else { return }
    children.remove(at: index)
  }

  var worldTransform: float4x4 {
    if let parent = parent {
      return parent.worldTransform * self.modelMatrix
    }
    return modelMatrix
  }

}
