import SwiftUI
import Foundation

class MoleculeScene: BaseScene {

  var eregPath: String
  @Binding var quad: Int
  var mol00: String
  var mol01: String
  var mol10: String
  var mol11: String
  @Binding var vis00: Bool
  @Binding var vis01: Bool
  @Binding var vis10: Bool
  @Binding var vis11: Bool
  @Binding var mov00: Bool
  @Binding var mov01: Bool
  @Binding var mov10: Bool
  @Binding var mov11: Bool
  @Binding var p00: (Float, Float, Float)
  @Binding var p01: (Float, Float, Float)
  @Binding var p10: (Float, Float, Float)
  @Binding var p11: (Float, Float, Float)
  @Binding var r00: (Float, Float, Float)
  @Binding var r01: (Float, Float, Float)
  @Binding var r10: (Float, Float, Float)
  @Binding var r11: (Float, Float, Float)
  @Binding var s00: Float
  @Binding var s01: Float
  @Binding var s10: Float
  @Binding var s11: Float

  var tub00: Prop?
  var tub01: Prop?
  var tub10: Prop?
  var tub11: Prop?

  init(sceneSize: CGSize,
       _ eregPath: String,
       _ quad: Binding<Int>,
       _ mol00: String,
       _ mol01: String,
       _ mol10: String,
       _ mol11: String,
       _ vis00: Binding<Bool>,
       _ vis01: Binding<Bool>,
       _ vis10: Binding<Bool>,
       _ vis11: Binding<Bool>,
       _ mov00: Binding<Bool>,
       _ mov01: Binding<Bool>,
       _ mov10: Binding<Bool>,
       _ mov11: Binding<Bool>,
       _ p00: Binding<(Float, Float, Float)>,
       _ p01: Binding<(Float, Float, Float)>,
       _ p10: Binding<(Float, Float, Float)>,
       _ p11: Binding<(Float, Float, Float)>,
       _ r00: Binding<(Float, Float, Float)>,
       _ r01: Binding<(Float, Float, Float)>,
       _ r10: Binding<(Float, Float, Float)>,
       _ r11: Binding<(Float, Float, Float)>,
       _ s00: Binding<Float>,
       _ s01: Binding<Float>,
       _ s10: Binding<Float>,
       _ s11: Binding<Float> ){
    
    self.eregPath = eregPath
    self._quad = quad
    self.mol00 = mol00
    self.mol01 = mol01
    self.mol10 = mol10
    self.mol11 = mol11
    self._vis00 = vis00
    self._vis01 = vis01
    self._vis10 = vis10
    self._vis11 = vis11
    self._mov00 = mov00
    self._mov01 = mov01
    self._mov10 = mov10
    self._mov11 = mov11
    self._p00 = p00
    self._p01 = p01
    self._p10 = p10
    self._p11 = p11
    self._r00 = r00
    self._r01 = r01
    self._r10 = r10
    self._r11 = r11
    self._s00 = s00
    self._s01 = s01
    self._s10 = s10
    self._s11 = s11
    super.init(sceneSize: sceneSize)
  }

  override func setupScene() {
    camera.position = ( 0.0, 0.0,-4)
    if( mol00 != "" ) {
      tub00 = Prop(eregPath: eregPath, name: mol00, vis: vis00, mov: mov00)
    }
    if( mol01 != "" ) {
      tub01 = Prop(eregPath: eregPath, name: mol01, vis: vis01, mov: mov01)
    }
    if( mol10 != "" ) {
      tub10 = Prop(eregPath: eregPath, name: mol10, vis: vis10, mov: mov10)
    }
    if( mol11 != "" ) {
      tub11 = Prop(eregPath: eregPath, name: mol11, vis: vis11, mov: mov11)
    }
    renderables = []
    inputController.player = []
    if let tub00 = tub00 {
      tub00.position = p00
      tub00.rotation = r00
      tub00.scale = ( s00, s00, s00)
      add(node: tub00)
      if( vis00 ){
        renderables.append(tub00)
      }
      if( mov00 ){
        inputController.player.append( tub00)
      }
    }
    if let tub01 = tub01 {
      tub01.position = p01
      tub01.rotation = r01
      tub01.scale = ( s01, s01, s01)
      add(node: tub01)
      if( vis01 ){
        renderables.append(tub01)
      }
      if( mov01 ){
        inputController.player.append( tub01)
      }
    }
    if let tub10 = tub10 {
      tub10.position = p10
      tub10.rotation = r10
      tub10.scale = ( s10, s10, s10)
      add(node: tub10)
      if( vis10 ){
        renderables.append(tub10)
      }
      if( mov10 ){
        inputController.player.append( tub10)
      }
    }
    if let tub11 = tub11 {
      tub11.position = p11
      tub11.rotation = r11
      tub11.scale = ( s11, s11, s11)
      add(node: tub11)
      if( vis11 ){
        renderables.append(tub11)
      }
      if( mov11 ){
        inputController.player.append( tub11)
      }
    }
  }

  override func updateScene(deltaTime: Float) {
    renderables = []
    inputController.player = []
    if let tub00 = tub00 {
      p00 = tub00.position
      r00 = tub00.rotation
      s00 = tub00.scale.0
      tub00.VIS = vis00
      tub00.MOV = mov00
      add(node: tub00)
      if( vis00 ){
        renderables.append(tub00)
      }
      if( mov00 ){
        inputController.player.append( tub00)
      }
      if      ( quad == 1 ){
        tub00.quadx = ( 0.00)
        tub00.quady = ( 0.00)
      }else if( quad == 2 ){
        tub00.quadx = (-2.00)
        tub00.quady = ( 0.00)
      }else if( quad == 4 ){
        tub00.quadx = (-2.00)
        tub00.quady = (-0.90)
      }
    }
    if let tub01 = tub01 {
      p01 = tub01.position
      r01 = tub01.rotation
      s01 = tub01.scale.0
      tub01.VIS = vis01
      tub01.MOV = mov01
      add(node: tub01)
      if( vis01 ){
        renderables.append(tub01)
      }
      if( mov01 ){
        inputController.player.append( tub01)
      }
      if      ( quad == 1 ){
        tub01.quadx = ( 0.00)
        tub01.quady = ( 0.00)
      }else if( quad == 2 ){
        tub01.quadx = (-2.00)
        tub01.quady = ( 0.00)
      }else if( quad == 4 ){
        tub01.quadx = (-2.00)
        tub01.quady = ( 1.10)
      }
    }
    if let tub10 = tub10 {
      p10 = tub10.position
      r10 = tub10.rotation
      s10 = tub10.scale.0
      tub10.VIS = vis10
      tub10.MOV = mov10
      add(node: tub10)
      if( vis10 ){
        renderables.append(tub10)
      }
      if( mov10 ){
        inputController.player.append( tub10)
      }
      if      ( quad == 1 ){
        tub10.quadx = ( 0.00)
        tub10.quady = ( 0.00)
      }else if( quad == 2 ){
        tub10.quadx = ( 2.00)
        tub10.quady = ( 0.00)
      }else if( quad == 4 ){
        tub10.quadx = ( 2.00)
        tub10.quady = (-0.90)
      }
    }
    if let tub11 = tub11 {
      p11 = tub11.position
      r11 = tub11.rotation
      s11 = tub11.scale.0
      tub11.VIS = vis11
      tub11.MOV = mov11
      add(node: tub11)
      if( vis11 ){
        renderables.append(tub11)
      }
      if( mov11 ){
        inputController.player.append( tub11)
      }
      if      ( quad == 1 ){
        tub11.quadx = ( 0.00)
        tub11.quady = ( 0.00)
      }else if( quad == 2 ){
        tub11.quadx = ( 2.00)
        tub11.quady = ( 0.00)
      }else if( quad == 4 ){
        tub11.quadx = ( 2.00)
        tub11.quady = ( 1.10)
      }
    }
  }
}
