import SwiftUI
import MetalKit

struct MetalView: ViewRepresentable {

  var renderer: Renderer
  var eregPath: String
  @Binding var quad: Int
  var mol00: String
  var mol01: String
  var mol10: String
  var mol11: String
  @Binding var vis00: Bool
  @Binding var vis01: Bool
  @Binding var vis10: Bool
  @Binding var vis11: Bool
  @Binding var mov00: Bool
  @Binding var mov01: Bool
  @Binding var mov10: Bool
  @Binding var mov11: Bool
  @Binding var p00: (Float, Float, Float)
  @Binding var p01: (Float, Float, Float)
  @Binding var p10: (Float, Float, Float)
  @Binding var p11: (Float, Float, Float)
  @Binding var r00: (Float, Float, Float)
  @Binding var r01: (Float, Float, Float)
  @Binding var r10: (Float, Float, Float)
  @Binding var r11: (Float, Float, Float)
  @Binding var s00: Float
  @Binding var s01: Float
  @Binding var s10: Float
  @Binding var s11: Float

  init(_ renderer: Renderer,
       _ eregPath: String,
       _ quad: Binding<Int>,
       _ mol00: String,
       _ mol01: String,
       _ mol10: String,
       _ mol11: String,
       _ vis00: Binding<Bool>,
       _ vis01: Binding<Bool>,
       _ vis10: Binding<Bool>,
       _ vis11: Binding<Bool>,
       _ mov00: Binding<Bool>,
       _ mov01: Binding<Bool>,
       _ mov10: Binding<Bool>,
       _ mov11: Binding<Bool>,
       _ p00: Binding<(Float, Float, Float)>,
       _ p01: Binding<(Float, Float, Float)>,
       _ p10: Binding<(Float, Float, Float)>,
       _ p11: Binding<(Float, Float, Float)>,
       _ r00: Binding<(Float, Float, Float)>,
       _ r01: Binding<(Float, Float, Float)>,
       _ r10: Binding<(Float, Float, Float)>,
       _ r11: Binding<(Float, Float, Float)>,
       _ s00: Binding<Float>,
       _ s01: Binding<Float>,
       _ s10: Binding<Float>,
       _ s11: Binding<Float> ){

    self.renderer = renderer
    self.eregPath = eregPath
    self._quad = quad
    self.mol00 = mol00
    self.mol01 = mol01
    self.mol10 = mol10
    self.mol11 = mol11
    self._vis00 = vis00
    self._vis01 = vis01
    self._vis10 = vis10
    self._vis11 = vis11
    self._mov00 = mov00
    self._mov01 = mov01
    self._mov10 = mov10
    self._mov11 = mov11
    self._p00 = p00
    self._p01 = p01
    self._p10 = p10
    self._p11 = p11
    self._r00 = r00
    self._r01 = r01
    self._r10 = r10
    self._r11 = r11
    self._s00 = s00
    self._s01 = s01
    self._s10 = s10
    self._s11 = s11
  }

  func makeView(context: Context) -> MTKView {
    let metalView = GameView(frame: .zero, device: Renderer.device)
    metalView.device = Renderer.device
    metalView.depthStencilPixelFormat = .depth32Float
    metalView.clearColor = MTLClearColor(red: 0.0, green: 0.0, blue: 0.0, alpha: 1)
    metalView.delegate = renderer
    Renderer.colorPixelFormat = metalView.colorPixelFormat
    let scene = MoleculeScene(sceneSize: metalView.bounds.size,
                              eregPath,
                              $quad,
                              mol00, mol01, mol10, mol11,
                              $vis00, $vis01, $vis10, $vis11,
                              $mov00, $mov01, $mov10, $mov11,
                              $p00, $p01, $p10, $p11,
                              $r00, $r01, $r10, $r11,
                              $s00, $s01, $s10, $s11)
    renderer.scene = scene
    metalView.inputController = scene.inputController
    return metalView
  }

  func updateView(_ view: MTKView, context: Context) {
    view.delegate = renderer
  }
}
