import SwiftUI
import Foundation

struct LabelView: View {

  @Binding var p: (Float, Float, Float)
  @Binding var r: (Float, Float, Float)
  @Binding var s: Float
  @Binding var rlab: Bool
  var reslabs: Array<ResLab>
  @Binding var alab: Bool
  var atmlabs: Array<AtmLab>

  init(_ p: Binding<(Float, Float, Float)>,
       _ r: Binding<(Float, Float, Float)>,
       _ s: Binding<Float>,
       _ rlab: Binding<Bool>,
       _ reslabs: Array<ResLab>,
       _ alab: Binding<Bool>,
       _ atmlabs: Array<AtmLab> ){
    self._p = p
    self._r = r
    self._s = s
    self._rlab = rlab
    self.reslabs = reslabs
    self._alab = alab
    self.atmlabs = atmlabs
//    print("LabelView init")
  }

  var body: some View {

    if( rlab ){
      let RAD: Double = 0.01745329251994328
      let the: Double = RAD*(  35.00)
      let Cthe: Double = cos( the)
      let Sthe: Double = sin( the)
      let TRANS: Coordinates = Coordinates( p)
      let CAM: Coordinates = Coordinates( ( 0.0, 0.0, 4.0))
      let ROT: Rotation_Matrix = Rotation_Matrix(euler: r)
      let scale: Double = Double( s)

      ForEach( reslabs ) { label in
        let rec: String = label.rec
//
//
// translate, rotate, scale, project coordinates
//
        let x_0: Coordinates = Coordinates( (label.x, label.y, label.z))
        let x_1: Coordinates = TRANS + CAM + ROT * (scale * x_0)
        let x_2: Coordinates = Coordinates(x_1.x, Cthe, Sthe)
//
//
// add residue label
//
        Text(rec)
        .foregroundColor(.white)
        .position(x: CGFloat( x_2.x.0), y: CGFloat( x_2.x.1))
      }
    }
    if( alab ){
      let RAD: Double = 0.01745329251994328
      let the: Double = RAD*(  35.00)
      let Cthe: Double = cos( the)
      let Sthe: Double = sin( the)
      let TRANS: Coordinates = Coordinates( p)
      let CAM: Coordinates = Coordinates( ( 0.0, 0.0, 4.0))
      let ROT: Rotation_Matrix = Rotation_Matrix(euler: r)
      let scale: Double = Double( s)

      ForEach( atmlabs ) { label in
        let atm: String = label.atm
//
//
// translate, rotate, scale, project coordinates
//
        let x_0: Coordinates = Coordinates( (label.x, label.y, label.z))
        let x_1: Coordinates = TRANS + CAM + ROT * (scale * x_0)
        let x_2: Coordinates = Coordinates(x_1.x, Cthe, Sthe)
//
//
// add residue label
//
        Text(atm)
        .foregroundColor(.white)
        .position(x: CGFloat( x_2.x.0), y: CGFloat( x_2.x.1))
      }
    }
  }
}
