import Cocoa
import simd

//protocol KeyboardDelegate {
//  func keyPressed(key: KeyboardControl,
//                  state: InputState) -> Bool
//}
//protocol MouseDelegate {
//  func mouseEvent(mouse: MouseControl,
//                  state: InputState,
//                  delta: SIMD3<Float>,
//                  location: SIMD2<Float>)
//}

class InputController {
//var keyboardDelegate: KeyboardDelegate?
//var mouseDelegate: MouseDelegate?
  var player: [Node] = []
  var directionKeysDown: Set<KeyboardControl> = []

  public func updatePlayer(deltaTime: Float) {
    if directionKeysDown.contains(KeyboardControl.space) {
      let translation = deltaTime * ( 2.00)
      for key in directionKeysDown {
        switch key {
        case .a:
          for i: Int in  0..<player.count {
            player[i].position.0 -= translation
          }
        case .d:
          for i: Int in  0..<player.count {
            player[i].position.0 += translation
          }
        case .x:
          for i: Int in  0..<player.count {
            player[i].position.1 -= translation
          }
        case .w:
          for i: Int in  0..<player.count {
            player[i].position.1 += translation
          }
        case .z:
          for i: Int in  0..<player.count {
            player[i].position.2 -= translation
          }
        case .e:
          for i: Int in  0..<player.count {
            player[i].position.2 += translation
          }
        default:
          break
        }
      }
    }else{
      let rotation = deltaTime * ( 1.00)
      var d: (Float,Float,Float)
      for key in directionKeysDown {
        switch key {
        case .a:
          d = ( 0.00, -rotation, 0.00)
          for i: Int in  0..<player.count {
            let current: (Float,Float,Float) = player[i].rotation
            player[i].rotation = update(x: current, d: d)
          }
        case .d:
          d = ( 0.00, rotation, 0.00)
          for i: Int in  0..<player.count {
            let current: (Float,Float,Float) = player[i].rotation
            player[i].rotation = update(x: current, d: d)
          }
        case .x:
          d = ( (-0.50)*Float.pi, rotation, ( 0.50)*Float.pi)
          for i: Int in  0..<player.count {
            let current: (Float,Float,Float) = player[i].rotation
            player[i].rotation = update(x: current, d: d)
          }
        case .w:
          d = ( (-0.50)*Float.pi, -rotation, ( 0.50)*Float.pi)
          for i: Int in  0..<player.count {
            let current: (Float,Float,Float) = player[i].rotation
            player[i].rotation = update(x: current, d: d)
          }
        case .z:
          d = ( -rotation, 0.00, 0.00)
          for i: Int in  0..<player.count {
            let current: (Float,Float,Float) = player[i].rotation
            player[i].rotation = update(x: current, d: d)
          }
        case .e:
          d = ( rotation, 0.00, 0.00)
          for i: Int in  0..<player.count {
            let current: (Float,Float,Float) = player[i].rotation
            player[i].rotation = update(x: current, d: d)
          }
        default:
          break
        }
      }
    }
  }

  func processEvent(key inKey: KeyboardControl, state: InputState) {
    let key = inKey
//  if !(keyboardDelegate?.keyPressed(key: key, state: state) ?? true) {
//    return
//  }
    if state == .began {
      directionKeysDown.insert(key)
    }
    if state == .ended {
      directionKeysDown.remove(key)
    }
  }
  func processEvent(mouse: MouseControl, state: InputState, event: NSEvent) {
    let delta: (Float,Float) = (Float(event.deltaX),
                                Float(event.deltaY))
//    let locationInWindow: (Float,Float) = (Float(event.locationInWindow.x),
//                                           Float(event.locationInWindow.y))
//  mouseDelegate?.mouseEvent(mouse: mouse,
//                            state: state,
//                            delta: delta,
//                            location: locationInWindow)
    if directionKeysDown.contains(KeyboardControl.space) {
      if mouse == .leftDown {
      }
      if mouse == .leftUp {
      }
      if mouse == .leftDrag {
        for i: Int in  0..<player.count {
          player[i].position.0 += ( 0.01)*delta.0
          player[i].position.1 += (-0.01)*delta.1
        }
      }
      if mouse == .rightDown {
      }
      if mouse == .rightUp {
      }
      if mouse == .rightDrag {
        for i: Int in  0..<player.count {
          player[i].position.2 += ( 0.008)*delta.0
          player[i].position.2 += (-0.008)*delta.1
        }
      }
      if mouse == .scroll {
      }
    }else{
      if mouse == .leftDown {
      }
      if mouse == .leftUp {
      }
      if mouse == .leftDrag {
        var d: (Float,Float,Float)
        if( abs( delta.0) > abs( delta.1) ){
          d = ( 0.00, ( 0.01)*delta.0, 0.00)
        }else{
          d = ( (-0.50)*Float.pi, ( 0.01)*delta.1, ( 0.50)*Float.pi)
        }
        for i: Int in  0..<player.count {
          let current: (Float,Float,Float) = player[i].rotation
          player[i].rotation = update(x: current, d: d)
        }
      }
      if mouse == .rightDown {
      }
      if mouse == .rightUp {
      }
      if mouse == .rightDrag {
        let d: (Float,Float,Float) = ( ( 0.01)*delta.0, 0.00, 0.00)
        for i: Int in  0..<player.count {
          let current: (Float,Float,Float) = player[i].rotation
          player[i].rotation = update(x: current, d: d)
        }
      }
      if mouse == .scroll {
        for i: Int in  0..<player.count {
          let s = (( 1.00)/( (1.00) + ( 0.01)*delta.1))
          player[i].scale.0 *= s
          player[i].scale.1 *= s
          player[i].scale.2 *= s
        }
      }
    }
  }
}

enum InputState {
  case began
  case moved
  case ended
  case cancelled
  case continued
}
enum KeyboardControl: UInt16 {
  case a =      0
  case s =      1
  case d =      2
  case q =      12
  case w =      13
  case e =      14
  case z =      6
  case x =      7
  case c =      8
  case left =   123
  case right =  124
  case down =   125
  case up =     126
  case key1 =   18
  case key2 =   19
  case key0 =   29
  case space =  49
}
enum MouseControl {
  case leftDown
  case leftUp
  case leftDrag
  case rightDown
  case rightUp
  case rightDrag
  case scroll
  case mouseMoved
}
