import Foundation

class Coordinates {
   var x: (Double,Double,Double)        //cartesian coords

   init() {
      x = ( 0.00, 0.00, 0.00)
   }

   init(_ a: (Float,Float,Float)) {
      x = ( Double( a.0), Double( a.1), Double( a.2))
   }

   init(_ a: (Double,Double,Double), _ Cthe: Double, _ Sthe: Double) {
      let near: Double = 0.001
      let far: Double = 100
      let w: Double = 1280.0
      let h: Double =  650.0
      x.0 = (w + ((a.0 * Cthe * h) / (a.2 * Sthe)))
      x.1 = (h - ((a.1 * Cthe * h) / (a.2 * Sthe)))
      x.2 = (a.2 - near) / (far - near)
   }

   static func += (left: inout Coordinates,
                   a: Coordinates) {
      left.x.0 += a.x.0
      left.x.1 += a.x.1
      left.x.2 += a.x.2
   }
   static func -= (left: inout Coordinates,
                   a: Coordinates) {
      left.x.0 -= a.x.0
      left.x.1 -= a.x.1
      left.x.2 -= a.x.2
   }
   static func *= (left: inout Coordinates,
                   a: Double) {
      left.x.0 *= a
      left.x.1 *= a
      left.x.2 *= a
   }
   static func /= (left: inout Coordinates,
                   a: Double) {
      left.x.0 /= a
      left.x.1 /= a
      left.x.2 /= a
   }

   static func + (a: Coordinates,
                  b: Coordinates) -> Coordinates {
      let t: Coordinates = Coordinates()
      t.x.0 = a.x.0 + b.x.0
      t.x.1 = a.x.1 + b.x.1
      t.x.2 = a.x.2 + b.x.2
      return t
   }
   static func - (a: Coordinates,
                  b: Coordinates) -> Coordinates {
      let t: Coordinates = Coordinates()
      t.x.0 = a.x.0 - b.x.0
      t.x.1 = a.x.1 - b.x.1
      t.x.2 = a.x.2 - b.x.2
      return t
   }
   static prefix func - (a: Coordinates) -> Coordinates {
      let t: Coordinates = Coordinates()
      t.x.0 = -a.x.0
      t.x.1 = -a.x.1
      t.x.2 = -a.x.2
      return t
   }

   func zero() {
      x = ( 0.00, 0.00, 0.00)
   }
   func rr() -> Double {
      let z: Double = (x.0 * x.0) + (x.1 * x.1) + (x.2 * x.2)
      return z
   }
   func r() -> Double {
      var z: Double = (x.0 * x.0) + (x.1 * x.1) + (x.2 * x.2)
      z = sqrt( z)
      return z
   }
   func normalize() {
      var z: Double = (x.0 * x.0) + (x.1 * x.1) + (x.2 * x.2)
      z = sqrt( z)
      x.0 /= z
      x.1 /= z
      x.2 /= z
   }
}
//
//
// global operators
//
func * (_ a: Double,
        _ b: Coordinates) -> Coordinates {
   let t: Coordinates = Coordinates()
   t.x.0 = a * b.x.0
   t.x.1 = a * b.x.1
   t.x.2 = a * b.x.2
   return t
}
func * (_ ROT: Rotation_Matrix,
        _ b: Coordinates) -> Coordinates {
   let t: Coordinates = Coordinates()
   t.x.0 = (ROT.row0.0 * b.x.0) + (ROT.row0.1 * b.x.1) + (ROT.row0.2 * b.x.2)
   t.x.1 = (ROT.row1.0 * b.x.0) + (ROT.row1.1 * b.x.1) + (ROT.row1.2 * b.x.2)
   t.x.2 = (ROT.row2.0 * b.x.0) + (ROT.row2.1 * b.x.1) + (ROT.row2.2 * b.x.2)
   return t
}
//
//
// global functions
//
func dot(_ a: Coordinates,
         _ b: Coordinates) -> Double {
   return (a.x.0 * b.x.0) + (a.x.1 * b.x.1) + (a.x.2 * b.x.2)
}
func cross(_ a: Coordinates,
           _ b: Coordinates) -> Coordinates {
   let t: Coordinates = Coordinates()
   t.x.0 = (a.x.1 * b.x.2) - (a.x.2 * b.x.1)
   t.x.1 = (a.x.2 * b.x.0) - (a.x.0 * b.x.2)
   t.x.2 = (a.x.0 * b.x.1) - (a.x.1 * b.x.0)
   return t
}
