import SwiftUI
import Foundation

struct ContentView: View {

  let renderer: Renderer = Renderer()
  let residueMappings: ResidueMappings = ResidueMappings()
  var eregPath: String {
    let fileManager: FileManager = FileManager()
    var path: String = fileManager.currentDirectoryPath
    path.append( Character( "/"))
    return path
  }

  @State private var refreshMetalView = false
  @State private var quad: Int = 1

  @State private var mol00: String = ""
  @State private var mol01: String = ""
  @State private var mol10: String = ""
  @State private var mol11: String = ""

  @FocusState private var field00IsFocused: Bool
  @FocusState private var field01IsFocused: Bool
  @FocusState private var field10IsFocused: Bool
  @FocusState private var field11IsFocused: Bool

  @State private var vis00: Bool = false
  @State private var vis01: Bool = false
  @State private var vis10: Bool = false
  @State private var vis11: Bool = false

  @State private var mov00: Bool = false
  @State private var mov01: Bool = false
  @State private var mov10: Bool = false
  @State private var mov11: Bool = false

  @State private var p00: (Float, Float, Float) = ( 0.0, 0.0, 0.0)
  @State private var p01: (Float, Float, Float) = ( 0.0, 0.0, 0.0)
  @State private var p10: (Float, Float, Float) = ( 0.0, 0.0, 0.0)
  @State private var p11: (Float, Float, Float) = ( 0.0, 0.0, 0.0)

  @State private var r00: (Float, Float, Float) = ( 0.0, 0.0, 0.0)
  @State private var r01: (Float, Float, Float) = ( 0.0, 0.0, 0.0)
  @State private var r10: (Float, Float, Float) = ( 0.0, 0.0, 0.0)
  @State private var r11: (Float, Float, Float) = ( 0.0, 0.0, 0.0)

  @State private var s00: Float = ( 1.00)
  @State private var s01: Float = ( 1.00)
  @State private var s10: Float = ( 1.00)
  @State private var s11: Float = ( 1.00)

  @State private var rlab00: Bool = false
  @State private var rlab01: Bool = false
  @State private var rlab10: Bool = false
  @State private var rlab11: Bool = false

  @State var reslabs00: Array<ResLab> = []
  @State var reslabs01: Array<ResLab> = []
  @State var reslabs10: Array<ResLab> = []
  @State var reslabs11: Array<ResLab> = []

  @State private var alab00: Bool = false
  @State private var alab01: Bool = false
  @State private var alab10: Bool = false
  @State private var alab11: Bool = false

  @State var atmlabs00: Array<AtmLab> = []
  @State var atmlabs01: Array<AtmLab> = []
  @State var atmlabs10: Array<AtmLab> = []
  @State var atmlabs11: Array<AtmLab> = []

  var body: some View {
    VStack {
      ZStack {
        MetalView(renderer,
                  eregPath,
                  $quad,
                  mol00, mol01, mol10, mol11,
                  $vis00, $vis01, $vis10, $vis11,
                  $mov00, $mov01, $mov10, $mov11,
                  $p00, $p01, $p10, $p11,
                  $r00, $r01, $r10, $r11,
                  $s00, $s01, $s10, $s11)
        .id(refreshMetalView)
        LabelView($p00, $r00, $s00, $rlab00, reslabs00, $alab00, atmlabs00)
        .frame(width: (renderer.scene?.sceneSize.width ?? 2560),
               height: (renderer.scene?.sceneSize.height ?? 1299))
        LabelView($p01, $r01, $s01, $rlab01, reslabs01, $alab01, atmlabs01)
        .frame(width: (renderer.scene?.sceneSize.width ?? 2560),
               height: (renderer.scene?.sceneSize.height ?? 1299))
        LabelView($p10, $r10, $s10, $rlab10, reslabs10, $alab10, atmlabs10)
        .frame(width: (renderer.scene?.sceneSize.width ?? 2560),
               height: (renderer.scene?.sceneSize.height ?? 1299))
        LabelView($p11, $r11, $s11, $rlab11, reslabs11, $alab11, atmlabs11)
        .frame(width: (renderer.scene?.sceneSize.width ?? 2560),
               height: (renderer.scene?.sceneSize.height ?? 1299))
      }
      HStack {
        Text("frames")
        Button {
          quad = 1
        } label: {
          Text("1")
          .foregroundColor((quad == 1) ? .red : .black)
        }
        Button {
          quad = 2
        } label: {
          Text("2")
          .foregroundColor((quad == 2) ? .red : .black)
        }
        Button{
          quad = 4
        } label: {
          Text("4")
          .foregroundColor((quad == 4) ? .red : .black)
        }
        Button{
          exit( 0)
        } label: {
          Text("quit")
        }
        .padding(.horizontal, 25)
      }
      HStack (spacing: 20) {
        VStack {
          TextField("quad01",text: $mol01)
          .frame(width: 300,height: 20)
          .focused($field01IsFocused)
          .onSubmit {/*validate(name: mol01)*/}
          .disableAutocorrection(true)
          .border(.secondary)
          .foregroundColor(field01IsFocused ? .red : .black)
          HStack {
            Button {
              let str01: Structure = Structure(residueMappings: residueMappings,
                                               rootPath: eregPath,
                                               filename: mol01)
              if( str01.Z0.count > 0 ) {
                str01.createobj(residueMappings: residueMappings)
                vis01 = true
                mov01 = true
                reslabs01 = str01.reslab()
                atmlabs01 = str01.atmlab()
                refreshMetalView.toggle()
              }
            } label: {
              Text("r")
            }
            Button {
              let objPath: String = eregPath + mol01 + ".obj"
              let objURL = URL(fileURLWithPath: objPath)
              do {
                try FileManager.default.removeItem(at: objURL)
              } catch {
                print("ERROR: Deletion failed, file \(mol01).obj not found.")
              }
              let mtlPath: String = eregPath + mol01 + ".mtl"
              let mtlURL = URL(fileURLWithPath: mtlPath)
              do {
                try FileManager.default.removeItem(at: mtlURL)
              } catch {
                print("ERROR: Deletion failed, file \(mol01).mtl not found.")
              }
              mol01 = ""
              vis01 = false
              mov01 = false
              rlab01 = false
              alab01 = false
              refreshMetalView.toggle()
            } label: {
              Text("d")
            }
            Button {
              vis01.toggle()
            } label: {
              Text("h")
              .foregroundColor(vis01 ? .red : .black)
            }
            Button {
              mov01.toggle()
            } label: {
              Text("m")
              .foregroundColor(mov01 ? .red : .black)
            }
            Button {
              rlab01.toggle()
              alab01 = false
            } label: {
              Text("label r")
              .foregroundColor(rlab01 ? .red : .black)
            }
            Button {
              alab01.toggle()
              rlab01 = false
            } label: {
              Text("label a")
              .foregroundColor(alab01 ? .red : .black)
            }
          }
          TextField("quad00",text: $mol00)
          .frame(width: 300,height: 20)
          .focused($field00IsFocused)
          .onSubmit {/*validate(name: mol00)*/}
          .disableAutocorrection(true)
          .border(.secondary)
          .foregroundColor(field00IsFocused ? .red : .black)
          HStack {
            Button {
              let str00: Structure = Structure(residueMappings: residueMappings,
                                               rootPath: eregPath,
                                               filename: mol00)
              if( str00.Z0.count > 0 ) {
                str00.createobj(residueMappings: residueMappings)
                vis00 = true
                mov00 = true
                reslabs00 = str00.reslab()
                atmlabs00 = str00.atmlab()
                refreshMetalView.toggle()
              }
            } label: {
              Text("r")
            }
            Button {
              let objPath: String = eregPath + mol00 + ".obj"
              let objURL = URL(fileURLWithPath: objPath)
              do {
                try FileManager.default.removeItem(at: objURL)
              } catch {
                print("ERROR: Deletion failed, file \(mol00).obj not found.")
              }
              let mtlPath: String = eregPath + mol00 + ".mtl"
              let mtlURL = URL(fileURLWithPath: mtlPath)
              do {
                try FileManager.default.removeItem(at: mtlURL)
              } catch {
                print("ERROR: Deletion failed, file \(mol00).mtl not found.")
              }
              mol00 = ""
              vis00 = false
              mov00 = false
              rlab00 = false
              alab00 = false
              refreshMetalView.toggle()
            } label: {
              Text("d")
            }
            Button {
              vis00.toggle()
            } label: {
              Text("h")
              .foregroundColor(vis00 ? .red : .black)
            }
            Button {
              mov00.toggle()
            } label: {
              Text("m")
              .foregroundColor(mov00 ? .red : .black)
            }
            Button {
              rlab00.toggle()
              alab00 = false
            } label: {
              Text("label r")
              .foregroundColor(rlab00 ? .red : .black)
            }
            Button {
              alab00.toggle()
              rlab00 = false
            } label: {
              Text("label a")
              .foregroundColor(alab00 ? .red : .black)
            }
          }

        }
        VStack {
          TextField("quad11",text: $mol11)
          .frame(width: 300,height: 20)
          .focused($field11IsFocused)
          .onSubmit {/*validate(name: mol11)*/}
          .disableAutocorrection(true)
          .border(.secondary)
          .foregroundColor(field11IsFocused ? .red : .black)
          HStack {
            Button {
              let str11: Structure = Structure(residueMappings: residueMappings,
                                               rootPath: eregPath,
                                               filename: mol11)
              if( str11.Z0.count > 0 ) {
                str11.createobj(residueMappings: residueMappings)
                vis11 = true
                mov11 = true
                reslabs11 = str11.reslab()
                atmlabs11 = str11.atmlab()
                refreshMetalView.toggle()
              }
            } label: {
              Text("r")
            }
            Button {
              let objPath: String = eregPath + mol11 + ".obj"
              let objURL = URL(fileURLWithPath: objPath)
              do {
                try FileManager.default.removeItem(at: objURL)
              } catch {
                print("ERROR: Deletion failed, file \(mol11).obj not found.")
              }
              let mtlPath: String = eregPath + mol11 + ".mtl"
              let mtlURL = URL(fileURLWithPath: mtlPath)
              do {
                try FileManager.default.removeItem(at: mtlURL)
              } catch {
                print("ERROR: Deletion failed, file \(mol11).mtl not found.")
              }
              mol11 = ""
              vis11 = false
              mov11 = false
              rlab11 = false
              alab11 = false
              refreshMetalView.toggle()
            } label: {
              Text("d")
            }
            Button {
              vis11.toggle()
            } label: {
              Text("h")
              .foregroundColor(vis11 ? .red : .black)
            }
            Button {
              mov11.toggle()
            } label: {
              Text("m")
              .foregroundColor(mov11 ? .red : .black)
            }
            Button {
              rlab11.toggle()
              alab11 = false
            } label: {
              Text("label r")
              .foregroundColor(rlab11 ? .red : .black)
            }
            Button {
              alab11.toggle()
              rlab11 = false
            } label: {
              Text("label a")
              .foregroundColor(alab11 ? .red : .black)
            }
          }
          TextField("quad10",text: $mol10)
          .frame(width: 300,height: 20)
          .focused($field10IsFocused)
          .onSubmit {/*validate(name: mol10)*/}
          .disableAutocorrection(true)
          .border(.secondary)
          .foregroundColor(field10IsFocused ? .red : .black)
          HStack {
            Button {
              let str10: Structure = Structure(residueMappings: residueMappings,
                                               rootPath: eregPath,
                                               filename: mol10)
              if( str10.Z0.count > 0 ) {
                str10.createobj(residueMappings: residueMappings)
                vis10 = true
                mov10 = true
                reslabs10 = str10.reslab()
                atmlabs10 = str10.atmlab()
                refreshMetalView.toggle()
              }
            } label: {
              Text("r")
            }
            Button {
              let objPath: String = eregPath + mol10 + ".obj"
              let objURL = URL(fileURLWithPath: objPath)
              do {
                try FileManager.default.removeItem(at: objURL)
              } catch {
                print("ERROR: Deletion failed, file \(mol10).obj not found.")
              }
              let mtlPath: String = eregPath + mol10 + ".mtl"
              let mtlURL = URL(fileURLWithPath: mtlPath)
              do {
                try FileManager.default.removeItem(at: mtlURL)
              } catch {
                print("ERROR: Deletion failed, file \(mol10).mtl not found.")
              }
              mol10 = ""
              vis10 = false
              mov10 = false
              rlab10 = false
              alab10 = false
              refreshMetalView.toggle()
            } label: {
              Text("d")
            }
            Button {
              vis10.toggle()
            } label: {
              Text("h")
              .foregroundColor(vis10 ? .red : .black)
            }
            Button {
              mov10.toggle()
            } label: {
              Text("m")
              .foregroundColor(mov10 ? .red : .black)
            }
            Button {
              rlab10.toggle()
              alab10 = false
            } label: {
              Text("label r")
              .foregroundColor(rlab10 ? .red : .black)
            }
            Button {
              alab10.toggle()
              rlab10 = false
            } label: {
              Text("label a")
              .foregroundColor(alab10 ? .red : .black)
            }
          }

        }
      }
    }
  }
}
